/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.time.Instant;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource source2, AuthorizationProvider authorizationProvider) {
        Result result2 = new Result();
        try {
            long lastModified2 = source2.getLastModified();
            HttpURLConnection connection = (HttpURLConnection)UrlConnectionFactory.createConnection(source2.getURI().toURL(), lastModified2, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
            connection.connect();
            try {
                int code = connection.getResponseCode();
                switch (code) {
                    case 304: {
                        LOGGER.debug("{} resource {}: not modified since {}", HttpInputStreamUtil.formatProtocol(source2), () -> source2, () -> Instant.ofEpochMilli(lastModified2));
                        result2.status = Status.NOT_MODIFIED;
                        Result result3 = result2;
                        return result3;
                    }
                    case 404: {
                        LOGGER.debug("{} resource {}: not found", HttpInputStreamUtil.formatProtocol(source2), () -> source2);
                        result2.status = Status.NOT_FOUND;
                        Result result4 = result2;
                        return result4;
                    }
                    case 200: {
                        Result result5;
                        InputStream is = connection.getInputStream();
                        try {
                            source2.setLastModified(connection.getLastModified());
                            LOGGER.debug("{} resource {}: last modified on {}", HttpInputStreamUtil.formatProtocol(source2), () -> source2, () -> Instant.ofEpochMilli(connection.getLastModified()));
                            result2.status = Status.SUCCESS;
                            Result.access$102(result2, HttpInputStreamUtil.readStream(is));
                            result5 = result2;
                            if (is == null) return result5;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is == null) throw throwable;
                                try {
                                    is.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                try (InputStream es = connection.getErrorStream();){
                                    if (!LOGGER.isDebugEnabled()) throw new ConfigurationException("Unable to access " + source2, e);
                                    LOGGER.debug("Error accessing {} resource at {}: {}", (Object)HttpInputStreamUtil.formatProtocol(source2).get(), (Object)source2, (Object)HttpInputStreamUtil.readStream(es), (Object)e);
                                    throw new ConfigurationException("Unable to access " + source2, e);
                                }
                                catch (IOException ioe) {
                                    LOGGER.debug("Error accessing {} resource at {}", HttpInputStreamUtil.formatProtocol(source2), () -> source2, () -> e);
                                }
                                throw new ConfigurationException("Unable to access " + source2, e);
                            }
                        }
                        is.close();
                        return result5;
                    }
                    case 401: {
                        throw new ConfigurationException("Authentication required for " + source2);
                    }
                    case 403: {
                        throw new ConfigurationException("Access denied to " + source2);
                    }
                }
                if (code < 0) {
                    LOGGER.debug("{} resource {}: invalid response code", (Object)HttpInputStreamUtil.formatProtocol(source2), (Object)source2);
                    throw new ConfigurationException("Unable to access " + source2);
                }
                LOGGER.debug("{} resource {}: unexpected response code {}", (Object)HttpInputStreamUtil.formatProtocol(source2), (Object)source2, (Object)code);
                throw new ConfigurationException("Unable to access " + source2);
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error accessing {} resource at {}", (Object)HttpInputStreamUtil.formatProtocol(source2), (Object)source2, (Object)e);
            throw new ConfigurationException("Unable to access " + source2, e);
        }
    }

    private static Supplier<String> formatProtocol(Source source2) {
        return () -> Strings.toRootUpperCase(source2.getURI().getScheme());
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result2 = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result2.write(buffer, 0, length);
        }
        return result2.toByteArray();
    }

    @NullMarked
    public static class Result {
        private byte @Nullable [] bytes = null;
        private Status status;

        public Result() {
            this(Status.ERROR);
        }

        public Result(Status status2) {
            this.status = status2;
        }

        public @Nullable InputStream getInputStream() {
            return this.bytes != null ? new ByteArrayInputStream(this.bytes) : null;
        }

        public Status getStatus() {
            return this.status;
        }

        static /* synthetic */ byte[] access$102(Result x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

