/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.comments;

import it.krzeminski.snakeyaml.engine.kmp.comments.CommentLine;
import it.krzeminski.snakeyaml.engine.kmp.comments.CommentType;
import it.krzeminski.snakeyaml.engine.kmp.comments.EventQueue;
import it.krzeminski.snakeyaml.engine.kmp.events.CommentEvent;
import it.krzeminski.snakeyaml.engine.kmp.events.Event;
import it.krzeminski.snakeyaml.engine.kmp.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB%\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bB+\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u0016\u001a\u00020\u0000J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0006\u0010\u001a\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentEventsCollector;", "", "eventSource", "Lit/krzeminski/snakeyaml/engine/kmp/comments/EventQueue;", "expectedCommentTypes", "", "Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentType;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/comments/EventQueue;[Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentType;)V", "parser", "Lit/krzeminski/snakeyaml/engine/kmp/parser/Parser;", "(Lit/krzeminski/snakeyaml/engine/kmp/parser/Parser;[Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentType;)V", "Lkotlin/collections/ArrayDeque;", "Lit/krzeminski/snakeyaml/engine/kmp/events/Event;", "(Lkotlin/collections/ArrayDeque;[Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentType;)V", "[Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentType;", "commentLineList", "", "Lit/krzeminski/snakeyaml/engine/kmp/comments/CommentLine;", "isEventExpected", "", "event", "collectEvents", "collectEventsAndPoll", "consume", "", "isEmpty", "snakeyaml-engine-kmp"})
public final class CommentEventsCollector {
    @NotNull
    private final EventQueue eventSource;
    @NotNull
    private final CommentType[] expectedCommentTypes;
    @NotNull
    private final List<CommentLine> commentLineList;

    private CommentEventsCollector(EventQueue eventSource, CommentType[] expectedCommentTypes) {
        this.eventSource = eventSource;
        this.expectedCommentTypes = expectedCommentTypes;
        this.commentLineList = new ArrayList();
    }

    public CommentEventsCollector(@NotNull Parser parser, CommentType ... expectedCommentTypes) {
        Intrinsics.checkNotNullParameter(parser, "parser");
        Intrinsics.checkNotNullParameter(expectedCommentTypes, "expectedCommentTypes");
        this(new EventQueue(parser), expectedCommentTypes);
    }

    public CommentEventsCollector(@NotNull ArrayDeque<Event> eventSource, CommentType ... expectedCommentTypes) {
        Intrinsics.checkNotNullParameter(eventSource, "eventSource");
        Intrinsics.checkNotNullParameter(expectedCommentTypes, "expectedCommentTypes");
        this(new EventQueue(eventSource), expectedCommentTypes);
    }

    private final boolean isEventExpected(Event event) {
        return event != null && event.getEventId() == Event.ID.Comment && event instanceof CommentEvent && ArraysKt.contains(this.expectedCommentTypes, ((CommentEvent)event).getCommentType());
    }

    @NotNull
    public final CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    @Nullable
    public final Event collectEvents(@Nullable Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.commentLineList.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (this.isEventExpected(this.eventSource.peek())) {
            Event e = this.eventSource.poll();
            Intrinsics.checkNotNull(e, "null cannot be cast to non-null type it.krzeminski.snakeyaml.engine.kmp.events.CommentEvent");
            this.commentLineList.add(new CommentLine((CommentEvent)e));
        }
        return null;
    }

    @NotNull
    public final Event collectEventsAndPoll(@Nullable Event event) {
        Event nextEvent = this.collectEvents(event);
        Event event2 = nextEvent;
        if (event2 == null) {
            event2 = this.eventSource.poll();
        }
        return event2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CommentLine> consume() {
        List<CommentLine> list;
        try {
            list = CollectionsKt.toList((Iterable)this.commentLineList);
        }
        finally {
            this.commentLineList.clear();
        }
        return list;
    }

    public final boolean isEmpty() {
        return this.commentLineList.isEmpty();
    }
}

