/**/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options


programs = 6

if language = '049' then do

  msg.1 = 'msg:Installiere die Programmdateien'
  msg.2 = 'msg:Erzeuge plain.base'
  msg.3 = 'msg:Erzeuge cm.base'
  msg.4 = 'msg:Erzeuge plain.fmt mit Englischen Trennmustern'
  msg.5 = 'msg:Erzeuge OS2TeX-Ordner'
  msg.6 = 'msg:Erzeuge Programmobjekt'

  err.1  = 'err:Fehler beim Erzeugen des OS2TeX-Ordners'
  err.2  = 'err:Fehler beim Erzeugen des Programmobjektes'

  errcd  = 'err:Verzeichniswechsel nicht mglich'

  pgm.title.1 = 'Shell'
  pgm.file.1  = 'shell.exe'
  pgm.assoc.1 = '*.txp'
  pgm.title.2 = 'Previewer'
  pgm.file.2  = 'dvi.exe'
  pgm.assoc.2 = '*.dvi'
  pgm.title.3 = 'Image'
  pgm.file.3  = 'image.exe'
  pgm.assoc.3 = ''
  pgm.title.4 = 'Formatdatei Werkzeug'
  pgm.file.4  = 'fftool.exe'
  pgm.assoc.4 = ''
  pgm.title.5 = 'Server Konfiguration'
  pgm.file.5  = 'service.exe'
  pgm.assoc.5 = ''
  pgm.title.6 = 'Metafont Server'
  pgm.file.6  = 'mfserver.exe'
  pgm.assoc.6 = ''

end
else do

  msg.1 = 'msg:Installing executables'
  msg.2 = 'msg:Creating plain.base'
  msg.3 = 'msg:Creating cm.base'
  msg.4 = 'msg:Creating plain.fmt, English hyphenation patterns preloaded'
  msg.5 = 'msg:Creating OS2TeX folder'
  msg.6 = 'msg:Creating program object'

  err.1  = 'err:Error while creating OS2TeX folder'
  err.2  = 'err:Error while creating program object'

  errcd  = 'err:Unable to change directory'

  pgm.title.1 = 'Shell'
  pgm.file.1  = 'shell.exe'
  pgm.assoc.1 = '*.txp'
  pgm.title.2 = 'Previewer'
  pgm.file.2  = 'dvi.exe'
  pgm.assoc.2 = '*.dvi'
  pgm.title.3 = 'Image'
  pgm.file.3  = 'image.exe'
  pgm.assoc.3 = ''
  pgm.title.4 = 'Format File Tool'
  pgm.file.4  = 'fftool.exe'
  pgm.assoc.4 = ''
  pgm.title.5 = 'Server Configuration'
  pgm.file.5  = 'service.exe'
  pgm.assoc.5 = ''
  pgm.title.6 = 'Metafont Server'
  pgm.file.6  = 'mfserver.exe'
  pgm.assoc.6 = ''

end



target = texmf||'\os2tex\bin'


install = texmf||'\os2tex\install'




if Pos("InstallFiles", options) > 0 then do

   if directory(texmf) = '' then do
      say errdir' - 'texmf
      exit 1
   end


   say msg.1

   install||'\unzip -o '||source||'\bin.zip'


   exec = texmf||'\os2tex\bin\mf.exe'

   eqn = ' '


   say msg.2

   exec||' -i -r -pi'eqn||texmf||'\os2tex\bin;'||texmf||'\metafont;'||texmf||'\fonts\source -po'eqn||texmf||'\os2tex\bin plain.ini'


   say msg.3

   exec||' -i -r -pi'eqn||texmf||'\os2tex\bin;'||texmf||'\metafont;'||texmf||'\fonts\source -po'eqn||texmf||'\os2tex\bin cm.ini'




   bin = texmf||'\os2tex\bin'

   exec = bin||'\tex.exe'



   say msg.4

   exec||' -i -r -po '||bin||' -pi '||tex||'\plain;'||tex||'\generic\hyphen;'||bin||' -pt '||fonts||'\tfm plain.tex \dump'



   say msg.5

end


if SysOS2Ver() = '2.30' then
  top = '48'
else
  top = '45'



if Pos("CreateObjects", options) > 0 then do

   classname = 'WPFolder'
   objtitle  = 'OS/2-TeX'
   location  = '<WP_DESKTOP>'
   setup     = 'ICONFILE='target'\folder.ico;OBJECTID=<OS2TEX_FOLDER>;ICONVIEW=NONFLOWED;ICONVIEWPOS=0,50,25,'||top
   duplicate = 'update'



   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      say err.1
      exit 1
   end


   if language="044" then do
   lang = "PARAMETERS=-044;"
   end
   else do
   lang = ""
   end



   do i=1 to programs

      classname = 'WPProgram'
      objtitle  = pgm.title.i
      location  = '<OS2TEX_FOLDER>'

      if length(pgm.assoc.i) > 0 then
         setup = 'EXENAME='target'\'pgm.file.i';'lang'STARTUPDIR='target';OBJECTID=<OS2TEX_'pgm.file.i'>;ASSOCFILTER='||pgm.assoc.i||';'
      else
      if pgm.file.i \= 'mfserver.exe' then
         setup = 'EXENAME='target'\'pgm.file.i';'lang'STARTUPDIR='target';OBJECTID=<OS2TEX_'pgm.file.i'>;'
      else
         setup = 'PARAMETERS=-debug stdout;EXENAME='target'\'pgm.file.i';STARTUPDIR='target';OBJECTID=<OS2TEX_'pgm.file.i'>;'

      duplicate = 'replace'

      say msg.6' 'pgm.title.i

      rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

      if rc = 0 then do
         say err.2' 'pgm.title.i
         exit 1
      end

   end







   classname = 'WPFolder'

   if language = '049' then
      objtitle = 'Dokumentation'
   else
      objtitle = 'Documentation'

   location  = '<OS2TEX_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_DOC_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=25,50,25,'||top
   duplicate = 'update'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end




   classname = 'WPProgram'
   objtitle  = "OS2TeX Information"
   location  = '<OS2TEX_DOC_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_Information.dvi>;PARAMETERS='texmf'\doc\os2tex\Information.dvi'
   duplicate = 'replace'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end

end




