/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "tcl_strobj.cc"
 *                                    created: 14/12/97 {7:14:35 pm} 
 *                                last update: 27/1/98 {7:45:44 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * Copyright (c) 1997  Vince Darley
 * 
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *  See header file for further information
 * ###################################################################
 */

#include "tcl_strobj.h"

bool tcl_strobj::own(void) const {
    if(is_str()) {
	return (str_s != NULL ? true : false);
    } else {
	if(str_o) {
	    if(Tcl_IsShared(str_o)) {
		Tcl_DecrRefCount(str_o);
		str_o = Tcl_DuplicateObj(str_o);
		Tcl_IncrRefCount(str_o);
	    }
	    return true;
	}
	return false;
    }
}

Tcl_Obj* tcl_strobj::ownobj(void) const {
    if(is_str()) {
	// This call to 'New' copies the string, so we don't have to
	// worry that we were given a constant string literal.
    	// NOT SURE THIS WORKS IF I WAS CONSTRUCTED WITH A SINGLE CHAR
    	str_o = Tcl_NewStringObj((char*)str_s,length);
	Tcl_IncrRefCount(str_o);
	length = -2;
    } else {
	if(str_o) {
	    if(Tcl_IsShared(str_o)) {
		Tcl_DecrRefCount(str_o);
		str_o = Tcl_DuplicateObj(str_o);
		Tcl_IncrRefCount(str_o);
	    }
	} else {
	    str_o = Tcl_NewObj();
	    Tcl_IncrRefCount(str_o);
	}
    }
    return str_o;
}

Tcl_Obj* tcl_strobj::append_me_to(Tcl_Obj* &o) const {
    if(is_empty()) return o;
    if(is_str()) {
	if(o) {
	    Tcl_AppendToObj(o,(char*)str_s,length);
	} else {
	    o = Tcl_NewStringObj((char*)str_s,length);
	    Tcl_IncrRefCount(o);
	}
    } else {
	if(o) {
	    #if (TCL_MINOR_VERSION > 0)
	    static Tcl_ObjType* tclByteArrayType = Tcl_GetObjType("bytearray");
	    // Check if both objects are actually byte-arrays
	    if(str_o && str_o->typePtr == tclByteArrayType 
	       && o->typePtr == tclByteArrayType) {
		int oldlen, newlen;
		Tcl_GetByteArrayFromObj(o,&oldlen);
		unsigned char* my_bptr = Tcl_GetByteArrayFromObj(str_o,&newlen);
		unsigned char* bptr = Tcl_SetByteArrayLength(o,oldlen+newlen);
		memcpy((void *) bptr, (void*)my_bptr, newlen);
	    } else {
		register int len;
		char* s = Tcl_GetStringFromObj(str_o, &len);
		Tcl_AppendToObj(o,s,len);
	    }
	    #else
	    register int len;
	    char* s = Tcl_GetStringFromObj(str_o, &len);
	    Tcl_AppendToObj(o,s,len);
	    #endif
	} else {
	    o = str_o;
	    Tcl_IncrRefCount(o);
	}
    }
    return o;
}

void tcl_strobj::append(const tcl_strobj& t) {
    if(is_empty()) {
	length = t.length;
	if(t.is_str()) {
	    str_s = t.str_s;
	} else {
	    str_o = t.str_o;
	    Tcl_IncrRefCount(str_o);
	}
    } else {
	ownobj();
	t.append_me_to(str_o);
    }
}

void tcl_strobj::lappend(const tcl_strobj& o) {
    if(is_empty()) {
	Tcl_Obj* oo = (Tcl_Obj*)o;
	str_o = Tcl_NewListObj(1,&oo);
	Tcl_IncrRefCount(str_o);
	length = -2;
    } else {
	ownobj();
	Tcl_ListObjAppendElement(NULL,str_o,(Tcl_Obj*)o);
    }
}





