#include <forms.h>
#include "load_data.h"
#include "main_window.h"
#include "search_window.h"


extern FD_main_window *main_window;
extern FD_search_window *search_window;

extern char field_name_list[][32];

extern BS_data_list data;


void
cb_search_fields(FL_OBJECT *ob, long button)
{
  int irun;

  fl_deactivate_form(main_window->main_window);

  /*******************************/

  /* prepare field names */

  fl_clear_choice(search_window->search_choice);
  fl_addto_choice(search_window->search_choice,"ANY FIELD");

  irun=0;
  while(irun++<MAXFIELDS &&
	strlen(&field_name_list[irun][0])!=0)
    fl_addto_choice(search_window->search_choice,&field_name_list[irun][0]);

  fl_activate_form(search_window->search_window);

  fl_show_form(search_window->search_window,FL_PLACE_MOUSE,FL_FULLBORDER,
	       "xbiborg search fields");

}

void
cb_search_cancel(FL_OBJECT *ob, long button)
{
  fl_hide_form(search_window->search_window);
  list_data(fl_get_browser_maxline(main_window->list));
  fl_activate_form(main_window->main_window);
}

void
cb_search(FL_OBJECT *ob, long button)
{
  BS_data_list present_entry,first_entry;
  
  int choice,irun,j;
  int field,start_field,end_field;
  char search_text[1000];
  char buffer[BUFFERSIZE];


  if(strlen(fl_get_input(search_window->search_text))>0)
    {
      first_entry=data;
      
      choice=fl_get_choice(search_window->search_choice);
      if(choice==1)
	{
	  /* Search all fields */
	  start_field=0;
	  end_field=MAXFIELDS-1;
	}
      else
	{
	  /* Search all fields */
	  start_field=choice-1;
	  end_field=choice-1;
	}
      
      sprintf(search_text,"%s",
	      fl_get_input(search_window->search_text));
	
      if(fl_get_button(search_window->search_literal)==0)
	{
	  /* Remove '\n's, double spaces, spaces at end */
	  j=0;
	  do
	    {
	      if(search_text[j]==' ' && search_text[j+1]==' ')
		memmove(&search_text[0]+j,&search_text[0]+j+1,strlen(search_text));
	      if(isalnum(search_text[j])==0)
		memmove(&search_text[0]+j,&search_text[0]+j+1,strlen(search_text));
	      if(fl_get_button(search_window->search_case)==0)
		search_text[j]=tolower(search_text[j]);
	    }while(++j< strlen(search_text));
	  while(search_text[strlen(search_text)-1]==' ')
	    search_text[strlen(search_text)-1]=0;
	}
      if(fl_get_button(search_window->search_phrase)==0)
	{
	  memmove(&search_text[0]+1,&search_text[0],strlen(search_text)+1);
	  search_text[0]=' ';
	  strcat(search_text," ");
	}


      first_entry=data;  
      irun=1;
      do
	{
	  
	  field=start_field;
	  do
	    {
	      if(strlen(data->field_text[field])>0)
		{
		  sprintf(buffer,"%s",data->field_text[field]);
		  if(fl_get_button(search_window->search_literal)==0)
		    {
		      /* Remove '\n's, spaces, spaces at end */
		      j=0;

		      do
			{
			  while((buffer[j]==' ' && buffer[j+1]==' ' ||
				isalnum(buffer[j])==0 && buffer[j]!=' ') &&
				j< strlen(buffer))
			    memmove(&buffer[0]+j,&buffer[0]+j+1,strlen(buffer));
			  if(fl_get_button(search_window->search_case)==0)
			    buffer[j]=tolower(buffer[j]);
			}while(++j< strlen(buffer));
		      while(buffer[strlen(buffer)-1]==' ')
			buffer[strlen(buffer)-1]=0;
		    }
		  if(fl_get_button(search_window->search_phrase)==0)
		    {
		      memmove(&buffer[0]+1,&buffer[0],strlen(buffer)+1);
		      buffer[0]=' ';
		      strcat(buffer," ");
		    }

		  if(strstr(buffer,search_text)!=0)
		    fl_select_browser_line(main_window->list,irun);
		}
	    }while(field++<end_field);
	  data=data->next_entry;
	}while(irun++ < fl_get_browser_maxline(main_window->list));
      
      data=first_entry;
    }
  fl_hide_form(search_window->search_window);
  fl_activate_form(main_window->main_window);
}






