/* These are the generic types for DT things with parameters */
#define DT_SET		0
#define DT_PUT		1
#define DT_RIGHT	2
#define DT_W		3
#define DT_X		4
#define DT_DOWN		5
#define DT_Y		6
#define DT_Z		7
#define DT_FNT		8
#define DT_XXX		9
#define DT_FNTDEF      10

/* DVI_OpLen returns the value 0 => no param, 1 => byte param, 2 => 2 byte
   param, 3 => 3 byte param, 4 => 4 byte param.  If the value has 4 added
   to it (i.e., 5 through 7) it is unsigned.

   If there is a param, DVI_DT classifies the DVI opcode type for that
   opcode. */
#define DVI_OpLen(code)  ((&dvi_oplen[-128])[code])
#define DVI_DT(code)	 ((&dvi_dt   [-128])[code])
#define DVI_IsChar(code) ((code) < 128)
#define DVI_IsFont(code) ((code) >= 171 && (code) < 235)

extern char dvi_oplen[];
extern char dvi_dt[];
