(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11740,        383]
NotebookOptionsPosition[     10218,        323]
NotebookOutlinePosition[     10559,        338]
CellTagsIndexPosition[     10516,        335]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.504611544095785*^9, 3.504611548061817*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.504611624578113*^9, 3.504612596138023*^9, 
  3.5046163489964447`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.504611504172099*^9, 3.5046115237780867`*^9}}],

Cell[BoxData["\<\"/Users/abad/Desktop/TIDESExamples/chapter08\"\>"], "Output",
 CellChangeTimes->{3.5046116262400103`*^9, 3.504612596230681*^9, 
  3.504616350807206*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the Lorenz differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}, {
  3.504612548740176*^9, 3.504612549593028*^9}, {3.504616317526087*^9, 
  3.504616320164647*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lorenz", " ", "=", " ", 
  RowBox[{"FirstOrderODE", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "y"}], ")"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], " ", "z"}], " ", "+", " ", 
       RowBox[{"r", " ", "x"}], " ", "-", "y"}], ",", " ", 
      RowBox[{
       RowBox[{"x", " ", "y"}], " ", "-", 
       RowBox[{"b", " ", "z"}]}]}], "}"}], ",", " ", "t", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "r"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "y"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"r", " ", "x"}], "-", "y", "-", 
      RowBox[{"x", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", 
      RowBox[{"b", " ", "z"}]}]}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.504616352198888*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the integrator", "Section",
 CellChangeTimes->{{3.504616478508404*^9, 3.504616485088214*^9}}],

Cell[CellGroupData[{

Cell["Case 1", "Subsection",
 CellChangeTimes->{{3.504616491057157*^9, 3.5046164941283216`*^9}}],

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "lorenz", ",", " ", "\"\<lorenzC1\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"1", "/", "3"}], ",", " ", 
      RowBox[{"2", "/", "3"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"8", "/", "3"}], ",", " ", "27"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AddPartials", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", "3", ",", " ", "Until"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "\"\<lorenzC1.txt\>\""}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Case 2", "Subsection",
 CellChangeTimes->{{3.504616491057157*^9, 3.5046165048338547`*^9}}],

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "lorenz", ",", " ", "\"\<lorenzC2\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"1", "/", "3"}], ",", " ", 
      RowBox[{"2", "/", "3"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"8", "/", "3"}], ",", " ", "27"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AddPartials", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "a"}], "}"}], ",", "2", ",", " ", 
      "Until"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "\"\<lorenzC2.txt\>\""}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Case 3", "Subsection",
 CellChangeTimes->{{3.504616491057157*^9, 3.5046165082799187`*^9}}],

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "lorenz", ",", " ", "\"\<lorenzC3\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"1", "/", "3"}], ",", " ", 
      RowBox[{"2", "/", "3"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"8", "/", "3"}], ",", " ", "27"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AddPartials", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "a"}], "}"}], ",", "2", ",", " ", "Only"}],
      "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AddFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", " ", "-", " ", 
         RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], " ", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"2", "/", "3"}]}], ")"}], "^", "2"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "\"\<lorenzC3.txt\>\""}]}], "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Another way to compute different partials for the same ODE", "Section",
 CellChangeTimes->{{3.504616530333391*^9, 3.504616556378059*^9}}],

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "lorenz", ",", "\[IndentingNewLine]", "\"\<lorenzC\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"1", "/", "3"}], ",", 
      RowBox[{"2", "/", "3"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"8", "/", "3"}], ",", "27"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "\"\<lorenzC.txt\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504616569531591*^9, 3.504616578063322*^9}}],

Cell[CellGroupData[{

Cell["Case 1", "Subsection",
 CellChangeTimes->{{3.50461658192589*^9, 3.504616586002288*^9}}],

Cell[BoxData[
 RowBox[{"PartialDerivativesText", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", "3", ",", " ", "Until"}], "}"}], ",", " ", 
   "\"\<lorenzC1\>\""}], " ", "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Case 2", "Subsection",
 CellChangeTimes->{{3.50461658192589*^9, 3.504616594323207*^9}}],

Cell[BoxData[
 RowBox[{"PartialDerivativesText", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "r"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "a"}], "}"}], ",", "2", ",", " ", "Until"}],
     "}"}], ",", " ", "\"\<lorenzC2\>\""}], " ", "]"}]], "Input"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{901, 756},
WindowMargins->{{Automatic, 180}, {39, Automatic}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 120, 2, 40, "Input"],
Cell[817, 31, 1496, 39, 147, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2362, 76, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2500, 81, 172, 3, 40, "Input"],
Cell[2675, 86, 169, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2893, 94, 225, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[3143, 101, 683, 20, 64, "Input"],
Cell[3829, 123, 603, 19, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4481, 148, 107, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[4613, 153, 96, 1, 51, "Subsection"],
Cell[4712, 156, 887, 22, 156, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5636, 183, 96, 1, 51, "Subsection"],
Cell[5735, 186, 928, 23, 156, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6700, 214, 96, 1, 51, "Subsection"],
Cell[6799, 217, 1402, 38, 179, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8250, 261, 143, 1, 133, "Section"],
Cell[8396, 264, 784, 19, 156, "Input"],
Cell[CellGroupData[{
Cell[9205, 287, 93, 1, 51, "Subsection"],
Cell[9301, 290, 359, 10, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9697, 305, 93, 1, 51, "Subsection"],
Cell[9793, 308, 397, 11, 64, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
