(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7164,        231]
NotebookOptionsPosition[      6109,        187]
NotebookOutlinePosition[      6449,        202]
CellTagsIndexPosition[      6406,        199]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.500126833670376*^9, 3.50012683884439*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.500126839838992*^9, 3.501826792077366*^9, 
  3.504613214369381*^9, 3.504615940351945*^9, 3.506083830042835*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.500126864762299*^9, 3.500126877610745*^9}}],

Cell[BoxData["\<\"/Users/abad/Desktop/TIDESExamples/chapter07\"\>"], "Output",
 CellChangeTimes->{3.500126878296873*^9, 3.5018267921805696`*^9, 
  3.5018270859177837`*^9, 3.504613215615436*^9, 3.504615941864102*^9, 
  3.506083830154872*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the ellipticF differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}, {
  3.504612548740176*^9, 3.504612549593028*^9}, {3.5046132010718317`*^9, 
  3.504613206630245*^9}, {3.504616368712102*^9, 3.50461637389363*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ellipFODE", " ", "=", " ", 
  RowBox[{"FirstOrderODE", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], " ", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}]}], "}"}], ",",
     "t", ",", 
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"{", "k", "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]]], "}"}], ",", "t", ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.504615943853322*^9, 3.506083830245615*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the integrator", "Section",
 CellChangeTimes->{{3.5046130312990847`*^9, 3.504613036235671*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "ellipFODE", ",", "\[IndentingNewLine]", "\"\<ellipF30\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", "0", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", ".5", "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Delta", "[", 
       RowBox[{"Pi", "/", "8"}], "]"}], ",", 
      RowBox[{"Points", "[", "4", "]"}]}], "}"}]}], ",", 
   RowBox[{"Precision", "\[Rule]", 
    RowBox[{"Multiple", "[", "30", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504615973794167*^9, 3.504615979368977*^9}}],

Cell[BoxData["\<\"Files \\\"dr_ellipF30.c\\\", \\\"ellipF30.h\\\", ellipF30.c\
\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.506083830490053*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{"ellipFODE", ",", "\"\<ellipMP\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{"Precision", "\[Rule]", 
    RowBox[{"Multiple", "[", "30", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Driver", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.506084168169649*^9, 3.506084168359106*^9}, {
  3.506084657524372*^9, 3.506084664360239*^9}}],

Cell[BoxData["\<\"Files \\\"ellipMP.h\\\", ellipMP.c\\\", written on \
directory \\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",\

 CellChangeTimes->{3.506083830525124*^9, 3.506084171533319*^9, 
  3.5060846658010798`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{880, 763},
WindowMargins->{{Automatic, 362}, {Automatic, 4}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 119, 2, 40, "Input"],
Cell[816, 31, 1538, 39, 147, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2403, 76, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2541, 81, 170, 3, 40, "Input"],
Cell[2714, 86, 240, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3003, 95, 275, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[3303, 102, 452, 14, 40, "Input"],
Cell[3758, 118, 437, 13, 79, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4244, 137, 109, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[4378, 142, 792, 18, 179, "Input"],
Cell[5173, 162, 219, 3, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5429, 170, 406, 7, 87, "Input"],
Cell[5838, 179, 243, 4, 64, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
