(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18864,        573]
NotebookOptionsPosition[     17054,        502]
NotebookOutlinePosition[     17417,        518]
CellTagsIndexPosition[     17374,        515]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.500126833670376*^9, 3.50012683884439*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.500126839838992*^9, 3.501826792077366*^9, 
  3.504613214369381*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.500126864762299*^9, 3.500126877610745*^9}}],

Cell[BoxData["\<\"/Users/abad/Desktop/TIDESExamples/tutorial06\"\>"], "Output",
 CellChangeTimes->{3.500126878296873*^9, 3.5018267921805696`*^9, 
  3.5018270859177837`*^9, 3.504613215615436*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the three body problem differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}, {
  3.504612548740176*^9, 3.504612549593028*^9}, {3.5046132010718317`*^9, 
  3.504613206630245*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"threeBP", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"y", "'"}]}]}], "\[Equal]", 
      RowBox[{"x", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "mu"}], ")"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "mu"}], ")"}], "/", 
         RowBox[{"r", "^", "3"}]}]}], "-", 
       RowBox[{"mu", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "mu", "-", "1"}], ")"}], "/", 
         RowBox[{"s", "^", "3"}]}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"x", "'"}]}]}], "\[Equal]", 
      RowBox[{"y", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "mu"}], ")"}], " ", 
        RowBox[{"y", "/", 
         RowBox[{"r", "^", "3"}]}]}], "-", 
       RowBox[{"mu", " ", 
        RowBox[{"y", "/", 
         RowBox[{"s", "^", "3"}]}]}]}]}]}], "\n", "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "\[Rule]", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "mu"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"s", "\[Rule]", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "mu", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "]"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.5001267448718653`*^9, 3.500126746473137*^9}, {
  3.500126793793894*^9, 3.500126828856776*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None]}], "+", 
     SuperscriptBox["x", "\[Prime]\[Prime]",
      MultilineFunction->None]}], "\[Equal]", 
    RowBox[{"x", "-", 
     FractionBox[
      RowBox[{"mu", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "mu"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"mu", "+", "x"}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"mu", "+", "x"}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None]}], "+", 
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None]}], "\[Equal]", 
    RowBox[{"y", "-", 
     FractionBox[
      RowBox[{"mu", " ", "y"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "mu"}], ")"}], " ", "y"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"mu", "+", "x"}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.500126813712171*^9, 3.50012683071738*^9}, 
   3.5001268801195927`*^9, 3.50182679221353*^9, 3.50461321687344*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"threeBPEQ", " ", "=", " ", 
  RowBox[{"NthOrderODE", "[", 
   RowBox[{"threeBP", ",", " ", "t", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", "mu", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5001268831726837`*^9, 3.5001269228385973`*^9}, {
  3.500126973130384*^9, 3.5001269755438633`*^9}}],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x$d1", ",", "y$d1", ",", 
     RowBox[{"x", "-", 
      FractionBox[
       RowBox[{"mu", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}], "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "mu"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"mu", "+", "x"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"mu", "+", "x"}], ")"}], "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      RowBox[{"2", " ", "y$d1"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x$d1"}], "+", "y", "-", 
      FractionBox[
       RowBox[{"mu", " ", "y"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "mu", "+", "x"}], ")"}], "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "mu"}], ")"}], " ", "y"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"mu", "+", "x"}], ")"}], "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}]}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "x$d1", ",", "y$d1"}], "}"}], ",", 
   RowBox[{"{", "mu", "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.500126924162747*^9, 3.500126977101488*^9, 
  3.501826792399562*^9, 3.504613220367525*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the integrator", "Section",
 CellChangeTimes->{{3.5046130312990847`*^9, 3.504613036235671*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "threeBPEQ", ",", " ", "\[IndentingNewLine]", "\"\<threebody\>\"", ",", " ",
    "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.85", ",", "0.5", ",", "0", ",", "0"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "0.001", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "150", ",", " ", 
      RowBox[{"Points", "[", "150", "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "\"\<horseshoe\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.500126961890044*^9, 3.5001271033556557`*^9}, {
   3.5001271355265617`*^9, 3.50012713868478*^9}, 3.5046132328185587`*^9}],

Cell[BoxData["\<\"Files \\\"dr_threebody.c\\\", \\\"threebody.h\\\", \
threebody.c\\\", \\\"dp_tides.h\\\", written on directory \
\\\"/Users/abad/Dropbox/Trabajo/TidesWork/EjemplosTutorial/trescuerpos\\\".\"\
\>"], "Output",
 CellChangeTimes->{{3.5001271289889307`*^9, 3.500127139362265*^9}, 
   3.501826792927095*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the solution", "Section",
 CellChangeTimes->{{3.504613263202632*^9, 3.504613285792453*^9}}],

Cell[CellGroupData[{

Cell["Reading the file", "Subsection",
 CellChangeTimes->{{3.504613291258915*^9, 3.504613294464624*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dat", " ", "=", " ", 
  RowBox[{"OpenRead", "[", "\"\<horseshoe\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.5018268990096197`*^9, 3.5018269142437553`*^9}, 
   3.513406244555821*^9}],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"horseshoe\"\>", ",", "15"}], "]"}]], "Output",
 CellChangeTimes->{
  3.5018269149591618`*^9, 3.5018269734996634`*^9, {3.501827080738986*^9, 
   3.501827089130616*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "=", " ", 
   RowBox[{"ReadList", "[", 
    RowBox[{"dat", ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "Real", ",", " ", "Real", ",", " ", "Real", ",", " ", "Real", ",", " ", 
       "Real"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.50182692355551*^9, 3.5018269805981092`*^9}, 
   3.501827062419758*^9, 3.5018270945578537`*^9, {3.5134062465780478`*^9, 
   3.513406249202033*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Taking the coordinates x, y of the solution", "Subsection",
 CellChangeTimes->{{3.5046133136195307`*^9, 3.5046133324016867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"solxy", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], ",", " ", "sol"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.501826995943569*^9, 3.5018270337477007`*^9}, 
   3.501827116328228*^9, 3.513406252130137*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ploting the solution", "Subsection",
 CellChangeTimes->{{3.504613339996462*^9, 3.504613348513721*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"solxy", ",", " ", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.501827132954481*^9, 3.501827205810442*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdlHk41YkXxlFSGEpZo2VKGJVMsiWnUCYp0YRQ9jBDliE0McpaalBRUyRb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    "]]},
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{{3.501827155429679*^9, 3.501827165152533*^9}, 
   3.5018272064449053`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "dat", "]"}]], "Input",
 CellChangeTimes->{{3.501826964165928*^9, 3.501826967758875*^9}, 
   3.513406271763525*^9}],

Cell[BoxData["\<\"horseshoe\"\>"], "Output",
 CellChangeTimes->{3.501826968499392*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1037, 765},
WindowMargins->{{Automatic, 217}, {Automatic, 28}},
ShowSelection->True,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 119, 2, 40, "Input"],
Cell[816, 31, 1494, 39, 130, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2359, 76, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2497, 81, 170, 3, 40, "Input"],
Cell[2670, 86, 194, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2913, 94, 239, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[3177, 101, 1690, 54, 110, "Input"],
Cell[4870, 157, 2249, 72, 138, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7156, 234, 363, 8, 40, "Input"],
Cell[7522, 244, 2128, 65, 138, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9699, 315, 109, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[9833, 320, 839, 18, 156, "Input"],
Cell[10675, 340, 319, 5, 65, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11043, 351, 106, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[11174, 356, 104, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[11303, 361, 208, 4, 40, "Input"],
Cell[11514, 367, 226, 5, 40, "Output"]
}, Open  ]],
Cell[11755, 375, 444, 11, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12236, 391, 135, 1, 51, "Subsection"],
Cell[12374, 394, 469, 14, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12880, 413, 108, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[13013, 418, 260, 5, 40, "Input"],
Cell[13276, 425, 3460, 61, 579, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16773, 491, 152, 3, 40, "Input"],
Cell[16928, 496, 86, 1, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
