(* ::Package:: *)

(* ::Title:: *)
(*MathTIDES`FunctionCodes:  C function Codes*)


(* ::Text:: *)
(*Copyright (C) 2010  Alberto Abad, Roberto Barrio, Fernando Blesa, Marcos Rodriguez*)
(*Grupo de Mec\[AAcute]nica Espacial.  IUMA.*)
(*University of Zaragoza*)
(*50009 Zaragoza. Spain.*)
(**)
(*http://gme.unizar.es/software/tides*)


(* ::Text:: *)
(*This file is part of TIDES.*)
(*  	*)
(*TIDES is free software : you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.*)
(*  	*)
(*TIDES is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.*)
(*  	*)
(*You should have received a copy of the GNU General Public License along with TIDES.  If not, see < http://www.gnu.org/licenses/ > .*)


(* ::Text:: *)
(*v - 20*)


(* ::Title::Closed:: *)
(*FunctionCodes*)


(* ::Section::Closed:: *)
(*Contexto y diccionario*)


(* ::Subsection::Closed:: *)
(*Comienzo*)


BeginPackage["MathTIDES`FunctionCodes`",
				"MathTIDES`MinimalCode`",
					"MathTIDES`LKFunctions`"]


(* ::Subsection::Closed:: *)
(*S\[IAcute]mbolos*)


{
TidesFunction,
FunctionCodeFiles,
Rounding,
TextCodeCFunction,
TextCodeHFunction,
dpFunctionEvaluation,
dpGradientEvaluation,
mpFunctionEvaluation,
mpGradientEvaluation, 
headDPFunEv,
headMPFunEv,
RNDN,RNDD,RNDU,RNDZ
}


(* ::Subsection::Closed:: *)
(*Protecci\[OAcute]n*)


Unprotect @@ Names["MathTIDES`FunctionCodes`*"]
Clear @@ Names["MathTIDES`FunctionCodes`*"]


(* ::Section::Closed:: *)
(*Mensajes*)


Begin["`mess`"]


FunctionCodeFiles::"vecfun"="We can not compute the gradient of a vectorial function. Try the jacobian."


End[]


(* ::Section::Closed:: *)
(*C\[OAcute]digo*)


(* ::Subsection::Closed:: *)
(*Comienzo*)


Begin["`code`"]


(* ::Subsection::Closed:: *)
(*Auxiliar*)


CstrConstmpAux2[LKF$Constant[E], var_String]:= 
	"\tmpfr_set_si("<> var <> ", 1, rnd);\n"<>
	"\tmpfr_exp("<> var <> ","<> var <>", rnd);\n";
CstrConstmpAux2[LKF$Constant[Pi], var_String]:= 
	"\tmpfr_const_pi("<> var <> ", rnd);\n";
CstrConstmpAux2[LKF$Constant[x_Integer], var_String]:= 
	"\tmpfr_set_si("<> var <> ","<> ToString[x] <>", rnd);\n";
CstrConstmpAux2[LKF$Constant[x_Rational], var_String]:= 
	"\tmpfr_set_si("<> var <> ","<> ToString[Numerator[x]] <>", rnd);\n" <>
	"\tmpfr_div_si("<> var <> ","<> var <> ","<> ToString[Denominator[x]] <>", rnd);\n" ;
CstrConstmpAux2[LKF$Constant[x_Real], var_String]:= 
	"\tmpfr_set_str(&"<> var <> ","<> ToString[N[x, Precision[x]]] <>", rnd);\n";



CstrConstmp2[LKF$Const[n_]]:= "ct[" <> ToString[n-1] <> "]";

CstrConstmp2[LKF$Constant[f_,x_], i_]:= 
	Module[{par,texto},
		par = "ct["<>ToString[i-1] <> "]";
		texto = CstrConstmpAux2[LKF$Constant[x], par ];
		texto = texto <> "\t"<>strFunCmp2[f]<>"(" <> par <> ", " <> par <> ", rnd);\n";
		texto]
CstrConstmp2[x_LKF$Constant, i_]:= 
	CstrConstmpAux2[x, "ct["<> ToString[i-1] <> "]" ]

CstrConstmp2[LKF$Plus[x_,y_],i_]:= 
	"\tmpfr_add(ct["<> ToString[i-1] <> "], "<> CstrConstmp[x] <> "," <> CstrConstmp[y] <>",rnd);\n";
CstrConstmp2[LKF$Times[x_,y_], i_]:= 	
	"\tmpfr_mul(ct["<> ToString[i-1] <> "], "<> CstrConstmp[x] <> "," <> CstrConstmp[y] <>",rnd);\n";
CstrConstmp2[LKF$Power[x_,y_], i_]:= 
	"\tmpfr_pow(ct["<> ToString[i-1] <> "], "<> CstrConstmp[x] <> "," <> CstrConstmp[y] <>",rnd);\n";
CstrConstmp2[LKF$Divide[x_,y_], i_]:= 
	"\tmpfr_div(ct["<> ToString[i-1] <> "], "<> CstrConstmp[x] <> "," <> CstrConstmp[y] <>",rnd);\n";
CstrConstmp2[h_[x_], i_]:= 
	"\t"<>strFunCmp2[h]<>"(ct["<>ToString[i-1] <> "],"<> CstrConstmp[x] <> ",rnd);\n";



TextMP2Constants[x_]:= 
	Module[{len,texto=""},
		len = Length[x];
		texto = texto <>"\tint NCONST = "<>ToString[len]<>";\n";
		texto = texto <>"\tmpfr_t ct[NCONST];\n";
		texto = texto <> "\tfor(i = 0; i < NCONST ; i++ ) { ";
		texto = texto<>"\n\t\tmpfr_init2(ct[i], prec);\n\t}\n";
		texto = texto<>(StringJoin @@ Map[CstrConstmp2[x[[#]],#]&, Range[len]]);
		texto] 


(* ::Subsection::Closed:: *)
(*C\[OAcute]digo*)


FunctionCodeFiles /:
	Options[FunctionCodeFiles]= {
		Precision -> Double,
		Rounding -> RNDN,
		Evaluate -> Function
	}


tTox[TidesFunction[a_,b_,c_,d___]]:=
	TidesFunction[a,Append[c,b],d]


TextCodeCFunction[fun_, name_?StringQ, opt___Rule]:=
		Module[{pr, rnd, eval, time, textprev = "", textfn, lkf, sigo = True},
			{pr,rnd, eval} = {Precision, Rounding, Evaluate}/.
				{opt}/.Options[FunctionCodeFiles];
			If[Head[fun[[2]]] === Symbol,
				time = True; 
				lkf = ToLKFCPar @@ tTox[fun],
				time = False; 
				lkf = ToLKFCPar @@ fun];
			If[ pr === Multiple, 
				textprev = 
					"#if (!defined(MPFR_VERSION) || (MPFR_VERSION < MPFR_VERSION_NUM(3,0,0)))\n" <>
					"#define RND_METHOD GMP_RNDN\n" <>
					"#else\n" <>
					"#define RND_METHOD MPFR_RNDN\n" <>
					"#endif\n\n";];
			rnd = "GMP_"<> ToString[rnd];
			If[pr === Double && eval === Function, 
					textfn = dpFunctionEvaluation[lkf, name, time]];
			If[pr === Double && eval === Gradient, 
					textfn = dpGradientEvaluation[lkf, name, time]];
			If[pr === Double && eval === Jacobian, 
					textfn = dpGradientEvaluation[lkf, name, time]];
			If[pr === Multiple && eval === Function, 
					textfn = mpFunctionEvaluation[lkf, name, rnd, time]];
			If[pr === Multiple && eval === Gradient, 
					textfn = mpGradientEvaluation[lkf, name, rnd, time]];
			If[pr === Multiple && eval === Jacobian, 
					textfn = mpGradientEvaluation[lkf, name, rnd, time]];
			
			textprev<>textfn
		]



TextCodeHFunction[fun_, name_?StringQ, opt___Rule]:=
		Module[{ pr, eval, time, texth, texthb, lkf},
			{pr,eval} = {Precision, Evaluate}/.
				{opt}/.Options[FunctionCodeFiles];
			If[Head[fun[[2]]] === Symbol,
				time = True; 
				lkf = ToLKFCPar @@ tTox[fun],
				time = False; 
				lkf = ToLKFCPar @@ fun]; 
			If[pr === Double && eval === Function, 
				texthb = headDPFunEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			If[pr === Double && eval === Gradient, 
				texthb = headDPGradEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			If[pr === Double && eval === Jacobian, 
				texthb = headDPGradEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			If[pr === Multiple && eval === Function, 
				texthb = headMPFunEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			If[pr === Multiple && eval === Gradient, 
				texthb = headMPGradEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			If[pr === Multiple && eval === Jacobian, 
				texthb = headMPGradEv[lkf[[1]], lkf[[2]], Length[lkf[[6]]],name, time]<>";\n"];
			texth = headFile1[name] ;
			texth = texth <> includeMath;
			If[pr === Multiple, texth = texth <> includeMpfr];
			texth = texth <>"\n"<> texthb <> headFile2;
			texth
		]



FunctionCodeFiles[x_TidesFunction, name_?StringQ, opt___Rule]:=
		Module[{lkf, textfn, texth, namet, namec, nameh, pr, eval, sigo = True},
			{pr,eval} = {Precision,Evaluate} /.{opt}/.Options[FunctionCodeFiles];
			
			If[Head[x[[1]]]=== List && Length[x[[1]]]>1 && eval === Gradient,
				Message[FunctionCodeFiles::"vecfun"]; sigo = False];

			If[sigo ,
				textfn = "#include \""<> name <>".h\"\n\n";
				textfn = textfn <> TextCodeCFunction[x, name, opt];
				texth = TextCodeHFunction[x, name, opt];

				textfn = gmecopyrightC[] <> textfn;
				texth = gmecopyrightC[] <> texth ;

				namet = name <> ".txt";
				namec = name <> ".c";
				nameh = name <> ".h";
				Off[DeleteFile::nffil];
				Export[namet, textfn];
				DeleteFile[namec];
				RenameFile[namet,namec];
				Export[namet, texth];
				DeleteFile[nameh];
				RenameFile[namet,nameh];
				On[DeleteFile::nffil];
				EndMessage[name]]
		]



EndMessage[name_?StringQ]:= 
	Module[{texto},
		texto  = "Files ";
		texto = texto <> "\"" <> name <> ".h\" and ";
		texto = texto <> name <> ".c\"";
	    texto = texto <> " written on directory \""<> Directory[]<> "\".";
		texto]


headFile1[name_]:=
	Module[{texto},
		texto = "\n\n#ifndef Header_"<> name <> "_h\n";
		texto = texto <> "#define Header_"<> name <> "_h\n";
		texto]

headFile2 = "\n\n#endif\n\n\n"



(* ::Subsection::Closed:: *)
(*Doble precisi\[OAcute]n*)


$listConstants = {}


headDPFunEv[nvar_, 0,nfun_,name_, False]:= 
	"void "<>name <> "(double *x, double *f)";
headDPFunEv[nvar_, npar_, nfun_,name_, False]:= 
	"void "<>name <> "(double *x, double *p, double *f)";


headDPFunEv[nvar_, npar_, nfun_,name_, True]:= 
	"void "<>name <> "(double t, double *x, double *p, double *f)";


headDPGradEv[nvar_, 0,1,name_, False]:= 
	"void "<>name <> "(double *x, double *f, double *grad)";
headDPGradEv[nvar_, npar_,1,name_, False]:= 
	"void "<>name <> "(double *x, double *p, double *f, double *grad)";


headDPGradEv[nvar_, npar_,1,name_, True]:= 
	"void "<>name <> "(double t, double *x, double *p, double *f, double *grad)";


headDPGradEv[1, 0,nfun_,name_, False]:= 
	"void "<>name <> "(double *x, double *f, double *jacob)";
headDPGradEv[1,npar_,nfun_,name_, False]:= 
	"void "<>name <> "(double *x, double *p, double *f, double *jacob)";
headDPGradEv[nvar_, 0, nfun_, name_, False]:= 
	"void "<>name <> "(double *x, double *f, double jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";
headDPGradEv[nvar_, npar_, nfun_, name_, False]:= 
	"void "<>name <> "(double *x, double *p, double *f, double jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";


headDPGradEv[1,npar_,nfun_,name_, True]:= 
	"void "<>name <> "(double t, double *x, double *p, double *f, double *jacob)";
headDPGradEv[nvar_, npar_, nfun_, name_, True]:= 
	"void "<>name <> "(double t, double *x, double *p, double *f, double jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";


includeMath = "#include <math.h>\n";
includeMpfr = "#include \"mpfr.h\"\n";


initDPFunEv[nvar_, npar_,tpar_, nlinks_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tdouble var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) var[i] = x[i];\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) par[i] = p[i];\n";];
		texto 
]

initDPFunTEv[nvar_, npar_,tpar_, nlinks_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tdouble var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS-1 ; i++ ) var[i] = x[i];\n";
		texto = texto<>"\tvar[NVARS-1] = t;\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) par[i] = p[i];\n";];
		texto 
]


initDPGradEv[nvar_, npar_,tpar_, nlinks_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i,j;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tdouble var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto <> "\tdouble gvar[NVARS][NVARS], glink[NLINKS][NVARS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<>"\t\tvar[i] = x[i];\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) gvar[i][j] = 0.0;\n";
		texto = texto<>"\t\tgvar[i][i] = 1.0;\n\t}\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) par[i] = p[i];\n";];
		texto 
]

initDPGradTEv[nvar_, npar_,tpar_, nlinks_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i,j;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tdouble var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto <> "\tdouble gvar[NVARS][NVARS], glink[NLINKS][NVARS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<>"\t\tif(i<NVARS-1) var[i] = x[i];\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) gvar[i][j] = 0.0;\n";
		texto = texto<>"\t\tgvar[i][i] = 1.0;\n\t}\n";
		texto = texto<>"\tvar[NVARS-1] = t;\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) par[i] = p[i];\n";];
		texto 
]


strOBJCdp[LKF$Var[n_]]:= "var[" <> ToString[n-1] <> "]";
strOBJCdp[LKF$Link[n_]]:= "link[" <> ToString[n-1] <> "]";
strOBJCdp[LKF$Par[n_]]:= "par[" <> ToString[n-1] <> "]";
strOBJCdp[LKF$Par[n_]-1]:= "par[" <> ToString[n-1] <> "]-1";
strOBJCdp[LKF$Const[n_]]:= $listConstants[[n]]
strOBJCdp[LKF$Const[n_]-1]:= 
	ToString[CForm[ToExpression[$listConstants[[n]]]-1]]


strOBJGradCdp[LKF$Var[n_]]:= "gvar[" <> ToString[n-1] <> "][i]";
strOBJGradCdp[LKF$Link[n_]]:= "glink[" <> ToString[n-1] <> "][i]";
strOBJGradCdp[LKF$Par[n_]]:= "0.0";
strOBJGradCdp[LKF$Const[x__]]:="0.0";
strOBJGradCdp[x_?numberSQ]:= "0.0";


strOBJGradCdp1[LKF$Var[n_]]:= "gvar[" <> ToString[n-1] <> "][0]";
strOBJGradCdp1[LKF$Link[n_]]:= "glink[" <> ToString[n-1] <> "][0]";
strOBJGradCdp1[LKF$Par[n_]]:= "0.0";
strOBJGradCdp1[LKF$Const[x__]]:="0.0";
strOBJGradCdp1[x_?numberSQ]:= "0.0";


CFunDpPARAMS[np_,pit_,pr_ ]:= 
	(StringJoin @@ Map[CstrPITER[pit[[#]],#,pr]&, Range[Length[pit]]]) 


CstrPITER[LKF$Constant[x__], i_, p_]:= 
	"\tpar[" <> ToString[i+p-1] <> "] = " <> strOBJCdp[LKF$Constant[x]] <> ";\n";
CstrPITER[LKF$Plus[x_,y_], i_, p_]:= 
	"\tpar[" <> ToString[i+p-1] <> "] = " <> strOBJCdp[x] <> " + " <> strOBJCdp[y] <> ";\n";
CstrPITER[LKF$Times[x_,y_], i_, p_]:= 	
	"\tpar[" <> ToString[i+p-1] <> "] = " <> strOBJCdp[x] <> " * " <> strOBJCdp[y] <> ";\n"
CstrPITER[LKF$Power[x_,y_], i_, p_]:= 
	"\tpar[" <> ToString[i+p-1] <> "] = pow(" <> strOBJCdp[x] <> "," <> strOBJCdp[y] <> ");\n";
CstrPITER[LKF$Divide[x_,y_], i_, p_]:= 
	"\tpar[" <> ToString[i+p-1] <> "] = " <> strOBJCdp[x] <> " / " <> strOBJCdp[y] <> ";\n";
CstrPITER[h_[x_], i_, p_]:= 
	"\tpar[" <> ToString[i+p-1] <> "] = " <> strFunC[h] <> "(" <> strOBJCdp[x] <> ");\n";


CFunDpITERS[it_]:=
	 StringJoin @@ Map[CstrFunITER[#]&, it];


CstrFunITER[LKF$Par[_]== h_]:= "";

CstrFunITER[iz_ == h_[x_]]:=
	"\t" <> strOBJCdp[iz] <> " = " <> 
	strFunC[h] <> "(" <> strOBJCdp[x] <> ");\n"
CstrFunITER[iz_ ==LKF$Plus[x_,y_]]:=
	"\t" <> strOBJCdp[iz] <> " = " <> 
	strOBJCdp[x] <> " + " <> strOBJCdp[y] <> ";\n"
CstrFunITER[iz_ ==LKF$Times[x_,y_]]:=
	"\t" <> strOBJCdp[iz] <> " = " <> 
	strOBJCdp[x] <> " * " <> strOBJCdp[y] <> ";\n"
CstrFunITER[iz_ ==LKF$Divide[x_,y_]]:=
	"\t" <> strOBJCdp[iz] <> " = " <> 
	strOBJCdp[x] <> " / " <> strOBJCdp[y] <> ";\n"
CstrFunITER[iz_ ==LKF$Power[x_,y_]]:=
	"\t" <> strOBJCdp[iz] <> " = pow(" <> 
	strOBJCdp[x] <> "," <> strOBJCdp[y] <> ");\n"
CstrFunITER[iz_ ==LKF$Divide[1,y_]]:=
	"\t" <> strOBJCdp[iz] <> " =  1 / " <> strOBJCdp[y] <> ";\n"
CstrFunITER[iz_ == LKF$Constant[x__]]:=
	"\t" <> strOBJCdp[iz] <> " = " <> strOBJCdp[x] <> ";\n"


CGradDpITERS[it_]:=
	 StringJoin @@ Map[CstrGradITER[#]&, it];


CstrGradITER[LKF$Par[_]== h_]:= "";
CstrGradITER[LKF$Const[_]== h_]:= "";

CstrGradITER[iz_ == LKF$Sin[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> "cos("<> 
	strOBJCdp[x] <> ")*" <> strOBJGradCdp[x]<> ";\n";
CstrGradITER[iz_ == LKF$Cos[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> "- sin("<> 
	strOBJCdp[x] <> ")*" <> strOBJGradCdp[x]<> ";\n";
CstrGradITER[iz_ == LKF$Tan[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/pow(cos("<> strOBJCdp[x]<>"),2);\n";

CstrGradITER[iz_ == LKF$Sinh[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> "cosh("<> 
	strOBJCdp[x] <> ")*" <> strOBJGradCdp[x]<> ";\n";
CstrGradITER[iz_ == LKF$Cosh[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> "sinh("<> 
	strOBJCdp[x] <> ")*" <> strOBJGradCdp[x]<> ";\n";
CstrGradITER[iz_ == LKF$Tan[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/pow(cosh("<> strOBJCdp[x]<>"),2);\n";



CstrGradITER[iz_ == LKF$ArcSin[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/sqrt(1-"<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>");\n";
CstrGradITER[iz_ == LKF$ArcCos[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = -" <> strOBJGradCdp[x]<> 
	"/sqrt(1-"<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>");\n";
CstrGradITER[iz_ == LKF$ArcTan[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/(1+"<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>");\n";

CstrGradITER[iz_ == LKF$ArcSinh[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/sqrt(1+"<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>");\n";
CstrGradITER[iz_ == LKF$ArcCosh[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/sqrt("<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>" - 1);\n";
CstrGradITER[iz_ == LKF$ArcTanh[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/(1-"<> strOBJCdp[x]<>"*" <>strOBJCdp[x]<>");\n";

CstrGradITER[iz_ == LKF$Log[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"/"<>strOBJCdp[x]<>";\n";
CstrGradITER[iz_ == LKF$Exp[x_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<> 
	"*"<>strOBJCdp[iz]<>";\n";


CstrGradITER[iz_ == LKF$Plus[x_,y_?constantLKFQ]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<>";\n";
CstrGradITER[iz_ == LKF$Plus[x_?constantLKFQ,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[y]<>";\n";
CstrGradITER[iz_ == LKF$Plus[x_,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJGradCdp[x]<>"+"<> 
		strOBJGradCdp[y]<>";\n";

CstrGradITER[iz_ == LKF$Times[x_,y_?constantLKFQ]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <>strOBJCdp[y]<>
	"*"<> strOBJGradCdp[x]<>";\n";
CstrGradITER[iz_ == LKF$Times[x_?constantLKFQ,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <>strOBJCdp[x]<>
	"*"<> strOBJGradCdp[y]<>";\n";
CstrGradITER[iz_ == LKF$Times[x_,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <>strOBJCdp[x]<>
	"*"<> strOBJGradCdp[y]<>"+"<>strOBJCdp[y]<>
	"*"<> strOBJGradCdp[x]<> ";\n";

CstrGradITER[iz_ == LKF$Divide[x_,y_?constantLKFQ]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> 
	"("<>strOBJGradCdp[x]<>"/"<>strOBJCdp[y]<>")"<>";\n";
CstrGradITER[iz_ == LKF$Divide[1,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> 
	"-("<>strOBJGradCdp[y]<>"/("<>
		strOBJCdp[y]<>"*"<>strOBJCdp[y]<>"))"<>";\n";
CstrGradITER[iz_ == LKF$Divide[x_?constantLKFQ,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> 
	"-("<>strOBJCdp[x]<>"*"<>strOBJGradCdp[y]<>"/("<>
		strOBJCdp[y]<>"*"<>strOBJCdp[y]<>"))"<>";\n";
CstrGradITER[iz_ == LKF$Divide[x_,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> 
	"("<>strOBJGradCdp[x]<>"/"<>strOBJCdp[y]<>")"<>
	"-("<>strOBJCdp[x]<>"*"<>strOBJGradCdp[y]<>"/("<>
		strOBJCdp[y]<>"*"<>strOBJCdp[y]<>"))"<>";\n";

CstrGradITER[iz_ == LKF$Power[x_?constantLKFQ,y_]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJCdp[iz] <>"*log(" <> 
	strOBJCdp[x]<>")*"<> strOBJGradCdp[y]<> ";\n";

CstrGradITER[iz_ == LKF$Power[x_,y_?constantLKFQ]]:=
	"\t\t" <> strOBJGradCdp[iz] <> " = " <> strOBJCdp[y] <>"*pow("<> 
	strOBJCdp[x] <> ","<>strOBJCdp[y-1] <>")*" <> 
	strOBJGradCdp[x]<> ";\n";


CstrGradITER[x_]:="\t\t!!!!!!"<>ToString[x]<>"\n";



constantLKFQ[LKF$Par[_]]:=True;
constantLKFQ[LKF$Const[__]]:=True;
constantLKFQ[LKF$Constant[__]]:=True;
constantLKFQ[x_?numberSQ]:=True;
constantLKFQ[x_]:=False;


CFunDpEnd[x_]:=
	StringJoin @@Map[("\tf["<>ToString[#-1]<>"] = "<> strOBJCdp[x[[#]]]<> ";\n")&, 
			Range[Length[x]]]


CGradDpEnd[x_]:=
	Module[{nfun},
		nfun = Length[x];
		If[nfun == 1, "\t\tgrad[i] = "<> strOBJGradCdp[x[[1]]]<> ";\n",
			StringJoin @@Map[
			("\t\tjacob["<>ToString[#-1]<>"][i] = "<> strOBJGradCdp[x[[#]]]<> ";\n")&, 
			Range[Length[x]]]]]


CGradDpEnd1[x_]:=
	Module[{nfun},
		nfun = Length[x];
		StringJoin @@Map[
			("\tjacob["<>ToString[#-1]<>"] = "<> strOBJGradCdp1[x[[#]]]<> ";\n")&, 
			Range[Length[x]]]]


dpFunctionEvaluation[fun_LKFCPar, name_, time_]:=
	Module[{nvar,npar,tpar,nfun, nlinks,  texto=""},
		nvar = fun[[1]];
		npar= fun[[2]];
		$listConstants = ListCTextConstants[fun[[3]]];
		tpar = npar + Length[fun[[4]]];
		nlinks= Length[fun[[5]]];
		nfun= Length[fun[[6]]];
		texto = headDPFunEv[nvar, npar,nfun,name,time];
		If[time, 
			texto = texto <>initDPFunTEv[nvar,npar,tpar,nlinks],
			texto = texto <>initDPFunEv[nvar,npar,tpar,nlinks]];
		texto = texto <>CFunDpPARAMS[tpar,fun[[4]],npar];
		texto = texto<> CFunDpITERS[IterationLKF[fun[[5]]]];
		texto = texto<>  CFunDpEnd[fun[[6]]];
		texto = texto <> "}\n\n";
		$listConstants = {};
		texto
	]


dpGradientEvaluation[fun_LKFCPar, name_, time_]:=
	Module[{nvar,npar,tpar,nlinks,nfun,itlkf,  texto=""},
		nvar = fun[[1]];
		npar= fun[[2]];
		$listConstants = ListCTextConstants[fun[[3]]];
		tpar = npar + Length[fun[[4]]];
		nlinks= Length[fun[[5]]];
		nfun= Length[fun[[6]]];
		itlkf = IterationLKF[fun[[5]]];
		texto = headDPGradEv[nvar, npar,nfun,name,time];
		If[time, 
			texto = texto <>initDPGradTEv[nvar,npar,tpar, nlinks],
			texto = texto <>initDPGradEv[nvar,npar,tpar, nlinks]];
		texto = texto <>CFunDpPARAMS[tpar,fun[[4]],npar];
		texto = texto<> CFunDpITERS[itlkf];
		texto = texto<> CFunDpEnd[fun[[6]]];
		texto = texto<> "\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<> CGradDpITERS[itlkf];
		If[nvar == 1 && nfun > 1, 
			texto = texto <> "\t}\n";
				texto = texto<> CGradDpEnd1[fun[[6]]],
			texto = texto<> CGradDpEnd[fun[[6]]];
				texto = texto <> "\t}\n"];
		texto = texto <> "}\n\n";
		$listConstants = {};
		texto
	]


(* ::Subsection::Closed:: *)
(*Multiple  precisi\[OAcute]n*)


headMPFunEv[nvar_, 0,nfun_,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *f)";
headMPFunEv[nvar_, npar_, nfun_,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *p, mpfr_t *f)";


headMPFunEv[nvar_, npar_, nfun_,name_, True]:= 
	"void "<>name <> "(mpfr_t t, mpfr_t *x, mpfr_t *p, mpfr_t *f)";


headMPGradEv[nvar_, 0,1,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *f, mpfr_t *grad)";
headMPGradEv[nvar_, npar_,1,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t *grad)";


headMPGradEv[nvar_, npar_,1,name_, True]:= 
	"void "<>name <> "(mpfr_t t, mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t *grad)";


headMPGradEv[1,npar_,nfun_,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t *jacob)";
headMPGradEv[1,npar_,nfun_,name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t *jacob)";
headMPGradEv[nvar_, 0, nfun_, name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *f, mpfr_t jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";
headMPGradEv[nvar_, npar_, nfun_, name_, False]:= 
	"void "<>name <> "(mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";


headMPGradEv[1,npar_,nfun_,name_, True]:= 
	"void "<>name <> "(mpfr_t t, mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t *jacob)";
headMPGradEv[nvar_, npar_, nfun_, name_, True]:= 
	"void "<>name <> "(mpfr_t t, mpfr_t *x, mpfr_t *p, mpfr_t *f, mpfr_t jacob["<>
	ToString[nfun]<>"]["<>ToString[nvar]<>"])";


initMPFunEv[nvar_, npar_,tpar_, nlinks_, nconsts_, rnd_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i, prec;\n";
		texto = texto <> "\tprec = mpfr_get_prec(f[0]);\n";
		texto = texto <> "\tmp_rnd_t rnd = RND_METHOD;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tmpfr_t var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(var[i], prec);";
		texto = texto<>"\n\t\tmpfr_set(var[i], x[i], rnd);\n\t}\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < TPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_init2(par[i], prec);\n\t}\n";
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_set(par[i], p[i], rnd);\n\t}\n"];
		texto = texto<>"\tfor(i = 0; i < NLINKS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(link[i], prec);\n\t}\n";
		texto 
]

initMPFunTEv[nvar_, npar_,tpar_, nlinks_, nconsts_, rnd_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i, prec;\n";
		texto = texto <> "\tprec = mpfr_get_prec(f[0]);\n";
		texto = texto <> "\tmp_rnd_t rnd = RND_METHOD;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tmpfr_t var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(var[i], prec);";
		texto = texto<>"\n\t\tmpfr_set(var[i], x[i], rnd);\n\t}\n";
		texto = texto<>"\tmpfr_set(var[NVARS-1], t, rnd);\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < TPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_init2(par[i], prec);\n\t}\n";
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_set(par[i], p[i], rnd);\n\t}\n"];
		texto = texto<>"\tfor(i = 0; i < NLINKS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(link[i], prec);\n\t}\n";
		texto 
]


initMPGradEv[nvar_, npar_,tpar_, nlinks_, nconsts_, rnd_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i, j, prec;\n";
		texto = texto <> "\tprec = mpfr_get_prec(f[0]);\n";
		texto = texto <> "\tmp_rnd_t rnd = RND_METHOD;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tmpfr_t var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto <> "\tmpfr_t gvar[NVARS][NVARS], glink[NLINKS][NVARS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<>"\t\tmpfr_init2(var[i], prec);\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) {\n\t\t\tmpfr_init2(gvar[i][j], prec);\n";
		texto = texto<>"\t\t\tmpfr_set_si(gvar[i][j], 0, rnd);\n\t\t}\n";
		texto = texto<>"\t\tmpfr_set(var[i], x[i], rnd);\n";
		texto = texto<>"\t\tmpfr_set_si(gvar[i][i], 1, rnd);\n\t}\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < TPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_init2(par[i],prec);\n\t}\n";
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_set(par[i], p[i], rnd);\n\t}\n"];
		texto = texto<>"\tfor(i = 0; i < NLINKS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(link[i], prec);";
		texto = texto<>"\n\t\tmpfr_set_si(link[i], 0, rnd);\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) {\n";
		texto = texto<>"\t\t\tmpfr_init2(glink[i][j], prec);\n";
		texto = texto<>"\t\t\tmpfr_set_si(glink[i][j], 0, rnd);\n\t\t}\n\t}\n";
		texto = texto <> "\tmpfr_t aux;\n";
		texto = texto <> "\tmpfr_init2(aux, prec);\n";
		texto 
]

initMPGradTEv[nvar_, npar_,tpar_, nlinks_, nconsts_, rnd_]:=
	Module[{texto=""},
		texto = texto <> "\n{\n";
		texto = texto <> "\tint i, j, prec;\n";
		texto = texto <> "\tprec = mpfr_get_prec(f[0]);\n";
		texto = texto <> "\tmp_rnd_t rnd = RND_METHOD;\n";
		texto = texto <> "\tint NVARS = "<> ToString[nvar]<>", ";
		If[npar  =!= 0, 
			texto = texto <> "NPARS = "<> ToString[npar]<>", ";];
		If[tpar  =!= 0, 
			texto = texto <> "TPARS = "<> ToString[tpar]<>", ";];
		texto = texto <> "NLINKS = "<> ToString[nlinks]<>";\n";
		texto = texto <> "\tmpfr_t var[NVARS], ";
		If[tpar  =!= 0,texto = texto <>"par[TPARS], "];
		texto = texto <> "link[NLINKS];\n";
		texto = texto <> "\tmpfr_t gvar[NVARS][NVARS], glink[NLINKS][NVARS];\n";
		texto = texto<>"\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<>"\t\tmpfr_init2(var[i], prec);\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) {\n\t\t\tmpfr_init2(gvar[i][j], prec);\n";
		texto = texto<>"\t\t\tmpfr_set_si(gvar[i][j], 0, rnd);\n\t\t}\n";
		texto = texto<>"\t\tif(i<NVARS-1) mpfr_set(var[i], x[i], rnd);\n";
		texto = texto<>"\t\tmpfr_set_si(gvar[i][i], 1, rnd);\n\t}\n";
		texto = texto<>"\tmpfr_set(var[NVARS-1], t, rnd);\n";
		If[npar  =!= 0, 
			texto = texto <> "\tfor(i = 0; i < TPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_init2(par[i], prec);\n\t}\n";
			texto = texto <> "\tfor(i = 0; i < NPARS ; i++ ) { ";
			texto = texto<>"\n\t\tmpfr_set(par[i], p[i], rnd);\n\t}\n"];
		texto = texto<>"\tfor(i = 0; i < NLINKS ; i++ ) {";
		texto = texto<>"\n\t\tmpfr_init2(link[i], prec);";
		texto = texto<>"\n\t\tmpfr_set_si(link[i], 0, rnd);\n";
		texto = texto<>"\t\tfor(j = 0; j < NVARS ; j++ ) {\n";
		texto = texto<>"\t\t\tmpfr_init2(glink[i][j], prec);\n";
		texto = texto<>"\t\t\tmpfr_set_si(glink[i][j], 0, rnd);\n\t\t}\n\t}\n";
		texto = texto <> "\tmpfr_t aux;\n";
		texto = texto <> "\tmpfr_init2(aux, prec);\n";
		texto 
]


strOBJCmp[LKF$Var[n_]]:= "var[" <> ToString[n-1] <> "]";
strOBJCmp[LKF$Link[n_]]:= "link[" <> ToString[n-1] <> "]";
strOBJCmp[LKF$Par[n_]]:= "par[" <> ToString[n-1] <> "]";
strOBJCmp[LKF$Const[n_]]:= "ct[" <> ToString[n-1] <> "]";
strOBJCmp[]:= ""


strOBJGradCmp[LKF$Var[n_]]:= "gvar[" <> ToString[n-1] <> "][i]";
strOBJGradCmp[LKF$Link[n_]]:= "glink[" <> ToString[n-1] <> "][i]";


strFunCmp2[LKF$Power]:= "mpfr_pow";
strFunCmp2[LKF$Sin]:= "mpfr_sin";
strFunCmp2[LKF$Cos]:= "mpfr_cos";
strFunCmp2[LKF$Tan]:= "mpfr_tan";
strFunCmp2[LKF$Sinh]:= "mpfr_sinh";
strFunCmp2[LKF$Cosh]:= "mpfr_cosh";
strFunCmp2[LKF$Tanh]:= "mpfr_tanh";
strFunCmp2[LKF$ArcSin]:= "mpfr_asin";
strFunCmp2[LKF$ArcCos]:= "mpfr_acos";
strFunCmp2[LKF$ArcTan]:= "mpfr_atan";
strFunCmp2[LKF$ArcSinh]:= "mpfr_asinh";
strFunCmp2[LKF$ArcCosh]:= "mpfr_acosh";
strFunCmp2[LKF$ArcTanh]:= "mpfr_atanh";
strFunCmp2[LKF$Log]:= "mpfr_log";
strFunCmp2[LKF$Exp]:= "mpfr_exp";
strFunCmp2[Sin]:= "mpfr_sin";
strFunCmp2[Cos]:= "mpfr_cos";
strFunCmp2[Tan]:= "mpfr_tan";
strFunCmp2[Sinh]:= "mpfr_sinh";
strFunCmp2[Cosh]:= "mpfr_cosh";
strFunCmp2[Tanh]:= "mpfr_tanh";
strFunCmp2[ArcSin]:= "mpfr_asin";
strFunCmp2[ArcCos]:= "mpfr_acos";
strFunCmp2[ArcTan]:= "mpfr_atan";
strFunCmp2[ArcSinh]:= "mpfr_asinh";
strFunCmp2[ArcCosh]:= "mpfr_acosh";
strFunCmp2[ArcTanh]:= "mpfr_atanh";
strFunCmp2[Log]:= "mpfr_log";
strFunCmp2[Exp]:= "mpfr_exp";



CFunMpPARAMS[np_,pit_,pr_ ]:= 
	(StringJoin @@ Map[CstrPITERmp[pit[[#]],#,pr]&, Range[Length[pit]]]) 


CstrPITERmp[LKF$Plus[x_,y_], i_, p_]:= 
	"\tmpfr_add(par["<>ToString[i+p-1] <> "], "<> strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";
CstrPITERmp[LKF$Times[x_,y_], i_, p_]:= 	
	"\tmpfr_mul(par["<>ToString[i+p-1] <> "], "<> strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";
CCstrPITERmp[LKF$Power[x_,y_], i_, p_]:= 
	"\tmpfr_pow(par["<>ToString[i+p-1] <> "], "<> strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";
CstrPITERmp[LKF$Divide[x_,y_], i_, p_]:= 
	"\tmpfr_div(par["<>ToString[i+p-1] <> "], "<> strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";
CstrPITERmp[h_[x_], i_, p_]:= 
	"\t"<>strFunCmp2[h]<>"(par["<>ToString[i+p-1] <> "], "<> strOBJCmp[x] <> ", rnd);\n";


CFunMpITERS[it_]:=
	 StringJoin @@ Map[CstrFunITERmp[#]&, it];



CstrFunITERmp[iz_ ==LKF$Plus[x_,y_]]:=
	"\tmpfr_add(" <> strOBJCmp[iz]<> ", " <> 
	strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";

CstrFunITERmp[iz_ ==LKF$Times[x_,y_]]:=
	"\tmpfr_mul(" <> strOBJCmp[iz]<> ", " <> 
	strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";

CstrFunITERmp[iz_ ==LKF$Divide[1,y_]]:=
	"\tmpfr_si_div(" <> strOBJCmp[iz]<> ", 1, " <> 
	strOBJCmp[y] <>", rnd);\n";

CstrFunITERmp[iz_ ==LKF$Divide[x_,y_]]:=
	"\tmpfr_div(" <> strOBJCmp[iz]<> ", " <> 
	strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";

CstrFunITERmp[iz_ ==LKF$Power[x_,y_]]:=
	"\tmpfr_pow(" <> strOBJCmp[iz]<> ", " <> 
	strOBJCmp[x] <> ", " <> strOBJCmp[y] <>", rnd);\n";

CstrFunITERmp[iz_ ==LKF$Const[x__]]:=
	"\tmpfr_set(" <> strOBJCmp[iz]<> ", " <>  strOBJCmp[LKF$Const[x]] <> ", rnd);\n";	

CstrFunITERmp[iz_ == h_[x_]]:=
	"\t"<> strFunCmp2[h] <> "("<> strOBJCmp[iz] <> ", " <> strOBJCmp[x] <>", rnd);\n";



CGradMpITERS[it_]:=
	 StringJoin @@ Map[CstrGradITERmp[#]&, it];


CstrGradITERmp[LKF$Par[_]== h_]:= "";
CstrGradITERmp[LKF$Const[_]== h_]:= "";

CstrGradITERmp[iz_ == LKF$Sin[x_]]:=
	"\t\tmpfr_cos(aux, " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  
CstrGradITERmp[iz_ == LKF$Cos[x_]]:=
	"\t\tmpfr_sin(aux , " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_neg(aux, aux, rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  
CstrGradITERmp[iz_ == LKF$Tan[x_]]:=
	"\t\tmpfr_cos(aux , " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n" <> 
	"\t\tmpfr_si_div(aux , 1, aux, rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  


CstrGradITERmp[iz_ == LKF$Sinh[x_]]:=
	"\t\tmpfr_cosh(aux, " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  
CstrGradITERmp[iz_ == LKF$Cosh[x_]]:=
	"\t\tmpfr_sinh(aux, " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  
CstrGradITERmp[iz_ == LKF$Tanh[x_]]:=
	"\t\tmpfr_cosh(aux , " <> strOBJCmp[x] <> ", rnd);\n" <> 
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n" <> 
	"\t\tmpfr_si_div(aux , 1, aux, rnd);\n" <> 
	"\t\tmpfr_mul(" <> strOBJGradCmp[iz] <> ", aux, "<> strOBJGradCmp[x] <> ", rnd);\n"  




CstrGradITERmp[iz_ == LKF$ArcSin[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_si_sub(aux, 1, aux, rnd);\n"<>
	"\t\tmpfr_sqrt(aux, aux, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$ArcCos[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_si_sub(aux, 1, aux, rnd);\n"<>
	"\t\tmpfr_sqrt(aux, aux, rnd);\n"<>
	"\t\tmpfr_neg(aux, aux, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$ArcTan[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_add_si(aux, aux, 1, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$ArcSinh[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_add_si(aux, aux, 1, rnd);\n"<>
	"\t\tmpfr_sqrt(aux, aux, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$ArcCosh[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_sub_si(aux, aux, 1, rnd);\n"<>
	"\t\tmpfr_sqrt(aux, aux, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$ArcTanh[x_]]:=
	"\t\tmpfr_set(aux, "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul(aux, aux, aux, rnd);\n"<>
	"\t\tmpfr_si_sub(aux, 1, aux, rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", aux, rnd);\n"

CstrGradITERmp[iz_ == LKF$Log[x_]]:=
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", "<> strOBJCmp[x] <>", rnd);\n"

CstrGradITERmp[iz_ == LKF$Exp[x_]]:=
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", "<> strOBJCmp[iz] <>", rnd);\n"



CstrGradITERmp[iz_ == LKF$Plus[x_,y_?constantLKFQ]]:=
	"\t\tmpfr_set("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", rnd);\n"
CstrGradITERmp[iz_ == LKF$Plus[x_?constantLKFQ,y_]]:=
	"\t\tmpfr_set("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", rnd);\n"
CstrGradITERmp[iz_ == LKF$Plus[x_,y_]]:=
	"\t\tmpfr_add("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", "<> strOBJGradCmp[y]<>", rnd);\n"

CstrGradITERmp[iz_ == LKF$Times[x_,y_?constantLKFQ]]:=
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", "<> strOBJCmp[y]<>", rnd);\n"
CstrGradITERmp[iz_ == LKF$Times[x_?constantLKFQ,y_]]:=
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", "<> strOBJCmp[x]<>", rnd);\n"
CstrGradITERmp[iz_ == LKF$Times[x_,y_]]:=
	"\t\tmpfr_mul(aux, "<> strOBJGradCmp[x]<>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_add("<> strOBJGradCmp[iz]<> ", aux , "<> strOBJGradCmp[iz]<>", rnd);\n"

CstrGradITERmp[iz_ == LKF$Divide[x_,y_?constantLKFQ]]:=
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[x]<>", "<> strOBJCmp[y]<>", rnd);\n"
CstrGradITERmp[iz_ == LKF$Divide[1,y_]]:=
	"\t\tmpfr_mul(aux, "<> strOBJCmp[y] <>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_neg("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>",  aux, rnd);\n"
CstrGradITERmp[iz_ == LKF$Divide[x_?constantLKFQ,y_]]:=
	"\t\tmpfr_mul(aux, "<> strOBJCmp[y] <>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_neg("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>",  aux, rnd);\n"
CstrGradITERmp[iz_ == LKF$Divide[x_,y_]]:=
	"\t\tmpfr_mul(aux, "<> strOBJGradCmp[x]<>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[y]<>", "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_sub("<> strOBJGradCmp[iz]<> ", aux , "<> strOBJGradCmp[iz]<>", rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_div("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", "<> strOBJCmp[y]<>", rnd);\n"


CstrGradITERmp[iz_ == LKF$Power[x_?constantLKFQ,y_]]:=
	"\t\tmpfr_log("<>strOBJGradCmp[iz]<>", "<> strOBJCmp[x]<>", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<> ", "<> strOBJCmp[iz]<> ", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", "<> strOBJGradCmp[y]<> ", rnd);\n"


CstrGradITERmp[iz_ == LKF$Power[x_,y_?constantLKFQ]]:=
	"\t\tmpfr_sub_si(aux, "<> strOBJCmp[y]<>", 1, rnd);\n"<>
	"\t\tmpfr_pow("<> strOBJGradCmp[iz]<> ", "<> strOBJCmp[x]<>", aux , rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", "<> strOBJCmp[y]<>", rnd);\n"<>
	"\t\tmpfr_mul("<> strOBJGradCmp[iz]<> ", "<> strOBJGradCmp[iz]<>", "<> strOBJGradCmp[x]<> ", rnd);\n"


CstrGradITERmp[x_]:="\t\t!!!!!!"<>ToString[x]<>"\n";



CFunMpEnd[x_]:=
	StringJoin @@ Map[("\tmpfr_set(f["<>ToString[#-1]<>"], "<> strOBJCmp[x[[#]]]<> ", rnd);\n")&, 
			Range[Length[x]]]


CGradEndText[x_]:=
	If[Head[x] === LKF$Par || Head[x] === LKF$Const, 
		"\t\tmpfr_set_si(grad[i], 0, rnd);\n",
		"\t\tmpfr_set(grad[i], "<> strOBJGradCmp[x]<> ", rnd);\n"]

CJacobEndText[x_,i_]:=
	If[Head[x] === LKF$Par || Head[x] === LKF$Const, 
		"\t\tmpfr_set_si(jacob["<>ToString[i-1]<>"][i], 0, rnd);\n",
		"\t\tmpfr_set(jacob["<>ToString[i-1]<>"][i], "<> strOBJGradCmp[x]<> ", rnd);\n"]

CGradMpEnd[x_]:=
	Module[{nfun},
		nfun = Length[x];
		If[nfun == 1, CGradEndText[x[[1]]],
			StringJoin @@ Map[CJacobEndText[x[[#]],#]&,  Range[Length[x]]]]]

CGradMpEnd1[x_]:=
	Module[{nfun},
		nfun = Length[x];
		StringJoin @@Map[ CJacobEndText[x[[#]],#]&,  Range[Length[x]]]]


mpFunctionEvaluation[fun_LKFCPar, name_, rnd_, time_]:=
	Module[{nvar,npar,tpar, nfun, nlinks, consts,nconsts, texto=""},
		consts = fun[[3]];
		nconsts = Length[consts];
		nvar = fun[[1]];
		npar= fun[[2]];
		tpar = npar + Length[fun[[4]]];
		nlinks= Length[fun[[5]]];
		nfun= Length[fun[[6]]];
		texto = headMPFunEv[nvar, npar,nfun,name,time];
		If[time, 
			texto = texto <>initMPFunTEv[nvar,npar,tpar,nlinks,nconsts,rnd],
			texto = texto <>initMPFunEv[nvar,npar,tpar,nlinks,nconsts,rnd]];
		If[consts =!= {}, texto = texto <>TextMP2Constants[consts]];
		texto = texto <>CFunMpPARAMS[tpar,fun[[4]],npar];
		texto = texto<> CFunMpITERS[IterationLKF[fun[[5]]]];
		texto = texto<> CFunMpEnd[fun[[6]]];
		texto = texto <> "}\n\n";
		texto
	]



mpGradientEvaluation[fun_LKFCPar, name_, rnd_, time_]:=
	Module[{nvar,npar,tpar,nlinks, nfun, itlkf, consts,nconsts,texto=""},
		consts = fun[[3]];
		nconsts = Length[consts];
		nvar = fun[[1]];
		npar= fun[[2]];
		tpar = npar + Length[fun[[4]]];
		nlinks= Length[fun[[5]]];
		nfun= Length[fun[[6]]];
		itlkf = IterationLKF[fun[[5]]];
		texto = headMPGradEv[nvar, npar,nfun,name,time];
		If[time,
			texto = texto <>initMPGradTEv[nvar,npar,tpar, nlinks,nconsts,rnd],
			texto = texto <>initMPGradEv[nvar,npar,tpar, nlinks,nconsts,rnd]];
		If[consts =!= {}, texto = texto <>TextMP2Constants[consts]];
		texto = texto <>CFunMpPARAMS[tpar,fun[[4]],npar];
		texto = texto<> CFunMpITERS[itlkf];
		texto = texto<> CFunMpEnd[fun[[6]]];
		texto = texto<> "\tfor(i = 0; i < NVARS ; i++ ) {\n";
		texto = texto<> CGradMpITERS[itlkf];
		If[nvar == 1 && nfun > 1, 
			texto = texto <> "\t}\n";
				texto = texto<> CGradMpEnd1[fun[[6]]],
			texto = texto<> CGradMpEnd[fun[[6]]];
				texto = texto <> "\t}\n"];
		texto = texto <> "}\n\n";
		texto
	]



(* ::Subsection::Closed:: *)
(*Final*)


End[]


(* ::Section::Closed:: *)
(*Final*)


Protect @@ Names["MathTIDES`FunctionCodes`"]

EndPackage[]

Null
