(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5413,        151]
NotebookOptionsPosition[      4881,        128]
NotebookOutlinePosition[      5244,        144]
CellTagsIndexPosition[      5201,        141]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["MathTIDES.  Version : 2.00", "Section",
 CellChangeTimes->{{3.470545224089817*^9, 3.470545228544339*^9}, {
   3.470545353980753*^9, 3.470545354130248*^9}, 3.473426292675918*^9, 
   3.4742921503318787`*^9, 3.475324343617917*^9, 3.4779747132705317`*^9, 
   3.4785247659838133`*^9, 3.480852157225596*^9, 3.4819709698476562`*^9, 
   3.492171708070709*^9, 3.49336049095426*^9, {3.495286516134944*^9, 
   3.4952865187324657`*^9}}],

Cell["\<\
Copyright (C) 2010  Alberto Abad, Roberto Barrio, Fernando Blesa, Marcos \
Rodriguez
Grupo de Mec\[AAcute]nica Espacial.  IUMA.
University of Zaragoza
50009 Zaragoza. Spain.

http://gme.unizar.es/software/tides\
\>", "Text"],

Cell["\<\
This file is part of TIDES.
  \t
TIDES is free software : you can redistribute it and/or modify it under the \
terms of the GNU General Public License as published by the Free Software \
Foundation, either version 3 of the License, or (at your option) any later \
version.
  \t
TIDES is distributed in the hope that it will be useful, but WITHOUT ANY \
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR \
A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
  \t
You should have received a copy of the GNU General Public License along with \
TIDES.  If not, see < http://www.gnu.org/licenses/ > .\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Installation", "Section",
 CellChangeTimes->{{3.4705452562377768`*^9, 3.4705452632256317`*^9}}],

Cell[TextData[{
 StyleBox["To install MathTIDES run the next cell\n ",
  FontSize->36],
 StyleBox["(It installs MathTIDES only for this user and includes \
uninstallation of previous versions)",
  FontSize->16]
}], "Text",
 CellChangeTimes->{{3.470126316193121*^9, 3.470126414814747*^9}, {
   3.504082052343251*^9, 3.504082103188521*^9}, {3.5040823484524717`*^9, 
   3.504082376369697*^9}, {3.504082414540613*^9, 3.5040824172665033`*^9}, {
   3.50459594567043*^9, 3.504595958060811*^9}, {3.5067586684560223`*^9, 
   3.50675874672535*^9}, 3.5067587775329437`*^9, {3.506759198918345*^9, 
   3.5067591992831373`*^9}}],

Cell[BoxData[
 RowBox[{"InstallMatTIDES", "=", "\[IndentingNewLine]", "\t", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "sep", ",", "dirap", ",", "dirapmt", ",", "dirnb", ",", " ", "olddir", 
      ",", " ", "c"}], "}"}], ",", "\n", "\t\t", 
    RowBox[{
     RowBox[{"olddir", " ", "=", " ", 
      RowBox[{"Directory", "[", "]"}]}], ";", "\n", "\t\t", 
     RowBox[{"sep", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"StringFreeQ", "[", 
         RowBox[{"$SystemID", ",", " ", "\"\<Windows\>\""}], "]"}], ",", " ", 
        "\"\</\>\"", ",", " ", "\"\<\\\\\>\""}], "]"}]}], ";", "\n", "\t\t", 
     RowBox[{"dirap", " ", "=", " ", 
      RowBox[{
      "$UserBaseDirectory", " ", "<>", " ", "sep", " ", "<>", 
       "\"\<Applications\>\"", "<>", "sep"}]}], ";", "\n", "\t\t", 
     RowBox[{"dirapmt", " ", "=", 
      RowBox[{"dirap", " ", "<>", " ", "\"\<MathTIDES\>\""}]}], ";", "\n", 
     "\t\t", 
     RowBox[{"SetDirectory", "[", "dirap", "]"}], ";", "\n", "\t\t", 
     RowBox[{"c", " ", "=", " ", 
      RowBox[{"Count", "[", 
       RowBox[{
        RowBox[{"FileNames", "[", "]"}], ",", "\"\<MathTIDES\>\""}], "]"}]}], 
     ";", "\n", "\t\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"c", " ", "!=", " ", "0"}], ",", " ", 
       RowBox[{"DeleteDirectory", "[", 
        RowBox[{"dirapmt", ",", " ", 
         RowBox[{"DeleteContents", "->", "True"}]}], "]"}]}], "]"}], ";", 
     "\n", "\t\t", 
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", "\t    ", 
     RowBox[{"CopyDirectory", "[", 
      RowBox[{"\"\<MathTIDES\>\"", ",", "dirapmt"}], "]"}], ";", "\n", "\t\t", 
     RowBox[{"SetDirectory", "[", "olddir", "]"}], ";", "\[IndentingNewLine]",
      "\t    ", 
     RowBox[{"<<", "MathTIDES`"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.50459555457353*^9, 3.50459561418699*^9}, {
  3.504595647598692*^9, 3.5045957697140408`*^9}, {3.504595802931622*^9, 
  3.504595803537993*^9}, {3.504595860483466*^9, 3.504595923058908*^9}, {
  3.504611072512561*^9, 3.504611076079074*^9}, {3.504611138824787*^9, 
  3.504611172606921*^9}}]
}, Open  ]]
},
WindowSize->{1141, 840},
WindowMargins->{{Automatic, 201}, {Automatic, 29}},
ShowSelection->True,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 430, 6, 100, "Section"],
Cell[1000, 30, 234, 8, 152, "Text"],
Cell[1237, 40, 671, 14, 264, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[1945, 59, 101, 1, 53, "Section"],
Cell[2049, 62, 614, 12, 134, "Text"],
Cell[2666, 76, 2199, 49, 317, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
