(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12044,        391]
NotebookOptionsPosition[     11016,        349]
NotebookOutlinePosition[     11358,        364]
CellTagsIndexPosition[     11315,        361]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.500126833670376*^9, 3.50012683884439*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.500126839838992*^9, 3.501826792077366*^9, 
  3.504613214369381*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.500126864762299*^9, 3.500126877610745*^9}}],

Cell[BoxData["\<\"/Users/abad/Desktop/TIDESExamples/tutorial06\"\>"], "Output",
 CellChangeTimes->{3.500126878296873*^9, 3.5018267921805696`*^9, 
  3.5018270859177837`*^9, 3.504613215615436*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the satellite main problem differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}, {
  3.504612548740176*^9, 3.504612549593028*^9}, {3.5046132010718317`*^9, 
  3.504613206630245*^9}, {3.5046163904889517`*^9, 3.50461639350209*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"X", "^", "2"}], "+", 
      RowBox[{"Y", "^", "2"}], "+", 
      RowBox[{"Z", "^", "2"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", 
   RowBox[{
    RowBox[{"-", "mu"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "]"}]}]}], ";", 
  RowBox[{"zon2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"mu", " ", 
        RowBox[{"rt", "^", "2"}]}], ")"}], "/", 
      RowBox[{"r", "^", "2"}]}], " ", "J2", " ", 
     RowBox[{"LegendreP", "[", 
      RowBox[{"2", ",", 
       RowBox[{"z", "/", "r"}]}], "]"}]}], "/.", 
    RowBox[{"r", "\[Rule]", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.504613468673479*^9, 3.504613479675798*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HamZ2", "=", 
  RowBox[{"T", "+", "V", "+", "zon2"}]}]], "Input",
 CellChangeTimes->{{3.504613468673479*^9, 3.504613479675798*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["mu", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}]]]}], "+", 
  FractionBox[
   RowBox[{"J2", " ", "mu", " ", 
    SuperscriptBox["rt", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "-", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"]}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], ")"}], "2"]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["X", "2"], "+", 
     SuperscriptBox["Y", "2"], "+", 
     SuperscriptBox["Z", "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.504613457326179*^9, 3.5046134838020287`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ztODE2", "=", 
  RowBox[{"HamiltonianToODE", "[", 
   RowBox[{"HamZ2", ",", "t", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "X", ",", "Y", ",", "Z"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"mu", ",", "rt", ",", "J2"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", ",", "Y", ",", "Z", ",", 
     RowBox[{
      FractionBox[
       RowBox[{"J2", " ", "mu", " ", 
        SuperscriptBox["rt", "2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"mu", " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"2", " ", "J2", " ", "mu", " ", 
        SuperscriptBox["rt", "2"], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["x", "2"]}], "-", 
          SuperscriptBox["y", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "3"]]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"J2", " ", "mu", " ", 
        SuperscriptBox["rt", "2"], " ", "y"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"mu", " ", "y"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"2", " ", "J2", " ", "mu", " ", 
        SuperscriptBox["rt", "2"], " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["x", "2"]}], "-", 
          SuperscriptBox["y", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "3"]]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "J2", " ", "mu", " ", 
         SuperscriptBox["rt", "2"], " ", "z"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], ")"}], "2"]]}], "-", 
      FractionBox[
       RowBox[{"mu", " ", "z"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"2", " ", "J2", " ", "mu", " ", 
        SuperscriptBox["rt", "2"], " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["x", "2"]}], "-", 
          SuperscriptBox["y", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], "3"]]}]}], "}"}], ",", "t", ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "X", ",", "Y", ",", "Z"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"mu", ",", "rt", ",", "J2"}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.504613492735044*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the integrator", "Section",
 CellChangeTimes->{{3.5046130312990847`*^9, 3.504613036235671*^9}}],

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "ztODE2", ",", " ", "\[IndentingNewLine]", "\"\<SatJ2\>\"", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
     "1.3", ",", "0", ",", "0", ",", "0", ",", "0.06423314045257492", ",", 
      "0.011326035717425298"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.005530428042714393", ",", "1", ",", "0.0010826266835531513"}],
      "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "125", ",", " ", 
      RowBox[{"Delta", "[", "25", "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"DataMatrix", " ", "\[Rule]", "\"\<datj2\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AddFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"T", "+", "V"}], ")"}], ",", " ", "HamZ2"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.504613535762629*^9, 3.5046135590904713`*^9}, 
   3.51340629527747*^9}]
}, Open  ]]
},
WindowSize->{1165, 855},
WindowMargins->{{Automatic, 138}, {Automatic, 35}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 119, 2, 40, "Input"],
Cell[816, 31, 1494, 39, 130, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2359, 76, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2497, 81, 170, 3, 40, "Input"],
Cell[2670, 86, 194, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2913, 94, 290, 3, 100, "Section"],
Cell[3206, 99, 1083, 36, 87, "Input"],
Cell[CellGroupData[{
Cell[4314, 139, 155, 3, 40, "Input"],
Cell[4472, 144, 978, 33, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5487, 182, 305, 8, 40, "Input"],
Cell[5795, 192, 3913, 117, 265, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9757, 315, 109, 1, 100, "Section"],
Cell[9869, 318, 1131, 28, 179, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
