(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12268,        383]
NotebookOptionsPosition[     10794,        324]
NotebookOutlinePosition[     11136,        339]
CellTagsIndexPosition[     11093,        336]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.504611544095785*^9, 3.504611548061817*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.504611624578113*^9, 3.504612596138023*^9, 
  3.51210264499963*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.504611504172099*^9, 3.5046115237780867`*^9}}],

Cell[BoxData["\<\"/Users/abad/Desktop/TIDESExamples/chapter07\"\>"], "Output",
 CellChangeTimes->{3.5046116262400103`*^9, 3.504612596230681*^9, 
  3.5121026451098547`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the Kepler differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}, {
  3.504612548740176*^9, 3.504612549593028*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"keplerODE", "=", 
  RowBox[{"PotentialToODE", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "mu"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], ",", "t", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "mu"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.504611670762719*^9, 3.5046116792513638`*^9}, 
   3.504612562253996*^9}],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x$d1", ",", "y$d1", ",", "z$d1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"mu", " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"mu", " ", "y"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"mu", " ", "z"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}]}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "x$d1", ",", "y$d1", ",", "z$d1"}], 
    "}"}], ",", 
   RowBox[{"{", "mu", "}"}]}], "]"}]], "Output",
 CellChangeTimes->{{3.504612566680607*^9, 3.50461259629179*^9}, 
   3.5121026451712437`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the integrator", "Section",
 CellChangeTimes->{{3.5046130312990847`*^9, 3.504613036235671*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "keplerODE", ",", "\[IndentingNewLine]", "\"\<kepler\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8", ",", "0", ",", "0", ",", "0", ",", "1.2247448713915892", ",", 
      "0"}], "}"}]}], ",", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", " ", "Pi"}], ",", 
      RowBox[{"Points", "[", "4", "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612611215254*^9, 3.5046126169734097`*^9}}],

Cell[BoxData["\<\"Files \\\"dr_kepler.c\\\", \\\"kepler.h\\\", kepler.c\\\", \
written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.5121026453416243`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Four different ways to declare the integration points", "Subsection",
 CellChangeTimes->{{3.504613044728297*^9, 3.504613059620338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "keplerODE", ",", "\[IndentingNewLine]", "\"\<kepler1\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8", ",", "0", ",", "0", ",", "0", ",", "1.2247448713915892", ",", 
      "0"}], "}"}]}], ",", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Delta", "[", 
       RowBox[{"Pi", "/", "2"}], "]"}], ",", 
      RowBox[{"Points", "[", "4", "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612755689451*^9, 3.504612760441184*^9}, 
   3.504612828649418*^9, 3.512102727919705*^9}],

Cell[BoxData["\<\"Files \\\"dr_kepler1.c\\\", \\\"kepler1.h\\\", \
kepler1.c\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.512102645719348*^9, 3.5121027630666857`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "keplerODE", ",", "\[IndentingNewLine]", "\"\<kepler2\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8", ",", "0", ",", "0", ",", "0", ",", "1.2247448713915892", ",", 
      "0"}], "}"}]}], ",", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", " ", "Pi"}], ",", 
      RowBox[{"Points", "[", "4", "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612766240135*^9, 3.504612772459155*^9}, {
  3.5121027346864347`*^9, 3.5121027376778917`*^9}}],

Cell[BoxData["\<\"Files \\\"dr_kepler2.c\\\", \\\"kepler2.h\\\", \
kepler2.c\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.512102645842299*^9, 3.512102759419639*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "keplerODE", ",", "\[IndentingNewLine]", "\"\<kepler3\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8", ",", "0", ",", "0", ",", "0", ",", "1.2247448713915892", ",", 
      "0"}], "}"}]}], ",", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", " ", "Pi"}], ",", 
      RowBox[{"Delta", "[", 
       RowBox[{"Pi", "/", "2"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612775768806*^9, 3.504612784478401*^9}, {
  3.5121027434932003`*^9, 3.512102746638159*^9}}],

Cell[BoxData["\<\"Files \\\"dr_kepler3.c\\\", \\\"kepler3.h\\\", \
kepler3.c\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.512102645958791*^9, 3.512102747728285*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "keplerODE", ",", "\[IndentingNewLine]", "\"\<kepler4\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.8", ",", "0", ",", "0", ",", "0", ",", "1.2247448713915892", ",", 
      "0"}], "}"}]}], ",", 
   RowBox[{"ParametersValue", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", "Pi", ",", 
      RowBox[{"3", " ", 
       RowBox[{"Pi", "/", "2"}]}], ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5046127870486717`*^9, 3.504612821347612*^9}, 
   3.512102752576449*^9}],

Cell[BoxData["\<\"Files \\\"dr_kepler4.c\\\", \\\"kepler4.h\\\", \
kepler4.c\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/chapter07\\\".\"\>"], "Output",
 CellChangeTimes->{3.512102646073111*^9, 3.512102753904001*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{901, 754},
WindowMargins->{{Automatic, 456}, {Automatic, 156}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 120, 2, 40, "Input"],
Cell[817, 31, 1493, 39, 147, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2359, 76, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2497, 81, 172, 3, 40, "Input"],
Cell[2672, 86, 171, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2892, 94, 176, 2, 100, "Section"],
Cell[CellGroupData[{
Cell[3093, 100, 502, 15, 40, "Input"],
Cell[3598, 117, 1324, 40, 131, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4971, 163, 109, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[5105, 168, 770, 19, 156, "Input"],
Cell[5878, 189, 215, 3, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6130, 197, 141, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[6296, 202, 854, 21, 156, "Input"],
Cell[7153, 225, 240, 3, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7430, 233, 822, 20, 156, "Input"],
Cell[8255, 255, 238, 3, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8530, 263, 844, 20, 156, "Input"],
Cell[9377, 285, 238, 3, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9652, 293, 861, 21, 156, "Input"],
Cell[10516, 316, 238, 3, 65, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
