(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13092,        410]
NotebookOptionsPosition[     11129,        332]
NotebookOutlinePosition[     11469,        347]
CellTagsIndexPosition[     11426,        344]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading MathTIDES", "Section",
 CellChangeTimes->{{3.504611527097014*^9, 3.504611535701703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "MathTIDES`"}]], "Input",
 CellChangeTimes->{{3.504611544095785*^9, 3.504611548061817*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{
    StyleBox[
     RowBox[{"    ", 
      RowBox[{
       RowBox[{"MathTIDES", " ", "2.00"}], "\n", "    ", 
       RowBox[{
        RowBox[{
        "MathTIDES", "    ", "is", "   ", "part", "   ", "of", "   ", "the", "   ",
          "TIDES", "   ", 
         RowBox[{"project", ".", "\n", "    ", "Copyright"}], 
         RowBox[{"(", "C", ")"}], "  ", "2010", "  ", "Abad"}], ",", " ", 
        RowBox[{"A", "."}], ",", "  ", "Barrio", ",", " ", 
        RowBox[{"R", "."}], ",", "  ", "Blesa", ",", " ", 
        RowBox[{
         RowBox[{"F", ".", "  ", "and"}], "  ", "Rodriguez"}], ",", " ", 
        RowBox[{"M", ".", "\n"}]}]}]}],
     FontFamily->"Geneva"], 
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"http://gme.unizar.es/software/tides\"\>", 
       True->
       StyleBox["\<\"http://gme.unizar.es/software/tides\"\>", 
        "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaseStyle->{"Hyperlink"},
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{
        URL["http://gme.unizar.es/software/tides"], None},
      ButtonNote->"http://gme.unizar.es/software/tides"],
     Annotation[#, "http://gme.unizar.es/software/tides", "Hyperlink"]& ]}],
   Background->RGBColor[1, 1, 0.85]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.504611624578113*^9, 3.504613768279772*^9, 
  3.504614952995749*^9, 3.511923024383087*^9, 3.5119242695559053`*^9, 
  3.511931710558186*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the work directory", "Section",
 CellChangeTimes->{{3.5046115899786386`*^9, 3.504611612743342*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.504611504172099*^9, 3.5046115237780867`*^9}}],

Cell[BoxData["\<\"/Users/abad/Dropbox/TFinal/TIDESExamples/chapter06\"\>"], \
"Output",
 CellChangeTimes->{3.5046116262400103`*^9, 3.504613768379983*^9, 
  3.504614954224221*^9, 3.511923026040304*^9, 3.5119242727758904`*^9, 
  3.511931710666913*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declaring the sincos differential equation", "Section",
 CellChangeTimes->{{3.504611649805194*^9, 3.504611659312459*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sincosODE", "=", 
  RowBox[{"FirstOrderODE", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "x"}]}], "}"}], ",", "t", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.504611670762719*^9, 3.5046116792513638`*^9}, 
   3.504612575885435*^9}],

Cell[BoxData[
 RowBox[{"FirstOrderODE$", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "x"}]}], "}"}], ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.504613768411306*^9, 3.504614955286092*^9, 
  3.51192302967554*^9, 3.511924276360775*^9, 3.511931710732666*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating the integrator", "Section",
 CellChangeTimes->{{3.5046116971327343`*^9, 3.5046117130252657`*^9}}],

Cell[CellGroupData[{

Cell["Using minf-tides with LibTIDES", "Subsection",
 CellChangeTimes->{{3.504611718746091*^9, 3.504611742585175*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosMFL\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}], ",", "\[IndentingNewLine]", 
   RowBox[{"MinTIDES", "\[Rule]", "\"\<Fortran\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5046117699499407`*^9, 3.504611773820484*^9}, 
   3.504611988834237*^9}],

Cell[BoxData["\<\"Files \\\"dr_sincosMFL.c\\\", sincosMFL.f\\\", written on \
directory \\\"/Users/abad/Desktop/TIDESExamples/tutorial04\\\".\"\>"], \
"Output",
 CellChangeTimes->{3.5046137684465437`*^9, 3.504614975488278*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using minf-tides without LibTIDES", "Subsection",
 CellChangeTimes->{{3.504611718746091*^9, 3.504611742585175*^9}, {
  3.504611807650769*^9, 3.504611808474421*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosMF\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}], ",", "\[IndentingNewLine]", 
   RowBox[{"MinTIDES", "\[Rule]", "\"\<Fortran\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TIDESFiles", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5046117699499407`*^9, 3.504611804853354*^9}}],

Cell[BoxData["\<\"Files \\\"dr_sincosMF.c\\\", sincosMF.f\\\", \
\\\"minc_tides.f\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/tutorial04\\\".\"\>"], "Output",
 CellChangeTimes->{3.50461376848168*^9, 3.504614961476612*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using minc-tides with LibTIDES", "Subsection",
 CellChangeTimes->{{3.504611914894945*^9, 3.5046119296687937`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosMCL\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}], ",", "\[IndentingNewLine]", 
   RowBox[{"MinTIDES", "\[Rule]", "\"\<C\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5046120002812443`*^9, 3.504612004265419*^9}}],

Cell[BoxData["\<\"Files \\\"dr_sincosMCL.c\\\", sincosMCL.c\\\" written on \
directory \\\"/Users/abad/Desktop/TIDESExamples/tutorial04\\\".\"\>"], \
"Output",
 CellChangeTimes->{3.504613768511918*^9, 3.504614996967638*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using minc-tides without LibTIDES", "Subsection",
 CellChangeTimes->{{3.504611922733129*^9, 3.50461193373281*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosMC\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}], ",", "\[IndentingNewLine]", 
   RowBox[{"MinTIDES", "\[Rule]", "\"\<C\>\""}], ",", "\[IndentingNewLine]", 
   RowBox[{"TIDESFiles", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612013882753*^9, 3.504612019547328*^9}}],

Cell[BoxData["\<\"Files \\\"dr_sincosMC.c\\\", sincosMC.c\\\" \
\\\"minc_tides.c\\\", \\\"minc_tides.h\\\", written on directory \
\\\"/Users/abad/Desktop/TIDESExamples/tutorial04\\\".\"\>"], "Output",
 CellChangeTimes->{3.504613768548588*^9, 3.504614984303033*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using dp-tides (standard double precision version of TIDES)", \
"Subsection",
 CellChangeTimes->{{3.50461204390554*^9, 3.504612058312435*^9}, {
  3.504612095873724*^9, 3.504612133568808*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosDP\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5046121368435497`*^9, 3.50461213941943*^9}}],

Cell[BoxData["\<\"Files \\\"dr_sincosDP.c\\\", \\\"sincosDP.h\\\", sincosDP.c\
\\\", \\\"dp_tides.h\\\", written on directory \
\\\"/Users/abad/Dropbox/TFinal/TIDESExamples/chapter06\\\".\"\>"], "Output",
 CellChangeTimes->{3.504613768578059*^9, 3.504615015543092*^9, 
  3.511923039990116*^9, 3.511931747744439*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Using mp-tides (standard multiple precision version  of TIDES)\
\>", "Subsection",
 CellChangeTimes->{{3.504612069322383*^9, 3.504612071220478*^9}, {
  3.504612113536998*^9, 3.504612128384691*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TSMCodeFiles", "[", 
  RowBox[{
  "sincosODE", ",", "\[IndentingNewLine]", "\"\<sincosMP\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"InitialConditions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"IntegrationPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"Points", "[", "1", "]"}]}], "}"}]}], ",", 
   RowBox[{"Output", "\[Rule]", "Screen"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Precision", "\[Rule]", 
    RowBox[{"Multiple", "[", "30", "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504612154453532*^9, 3.5046121644445267`*^9}}],

Cell[BoxData["\<\"Files \\\"dr_sincosMP.c\\\", \\\"sincosMP.h\\\", sincosMP.c\
\\\", \\\"mp_tides.h\\\", written on directory \
\\\"/Users/abad/Dropbox/TFinal/TIDESExamples/chapter06\\\".\"\>"], "Output",
 CellChangeTimes->{3.504613768614929*^9, 3.5046150225802813`*^9, 
  3.5119242818376427`*^9, 3.5119317478816433`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{765, 835},
WindowMargins->{{529, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 102, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[694, 27, 120, 2, 40, "Input"],
Cell[817, 31, 1565, 40, 172, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2431, 77, 113, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[2569, 82, 172, 3, 40, "Input"],
Cell[2744, 87, 249, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3042, 97, 127, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[3194, 102, 349, 10, 40, "Input"],
Cell[3546, 114, 381, 10, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3976, 130, 112, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[4113, 135, 118, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[4256, 140, 682, 16, 156, "Input"],
Cell[4941, 158, 226, 3, 88, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5216, 167, 170, 2, 51, "Subsection"],
Cell[CellGroupData[{
Cell[5411, 173, 734, 17, 179, "Input"],
Cell[6148, 192, 243, 3, 89, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6440, 201, 120, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[6585, 206, 650, 15, 156, "Input"],
Cell[7238, 223, 223, 3, 88, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7510, 232, 120, 1, 51, "Subsection"],
Cell[CellGroupData[{
Cell[7655, 237, 722, 16, 179, "Input"],
Cell[8380, 255, 265, 3, 89, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8694, 264, 197, 3, 51, "Subsection"],
Cell[CellGroupData[{
Cell[8916, 271, 570, 14, 133, "Input"],
Cell[9489, 287, 315, 4, 89, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9853, 297, 207, 4, 51, "Subsection"],
Cell[CellGroupData[{
Cell[10085, 305, 680, 16, 156, "Input"],
Cell[10768, 323, 321, 4, 89, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
