import base
import sys
import tdlib
import unittest

from graphs import *

#don't confuse python unittest
sys.argv=sys.argv[:1]

class TestTdLib_pre(unittest.TestCase):
    def test_preprocessing_0(self):
        for V, E in cornercases:
            G = Graph(V, E)
            G_, B, lb = tdlib.preprocessing(G)
            self.assertEqual(G_.vertices(), [])
            self.assertEqual(G_.edges(), [])

    def test_preprocessing_P6(self):
        G = Graph(V_P6, E_P6)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(G_.vertices(), [])
        self.assertEqual(G_.edges(), [])
        for i in range(len(B)):
            B[i].sort()
        B.sort()
        self.assertEqual(B, [[0, 1], [1, 2], [2, 3], [3, 4], [4, 5]])
        self.assertEqual(lb, 1)

    def test_preprocessing_Peter(self):
        G = Graph(V_Petersen, E_Petersen)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(len(B), 0)
        self.assertEqual(lb, 4)

    def test_preprocessing_4(self):
        G = Graph(V_Petersen_double, E_Petersen_double)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(len(B), 0)

    def test_preprocessing_5(self):
        G = Graph(V_Wagner, E_Wagner)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(len(B), 0)

    def test_preprocessing_6(self):
        G = Graph(V_Pappus, E_Pappus)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(len(B), 0)

    def test_preprocessing_7(self):
        G = Graph(V_Grid_5_5, E_Grid_5_5)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(lb, 4)

    def test_preprocessing_8(self):
        G = Graph(V_Gs_at_ipo, E_Gs_at_ipo)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(lb, 3)

    def test_preprocessing_8(self):
        G = Graph(V_GsF__dn_, E_GsF__dn_)
        G_, B, lb = tdlib.preprocessing(G)
        self.assertEqual(lb, 3)

    def test_preprocessing_GNP(self):
        for n in range(0, 13):
            for i in range(0, 10):
                V, E = randomGNP(n, 0.2)
                G = Graph(V, E)
                G_, B, lb = tdlib.preprocessing(G)

if __name__ == '__main__':
    unittest.main()

# vim:ts=8:sw=4:et
