"""
The contents of this file are the return value of
``sympy.assumptions.ask.compute_known_facts``.  Do NOT manually
edit this file.
"""

from sympy.logic.boolalg import And, Not, Or
from sympy.assumptions.ask import Q

# -{ Known facts in CNF }-
known_facts_cnf = And(
    Or(Q.invertible, Q.singular),
    Or(Not(Q.rational), Q.algebraic),
    Or(Not(Q.imaginary), Q.antihermitian),
    Or(Not(Q.algebraic), Q.complex),
    Or(Not(Q.imaginary), Q.complex),
    Or(Not(Q.real), Q.complex),
    Or(Not(Q.real_elements), Q.complex_elements),
    Or(Not(Q.infinity), Q.extended_real),
    Or(Not(Q.real), Q.extended_real),
    Or(Not(Q.invertible), Q.fullrank),
    Or(Not(Q.real), Q.hermitian),
    Or(Not(Q.even), Q.integer),
    Or(Not(Q.odd), Q.integer),
    Or(Not(Q.prime), Q.integer),
    Or(Not(Q.positive_definite), Q.invertible),
    Or(Not(Q.unitary), Q.invertible),
    Or(Not(Q.diagonal), Q.lower_triangular),
    Or(Not(Q.negative), Q.nonzero),
    Or(Not(Q.positive), Q.nonzero),
    Or(Not(Q.diagonal), Q.normal),
    Or(Not(Q.unitary), Q.normal),
    Or(Not(Q.prime), Q.positive),
    Or(Not(Q.orthogonal), Q.positive_definite),
    Or(Not(Q.integer), Q.rational),
    Or(Not(Q.irrational), Q.real),
    Or(Not(Q.nonzero), Q.real),
    Or(Not(Q.rational), Q.real),
    Or(Not(Q.integer_elements), Q.real_elements),
    Or(Not(Q.invertible), Q.square),
    Or(Not(Q.normal), Q.square),
    Or(Not(Q.symmetric), Q.square),
    Or(Not(Q.diagonal), Q.symmetric),
    Or(Not(Q.lower_triangular), Q.triangular),
    Or(Not(Q.unit_triangular), Q.triangular),
    Or(Not(Q.upper_triangular), Q.triangular),
    Or(Not(Q.orthogonal), Q.unitary),
    Or(Not(Q.diagonal), Q.upper_triangular),
    Or(Not(Q.antihermitian), Not(Q.hermitian)),
    Or(Not(Q.composite), Not(Q.prime)),
    Or(Not(Q.even), Not(Q.odd)),
    Or(Not(Q.imaginary), Not(Q.real)),
    Or(Not(Q.invertible), Not(Q.singular)),
    Or(Not(Q.irrational), Not(Q.rational)),
    Or(Not(Q.negative), Not(Q.positive)),
    Or(Not(Q.integer), Q.even, Q.odd),
    Or(Not(Q.extended_real), Q.infinity, Q.real),
    Or(Not(Q.real), Q.irrational, Q.rational),
    Or(Not(Q.triangular), Q.lower_triangular, Q.upper_triangular),
    Or(Not(Q.nonzero), Q.negative, Q.positive),
    Or(Not(Q.lower_triangular), Not(Q.upper_triangular), Q.diagonal),
    Or(Not(Q.fullrank), Not(Q.square), Q.invertible),
    Or(Not(Q.real), Not(Q.unitary), Q.orthogonal),
    Or(Not(Q.integer), Not(Q.positive), Q.composite, Q.prime)
)

# -{ Known facts in compressed sets }-
known_facts_dict = {
    Q.orthogonal: set([Q.orthogonal, Q.normal, Q.invertible, Q.fullrank,
        Q.positive_definite, Q.unitary, Q.square]),
    Q.invertible: set([Q.fullrank, Q.invertible, Q.square]),
    Q.odd: set([Q.complex, Q.odd, Q.hermitian, Q.real, Q.rational,
        Q.extended_real, Q.integer, Q.algebraic]),
    Q.symmetric: set([Q.symmetric, Q.square]),
    Q.upper_triangular: set([Q.upper_triangular, Q.triangular]),
    Q.fullrank: set([Q.fullrank]),
    Q.diagonal: set([Q.normal, Q.symmetric, Q.lower_triangular,
        Q.upper_triangular, Q.triangular, Q.diagonal, Q.square]),
    Q.antihermitian: set([Q.antihermitian]),
    Q.singular: set([Q.singular]),
    Q.even: set([Q.complex, Q.real, Q.hermitian, Q.even, Q.rational,
        Q.extended_real, Q.integer, Q.algebraic]),
    Q.hermitian: set([Q.hermitian]),
    Q.bounded: set([Q.bounded]),
    Q.positive_definite: set([Q.fullrank, Q.invertible, Q.square,
        Q.positive_definite]),
    Q.nonzero: set([Q.nonzero, Q.complex, Q.extended_real, Q.real,
        Q.hermitian]),
    Q.complex_elements: set([Q.complex_elements]),
    Q.square: set([Q.square]),
    Q.real_elements: set([Q.complex_elements, Q.real_elements]),
    Q.algebraic: set([Q.complex, Q.algebraic]),
    Q.normal: set([Q.normal, Q.square]),
    Q.is_true: set([Q.is_true]),
    Q.integer_elements: set([Q.complex_elements, Q.real_elements,
        Q.integer_elements]),
    Q.real: set([Q.real, Q.complex, Q.extended_real, Q.hermitian]),
    Q.rational: set([Q.complex, Q.hermitian, Q.real, Q.rational,
        Q.extended_real, Q.algebraic]),
    Q.extended_real: set([Q.extended_real]),
    Q.integer: set([Q.complex, Q.hermitian, Q.real, Q.rational,
        Q.extended_real, Q.integer, Q.algebraic]),
    Q.infinitesimal: set([Q.infinitesimal]),
    Q.commutative: set([Q.commutative]),
    Q.infinity: set([Q.extended_real, Q.infinity]),
    Q.complex: set([Q.complex]),
    Q.lower_triangular: set([Q.triangular, Q.lower_triangular]),
    Q.positive: set([Q.complex, Q.positive, Q.nonzero, Q.hermitian,
        Q.real, Q.extended_real]),
    Q.composite: set([Q.composite]),
    Q.triangular: set([Q.triangular]),
    Q.prime: set([Q.complex, Q.positive, Q.real, Q.hermitian, Q.prime,
        Q.rational, Q.extended_real, Q.nonzero, Q.integer,
        Q.algebraic]),
    Q.negative: set([Q.complex, Q.nonzero, Q.hermitian, Q.real,
        Q.negative, Q.extended_real]),
    Q.unitary: set([Q.normal, Q.square, Q.fullrank, Q.invertible,
        Q.unitary]),
    Q.irrational: set([Q.real, Q.irrational, Q.complex, Q.extended_real,
        Q.hermitian]),
    Q.unit_triangular: set([Q.triangular, Q.unit_triangular]),
    Q.imaginary: set([Q.antihermitian, Q.complex, Q.imaginary]),
}
