/* Copyright (C) 2000  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

#include "pari.h"
#include "paripriv.h"
#include "anal.h"
static GEN
ghell2(GEN e, GEN a, long prec) { return ellheight0(e,a,0,prec); }

static GEN
polylogd(long m, GEN x, long prec) { return polylog0(m,x,1,prec); }

static GEN
polylogdold(long m, GEN x, long prec) { return polylog0(m,x,2,prec); }

static GEN
polylogp(long m, GEN x, long prec) { return polylog0(m,x,3,prec); }

static GEN
prod0(GEN x, GEN a, GEN b, GEN ch) {return produit(a,b,ch,x);}

static GEN
sum0(GEN x, GEN a, GEN b, GEN ch) {return somme(a,b,ch,x);}

static long
sturm0(GEN x) {return sturm(x);}

static GEN
sigmak0(long k, GEN x) {return sumdivk(x,k);}

static GEN
lseriesell0(GEN a, GEN b, GEN c, GEN d, long prec)
  {(void)c; return elllseries(a,b,d,prec);}

static GEN
weipell(GEN e, long precdl) { return ellwpseries(e,0,precdl); }

static long
rounderror(GEN x)
{
  pari_sp av = avma;
  long e; (void)grndtoi(x,&e);
  avma = av; return (long)(e*LOG10_2);
}

static GEN
_factpol(GEN x, long t/*unused*/, long hint/*unused*/) {
  (void)t; (void)hint; return QX_factor(x);
}

static void
suppressed(void) {pari_err(e_MISC,"this function no longer exists");}

#define BUCH_PROTO "GDGDGD5,G,D1,G,D4,L,D3,L,p"
#define B_ARGS GEN g1,GEN g2,GEN g3,GEN g4,GEN g5,long l1,long l2,long prec
#define B_ARG1 g1,gtodouble(g2),gtodouble(g3),l1
#define B_CALL(flag) Buchall_param(B_ARG1,(flag),prec)
#define B_UNUSED (void)g4,(void)g5,(void)l2

#define B_DEFAULT if (!g2) g2 = dbltor(.3); \
                  if (!g3) g3 = dbltor(.3)

#define CLASSUNIT(flag) do { \
  pari_sp av = avma; \
  GEN bnf = B_CALL(flag), nf = bnf_get_nf(bnf), x; \
  B_UNUSED; \
  x = mkvec4(gel(nf,1), gel(nf,2), mkvec2(gel(nf,3), gel(nf,4)), gel(nf,7));\
  return gerepilecopy(av, mkmat(shallowconcat(x, gel(bnf,8)))); } while(0)

static GEN
buchgenfu(B_ARGS) { B_DEFAULT; CLASSUNIT(0); }
static GEN
buchgenforcefu(B_ARGS) { B_DEFAULT; CLASSUNIT(nf_FORCE); }
static GEN
buchinitfu(B_ARGS) { B_DEFAULT; B_UNUSED; return B_CALL(0); }
static GEN
buchinitforcefu(B_ARGS) { B_DEFAULT; B_UNUSED; return B_CALL(nf_FORCE); }
static GEN
smallbuchinit(B_ARGS) { (void)g2,(void)g3,(void)l1,B_UNUSED; return bnfcompress(Buchall(g1, 0, prec)); }
static GEN
factoredbase(GEN x, GEN fa) { return nfbasis0(x, 0, fa); }
static GEN
factoreddiscf(GEN x, GEN fa) { return nfdisc0(x, 0, fa); }
static GEN
buchfu(GEN bnf) { return bnf_get_fu_nocheck(checkbnf(bnf)); }
static GEN
buchrayinitgen(GEN bnf, GEN ideal)
{ return Buchray(bnf,ideal, nf_INIT | nf_GEN); }
static GEN
buchrayinit(GEN bnf, GEN ideal)
{ return Buchray(bnf,ideal, nf_INIT); }
static GEN
buchray(GEN bnf, GEN ideal)
{ return Buchray(bnf,ideal, nf_GEN); }
static GEN
principalideal(GEN nf, GEN x) { return algtobasis(nf,x); }

entree oldfonctions[]={
{"!_",0,(void*)gnot,13,"G","!_"},
{"#_",0,(void*)glength,13,"lG","length(x): number of non code words in x, number of characters for a string."},
{"%",0,(void*)pari_get_hist,1,"D0,L,","last history item"},
{"+_",0,NULL,13,NULL,"+_"},
{"-_",0,(void*)gneg,13,"G","-_"},
{"_!",0,(void*)mpfact,13,"L","_!"},
{"_!=_",0,(void*)gne,13,"GG","_!=_"},
{"_%=_",0,(void*)gmode,13,"&G","_%=_"},
{"_%_",0,(void*)gmod,13,"GG","_%_"},
{"_&&_",0,(void*)andpari,13,"GE","_&&_"},
{"_'",0,(void*)deriv,13,"GDn","_'"},
{"_*=_",0,(void*)gmule,13,"&G","x*=y: shortcut for x=x*y."},
{"_*_",0,(void*)gmul,13,"GG","_*_"},
{"_++",0,(void*)gadd1e,13,"&","x++"},
{"_+=_",0,(void*)gadde,13,"&G","x+=y: shortcut for x=x+y."},
{"_+_",0,(void*)gadd,13,"GG","x+y: sum of x and y."},
{"_--",0,(void*)gsub1e,13,"&","x--"},
{"_-=_",0,(void*)gsube,13,"&G","x-=y"},
{"_-_",0,(void*)gsub,13,"GG","x-y: difference of x and y."},
{"_.a1",0,(void*)member_a1,14,"G","_.a1"},
{"_.a2",0,(void*)member_a2,14,"G","_.a2"},
{"_.a3",0,(void*)member_a3,14,"G","_.a3"},
{"_.a4",0,(void*)member_a4,14,"G","_.a4"},
{"_.a6",0,(void*)member_a6,14,"G","_.a6"},
{"_.area",0,(void*)member_area,14,"G","_.area"},
{"_.b2",0,(void*)member_b2,14,"G","_.b2"},
{"_.b4",0,(void*)member_b4,14,"G","_.b4"},
{"_.b6",0,(void*)member_b6,14,"G","_.b6"},
{"_.b8",0,(void*)member_b8,14,"G","_.b8"},
{"_.bid",0,(void*)member_bid,14,"G","_.bid"},
{"_.bnf",0,(void*)member_bnf,14,"G","_.bnf"},
{"_.c4",0,(void*)member_c4,14,"G","_.c4"},
{"_.c6",0,(void*)member_c6,14,"G","_.c6"},
{"_.clgp",0,(void*)member_clgp,14,"G","_.clgp"},
{"_.codiff",0,(void*)member_codiff,14,"G","_.codiff"},
{"_.cyc",0,(void*)member_cyc,14,"G","_.cyc"},
{"_.diff",0,(void*)member_diff,14,"G","_.diff"},
{"_.disc",0,(void*)member_disc,14,"G","_.disc"},
{"_.e",0,(void*)member_e,14,"G","_.e"},
{"_.eta",0,(void*)member_eta,14,"G","_.eta"},
{"_.f",0,(void*)member_f,14,"G","_.f"},
{"_.fu",0,(void*)member_fu,14,"G","_.fu"},
{"_.futu",0,(void*)member_futu,14,"G","_.futu"},
{"_.gen",0,(void*)member_gen,14,"G","_.gen"},
{"_.group",0,(void*)member_group,14,"G","_.group"},
{"_.index",0,(void*)member_index,14,"G","_.index"},
{"_.j",0,(void*)member_j,14,"G","_.j"},
{"_.mod",0,(void*)member_mod,14,"G","_.mod"},
{"_.nf",0,(void*)member_nf,14,"G","_.nf"},
{"_.no",0,(void*)member_no,14,"G","_.no"},
{"_.omega",0,(void*)member_omega,14,"G","_.omega"},
{"_.orders",0,(void*)member_orders,14,"G","_.orders"},
{"_.p",0,(void*)member_p,14,"G","_.p"},
{"_.pol",0,(void*)member_pol,14,"G","_.pol"},
{"_.r1",0,(void*)member_r1,14,"G","_.r1"},
{"_.r2",0,(void*)member_r2,14,"G","_.r2"},
{"_.reg",0,(void*)member_reg,14,"G","_.reg"},
{"_.roots",0,(void*)member_roots,14,"G","_.roots"},
{"_.sign",0,(void*)member_sign,14,"G","_.sign"},
{"_.t2",0,(void*)member_t2,14,"G","_.t2"},
{"_.tate",0,(void*)member_tate,14,"G","_.tate"},
{"_.tu",0,(void*)member_tu,14,"G","_.tu"},
{"_.tufu",0,(void*)member_tufu,14,"G","_.tufu"},
{"_.zk",0,(void*)member_zk,14,"G","_.zk"},
{"_.zkst",0,(void*)member_zkst,14,"G","_.zkst"},
{"_/=_",0,(void*)gdive,13,"&G","x/=y"},
{"_/_",0,(void*)gdiv,13,"GG","_/_"},
{"_<<=_",0,(void*)gshiftle,13,"&L","x<<=y"},
{"_<<_",0,(void*)gshift,13,"GL","x<<y"},
{"_<=_",0,(void*)gle,13,"GG","_<=_"},
{"_<_",0,(void*)glt,13,"GG","_<_"},
{"_==_",0,(void*)geq,13,"GG","_==_"},
{"_>=_",0,(void*)gge,13,"GG","_>=_"},
{"_>>=_",0,(void*)gshiftre,13,"&L","_>>=_"},
{"_>>_",0,(void*)gshift_right,13,"GL","x>>y"},
{"_>_",0,(void*)ggt,13,"GG","_>_"},
{"_[_.._,_.._]",0,(void*)matslice0,13,"GD0,L,D0,L,D0,L,D0,L,","x[a..b,c..d] = [x[a,c],  x[a+1,c],  ...,x[b,c];                      x[a,c+1],x[a+1,c+1],...,x[b,c+1];                        ...       ...          ...                      x[a,d],  x[a+1,d]  ,...,x[b,d]]"},
{"_[_.._]",0,(void*)vecslice0,13,"GD0,L,L","x[a..b] = [x[a],x[a+1],...,x[b]]"},
{"_\\/=_",0,(void*)gdivrounde,13,"&G","x\\\\/=y"},
{"_\\/_",0,(void*)gdivround,13,"GG","x\\\\/y: rounded Euclidean quotient of x and y."},
{"_\\=_",0,(void*)gdivente,13,"&G","x\\\\=y"},
{"_\\_",0,(void*)gdivent,13,"GG","x\\\\y: Euclidean quotient of x and y."},
{"_^_",0,(void*)gpow,13,"GGp","_^_"},
{"_^s",0,(void*)gpowgs,13,"GL","_^s"},
{"__",0,NULL,13,NULL,"__"},
{"_derivfun",0,(void*)derivfun0,15,"GGp","_derivfun(closure,[args]) numerical derivation of closure with respect to the first variable at (args)."},
{"_eval_mnemonic",0,(void*)eval_mnemonic,15,"lGs","Convert a mnemonic string to a flag."},
{"_multi_if",0,(void*)ifpari_multi,15,"GE*","internal variant of if() that allows more than 3 arguments."},
{"_void_if",0,(void*)ifpari_void,11,"vGDIDI","internal variant of if() that does not return a value."},
{"_||_",0,(void*)orpari,13,"GE","x||y"},
{"_~",0,(void*)gtrans,13,"G","_~"},
{"O",0,(void*)ggrando,7,"GD1,L,","O(a^b): p-adic or power series zero with precision given by b."},
{"O(_^_)",0,(void*)ggrando,7,"GD1,L,","O(a^b): p-adic or power series zero with precision given by b."},
{"Str",0,(void*)Str,2,"s*","Str({x}*): concatenates its (string) argument into a single string."},
{"abs",1,(void*)gabs,3,"Gp","abs(x)=absolute value (or modulus) of x."},
{"acos",1,(void*)gacos,3,"Gp","acos(x)=inverse cosine of x."},
{"acosh",1,(void*)gacosh,3,"Gp","acosh(x)=inverse hyperbolic cosine of x."},
{"addell",3,(void*)elladd,5,"GGG","addell(e,z1,z2)=sum of the points z1 and z2 on elliptic curve e."},
{"addprimes",1,(void*)addprimes,4,"G","addprimes(x)=add primes in the vector x (with at most 20 components) to the prime table."},
{"adj",1,(void*)adj,8,"G","adj(x)=adjoint matrix of x."},
{"agm",2,(void*)agm,3,"GGp","agm(x,y)=arithmetic-geometric mean of x and y."},
{"akell",2,(void*)akell,5,"GG","akell(e,n)=computes the n-th Fourier coefficient of the L-function of the elliptic curve e."},
{"algdep",23,(void*)algdep,8,"GL","algdep(x,n)=algebraic relations up to degree n of x."},
{"algdep2",33,(void*)algdep0,8,"GLL","algdep2(x,n,dec)=algebraic relations up to degree n of x where dec is as in  lindep2."},
{"algtobasis",2,(void*)algtobasis,6,"GG","algtobasis(nf,x)=transforms the algebraic number x into a column vector on the integral basis nf[7]."},
{"anell",23,(void*)anell,5,"GL","anell(e,n)=computes the first n Fourier coefficients of the L-function of the elliptic curve e (n<32768)."},
{"apell",2,(void*)ellap,5,"GG","apell(e,p)=computes a_p for the elliptic curve e using Shanks-Mestre's method."},
{"apell2",2,(void*)ellap,5,"GG","apell2(e,p)=apell(e,p)."},
{"apprpadic",2,(void*)padicappr,7,"GG","apprpadic(x,a)=p-adic roots of the polynomial x congruent to a mod p."},
{"arg",1,(void*)garg,3,"Gp","arg(x)=argument of x,such that -pi<arg(x)<=pi."},
{"asin",1,(void*)gasin,3,"Gp","asin(x)=inverse sine of x."},
{"asinh",1,(void*)gasinh,3,"Gp","asinh(x)=inverse hyperbolic sine of x."},
{"assmat",1,(void*)matcompanion,8,"G","matcompanion(x)=associated matrix to polynomial x."},
{"atan",1,(void*)gatan,3,"Gp","atan(x)=inverse tangent of x."},
{"atanh",1,(void*)gatanh,3,"Gp","atanh(x)=inverse hyperbolic tangent of x."},
{"basis",13,(void*)nfbasis0,6,"GD0,L,DG","basis(x)=integral basis of the field Q[a], where a is a root of the polynomial x, using the round 4 algorithm."},
{"basis2",13,(void*)nfbasis0,6,"GD2,L,DG","basis2(x)=integral basis of the field Q[a], where a is a root of the polynomial x, using the round 2 algorithm."},
{"basistoalg",2,(void*)basistoalg,6,"GG","basistoalg(nf,x)=transforms the vertical vector x on the integral basis into an algebraic number."},
{"bernreal",11,(void*)bernreal,3,"Lp","bernreal(x)=Bernoulli number B_x, as a real number with the current precision."},
{"bernvec",11,(void*)bernvec,3,"L","bernvec(x)=Vector of rational Bernoulli numbers B_0, B_2,... up to B_(2x)."},
{"bestappr",2,(void*)bestappr,4,"GGp","bestappr(x,k)=gives the best approximation to the real x with denominator less or equal to k."},
{"bezout",2,(void*)gcdext0,4,"GG","bezout(x,y)=gives a 3-dimensional row vector [u,v,d] such that d=gcd(x,y) and u*x+v*y=d."},
{"bezoutres",2,(void*)polresultantext,4,"GG","bezoutres(x,y)=gives a 3-dimensional row vector [u,v,d] such that d=resultant(x,y) and u*x+v*y=d, where x and y are polynomials."},
{"bigomega",1,(void*)bigomega,4,"lG","bigomega(x)=number of repeated prime divisors of x."},
{"bilhell",3,(void*)bilhell,5,"GGGp","bilhell(e,z1,z2)=canonical bilinear form for the points z1,z2 on the elliptic curve e. Either z1 or z2 can also be a vector/matrix of points."},
{"bin",21,(void*)binomial,4,"GL","bin(x,y)=binomial coefficient x*(x-1)...*(x-y+1)/y! defined for y in Z and any x."},
{"binary",1,(void*)binaire,2,"G","binary(x)=gives the vector formed by the binary digits of x (x C-integer)."},
{"bittest",2,(void*)gbittest,2,"GL","bittest(x,n)=gives bit number n (coefficient of 2^n) of the integer x."},
{"boundcf",21,(void*)gboundcf,4,"GL","boundcf(x,lmax)=continued fraction expansion of x with at most lmax terms."},
{"boundfact",21,(void*)boundfact,4,"GL","boundfact(x,lim)=partial factorization of the integer x (using primes up to lim)."},
{"buchcertify",10,(void*)bnfcertify,6,"lG","buchcertify(bnf)=certify the correctness (i.e. remove the GRH) of the bnf data output by buchinit or buchinitfu."},
{"buchfu",1,(void*)buchfu,6,"Gp","buchfu(bnf)=compute the fundamental units of the number field bnf output by buchinit."},
{"buchgen",99,(void*)buchgenfu,6,BUCH_PROTO,"buchgen(P,...)=compute the structure of the class group and the regulator for the number field defined by the polynomial P. See manual for the other parameters (which can be omitted)."},
{"buchgenforcefu",99,(void*)buchgenforcefu,6,BUCH_PROTO,"buchgenforcefu(P,...)=compute the structure of the class group, the regulator a primitive root of unity and a system of fundamental units for the number field defined by the polynomial P, and insist until the units are obtained. See manual for the other parameters (which can be omitted)."},
{"buchgenfu",99,(void*)buchgenfu,6,BUCH_PROTO,"buchgenfu(P,...)=compute the structure of the class group, the regulator a primitive root of unity and a system of fundamental units (if they are not too large) for the number field defined by the polynomial P. See manual for the other parameters (which can be omitted)."},
{"buchimag",99,(void*)buchimag,4,"GD0.1,G,D0.1,G,D5,G,","buchimag(D,...)=compute the structure of the class group of the complex quadratic field of discriminant D<0. See manual for the other parameters (which can be omitted)."},
{"buchinit",99,(void*)buchinitfu,6,BUCH_PROTO,"buchinit(P,...)=compute the necessary data for future use in ideal and unit group computations. See manual for details."},
{"buchinitforcefu",99,(void*)buchinitforcefu,6,BUCH_PROTO,"buchinitforcefu(P,...)=compute the necessary data for future use in ideal and unit group computations, and insist on having fundamental units. See manual for details."},
{"buchinitfu",99,(void*)buchinitfu,6,BUCH_PROTO,"buchinitfu(P,...)=compute the necessary data for future use in ideal and unit group computations, including fundamental units if they are not too large. See manual for details."},
{"buchnarrow",1,(void*)buchnarrow,6,"Gp","buchnarrow(bnf)=given a big number field as output by buchinitxx, gives as a 3-component vector the structure of the narrow class group."},
{"buchray",2,(void*)buchray,6,"GGp","buchray(bnf,ideal)=given a big number field as output by buchinitfu (only) and  an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, finds the ray class group structure corresponding to this module."},
{"buchrayinit",2,(void*)buchrayinit,6,"GGp","buchrayinit(bnf,ideal)=same as buchrayinitgen, except that the generators are not explicitly computed."},
{"buchrayinitgen",2,(void*)buchrayinitgen,6,"GGp","buchrayinitgen(bnf,ideal)=given a big number field as output by buchinitfu (only) and  an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, initializes data for computing in the ray class group  corresponding to this module. In particular, the fifth component is the ray class group structure."},
{"buchreal",97,(void*)buchreal,4,"GD0,G,D0.1,G,D0.1,G,D5,G,p","buchreal(D,...)=compute the structure of the class group and the regulator of the real quadratic field of discriminant D>0 in the wide sense. See manual for the other parameters (which can be omitted)."},
{"bytesize",10,(void*)gsizebyte,2,"lG","bytesize(x)=number of bytes occupied by the complete tree of the object x."},
{"ceil",1,(void*)gceil,2,"G","ceil(x)=ceiling of x=smallest integer>=x."},
{"centerlift",1,(void*)centerlift,2,"G","centerlift(x)=centered lift of x. Same as lift except for integermods."},
{"cf",1,(void*)gcf,4,"Gp","cf(x)=continued fraction expansion of x (x rational,real or rational function)."},
{"cf2",2,(void*)gcf2,4,"GGp","cf2(b,x)=continued fraction expansion of x (x rational,real or rational function), where b is the vector of numerators of the continued fraction."},
{"changevar",0,(void*)suppressed,11,"GG","changevar(x,y)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"char",14,(void*)caradj,8,"GnD&","char(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using the comatrix."},
{"char1",14,(void*)caract,8,"Gn","char1(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using Lagrange interpolation."},
{"char2",14,(void*)carhess,8,"Gn","char2(x,y)=characteristic polynomial of the matrix x expressed with variable y, using the Hessenberg form. Can be much faster or much slower than char, depending on the base ring."},
{"chell",2,(void*)ellchangecurve,5,"GG","chell(x,y)=change data on elliptic curve according to y=[u,r,s,t]."},
{"chinese",2,(void*)chinese,4,"GG","chinese(x,y)=x,y being integers modulo mx and my,finds z such that z is congruent to x mod mx and y mod my."},
{"chptell",2,(void*)ellchangepoint,5,"GG","chptell(x,y)=change data on point or vector of points x on an elliptic curve according to y=[u,r,s,t]."},
{"classno",1,(void*)classno,4,"G","classno(x)=class number of discriminant x."},
{"classno2",1,(void*)classno2,4,"G","classno2(x)=class number of discriminant x."},
{"coeff",21,(void*)truecoeff,2,"GL","coeff(x,s)=coefficient of degree s of x, or the s-th component for vectors or matrices (for which it is simpler to use x[])."},
{"compimag",2,(void*)qficomp,4,"GG","compimag(x,y)=Gaussian composition of the binary quadratic forms x and y of negative discriminant."},
{"compo",21,(void*)compo,2,"GL","compo(x,s)=the s'th component of the internal representation of x. For vectors or matrices, it is simpler to use x[]."},
{"compositum",2,(void*)compositum,6,"GG","compositum(pol1,pol2)=vector of all possible compositums of the number fields defined by the polynomials pol1 and pol2."},
{"compositum2",2,(void*)compositum2,6,"GG","compositum2(pol1,pol2)=vector of all possible compositums of the number fields defined by the polynomials pol1 and pol2, with roots of pol1 and pol2 expressed on the compositum polynomials."},
{"comprealraw",2,(void*)qfrcompraw,4,"GG","comprealraw(x,y)=Gaussian composition without reduction of the binary quadratic forms x and y of positive discriminant."},
{"concat",2,(void*)concat,8,"GG","concat(x,y)=concatenation of x and y."},
{"conductor",99,(void*)bnrconductor0,6,"GDGDGD1,L,","conductor(bnr,subgroup)=conductor of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup."},
{"conductorofchar",2,(void*)bnrconductorofchar,6,"GG","conductorofchar(bnr,chi)=conductor of the character chi on the ray class group bnr."},
{"conj",1,(void*)gconj,2,"G","conj(x)=the algebraic conjugate of x."},
{"conjvec",1,(void*)conjvec,2,"Gp","conjvec(x)=conjugate vector of the algebraic number x."},
{"content",1,(void*)content,4,"G","content(x)=gcd of all the components of x, when this makes sense."},
{"convol",2,(void*)convol,7,"GG","convol(x,y)=convolution (or Hadamard product) of two power series."},
{"core",1,(void*)core,4,"G","core(n)=unique (positive of negative) squarefree integer d dividing n such that n/d is a square."},
{"core2",1,(void*)core2,4,"G","core2(n)=2-component row vector [d,f], where d is the unique squarefree integer dividing n such that n/d=f^2 is a square."},
{"coredisc",1,(void*)coredisc,4,"G","coredisc(n)=discriminant of the quadratic field Q(sqrt(n))."},
{"coredisc2",1,(void*)coredisc2,4,"G","coredisc2(n)=2-component row vector [d,f], where d is the discriminant of the quadratic field Q(sqrt(n)) and n=df^2. f may be a half integer."},
{"cos",1,(void*)gcos,3,"Gp","cos(x)=cosine of x."},
{"cosh",1,(void*)gcosh,3,"Gp","cosh(x)=hyperbolic cosine of x."},
{"cvtoi",13,(void*)gcvtoi,2,"Gf","cvtoi(x)=truncation of x, without taking into account loss of integer part precision."},
{"cyclo",11,(void*)polcyclo,7,"LDn","cyclo(n)=n-th cyclotomic polynomial."},
{"decodefactor",1,(void*)factorback,4,"G","decodefactor(fa)=given a factorisation fa, gives the factored object back."},
{"decodemodule",2,(void*)decodemodule,6,"GG","decodemodule(nf,fa)=given a coded module fa as in discrayabslist, gives the true module."},
{"degree",10,(void*)degree,2,"lG","degree(x)=degree of the polynomial or rational function x. -1 if equal 0, 0 if non-zero scalar."},
{"denom",1,(void*)denom,2,"G","denom(x)=denominator of x (or lowest common denominator in case of an array)."},
{"deplin",1,(void*)deplin,8,"Gp","deplin(x)=finds a linear dependence between the columns of the matrix x."},
{"deriv",14,(void*)deriv,7,"Gn","deriv(x,y)=derivative of x with respect to the main variable of y."},
{"det",1,(void*)det,8,"G","det(x)=determinant of the matrix x."},
{"det2",1,(void*)det2,8,"G","det2(x)=determinant of the matrix x (better for integer entries)."},
{"detint",1,(void*)detint,8,"G","detint(x)=some multiple of the determinant of the lattice generated by the columns of x (0 if not of maximal rank). Useful with hermitemod."},
{"diagonal",1,(void*)diagonal,8,"G","diagonal(x)=creates the diagonal matrix whose diagonal entries are the entries of the vector x."},
{"dilog",1,(void*)dilog,3,"Gp","dilog(x)=dilogarithm of x."},
{"dirdiv",2,(void*)dirdiv,7,"GG","dirdiv(x,y)=division of the Dirichlet series x by the Dir. series y."},
{"direuler",83,(void*)direuler0,7,"V=GGEDG","direuler(p=a,b,expr)=Dirichlet Euler product of expression expr from p=a to p=b, limited to b terms. Expr should be a polynomial or rational function in p and X, and X is understood to mean p^(-s)."},
{"dirmul",2,(void*)dirmul,7,"GG","dirmul(x,y)=multiplication of the Dirichlet series x by the Dir. series y."},
{"dirzetak",2,(void*)dirzetak,6,"GG","dirzetak(nf,b)=Dirichlet series of the Dedekind zeta function of the number field nf up to the bound b-1."},
{"disc",1,(void*)poldisc0,7,"GDn","disc(x)=discriminant of the polynomial x."},
{"discf",1,(void*)nfdisc0,6,"GD0,L,DG","discf(x)=discriminant of the number field defined by the polynomial x using round 4."},
{"discf2",1,(void*)nfdisc0,6,"GD2,L,DG","discf2(x)=discriminant of the number field defined by the polynomial x using round 2."},
{"discrayabs",62,(void*)bnrdisc0,6,"GD0,G,D0,G,D0,L,","discrayabs(bnr,subgroup)=absolute [N,R1,disc] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup."},
{"discrayabscond",62,(void*)bnrdisc0,6,"GD0,G,D0,G,D2,L,","discrayabscond(bnr,subgroup)=absolute [N,R1,disc] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup. Result is zero if fmodule is not the conductor."},
{"discrayabslist",2,(void*)discrayabslist,6,"GG","discrayabslist(bnf,listes)=if listes is a 2-component vector as output by ideallistunit or similar, gives list of corresponding discrayabscond."},
{"discrayabslistarch",32,(void*)discrayabslistarch,6,"GGL","discrayabslistarch(bnf,arch,bound)=gives list of discrayabscond of all modules up to norm bound with archimedean places arch, in a longvector format."},
{"discrayabslistarchall",32,(void*)discrayabslistarch,6,"GL","discrayabslistarchall(bnf,bound)=gives list of discrayabscond of all modules up to norm bound with all possible archimedean places arch in reverse lexicographic order, in a longvector format."},
{"discrayabslistlong",21,(void*)discrayabslistlong,6,"GL","discrayabslistlong(bnf,bound)=gives list of discrayabscond of all modules up to norm bound without archimedean places, in a longvector format."},
{"discrayrel",62,(void*)bnrdisc0,6,"GD0,G,D0,G,D1,L,","discrayrel(bnr,subgroup)=relative [N,R1,rnfdisc] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup."},
{"discrayrelcond",62,(void*)bnrdisc0,6,"GD0,G,D0,G,D3,L,","discrayrelcond(bnr,subgroup)=relative [N,R1,rnfdisc] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup. Result is zero if module is not the conductor."},
{"divisors",1,(void*)divisors,4,"G","divisors(x)=gives a vector formed by the divisors of x in increasing order."},
{"divres",2,(void*)gdiventres,1,"GG","divres(x,y)=euclidean division of x by y giving as a 2-dimensional column vector the quotient and the remainder."},
{"divsum",22,(void*)sumdivexpr,9,"GVE","divsum(n,X,expr)=sum of expression expr, X running over the divisors of n."},
{"eigen",1,(void*)eigen,8,"Gp","eigen(x)=eigenvectors of the matrix x given as columns of a matrix."},
{"eint1",1,(void*)eint1,3,"Gp","eint1(x)=exponential integral E1(x)."},
{"erfc",1,(void*)gerfc,3,"Gp","erfc(x)=complementary error function."},
{"eta",1,(void*)eta,3,"Gp","eta(x)=eta function without the q^(1/24)."},
{"euler",0,(void*)mpeuler,3,"p","euler=euler()=euler's constant with current precision."},
{"eval",1,(void*)geval_gp,7,"GC","eval(x)=evaluation of x, replacing variables by their value."},
{"exp",1,(void*)gexp,3,"Gp","exp(x)=exponential of x."},
{"extract",2,(void*)extract0,8,"GGDG","extract(x,y)=extraction of the components of the vector x according to the vector or mask y, from left to right (1, 2, 4, 8, ...for the first, second, third, fourth,...component)."},
{"fact",11,(void*)mpfactr,4,"Lp","fact(x)=factorial of x (x C-integer), the result being given as a real number."},
{"factcantor",2,(void*)factcantor,4,"GG","factcantor(x,p)=factorization mod p of the polynomial x using Cantor-Zassenhaus."},
{"factfq",3,(void*)factorff,4,"GGG","factfq(x,p,a)=factorization of the polynomial x in the finite field F_p[X]/a(X)F_p[X]."},
{"factmod",2,(void*)factmod,4,"GG","factmod(x,p)=factorization mod p of the polynomial x using Berlekamp."},
{"factor",1,(void*)factor,4,"G","factor(x)=factorization of x."},
{"factoredbasis",28,(void*)factoredbase,6,"GG","factoredbasis(x,p)=integral basis of the maximal order defined by the polynomial x, where p is the matrix of the factorization of the discriminant of x."},
{"factoreddiscf",2,(void*)factoreddiscf,6,"GG","factoreddiscf(x,p)=discriminant of the maximal order defined by the polynomial x, where p is the matrix of the factorization of the discriminant of x."},
{"factoredpolred",2,(void*)factoredpolred,6,"GG","factoredpolred(x,p)=reduction of the polynomial x, where p is the matrix of the factorization of the discriminant of x (gives minimal polynomials only)."},
{"factoredpolred2",2,(void*)factoredpolred2,6,"GG","factoredpolred2(x,p)=reduction of the polynomial x, where p is the matrix of the factorization of the discriminant of x (gives elements and minimal polynomials)."},
{"factornf",2,(void*)polfnf,6,"GG","factornf(x,t)=factorization of the polynomial x over the number field defined by the polynomial t."},
{"factorpadic",32,(void*)factorpadic,7,"GGL","factorpadic(x,p,r)=p-adic factorization of the polynomial x to precision r, using the round 4 algorithm."},
{"factorpadic2",32,(void*)factorpadic0,7,"GGLD1,L,","factorpadic2(x,p,r)=p-adic factorization of the polynomial x to precision r, using Buchmann-Lenstra."},
{"factpol",33,(void*)_factpol,7,"GLL","factpol(x,l,hint)=factorization over Z of the polynomial x up to degree l (complete if l=0) using Hensel lift, knowing that the degree of each factor is a multiple of hint."},
{"factpol2",0,(void*)suppressed,6,"GL","factpol2(x,l)=factorization over Z of the polynomial x up to degree l (complete if l=0) using root finding."},
{"fibo",11,(void*)fibo,4,"L","fibo(x)=fibonacci number of index x (x C-integer)."},
{"floor",1,(void*)gfloor,2,"G","floor(x)=floor of x=largest integer<=x."},
{"for",83,(void*)forpari,11,"vV=GGI","for(X=a,b,seq)=the sequence is evaluated, X going from a up to b."},
{"fordiv",84,(void*)fordiv,11,"vGVI","fordiv(n,X,seq)=the sequence is evaluated, X running over the divisors of n."},
{"forprime",83,(void*)forprime,11,"vV=GGI","forprime(X=a,b,seq)=the sequence is evaluated, X running over the primes between a and b."},
{"forstep",86,(void*)forstep,11,"vV=GGGI","forstep(X=a,b,s,seq)=the sequence is evaluated, X going from a to b in steps of s."},
{"forvec",87,(void*)forvec,11,"vV=GID0,L,","forvec(x=v,seq)=v being a vector of two-component vectors of length n, the sequence is evaluated with x[i] going from v[i][1] to v[i][2] for i=n,..,1."},
{"fpn",21,(void*)ffinit,2,"GLDn","fpn(p,n)=monic irreducible polynomial of degree n over F_p[x]."},
{"frac",1,(void*)gfrac,2,"G","frac(x)=fractional part of x=x-floor(x)."},
{"galois",1,(void*)polgalois,6,"Gp","galois(x)=Galois group of the polynomial x (see manual for group coding)."},
{"galoisapply",3,(void*)galoisapply,6,"GGG","galoisapply(nf,aut,x)=Apply the Galois automorphism sigma (polynomial or polymod) to the object x (element or ideal) in the number field nf."},
{"galoisconj",1,(void*)galoisconj,6,"GDG","galoisconj(nf)=list of conjugates of a root of the polynomial x=nf[1] in the same number field, using p-adics, LLL on integral basis (not always complete)."},
{"galoisconj1",0,(void*)suppressed,6,"G","galoisconj1(nf)=list of conjugates of a root of the polynomial x=nf[1] in the same number field nf, using complex numbers, LLL on integral basis (not always complete)."},
{"galoisconjforce",0,(void*)suppressed,6,"G","galoisconjforce(nf)=list of conjugates of a root of the polynomial x=nf[1] in the Galois number field nf, using p-adics, LLL on integral basis. Guaranteed to be complete if the field is Galois, otherwise there is an infinite loop."},
{"gamh",1,(void*)ggammah,3,"Gp","gamh(x)=gamma of x+1/2 (x integer)."},
{"gamma",1,(void*)ggamma,3,"Gp","gamma(x)=gamma function at x."},
{"gauss",2,(void*)gauss,8,"GG","gauss(a,b)=gaussian solution of ax=b (a matrix,b vector)."},
{"gaussmodulo",3,(void*)gaussmodulo,8,"GGG","gaussmodulo(M,D,Y)=(long)gen_1 solution of system of congruences MX=Y mod D."},
{"gaussmodulo2",3,(void*)gaussmodulo2,8,"GGG","gaussmodulo2(M,D,Y)=all solutions of system of congruences MX=Y mod D."},
{"gcd",2,(void*)ggcd,4,"GG","gcd(x,y)=greatest common divisor of x and y."},
{"getheap",0,(void*)getheap,2,"","getheap()=2-component vector giving the current number of objects in the heap and the space they occupy."},
{"getrand",0,(void*)getrand,2,"","getrand()=current value of random number seed."},
{"getstack",0,(void*)getstack,2,"l","getstack()=current value of stack pointer avma."},
{"gettime",0,(void*)gettime,2,"l","gettime()=time (in milliseconds) since last call to gettime."},
{"globalred",1,(void*)ellglobalred,5,"G","globalred(e)=e being an elliptic curve, returns [N,[u,r,s,t],c], where N is the conductor of e, [u,r,s,t] leads to the standard model for e, and c is the product of the local Tamagawa numbers c_p."},
{"goto",0,(void*)suppressed,11,"s*","goto(n)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"hclassno",1,(void*)hclassno,4,"G","hclassno(x)=Hurwitz-Kronecker class number of x>0."},
{"hell",2,(void*)ghell,5,"GGp","hell(e,x)=canonical height of point x on elliptic curve E defined by the vector e computed using theta-functions."},
{"hell2",2,(void*)ghell2,5,"GGp","hell2(e,x)=canonical height of point x on elliptic curve E defined by the vector e computed using Tate's method."},
{"hermite",1,(void*)ZM_hnf,8,"G","hermite(x)=(upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, using a naive algorithm."},
{"hermite2",1,(void*)hnfall,8,"G","hermite2(x)=2-component vector [H,U] such that H is an (upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, and U is a unimodular matrix such that xU=H, using Batut's algorithm."},
{"hermitehavas",0,(void*)suppressed,8,"G","hermitehavas(x)=3-component vector [H,U,P] such that H is an (upper triangular) Hermite normal form of x with extra zero columns, U is a unimodular matrix and P is a permutation of the rows such that P applied to xU gives H, using Havas's algorithm."},
{"hermitemod",2,(void*)hnfmod,8,"GG","hermitemod(x,d)=(upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, where d is the non-zero determinant of this lattice."},
{"hermitemodid",2,(void*)hnfmodid,8,"GG","hermitemodid(x,d)=(upper triangular) Hermite normal form of x concatenated with d times the identity matrix."},
{"hermiteperm",1,(void*)hnfperm,8,"G","hermiteperm(x)=3-component vector [H,U,P] such that H is an (upper triangular) Hermite normal form of x with extra zero columns, U is a unimodular matrix and P is a permutation of the rows such that P applied to xU gives H, using Batut's algorithm."},
{"hess",1,(void*)hess,8,"G","hess(x)=Hessenberg form of x."},
{"hilb",30,(void*) hilbert,4,"lGGG","hilb(x,y,p)=Hilbert symbol at p of x,y (integers or fractions)."},
{"hilbert",11,(void*)mathilbert,8,"L","hilbert(n)=Hilbert matrix of order n (n C-integer)."},
{"hilbp",20,(void*) hilbert,4,"lGGDG","hilbp(x,y)=Hilbert symbol of x,y (where x or y is integermod or p-adic)."},
{"hvector",22,(void*)vecteur,9,"GVE","hvector(n,X,expr)=row vector with n components of expression expr, the variable X ranging from 1 to n."},
{"hyperu",3,(void*)hyperu,3,"GGGp","hyperu(a,b,x)=U-confluent hypergeometric function."},
{"i",0,(void*)gen_I,2,"","i=i()=square root of -1."},
{"idealadd",3,(void*)idealadd,6,"GGG","idealadd(nf,x,y)=sum of two ideals x and y in the number field defined by nf."},
{"idealaddmultone",2,(void*)idealaddmultoone,6,"GG","idealaddone(nf,x,y)=when the sum of two ideals x and y in the number field K defined by nf is equal to Z_K, gives a two-component vector [a,b] such that a is in x, b is in y and a+b=1."},
{"idealaddone",3,(void*)idealaddtoone,6,"GGG","idealaddmultone(nf,list)=when the sum of the ideals in the number field K defined by nf and given in the vector list is equal to Z_K, gives a vector of elements of the corresponding ideals who sum to 1."},
{"idealappr",2,(void*)idealappr,6,"GGp","idealappr(nf,x)=x being a fractional ideal, gives an element b such that v_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p."},
{"idealapprfact",2,(void*)idealapprfact,6,"GG","idealapprfact(nf,x)=x being a prime ideal factorization with possibly zero or negative exponents, gives an element b such that v_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p."},
{"idealchinese",3,(void*)idealchinese,6,"GGG","idealchinese(nf,x,y)=x being a prime ideal factorization and y a vector of elements, gives an element b such that v_p(b-y_p)>=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p."},
{"idealcoprime",3,(void*)idealcoprime,6,"GGG","idealcoprime(nf,x,y)=gives an element b in nf such that b.x is an integral ideal coprime to the integral ideal y."},
{"idealdiv",3,(void*)idealdiv,6,"GGG","idealdiv(nf,x,y)=quotient x/y of two ideals x and y in HNF in the number field nf."},
{"idealdivexact",3,(void*)idealdivexact,6,"GGG","idealdivexact(nf,x,y)=quotient x/y of two ideals x and y in HNF in the number field nf when the quotient is known to be an integral ideal."},
{"idealfactor",2,(void*)idealfactor,6,"GG","idealfactor(nf,x)=factorization of the ideal x given in HNF into prime ideals in the number field nf."},
{"idealhermite",2,(void*)idealhnf,6,"GG","idealhermite(nf,x)=hermite normal form of the ideal x in the number field nf, whatever form x may have."},
{"idealhermite2",3,(void*)idealhnf0,6,"GGG","idealhermite2(nf,a,b)=hermite normal form of the ideal aZ_K+bZ_K in the number field K defined by nf, where a and b are elements."},
{"idealintersect",3,(void*)idealintersect,6,"GGG","idealintersect(nf,x,y)=intersection of two ideals x and y in HNF in the number field defined by nf."},
{"idealinv",2,(void*)idealinv,6,"GG","idealinv(nf,x)=inverse of the ideal x in the number field nf not using the different."},
{"idealinv2",2,(void*)idealinv,6,"GG","idealinv2(nf,x)=inverse of the ideal x in the number field nf using the different."},
{"ideallist",21,(void*)ideallist,6,"GL","ideallist(nf,bound)=vector of vectors of all ideals of norm<=bound in nf."},
{"ideallistarch",3,(void*)ideallistarch,6,"GGG","ideallistarch(nf,list,arch)=vector of vectors of all zidealstarinits of all modules in list with archimedean arch added, without generators."},
{"ideallistarchgen",3,(void*)ideallistarch,6,"GGG","ideallistarchgen(nf,list,arch)=vector of vectors of all zidealstarinits of all modules in list with archimedean arch added, with generators."},
{"ideallistunit",21,(void*)ideallist0,6,"GLD2,L,","ideallistunit(bnf,bound)=2-component vector [L,U] where L is as ideallistzstar, and U is a vector of vector of zinternallogs of the units, without generators."},
{"ideallistunitarch",3,(void*)ideallistarch,6,"GGG","ideallistunitarch(bnf,lists,arch)=adds the archimedean arch to the lists output by ideallistunit."},
{"ideallistunitarchgen",3,(void*)ideallistarch,6,"GGG","ideallistunitarchgen(bnf,lists,arch)=adds the archimedean arch to the lists output by ideallistunitgen."},
{"ideallistunitgen",21,(void*)ideallist0,6,"GLD3,L,","ideallistunitgen(bnf,bound)=2-component vector [L,U] where L is as ideallistzstar, and U is a vector of vector of zinternallogs of the units, with generators."},
{"ideallistzstar",21,(void*)ideallist0,6,"GLD0,L,","ideallistzstar(nf,bound)=vector of vectors of all zidealstarinits of all ideals of norm<=bound, without generators."},
{"ideallistzstargen",21,(void*)ideallist0,6,"GLD1,L,","ideallistzstargen(nf,bound)=vector of vectors of all zidealstarinits of all ideals of norm<=bound, with generators."},
{"ideallllred",3,(void*)idealred0,6,"GGGp","ideallllred(nf,x,vdir)=LLL reduction of the ideal x in the number field nf along direction vdir, in HNF."},
{"idealmul",3,(void*)idealmul,6,"GGG","idealmul(nf,x,y)=product of the two ideals x and y in the number field nf."},
{"idealmulred",3,(void*)idealmulred,6,"GGGp","idealmulred(nf,x,y)=reduced product of the two ideals x and y in the number field nf."},
{"idealnorm",2,(void*)idealnorm,6,"GG","idealnorm(nf,x)=norm of the ideal x in the number field nf."},
{"idealpow",3,(void*)idealpow,6,"GGG","idealpow(nf,x,n)=n-th power of the ideal x in HNF in the number field nf."},
{"idealpowred",3,(void*)idealpowred,6,"GGGp","idealpowred(nf,x,n)=reduced n-th power of the ideal x in HNF in the number field nf."},
{"idealtwoelt",2,(void*)idealtwoelt,6,"GG","idealtwoelt(nf,x)=2-element representation of an ideal x in the number field nf."},
{"idealtwoelt2",3,(void*)idealtwoelt2,6,"GGG","idealtwoelt2(nf,x,a)=2-element representation of an ideal x in the number field nf, with the first element equal to a."},
{"idealval",30,(void*)idealval,6,"lGGG","idealval(nf,x,p)=valuation at p given in primedec format of the ideal x in the number field nf."},
{"idmat",11,(void*)matid,8,"L","idmat(n)=identity matrix of order n (n C-integer)."},
{"if",0,(void*)ifpari,11,"GDEDE","if(a,seq1,seq2): if a is nonzero, seq1 is evaluated, otherwise seq2. seq1 and seq2 are optional, and if seq2 is omitted, the preceding comma can be omitted also."},
{"imag",1,(void*)gimag,2,"G","imag(x)=imaginary part of x."},
{"image",1,(void*)image,8,"G","image(x)=basis of the image of the matrix x."},
{"image2",1,(void*)image2,8,"G","image2(x)=basis of the image of the matrix x."},
{"imagecompl",1,(void*)imagecompl,8,"G","imagecompl(x)=vector of column indices not corresponding to the indices given by the function image."},
{"incgam",2,(void*)incgam,3,"GGp","incgam(s,x)=incomplete gamma function."},
{"incgam1",2,(void*)suppressed,3,"GGp","incgam1(s,x)=incomplete gamma function (for debugging only)."},
{"incgam2",2,(void*)suppressed,3,"GGp","incgam2(s,x)=incomplete gamma function (for debugging only)."},
{"incgam3",2,(void*)incgamc,3,"GGp","incgam3(s,x)=complementary incomplete gamma function."},
{"incgam4",3,(void*)incgam0,3,"GGGp","incgam4(s,x,y)=incomplete gamma function where y=gamma(s) is precomputed."},
{"indexrank",1,(void*)indexrank,8,"G","indexrank(x)=gives two extraction vectors (rows and columns) for the matrix x such that the exracted matrix is square of maximal rank."},
{"indsort",1,(void*)indexsort,8,"G","indsort(x)=indirect sorting of the vector x."},
{"initalg",1,(void*)nfinit,6,"Gp","initalg(x)=x being a nonconstant irreducible polynomial, gives the vector: [x,[r1,r2],nfdisc,index,[M,MC,T2,T,different] (see manual),r1+r2 first roots, integral basis, matrix of power basis in terms of integral basis, multiplication table of basis]."},
{"initalgred",1,(void*)nfinitred,6,"Gp","initalgred(x)=x being a nonconstant irreducible polynomial, finds (using polred) a simpler polynomial pol defining the same number field, and gives the vector: [pol,[r1,r2],nfdisc,index,[M,MC,T2,T,different] (see manual), r1+r2 first roots, integral basis, matrix of power basis in terms of integral basis, multiplication table of basis]."},
{"initalgred2",1,(void*)nfinitred2,6,"Gp","initalgred2(P)=P being a nonconstant irreducible polynomial, gives a two-element vector [nf,mod(a,pol)], where nf is as output by nfinitred and mod(a,pol) is a polymod equal to mod(x,P) and pol=nf[1]."},
{"initell",1,(void*)ellinit,5,"GDGp","initell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector: [a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,[e1,e2,e3],w1,w2,eta1,eta2,q,area]."},
{"initzeta",1,(void*)initzeta,6,"Gp","initzeta(x)=compute number field information necessary to use zetak, where x is an irreducible polynomial."},
{"integ",14,(void*)integ,7,"Gn","integ(x,y)=formal integration of x with respect to the main variable of y."},
{"intersect",2,(void*)intersect,8,"GG","intersect(x,y)=intersection of the vector spaces whose bases are the columns of x and y."},
{"intgen",99,(void*)intnumromb0,9,"V=GGED1,L,p","intgen(X=a,b,s)=general numerical integration of s from a to b with respect to X, to be used after removing singularities."},
{"intinf",99,(void*)intnumromb0,9,"V=GGED2,L,p","intinf(X=a,b,s)=numerical integration of s from a to b with respect to X, where a or b can be plus or minus infinity (1.0e4000), but of same sign."},
{"intnum",99,(void*)intnumromb0,9,"V=GGED0,L,p","intnum(X=a,b,s)=numerical integration of s from a to b with respect to X."},
{"intopen",99,(void*)intnumromb0,9,"V=GGED3,L,p","intopen(X=a,b,s)=numerical integration of s from a to b with respect to X, where s has only limits at a or b."},
{"inverseimage",2,(void*)inverseimage,8,"GG","inverseimage(x,y)=an element of the inverse image of the vector y by the matrix x if one exists, the empty vector otherwise."},
{"isdiagonal",10,(void*)isdiagonal,8,"lG","isdiagonal(x)=true(1) if x is a diagonal matrix, false(0) otherwise."},
{"isfund",1,(void*)isfundamental,4,"lG","isfund(x)=true(1) if x is a fundamental discriminant (including 1), false(0) if not."},
{"isideal",20,(void*)isideal,6,"lGG","isideal(nf,x)=true(1) if x is an ideal in the number field nf, false(0) if not."},
{"isincl",2,(void*)nfisincl,6,"GG","isincl(x,y)=tests whether the number field defined by the polynomial x is isomorphic to a subfield of the one defined by y; 0 if not, otherwise all the isomorphisms."},
{"isinclfast",2,(void*)nfisincl,6,"GG","isinclfast(nf1,nf2)=tests whether the number nf1 is isomorphic to a subfield of nf2 or not. If it gives a non-zero result, this proves that this is the case. However if it gives zero, nf1 may still be isomorphic to a subfield of nf2 so you have to use the much slower isincl to be sure."},
{"isirreducible",1,(void*)isirreducible,7,"lG","isirreducible(x)=true(1) if x is an irreducible non-constant polynomial, false(0) if x is reducible or constant."},
{"isisom",2,(void*)nfisisom,6,"GG","isisom(x,y)=tests whether the number field defined by the polynomial x is isomorphic to the one defined by y; 0 if not, otherwise all the isomorphisms."},
{"isisomfast",2,(void*)nfisisom,6,"GG","isisomfast(nf1,nf2)=tests whether the number fields nf1 and nf2 are isomorphic or not. If it gives a non-zero result, this proves that they are isomorphic. However if it gives zero, nf1 and nf2 may still be isomorphic so you have to use the much slower isisom to be sure."},
{"isoncurve",20,(void*)oncurve,5,"iGG","isoncurve(e,x)=true(1) if x is on elliptic curve e, false(0) if not."},
{"isprime",1,(void*)gisprime,4,"GD0,L,","isprime(x)=true(1) if x is a strong pseudoprime for 10 random bases, false(0) if not."},
{"isprincipal",2,(void*)isprincipal,6,"GG","isprincipal(bnf,x)=bnf being output by buchinit, gives the vector of exponents on the class group generators of x. In particular x is principal if and only if the result is the zero vector."},
{"isprincipalforce",2,(void*)isprincipalforce,6,"GG","isprincipalforce(bnf,x)=same as isprincipal, except that the precision is doubled until the result is obtained."},
{"isprincipalgen",2,(void*)isprincipalgen,6,"GG","isprincipalgen(bnf,x)=bnf being output by buchinit, gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector."},
{"isprincipalgenforce",2,(void*)isprincipalgenforce,6,"GG","isprincipalgenforce(bnf,x)=same as isprincipalgen, except that the precision is doubled until the result is obtained."},
{"isprincipalray",2,(void*)isprincipalray,6,"GG","isprincipalray(bnf,x)=bnf being output by buchrayinit, gives the vector of exponents on the ray class group generators of x. In particular x is principal if and only if the result is the zero vector."},
{"isprincipalraygen",2,(void*)isprincipalraygen,6,"GG","isprincipalraygen(bnf,x)=bnf being output by buchrayinit, gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector."},
{"ispsp",1,(void*)gispseudoprime,4,"GD1,L,","ispsp(x)=true(1) if x is a strong pseudoprime, false(0) if not."},
{"isqrt",1,(void*)sqrtint,4,"G","isqrt(x)=integer square root of x (x integer)."},
{"isset",10,(void*)setisset,8,"lG","isset(x)=true(1) if x is a set (row vector with strictly increasing entries), false(0) if not."},
{"issqfree",1,(void*)issquarefree,4,"lG","issqfree(x)=true(1) if x is squarefree, false(0) if not."},
{"issquare",1,(void*)issquare,4,"lG","issquare(x)=true(1) if x is a square, false(0) if not."},
{"isunit",2,(void*)bnfisunit,6,"GG","isunit(bnf,x)=bnf being output by buchinit, gives the vector of exponents of x on the fundamental units and the roots of unity if x is a unit, the empty vector otherwise."},
{"jacobi",1,(void*)jacobi,8,"Gp","jacobi(x)=eigenvalues and orthogonal matrix of eigenvectors of the real symmetric matrix x."},
{"jbesselh",2,(void*)jbesselh,3,"GGp","jbesselh(n,x)=J-bessel function of index n+1/2 and argument x, where n is a non-negative integer."},
{"jell",1,(void*)jell,3,"Gp","jell(x)=elliptic j invariant of x."},
{"karamul",0,(void*)suppressed,7,"GGL","karamul(x,y,k)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"kbessel",2,(void*)kbessel,3,"GGp","kbessel(nu,x)=K-bessel function of index nu and argument x (x positive real of type real, nu of any scalar type)."},
{"kbessel2",2,(void*)kbessel,3,"GGp","kbessel2(nu,x)=K-bessel function of index nu and argument x (x positive real of type real, nu of any scalar type)."},
{"ker",1,(void*)ker,8,"G","ker(x)=basis of the kernel of the matrix x."},
{"keri",1,(void*)keri,8,"G","keri(x)=basis of the kernel of the matrix x with integer entries."},
{"kerint",1,(void*)matkerint0,8,"GD0,L,","kerint(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral entries using a modified LLL."},
{"kerint1",1,(void*)matkerint0,8,"GD1,L,","kerint1(x)=LLL-reduced Z-basis of the kernel of the matrix x with rational entries using matrixqz3 and the HNF."},
{"kerint2",1,(void*)suppressed,8,"G","kerint2(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral entries using a modified LLL."},
{"kro",2,(void*)kronecker,4,"lGG","kro(x,y)=kronecker symbol (x/y)."},
{"label",0,(void*)suppressed,11,"s*","label(n)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"lambdak",2,(void*)glambdak,6,"GGp","lambdak(nfz,s)=Dedekind lambda function of the number field nfz at s, where nfz is the vector computed by initzeta (NOT by nfinit)."},
{"laplace",1,(void*)laplace,7,"G","laplace(x)=replaces the power series sum of a_n*x^n/n! by sum of a_n*x^n."},
{"lcm",2,(void*)glcm,4,"GG","lcm(x,y)=least common multiple of x and y=x*y/gcd(x,y)."},
{"legendre",11,(void*)pollegendre,7,"LDn","legendre(n)=legendre polynomial of degree n (n C-integer)."},
{"length",1,(void*)glength,2,"lG","length(x)=number of non code words in x."},
{"lex",20,(void*)lexcmp,2,"iGG","lex(x,y)=compare x and y lexicographically (1 if x>y, 0 if x=y, -1 if x<y)."},
{"lexsort",1,(void*)lexsort,8,"G","lexsort(x)=sort the elements of the vector x in ascending lexicographic order."},
{"lift",1,(void*)lift,2,"G","lift(x)=lifts every element of Z/nZ to Z or Z[x]/PZ[x] to Z[x]."},
{"lindep",1,(void*)lindep,8,"G","lindep(x)=Z-linear dependencies between components of x (Hastad et al)."},
{"lindep2",23,(void*)lindep2,8,"GL","lindep2(x,dec)=Z-linear dependencies between components of x using LLL, where dec should be about one half the number of decimal digits of precision."},
{"lll",1,(void*)lll,8,"Gp","lll(x)=lll reduction of the vectors forming the matrix x (gives the unimodular transformation matrix)."},
{"lll1",1,(void*)suppressed,8,"Gp","lll1(x)=old version of lll reduction of the vectors forming the matrix x (gives the unimodular transformation matrix)."},
{"lllgen",1,(void*)lllgen,8,"Gp","lllgen(x)=lll reduction of the vectors forming the matrix x with polynomial coefficients (gives the unimodular transformation matrix)."},
{"lllgram",1,(void*)lllgram,8,"Gp","lllgram(x)=lll reduction of the lattice whose gram matrix is x (gives the unimodular transformation matrix)."},
{"lllgram1",1,(void*)suppressed,8,"Gp","lllgram1(x)=old version of lll reduction of the lattice whose gram matrix is x (gives the unimodular transformation matrix)."},
{"lllgramgen",1,(void*)lllgramgen,8,"G","lllgramgen(x)=lll reduction of the lattice whose gram matrix is x with polynomial coefficients (gives the unimodular transformation matrix)."},
{"lllgramint",1,(void*)lllgramint,8,"G","lllgramint(x)=lll reduction of the lattice whose gram matrix is the integral matrix x (gives the unimodular transformation matrix)."},
{"lllgramkerim",1,(void*)lllgramkerim,8,"G","lllgramkerim(x)=kernel and lll reduction of the lattice whose gram matrix is the integral matrix x."},
{"lllgramkerimgen",1,(void*)lllgramkerimgen,8,"G","lllgramkerimgen(x)=kernel and lll reduction of the lattice whose gram matrix is the matrix x with polynomial coefficients."},
{"lllint",1,(void*)lllint,8,"G","lllint(x)=lll reduction of the vectors forming the matrix x when the gram matrix is integral (gives the unimodular transformation matrix)."},
{"lllintpartial",1,(void*)lllintpartial,8,"G","lllintpartial(x)=partial (hence faster) lll reduction of the vectors forming the matrix x when the gram matrix is integral (gives the unimodular transformation matrix)."},
{"lllkerim",1,(void*)lllkerim,8,"G","lllkerim(x)=kernel and lll reduction of the vectors forming the integral matrix x."},
{"lllkerimgen",1,(void*)lllkerimgen,8,"G","lllkerimgen(x)=kernel and lll reduction of the vectors forming the matrix x with polynomial coefficients."},
{"lllrat",1,(void*)suppressed,8,"G","lllrat(x)=lll reduction of the vectors forming the matrix x, computations done with rational numbers (gives the unimodular transformation matrix)."},
{"ln",1,(void*)glog,3,"Gp","ln(x)=log(x)=natural logarithm of x."},
{"lngamma",1,(void*)glngamma,3,"Gp","lngamma(x)=logarithm of the gamma function of x."},
{"localred",2,(void*)elllocalred,5,"GG","localred(e,p)=e being an ellliptic curve, returns [f,kod,[u,r,s,t],c], where f is the conductor's exponent, kod is the kodaira type for e at p, [u,r,s,t] is the change of variable needed to make e minimal at p, and c is the local Tamagawa number c_p."},
{"log",1,(void*)glog,3,"Gp","log(x)=ln(x)=natural logarithm of x."},
{"logagm",1,(void*)glog,3,"Gp","logagm(x)=natural logarithm of x, computed using agm (faster than log for more than a few hundred decimal digits)."},
{"lseriesell",4,(void*)lseriesell0,5,"GGGGp","lseriesell(e,s,N,A)=L-series at s of the elliptic curve e, where |N| is the conductor, sign(N) the sign of the functional equation, and A a cut-off point close to 1."},
{"makebigbnf",1,(void*)bnfinit0,6,"GD0,L,DGp","makebigbnf(sbnf)=transforms small sbnf as output by smallbuchinit into a true big bnf."},
{"mat",1,(void*)gtomat,8,"G","mat(x)=transforms any GEN x into a matrix."},
{"matextract",3,(void*)extract0,8,"GGG","matextract(x,y,z)=extraction of the components of the matrix x according to the vector or masks y (for the rows) and z (for the columns) from left to right (1,2,4,8,...for the first, second, third, fourth, ...rows or columns)."},
{"mathell",2,(void*)mathell,5,"GGp","mathell(e,x)=gives the height matrix for vector of points x on elliptic curve e using theta functions."},
{"matrix",49,(void*)matrice,9,"GGVVE","matrix(m,n,X,Y,expr)=mXn matrix of expression expr, the row variable X going  from 1 to m and the column variable Y going from 1 to n."},
{"matrixqz",2,(void*)QM_minors_coprime,8,"GG","matrixqz(x,p)=transforms the rational or integral mxn (m>=n) matrix x into an integral matrix with gcd of maximal determinants equal to 1 if p is equal to 0, not divisible by p otherwise."},
{"matrixqz2",1,(void*)QM_ImZ_hnf,8,"G","matrixqz2(x)=finds a basis of the intersection with Z^n of the lattice spanned by the columns of x."},
{"matrixqz3",1,(void*)QM_ImQ_hnf,8,"G","matrixqz3(x)=finds a basis of the intersection with Z^n of the Q-vector space spanned by the columns of x."},
{"matsize",1,(void*)matsize,2,"G","matsize(x)=number of rows and columns of the vector/matrix x as a 2-vector."},
{"max",2,(void*)gmax,1,"GG","max(x,y)=maximum of x and y."},
{"min",2,(void*)gmin,1,"GG","min(x,y)=minimum of x and y."},
{"minideal",3,(void*)idealmin,6,"GGG","idealmin(nf,ix,vdir)=minimum of the ideal ix in the direction vdir in the number field nf."},
{"minim",33,(void*)minim,8,"GGG","minim(x,bound,maxnum)=number of vectors of square norm <= bound, maximum norm and list of vectors for the integral and definite quadratic form x; minimal non-zero vectors if bound=0."},
{"minim2",23,(void*)minim2,8,"GG","minim2(x,bound)=looks for vectors of square norm <= bound, return the first one and its norm."},
{"mod",25,(void*)gmodulo,2,"GG","mod(x,y)=creates the integer x modulo y on the PARI stack."},
{"modp",25,(void*)gmodulo,2,"GG","modp(x,y)=creates the integer x modulo y as a permanent object (on the heap)."},
{"modreverse",1,(void*)modreverse,6,"G","modreverse(x)=reverse polymod of the polymod x, if it exists."},
{"modulargcd",2,(void*)QX_gcd,2,"GG","modulargcd(x,y)=gcd of the polynomials x and y using the modular method."},
{"mu",1,(void*)moebius,4,"lG","mu(x)=Moebius function of x."},
{"newtonpoly",2,(void*)newtonpoly,6,"GG","newtonpoly(x,p)=Newton polygon of polynomial x with respect to the prime p."},
{"nextprime",1,(void*)nextprime,4,"G","nextprime(x)=smallest prime number>=x."},
{"nfdetint",2,(void*)nfdetint,6,"GG","nfdetint(nf,x)=multiple of the ideal determinant of the pseudo generating set x."},
{"nfdiv",3,(void*)nfdiv,6,"GGG","nfdiv(nf,a,b)=element a/b in nf."},
{"nfdiveuc",3,(void*)nfdiveuc,6,"GGG","nfdiveuc(nf,a,b)=gives algebraic integer q such that a-bq is small."},
{"nfdivres",3,(void*)nfdivrem,6,"GGG","nfdivres(nf,a,b)=gives [q,r] such that r=a-bq is small."},
{"nfhermite",2,(void*)nfhnf,6,"GG","nfhermite(nf,x)=if x=[A,I], gives a pseudo-basis of the module sum A_jI_j."},
{"nfhermitemod",3,(void*)nfhnfmod,6,"GGG","nfhermitemod(nf,x,detx)=if x=[A,I], and detx is a multiple of the ideal determinant of x, gives a pseudo-basis of the module sum A_jI_j."},
{"nfmod",3,(void*)nfmod,6,"GGG","nfmod(nf,a,b)=gives r such that r=a-bq is small with q algebraic integer."},
{"nfmul",3,(void*)nfmul,6,"GGG","nfmul(nf,a,b)=element a.b in nf."},
{"nfpow",3,(void*)nfpow,6,"GGG","nfpow(nf,a,k)=element a^k in nf."},
{"nfreduce",3,(void*)nfreduce,6,"GGG","nfreduce(nf,a,id)=gives r such that a-r is the ideal id and r is small."},
{"nfsmith",2,(void*)nfsnf,6,"GG","nfsmith(nf,x)=if x=[A,I,J], outputs [c_1,...c_n] Smith normal form of x."},
{"nfval",30,(void*)nfval,6,"lGGG","nfval(nf,a,pr)=valuation of element a at the prime pr."},
{"norm",1,(void*)gnorm,2,"G","norm(x)=norm of x."},
{"norml2",1,(void*)gnorml2,2,"G","norml2(x)=square of the L2-norm of the vector x."},
{"nucomp",3,(void*)nucomp,4,"GGG","nucomp(x,y,l)=composite of primitive positive definite quadratic forms x and y using nucomp and nudupl, where l=[|D/4|^(1/4)] is precomputed."},
{"numdiv",1,(void*)numdiv,4,"G","numdiv(x)=number of divisors of x."},
{"numer",1,(void*)numer,2,"G","numer(x)=numerator of x."},
{"nupow",2,(void*)nupow,4,"GG","nupow(x,n)=n-th power of primitive positive definite quadratic form x using nucomp and nudupl."},
{"o",0,(void*)ggrando,7,"GD1,L,","o(a^b): p-adic or power series zero with precision given by b."},
{"omega",1,(void*)omega,4,"lG","omega(x)=number of unrepeated prime divisors of x."},
{"ordell",2,(void*)ellordinate,5,"GGp","ordell(e,x)=y-coordinates corresponding to x-ordinate x on elliptic curve e."},
{"order",1,(void*)order,4,"G","order(x)=order of the integermod x in (Z/nZ)*."},
{"orderell",2,(void*)orderell,5,"GG","orderell(e,p)=order of the point p on the elliptic curve e over Q, 0 if non-torsion."},
{"ordred",1,(void*)polredord,6,"Gp","ordred(x)=reduction of the polynomial x, staying in the same order."},
{"padicprec",20,(void*)padicprec,2,"lGG","padicprec(x,p)=absolute p-adic precision of object x."},
{"pascal",99,(void*)matqpascal,8,"LDG","pascal(n)=pascal triangle of order n (n C-integer)."},
{"perf",10,(void*)perf,8,"G","perf(a)=rank of matrix of xx~ for x minimal vectors of a gram matrix a."},
{"permutation",24,(void*)numtoperm,2,"LG","permutation(n,k)=permutation number k (mod n!) of n letters (n C-integer)."},
{"permutation2num",1,(void*)permtonum,2,"G","permutation2num(vect)=ordinal (between 1 and n!) of permutation vect."},
{"pf",2,(void*)primeform,4,"GGp","pf(x,p)=returns the prime form whose first coefficient is p, of discriminant x."},
{"phi",1,(void*)eulerphi,4,"G","phi(x)=Euler's totient function of x."},
{"pi",0,(void*)mppi,3,"p","pi=pi()=the constant pi, with current precision."},
{"pnqn",1,(void*)pnqn,4,"G","pnqn(x)=[p_n,p_{n-1};q_n,q_{n-1}] corresponding to the continued fraction x."},
{"pointell",2,(void*)pointell,5,"GGp","pointell(e,z)=coordinates of point on the curve e corresponding to the complex number z."},
{"polint",31,(void*)polint,7,"GGGD&","polint(xa,ya,x)=polynomial interpolation at x according to data vectors xa, ya."},
{"polred",1,(void*)polred,6,"G","polred(x)=reduction of the polynomial x (gives minimal polynomials only)."},
{"polred2",1,(void*)polred2,6,"G","polred2(x)=reduction of the polynomial x (gives elements and minimal polynomials)."},
{"polredabs",1,(void*)polredabs,6,"G","polredabs(x)=a smallest generating polynomial of the number field for the T2 norm on the roots, with smallest index for the minimal T2 norm."},
{"polredabs2",1,(void*)polredabs2,6,"G","polredabs2(x)=gives [pol,a] where pol is as in polredabs, and alpha is the element whose characteristic polynomial is pol."},
{"polredabsall",1,(void*)polredabsall,6,"G","polredabsall(x)=complete list of the smallest generating polynomials of the number field for the T2 norm on the roots."},
{"polredabsfast",0,(void*)suppressed,6,"G","polredabsfast(x)=a smallest generating polynomial of the number field for the T2 norm on the roots."},
{"polredabsnored",1,(void*)polredabs,6,"G","polredabsnored(x)=a smallest generating polynomial of the number field for the T2 norm on the roots without initial polred."},
{"polsym",21,(void*)polsym,7,"GL","polsym(x,n)=vector of symmetric powers of the roots of x up to n."},
{"polvar",1,(void*)gpolvar,2,"G","polvar(x)=main variable of object x. Gives p for p-adic x, error for scalars."},
{"poly",14,(void*)gtopoly,2,"Gn","poly(x,v)=convert x (usually a vector or a power series) into a polynomial with variable v, starting with the leading coefficient."},
{"polylog",24,(void*)gpolylog,3,"LGp","polylog(m,x)=m-th polylogarithm of x."},
{"polylogd",24,(void*)polylogd,3,"LGp","polylogd(m,x)=D_m~-modified m-th polylog of x."},
{"polylogdold",24,(void*)polylogdold,3,"LGp","polylogdold(m,x)=D_m-modified m-th polylog of x."},
{"polylogp",24,(void*)polylogp,3,"LGp","polylogp(m,x)=P_m-modified m-th polylog of x."},
{"polyrev",14,(void*)gtopolyrev,2,"Gn","polyrev(x,v)=convert x (usually a vector or a power series) into a polynomial with variable v, starting with the constant term."},
{"polzag",21,(void*)polzag,9,"LL","polzag(n,m)=Zagier's polynomials of index n,m."},
{"powell",3,(void*)ellmul,5,"GGGp","powell(e,x,n)=n times the point x on elliptic curve e (n in Z)."},
{"powrealraw",23,(void*)qfrpowraw,4,"GL","powrealraw(x,n)=n-th power without reduction of the binary quadratic form x of positive discriminant."},
{"prec",21,(void*)gprec,2,"GL","prec(x,n)=change the precision of x to be n (n C-integer)."},
{"precision",1,(void*)precision0,2,"GD0,L,","precision(x)=real precision of object x."},
{"prime",11,(void*)prime,4,"L","prime(n)=returns the n-th prime (n C-integer)."},
{"primedec",2,(void*)idealprimedec,6,"GG","primedec(nf,p)=prime ideal decomposition of the prime number p in the number field nf as a vector of 5 component vectors [p,a,e,f,b] representing the prime ideals pZ_K+a.Z_K, e,f as usual, a as vector of components on the  integral basis, b Lenstra's constant."},
{"primes",11,(void*)primes,4,"L","primes(n)=returns the vector of the first n primes (n C-integer)."},
{"primroot",1,(void*)znprimroot,4,"G","primroot(n)=returns a primitive root of n when it exists."},
{"principalideal",2,(void*)principalideal,6,"GG","principalideal(nf,x)=returns the principal ideal generated by the algebraic number x in the number field nf."},
{"principalidele",2,(void*)suppressed,6,"GG","principalidele(nf,x)=returns the principal idele generated by the algebraic number x in the number field nf."},
{"prod",48,(void*)prod0,9,"GV=GGE","prod(x,X=a,b,expr)=x times the product (X runs from a to b) of expression."},
{"prodeuler",37,(void*)prodeuler0,9,"V=GGEp","prodeuler(X=a,b,expr)=Euler product (X runs over the primes between a and b) of real or complex expression."},
{"prodinf",27,(void*)prodinf0,9,"V=GED0,L,p","prodinf(X=a,expr)=infinite product (X goes from a to infinity) of real or complex expression."},
{"prodinf1",27,(void*)prodinf0,9,"V=GED1,L,p","prodinf1(X=a,expr)=infinite product (X goes from a to infinity) of real or complex 1+expression."},
{"psi",1,(void*)gpsi,3,"Gp","psi(x)=psi-function at x."},
{"qfi",3,(void*)qfi,4,"GGG","qfi(a,b,c)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c<0."},
{"qfr",4,(void*)qfr,4,"GGGG","qfr(a,b,c,d)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c>0 and distance d."},
{"quaddisc",1,(void*)quaddisc,4,"G","quaddisc(x)=discriminant of the quadratic field Q(sqrt(x))."},
{"quadgen",1,(void*)quadgen,2,"G","quadgen(x)=standard generator of quadratic order of discriminant x."},
{"quadpoly",1,(void*)quadpoly,2,"G","quadpoly(x)=quadratic polynomial corresponding to the discriminant x."},
{"random",0,(void*)genrand,2,"DG","random()=random integer between 0 and 2^31-1."},
{"rank",10,(void*)rank,8,"lG","rank(x)=rank of the matrix x."},
{"rayclassno",2,(void*)bnrclassno,6,"GG","rayclassno(bnf,x)=ray class number of the module x for the big number field bnf. Faster than buchray if only the ray class number is wanted."},
{"rayclassnolist",2,(void*)bnrclassnolist,6,"GG","rayclassnolist(bnf,liste)=if listes is as output by idealisunit or similar, gives list of corresponding ray class numbers."},
{"real",1,(void*)greal,2,"G","real(x)=real part of x."},
{"recip",1,(void*)polrecip,7,"G","recip(x)=reciprocal polynomial of x."},
{"redimag",1,(void*)redimag,4,"G","redimag(x)=reduction of the binary quadratic form x with D<0."},
{"redreal",1,(void*)redreal,4,"G","redreal(x)=reduction of the binary quadratic form x with D>0."},
{"redrealnod",2,(void*)redrealnod,4,"GG","redrealnod(x,sq)=reduction of the binary quadratic form x with D>0 without distance function where sq=[sqrt D]."},
{"reduceddisc",1,(void*)reduceddiscsmith,7,"G","reduceddisc(f)=vector of elementary divisors of Z[a]/f'(a)Z[a], where a is a root of the polynomial f."},
{"regula",1,(void*)quadregulator,4,"Gp","regula(x)=regulator of the real quadratic field of discriminant x."},
{"reorder",0,(void*)suppressed,11,"G","reorder(x)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"resultant",2,(void*)resultant_all,7,"GGD&","resultant(x,y)=resultant of the polynomials x and y with exact entries."},
{"resultant2",2,(void*)resultant2,7,"GG","resultant2(x,y)=resultant of the polynomials x and y."},
{"reverse",1,(void*)serreverse,7,"G","reverse(x)=reversion of the power series x."},
{"rhoreal",1,(void*)rhoreal,4,"G","rhoreal(x)=single reduction step of the binary quadratic form x of positive discriminant."},
{"rhorealnod",2,(void*)rhorealnod,4,"GG","rhorealnod(x,sq)=single reduction step of the binary quadratic form x with D>0 without distance function where sq=[sqrt D]."},
{"rndtoi",13,(void*)grndtoi,2,"Gf","rndtoi(x)=take the nearest integer to all the coefficients of x, without taking into account loss of integer part precision."},
{"rnfbasis",2,(void*)rnfbasis,6,"GG","rnfbasis(bnf,order)=given an order as output by rnfpseudobasis or rnfsteinitz, gives either a basis of the order if it is free, or an n+1-element generating set."},
{"rnfdiscf",2,(void*)rnfdiscf,6,"GG","rnfdiscf(nf,pol)=given a pol with coefficients in nf, gives a 2-component vector [D,d], where D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2."},
{"rnfequation",2,(void*)rnfequation,6,"GG","rnfequation(nf,pol)=given a pol with coefficients in nf, gives the absolute equation of the number field defined by pol."},
{"rnfequation2",2,(void*)rnfequation2,6,"GG","rnfequation2(nf,pol)=given a pol with coefficients in nf, gives [apol,th], where apol is the absolute equation of the number field defined by pol and th expresses the root of nf[1] in terms of the root of apol."},
{"rnfhermitebasis",2,(void*)rnfhnfbasis,6,"GG","rnfhermitebasis(bnf,order)=given an order as output by rnfpseudobasis, gives either a true HNF basis of the order if it exists, zero otherwise."},
{"rnfisfree",20,(void*)rnfisfree,6,"lGG","rnfisfree(bnf,order)=given an order as output by rnfpseudobasis or rnfsteinitz, outputs true (1) or false (0) according to whether the order is free or not."},
{"rnflllgram",3,(void*)rnflllgram,6,"GGG","rnflllgram(nf,pol,order)=given a pol with coefficients in nf and an order as output by rnfpseudobasis or similar, gives [[neworder],U], where neworder is a reduced order and U is the unimodular transformation matrix."},
{"rnfpolred",2,(void*)rnfpolred,6,"GG","rnfpolred(nf,pol)=given a pol with coefficients in nf, finds a list of polynomials defining some subfields, hopefully simpler."},
{"rnfpseudobasis",2,(void*)rnfpseudobasis,6,"GG","rnfpseudobasis(nf,pol)=given a pol with coefficients in nf, gives a 4-component vector [A,I,D,d] where [A,I] is a pseudo basis of the maximal order in HNF on the power basis, D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2."},
{"rnfsteinitz",2,(void*)rnfsteinitz,6,"GG","rnfsteinitz(nf,order)=given an order as output by rnfpseudobasis, gives [A,I,..] where (A,I) is a pseudo basis where all the ideals except perhaps the last are trivial."},
{"rootmod",2,(void*)rootmod,7,"GG","rootmod(x,p)=roots mod p of the polynomial x."},
{"rootmod2",2,(void*)rootmod2,7,"GG","rootmod2(x,p)=roots mod p of the polynomial x, when p is small."},
{"rootpadic",32,(void*)rootpadic,7,"GGL","rootpadic(x,p,r)=p-adic roots of the polynomial x to precision r."},
{"roots",1,(void*)roots,7,"Gp","roots(x)=roots of the polynomial x using Schonhage's method modified by Gourdon."},
{"rootsof1",1,(void*)rootsof1,6,"G","rootsof1(nf)=number of roots of unity and primitive root of unity in the number field nf."},
{"rootsold",0,(void*)suppressed,11,"G","rootsold(x)=THIS FUNCTION HAS BEEN SUPPRESSED."},
{"round",1,(void*)ground,2,"G","round(x)=take the nearest integer to all the coefficients of x."},
{"rounderror",10,(void*)rounderror,2,"lG","rounderror(x)=maximum error found in rounding x."},
{"series",14,(void*)gtoser,2,"Gn","series(x,v)=convert x (usually a vector) into a power series with variable v, starting with the constant coefficient."},
{"set",1,(void*)gtoset,8,"G","set(x)=convert x into a set, i.e. a row vector with strictly increasing coefficients."},
{"setintersect",2,(void*)setintersect,8,"GG","setintersect(x,y)=intersection of the sets x and y."},
{"setminus",2,(void*)setminus,8,"GG","setminus(x,y)=set of elements of x not belonging to y."},
{"setrand",11,(void*)setrand,2,"vG","setrand(n)=reset the seed of the random number generator to n."},
{"setsearch",20,(void*)setsearch,8,"lGGD0,L,","setsearch(x,y)=looks if y belongs to the set x. Returns 0 if it is not, otherwise returns the index j such that y==x[j]."},
{"setunion",2,(void*)setunion,8,"GG","setunion(x,y)=union of the sets x and y."},
{"shift",21,(void*)gshift,1,"GL","shift(x,n)=shift x left n bits if n>=0, right -n bits if n<0."},
{"shiftmul",21,(void*)gmul2n,1,"GL","shiftmul(x,n)=multiply x by 2^n (n>=0 or n<0)."},
{"sigma",1,(void*)sumdiv,4,"G","sigma(x)=sum of the divisors of x."},
{"sigmak",24,(void*)sigmak0,4,"LG","sigmak(k,x)=sum of the k-th powers of the divisors of x (k C-integer)."},
{"sign",10,(void*)gsigne,1,"iG","sign(x)=sign of x, of type integer, real or fraction."},
{"signat",1,(void*)qfsign,8,"G","signat(x)=signature of the symmetric matrix x."},
{"signunit",1,(void*)signunits,6,"G","signunit(bnf)=matrix of signs of the real embeddings of the system of fundamental units found by buchinit."},
{"simplefactmod",2,(void*)simplefactmod,4,"GG","simplefactmod(x,p)=same as factmod except that only the degrees of the irreducible factors are given."},
{"simplify",1,(void*)simplify,2,"G","simplify(x)=simplify the object x as much as possible."},
{"sin",1,(void*)gsin,3,"Gp","sin(x)=sine of x."},
{"sinh",1,(void*)gsinh,3,"Gp","sinh(x)=hyperbolic sine of x."},
{"size",10,(void*)sizedigit,2,"lG","size(x)=maximum number of decimal digits minus one of (the coefficients of) x."},
{"smallbasis",13,(void*)nfbasis0,6,"GD1,L,DG","smallbasis(x)=integral basis of the field Q[a], where a is a root of the polynomial x where one assumes that no square of a prime>primelimit divides the discriminant of x."},
{"smallbuchinit",93,(void*)smallbuchinit,6,BUCH_PROTO,"smallbuchinit(pol)=small buchinit, which can be converted to a big one using makebigbnf."},
{"smalldiscf",1,(void*)nfdisc0,6,"GD1,L,DG","smalldiscf(x)=discriminant of the number field defined by the polynomial x where one assumes that no square of a prime>primelimit divides the discriminant of x."},
{"smallfact",1,(void*)boundfact,4,"GD0,L,","smallfact(x)=partial factorization of the integer x (using only the stored primes)."},
{"smallinitell",1,(void*)ellinit,5,"GDGp","smallinitell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector: [a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j]."},
{"smallpolred",1,(void*)smallpolred,6,"G","smallpolred(x)=partial reduction of the polynomial x (gives minimal polynomials only)."},
{"smallpolred2",1,(void*)smallpolred2,6,"G","smallpolred2(x)=partial reduction of the polynomial x (gives elements and minimal polynomials)."},
{"smith",1,(void*)smith,8,"G","smith(x)=Smith normal form (i.e. elementary divisors) of the matrix x, expressed as a vector."},
{"smith2",1,(void*)smithall,8,"G","smith2(x)=gives a three element vector [u,v,d] where u and v are square unimodular matrices such that d=u*x*v=diagonal(smith(x))."},
{"smithclean",1,(void*)smithclean,8,"G","smithclean(z)=if z=[u,v,d] as output by smith2, removes from u,v,d the rows and columns corresponding to entries equal to 1 in d."},
{"smithpol",1,(void*)gsmith,8,"G","smithpol(x)=Smith normal form (i.e. elementary divisors) of the matrix x with polynomial coefficients, expressed as a vector."},
{"solve",37,(void*)zbrent0,9,"V=GGEp","solve(X=a,b,expr)=real root of expression expr (X between a and b), where expr(a)*expr(b)<=0."},
{"sort",1,(void*)sort,8,"G","sort(x)=sort in ascending order of the vector x."},
{"sqr",1,(void*)gsqr,3,"G","sqr(x)=square of x. NOT identical to x*x."},
{"sqred",1,(void*)qfgaussred,8,"G","sqred(x)=square reduction of the (symmetric) matrix x ( returns a square matrix whose i-th diagonal term is the coefficient of the i-th square in which the coefficient of the i-th variable is 1)."},
{"sqrt",1,(void*)gsqrt,3,"Gp","sqrt(x)=square root of x."},
{"srgcd",2,(void*)RgX_gcd,7,"GG","srgcd(x,y)=polynomial gcd of x and y using the subresultant algorithm."},
{"sturm",10,(void*)sturm0,7,"lG","sturm(x)=number of real roots of the polynomial x."},
{"sturmpart",30,(void*)sturmpart,7,"lGGG","sturmpart(x,a,b)=number of real roots of the polynomial x in the interval (a,b]."},
{"subcyclo",2,(void*)polsubcyclo,6,"LLDn","subcyclo(p,d)=finds an equation for the d-th degree subfield of Q(zeta_p), where p must be a prime power."},
{"subell",3,(void*)ellsub,5,"GGGp","subell(e,z1,z2)=difference of the points z1 and z2 on elliptic curve e."},
{"subst",26,(void*)gsubst,7,"GnG","subst(x,y,z)=in expression x, replace the variable y by the expression z."},
{"sum",48,(void*)sum0,9,"GV=GGE","sum(x,X=a,b,expr)=x plus the sum (X goes from a to b) of expression expr."},
{"sumalt",27,(void*)sumalt0,9,"V=GED0,L,p","sumalt(X=a,expr)=Villegas-Zagier's acceleration of alternating series expr, X starting at a."},
{"sumalt2",27,(void*)sumalt0,9,"V=GED1,L,p","sumalt2(X=a,expr)=Cohen-Villegas-Zagier's acceleration of alternating series expr, X starting at a."},
{"suminf",27,(void*)suminf0,9,"V=GEp","suminf(X=a,expr)=infinite sum (X goes from a to infinity) of real or complex expression expr."},
{"sumpos",27,(void*)sumpos0,9,"V=GED0,L,p","sumpos(X=a,expr)=sum of positive series expr, the formal variable X starting at a."},
{"sumpos2",27,(void*)sumpos0,9,"V=GED1,L,p","sumpos2(X=a,expr)=sum of positive series expr, the formal variable X starting at a, using Zagier's polynomials."},
{"supplement",1,(void*)suppl,8,"G","supplement(x)=supplement the columns of the matrix x to an invertible matrix."},
{"sylvestermatrix",2,(void*)sylvestermatrix,7,"GG","sylvestermatrix(x,y)=forms the sylvester matrix associated to the two polynomials x and y. Warning: the polynomial coefficients are in columns, not in rows."},
{"tan",1,(void*)gtan,3,"Gp","tan(x)=tangent of x."},
{"tanh",1,(void*)gtanh,3,"Gp","tanh(x)=hyperbolic tangent of x."},
{"taniyama",1,(void*)elltaniyama,5,"GP","taniyama(e)=modular parametrization of elliptic curve e."},
{"taylor",12,(void*)tayl,7,"GnP","taylor(x,y)=taylor expansion of x with respect to the main variable of y."},
{"tchebi",11,(void*)polchebyshev,7,"LD1,L,Dn","tchebi(n)=Tchebitcheff polynomial of degree n (n C-integer)."},
{"teich",1,(void*)teich,3,"Gp","teich(x)=teichmuller character of p-adic number x."},
{"theta",2,(void*)theta,3,"GGp","theta(q,z)=Jacobi sine theta-function."},
{"thetanullk",21,(void*)thetanullk,3,"GLp","thetanullk(q,k)=k'th derivative at z=0 of theta(q,z)."},
{"threetotwo",0,(void*)suppressed,6,"GGGG","threetotwo(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is a unimodular 3x3 matrix with algebraic integer coefficients such that [a,b,c]*U=[0,d,e]."},
{"threetotwo2",0,(void*)suppressed,6,"GGGG","threetotwo2(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is a unimodular 3x3 matrix with algebraic integer coefficients such that [a,b,c]*U=[0,d,e]."},
{"torsell",1,(void*)elltors,5,"Gp","torsell(e)=torsion subgroup of elliptic curve e: order, structure, generators."},
{"trace",1,(void*)gtrace,8,"G","trace(x)=trace of x."},
{"trans",1,(void*)gtrans,8,"G","trans(x)=x~=transpose of x."},
{"trunc",1,(void*)gtrunc,2,"G","trunc(x)=truncation of x;when x is a power series,take away the O(X^)."},
{"tschirnhaus",1,(void*)tschirnhaus,6,"G","tschirnhaus(x)=random Tschirnhausen transformation of the polynomial x."},
{"twototwo",0,(void*)suppressed,6,"GGG","twototwo(nf,a,b)=returns a 3-component vector [d,e,U] such that U is a unimodular 2x2 matrix with algebraic integer coefficients such that [a,b]*U=[d,e] and d,e are hopefully smaller."},
{"unit",1,(void*)quadunit,4,"G","unit(x)=fundamental unit of the quadratic field of discriminant x where x must be positive."},
{"until",0,(void*)untilpari,11,"vEI","until(a,seq): evaluate the expression sequence seq until a is nonzero."},
{"valuation",20,(void*)gvaluation,2,"lGG","valuation(x,p)=valuation of x with respect to p."},
{"vec",1,(void*)gtovec,2,"G","vec(x)=transforms the object x into a vector. Used mainly if x is a polynomial or a power series."},
{"vecindexsort",2,(void*)indexsort,8,"G","vecindexsort(x): indirect sorting of the vector x."},
{"veclexsort",2,(void*)lexsort,8,"G","veclexsort(x): sort the elements of the vector x in ascending lexicographic order."},
{"vecmax",1,(void*)vecmax,2,"G","vecmax(x)=maximum of the elements of the vector/matrix x."},
{"vecmin",1,(void*)vecmin,2,"G","vecmin(x)=minimum of the elements of the vector/matrix x."},
{"vecsort",2,(void*)vecsort0,8,"GGD0,L,","vecsort(x,k)=sorts the vector of vector (or matrix) x according to the value of its k-th component."},
{"vector",22,(void*)vecteur,9,"GVE","vector(n,X,expr)=row vector with n components of expression expr (X ranges from 1 to n)."},
{"vvector",22,(void*)vvecteur,9,"GVE","vvector(n,X,expr)=column vector with n components of expression expr (X ranges from 1 to n)."},
{"weipell",1,(void*)weipell,5,"GP","weipell(e)=formal expansion in x=z of Weierstrass P function."},
{"wf",1,(void*)weberf,3,"Gp","weberf(x)=Weber's f function of x (j=(f^24-16)^3/f^24)."},
{"wf2",1,(void*)weberf2,3,"Gp","weberf2(x)=Weber's f2 function of x (j=(f2^24+16)^3/f2^24)."},
{"while",0,(void*)whilepari,11,"vEI","while(a,seq): while a is nonzero evaluate the expression sequence seq. Otherwise 0."},
{"zell",2,(void*)zell,5,"GGp","zell(e,z)=In the complex case, lattice point corresponding to the point z on the elliptic curve e."},
{"zeta",1,(void*)gzeta,3,"Gp","zeta(s)=Riemann zeta function at s."},
{"zetak",2,(void*)gzetak,6,"GGp","zetak(nfz,s)=Dedekind zeta function of the number field nfz at s, where nfz is the vector computed by initzeta (NOT by nfinit)."},
{"zideallog",3,(void*)ideallog,6,"GGG","zideallog(nf,x,bid)=if bid is a big ideal as given by zidealstarinit or zidealstarinitgen , gives the vector of exponents on the generators bid[2][3] (even if these generators have not been computed)."},
{"zidealstar",2,(void*)idealstar0,6,"GGD0,L,","zidealstar(nf,I)=3-component vector v, giving the structure of (Z_K/I)^*. v[1] is  the order (i.e. phi(I)), v[2] is a vector of cyclic components, and v[3]  is a vector giving the corresponding generators."},
{"zidealstarinit",2,(void*)idealstar0,6,"GGD1,L,","zidealstarinit(nf,I)=6-component vector [I,v,fa,f2,U,V] where v is as in zidealstar without the generators, fa is the prime ideal factorisation of I and f2, U and V are technical but essential to work in (Z_K/I)^*."},
{"zidealstarinitgen",2,(void*)idealstar0,6,"GGD2,L,","zidealstarinitgen(nf,I)=6-component vector [I,v,fa,f2,U,V] where v is as in zidealstar fa is the prime ideal factorisation of I and f2, U and V are technical but essential to work in (Z_K/I)^*."},
{"znstar",1,(void*)znstar,4,"G","znstar(n)=3-component vector v, giving the structure of (Z/nZ)^*. v[1] is  the order (i.e. phi(n)), v[2] is a vector of cyclic components, and v[3]  is a vector giving the corresponding generators."},

{NULL,0,NULL,0,NULL,NULL} /* sentinel */
};
