dnl  Intel Pentium mpn_addmul_1 -- mpn by limb multiplication.

dnl  Copyright 1992, 1994, 1996, 1999, 2000, 2002 Free Software Foundation,
dnl  Inc.
dnl
dnl  This file is part of the GNU MP Library.
dnl
dnl  The GNU MP Library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Lesser General Public License as
dnl  published by the Free Software Foundation; either version 2.1 of the
dnl  License, or (at your option) any later version.
dnl
dnl  The GNU MP Library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Lesser General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Lesser General Public
dnl  License along with the GNU MP Library; see the file COPYING.LIB.  If
dnl  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
dnl  Fifth Floor, Boston, MA 02110-1301, USA. */

include(`../config.m4')


C P5: 14.0 cycles/limb

define(OPERATION_addmul_1,1)

ifdef(`OPERATION_addmul_1', `
      define(M4_inst,        addl)
      define(M4_function_1,  mpn_addmul_1)
      define(M4_function_1c, mpn_addmul_1c)

',`ifdef(`OPERATION_submul_1', `
      define(M4_inst,        subl)
      define(M4_function_1,  mpn_submul_1)
      define(M4_function_1c, mpn_submul_1c)

',`m4_error(`Need OPERATION_addmul_1 or OPERATION_submul_1
')')')

MULFUNC_PROLOGUE(mpn_addmul_1 mpn_addmul_1c)


C mp_limb_t mpn_addmul_1 (mp_ptr dst, mp_srcptr src, mp_size_t size,
C                         mp_limb_t mult);
C mp_limb_t mpn_addmul_1c (mp_ptr dst, mp_srcptr src, mp_size_t size,
C                          mp_limb_t mult, mp_limb_t carry);
C
C mp_limb_t mpn_submul_1 (mp_ptr dst, mp_srcptr src, mp_size_t size,
C                         mp_limb_t mult);
C mp_limb_t mpn_submul_1c (mp_ptr dst, mp_srcptr src, mp_size_t size,
C                          mp_limb_t mult, mp_limb_t carry);
C

defframe(PARAM_CARRY,     20)
defframe(PARAM_MULTIPLIER,16)
defframe(PARAM_SIZE,      12)
defframe(PARAM_SRC,       8)
defframe(PARAM_DST,       4)

	TEXT

	ALIGN(8)
PROLOGUE(M4_function_1c)
deflit(`FRAME',0)

	movl	PARAM_CARRY, %ecx
	pushl	%esi		FRAME_pushl()

	jmp	L(start_1c)

EPILOGUE()


	ALIGN(8)
PROLOGUE(M4_function_1)
deflit(`FRAME',0)

	xorl	%ecx, %ecx
	pushl	%esi		FRAME_pushl()

L(start_1c):
	movl	PARAM_SRC, %esi
	movl	PARAM_SIZE, %eax

	pushl	%edi		FRAME_pushl()
	pushl	%ebx		FRAME_pushl()

	movl	PARAM_DST, %edi
	leal	-1(%eax), %ebx		C size-1

	leal	(%esi,%eax,4), %esi
	xorl	$-1, %ebx		C -size, and clear carry

	leal	(%edi,%eax,4), %edi

L(top):
	C eax
	C ebx	counter, negative
	C ecx	carry
	C edx
	C esi	src end
	C edi	dst end
	C ebp

	adcl	$0, %ecx
	movl	(%esi,%ebx,4), %eax

	mull	PARAM_MULTIPLIER

	addl	%ecx, %eax
	movl	(%edi,%ebx,4), %ecx

	adcl	$0, %edx
	M4_inst	%eax, %ecx

	movl	%ecx, (%edi,%ebx,4)
	incl	%ebx

	movl	%edx, %ecx
	jnz	L(top)


	adcl	$0, %ecx
	popl	%ebx

	movl	%ecx, %eax
	popl	%edi

	popl	%esi

	ret

EPILOGUE()
