/******************************************************************************
*
*            M4RIE: Linear Algebra over GF(2^e)
*
*    Copyright (C) 2010 Martin Albrecht <martinralbrecht@googlemail.com>
*
*  Distributed under the terms of the GNU General Public License (GEL)
*  version 2 or higher.
*
*    This code is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    General Public License for more details.
*
*  The full text of the GPL is available at:
*
*                  http://www.gnu.org/licenses/
******************************************************************************/

#include <givaro/givconfig.h>
#include <givaro/givgfq.h>
#include <m4rie.h>

namespace M4RIE {

#if GIVARO_VERSION  <  30400 || GIVARO_VERSION >= 196608 // old Givaro versions used 0x03xxyy
  class FiniteField: public GFqDom<int> {
  public:
  FiniteField(const unsigned int e) : GFqDom<int>(2, e){};
#else
  class FiniteField: public Givaro::GFqDom<int> {
  public:
  FiniteField(const unsigned int e) : Givaro::GFqDom<int>(2, e){};
#endif
      unsigned int  log2pol(int x) { return _log2pol[x]; };
      unsigned int  pol2log(int x) { return _pol2log[x]; };
  };
};

static inline gf2e *gf2e_init_givgfq(M4RIE::FiniteField *givgfq) {
  gf2e *ff = (gf2e*)m4ri_mm_malloc(sizeof(gf2e));
  ff->degree = givgfq->exponent();

  ff->mul = (word **)m4ri_mm_calloc(__M4RI_TWOPOW(givgfq->exponent()), sizeof(word *));
  for(unsigned int i = 0; i<__M4RI_TWOPOW(givgfq->exponent()); i++) {
    ff->mul[i] = (word *)m4ri_mm_calloc(__M4RI_TWOPOW(givgfq->exponent()),sizeof(word));
    for(unsigned int j=0; j<__M4RI_TWOPOW(givgfq->exponent()); j++) {
      int prod = givgfq->mul(prod, givgfq->pol2log(i) , givgfq->pol2log(j));
      ff->mul[i][j] = givgfq->log2pol(prod);
    }
  }
  ff->inv = (word*)m4ri_mm_calloc(__M4RI_TWOPOW(givgfq->exponent()), sizeof(word));
  for(unsigned int i = 0; i<__M4RI_TWOPOW(givgfq->exponent()); i++) {
    int tmp = givgfq->inv(tmp, givgfq->pol2log(i));
    ff->inv[i] = givgfq->log2pol(tmp);
  }
  word tmp = 1;
  for(unsigned int i = 0; i<ff->degree; i++) {
    tmp = ff->mul[2][tmp];
  }
  ff->minpoly = tmp ^ (1<<(ff->degree));
  gf2e_make_pow_gen(ff);
  return ff;
}

static inline int mzed_read_elem_log(const mzed_t *a, const size_t row, const size_t col, M4RIE::FiniteField *ff) {
  return ff->pol2log((int)__mzd_read_bits(a->x, row, a->w*col, a->w));
};

static inline void mzed_write_elem_log(mzed_t *a, const size_t row, const size_t col, const int elem, M4RIE::FiniteField *ff) {
  __mzd_clear_bits(a->x, row, a->w*col, a->w);
  __mzd_xor_bits(a->x, row, a->w*col, a->w, ff->log2pol(elem));
};

static inline void mzed_add_elem_log(mzed_t *a, const size_t row, const size_t col, const int elem, M4RIE::FiniteField *ff) {
  __mzd_xor_bits(a->x, row, a->w*col, a->w, ff->log2pol(elem));
};
