/* Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#ifndef MATRIX_H
#define MATRIX_H

#include "nr.h"

template <class ZT>
class ZZ_mat
{
public:
  ZZ_mat() : r(0), c(0) {}
  ZZ_mat(int rows, int cols) : r(0), c(cols) {SetNumRows(rows);}
  ~ZZ_mat() {clear();}

  int GetNumCols() const {return c;}
  int GetNumRows() const {return r;}
  void SetNumCols(int cols);
  void SetNumRows(int rows);
  void clear();

  // generators
  void gen_intrel(int bits);
  void gen_simdioph(int bits,int bits2);
  void gen_uniform(int bits);
  void gen_ntrulike(int bits,int q);
  void gen_ntrulike2(int bits,int q);
  void gen_ajtai(double alpha);
  void gen_ajtai2(FP_NR<mpfr_t> *w);

  //utils
  inline Z_NR<ZT>& Get(int i,int j);
  inline Z_NR<ZT>& operator()(int i, int j);
  inline const Z_NR<ZT>& operator()(int i, int j) const;
  inline void Set(int i,int j, Z_NR<ZT>& s);
  inline Z_NR<ZT>*& GetVec(int i);
  void print();
  void print(int d,int n);
  int read();
  int getMaxExp();

  int getShift();

private:
  int r, c;
  /* matrix.size() is at least r. For all 0 <= i < matrix.size(),
     matrix[i] is a pointer to an array of size c */
  vector<Z_NR<ZT>*> matrix;
};


template <class FT>
class FP_mat
{
public:
  FP_mat() : r(0), c(0) {}
  FP_mat(int rows, int cols) : r(0), c(cols) {SetNumRows(rows);}
  ~FP_mat() {clear();}

  int GetNumCols() const {return c;}
  int GetNumRows() const {return r;}
  void SetNumCols(int cols);
  void SetNumRows(int rows);
  void clear();

  inline FP_NR<FT>& Get(int i,int j);
  inline FP_NR<FT>& operator()(int i, int j);
  inline const FP_NR<FT>& operator()(int i, int j) const;
  inline FP_NR<FT>*& GetVec(int i);
  inline void Set(int i,int j,FP_NR<FT>& s);
  void print();
  void print(int d,int n);

private:
  int r, c;
  vector<FP_NR<FT>*> matrix;
};

#include "matrix.cpp"

#endif
