/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.c.PAL;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

public class ColorEncoder {
    private static final int GRAY = -8355712;
    public static final String BYELEMENT_PREFIX = "byelement";
    public static final String BYRESIDUE_PREFIX = "byresidue";
    private static final String BYELEMENT_JMOL = "byelement_jmol";
    private static final String BYELEMENT_RASMOL = "byelement_rasmol";
    private static final String BYRESIDUE_SHAPELY = "byresidue_shapely";
    private static final String BYRESIDUE_AMINO = "byresidue_amino";
    public static final int CUSTOM = -1;
    public static final int ROYGB = 0;
    public static final int BGYOR = 1;
    public static final int JMOL = 2;
    public static final int RASMOL = 3;
    public static final int SHAPELY = 4;
    public static final int AMINO = 5;
    public static final int RWB = 6;
    public static final int BWR = 7;
    public static final int LOW = 8;
    public static final int HIGH = 9;
    public static final int BW = 10;
    public static final int WB = 11;
    public static final int FRIENDLY = 12;
    public static final int USER = -13;
    public static final int RESU = -14;
    public static final int INHERIT = 15;
    public static final int ALT = 16;
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "byelement_jmol", "byelement_rasmol", "byresidue_shapely", "byresidue_amino", "rwb", "bwr", "low", "high", "bw", "wb", "friendly", "user", "resu", "inherit", "rgb", "bgr", "jmol", "rasmol", "byresidue"};
    private int[] paletteBW;
    private int[] paletteWB;
    private int[] paletteFriendly;
    private int[] argbsCpk;
    private int[] argbsRoygb;
    private int[] argbsRwb;
    private int[] argbsShapely;
    private int[] argbsAmino;
    private int ihalf;
    private static int[] rasmolScale;
    public Map<String, int[]> schemes;
    public int currentPalette = 0;
    public int currentSegmentCount = 1;
    public boolean isTranslucent = false;
    public float lo;
    public float hi;
    public boolean isReversed;
    int[] userScale = new int[]{-8355712};
    int[] thisScale = new int[]{-8355712};
    String thisName = "scheme";
    boolean isColorIndex;
    ColorEncoder ce;

    public ColorEncoder(ColorEncoder colorEncoder) {
        if (colorEncoder == null) {
            this.schemes = new Hashtable<String, int[]>();
            this.argbsCpk = PAL.argbsCpk;
            this.argbsRoygb = JC.argbsRoygbScale;
            this.argbsRwb = JC.argbsRwbScale;
            this.argbsShapely = JC.argbsShapely;
            this.argbsAmino = JC.argbsAmino;
            this.ihalf = JC.argbsRoygbScale.length / 3;
            this.ce = this;
        } else {
            this.ce = colorEncoder;
            this.schemes = colorEncoder.schemes;
        }
    }

    private static final int getSchemeIndex(String string) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(string)) continue;
            return i >= 16 ? i - 16 : (i < 13 ? i : -i);
        }
        return -1;
    }

    private static final String fixName(String string) {
        if (string.equalsIgnoreCase(BYELEMENT_PREFIX)) {
            return BYELEMENT_JMOL;
        }
        int n = ColorEncoder.getSchemeIndex(string);
        return n >= 0 ? colorSchemes[n] : string.toLowerCase();
    }

    private synchronized int makeColorScheme(String string, int[] nArray, boolean bl) {
        string = ColorEncoder.fixName(string);
        if (nArray == null) {
            this.schemes.remove(string);
            int n = this.createColorScheme(string, false, bl);
            if (bl) {
                switch (n) {
                    case 0x7FFFFFFF: {
                        return 0;
                    }
                    case 12: {
                        this.paletteFriendly = this.getPaletteAC();
                        break;
                    }
                    case 10: {
                        this.paletteBW = this.getPaletteBW();
                        break;
                    }
                    case 11: {
                        this.paletteWB = this.getPaletteWB();
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.argbsRoygb = JC.argbsRoygbScale;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.argbsRwb = JC.argbsRwbScale;
                        break;
                    }
                    case 2: {
                        this.argbsCpk = PAL.argbsCpk;
                        break;
                    }
                    case 3: {
                        ColorEncoder.getRasmolScale();
                        break;
                    }
                    case 5: {
                        this.argbsAmino = JC.argbsAmino;
                        break;
                    }
                    case 4: {
                        this.argbsShapely = JC.argbsShapely;
                    }
                }
            }
            return n;
        }
        this.schemes.put(string, nArray);
        this.setThisScheme(string, nArray);
        int n = this.createColorScheme(string, false, bl);
        if (bl) {
            switch (n) {
                case 10: {
                    this.paletteBW = this.thisScale;
                    break;
                }
                case 11: {
                    this.paletteWB = this.thisScale;
                    break;
                }
                case 0: 
                case 1: {
                    this.argbsRoygb = this.thisScale;
                    this.ihalf = this.argbsRoygb.length / 3;
                    break;
                }
                case 6: 
                case 7: {
                    this.argbsRwb = this.thisScale;
                    break;
                }
                case 2: {
                    this.argbsCpk = this.thisScale;
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    this.argbsAmino = this.thisScale;
                    break;
                }
                case 4: {
                    this.argbsShapely = this.thisScale;
                }
            }
        }
        return -1;
    }

    public int createColorScheme(String string, boolean bl, boolean bl2) {
        if ((string = string.toLowerCase()).equals("inherit")) {
            return 15;
        }
        int n = Math.max(string.indexOf("="), string.indexOf("["));
        if (n >= 0) {
            String string2 = PT.replaceAllCharacters(string.substring(0, n), " =", "");
            if (string2.length() > 0) {
                bl2 = true;
            }
            int n2 = 0;
            if (string.length() > n + 1 && !string.contains("[")) {
                string = "[" + string.substring(n + 1).trim() + "]";
                string = PT.rep(string.replace('\n', ' '), "  ", " ");
                string = PT.rep(string, ", ", ",").replace(' ', ',');
                string = PT.rep(string, ",", "][");
            }
            n = -1;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                ++n2;
            }
            if (n2 == 0) {
                return this.makeColorScheme(string2, null, bl2);
            }
            int[] nArray = new int[n2];
            n2 = 0;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                int n3;
                int n4 = string.indexOf("]", n);
                if (n4 < 0) {
                    n4 = string.length() - 1;
                }
                if ((n3 = CU.getArgbFromString(string.substring(n, n4 + 1))) == 0) {
                    n3 = CU.getArgbFromString(string.substring(n + 1, n4).trim());
                }
                if (n3 == 0) {
                    Logger.error("error in color value: " + string.substring(n, n4 + 1));
                    return 0;
                }
                nArray[n2++] = n3;
            }
            if (string2.equals("user")) {
                this.setUserScale(nArray);
                return -13;
            }
            return this.makeColorScheme(string2, nArray, bl2);
        }
        string = ColorEncoder.fixName(string);
        int n5 = ColorEncoder.getSchemeIndex(string);
        if (this.schemes.containsKey(string)) {
            this.setThisScheme(string, this.schemes.get(string));
            return n5;
        }
        return n5 != -1 ? n5 : (bl ? 0 : Integer.MAX_VALUE);
    }

    public void setUserScale(int[] nArray) {
        this.ce.userScale = nArray;
        this.makeColorScheme("user", nArray, false);
    }

    public int[] getColorSchemeArray(int n) {
        switch (n) {
            case -1: {
                return this.thisScale;
            }
            case 0: {
                return this.ce.argbsRoygb;
            }
            case 1: {
                return AU.arrayCopyRangeRevI(this.ce.argbsRoygb, 0, -1);
            }
            case 8: {
                return AU.arrayCopyRangeI(this.ce.argbsRoygb, 0, this.ce.ihalf);
            }
            case 9: {
                int[] nArray = AU.arrayCopyRangeI(this.ce.argbsRoygb, this.ce.argbsRoygb.length - 2 * this.ce.ihalf, -1);
                int[] nArray2 = new int[this.ce.ihalf];
                int n2 = nArray2.length;
                int n3 = nArray.length;
                while (--n2 >= 0 && --n3 >= 0) {
                    nArray2[n2] = nArray[n3--];
                }
                return nArray2;
            }
            case 12: {
                return this.getPaletteAC();
            }
            case 10: {
                return this.getPaletteBW();
            }
            case 11: {
                return this.getPaletteWB();
            }
            case 6: {
                return this.ce.argbsRwb;
            }
            case 7: {
                return AU.arrayCopyRangeRevI(this.ce.argbsRwb, 0, -1);
            }
            case 2: {
                return this.ce.argbsCpk;
            }
            case 3: {
                return ColorEncoder.getRasmolScale();
            }
            case 4: {
                return this.ce.argbsShapely;
            }
            case 5: {
                return this.ce.argbsAmino;
            }
            case -13: {
                return this.ce.userScale;
            }
            case -14: {
                return AU.arrayCopyRangeRevI(this.ce.userScale, 0, -1);
            }
        }
        return null;
    }

    public short getColorIndexFromPalette(float f, float f2, float f3, int n, boolean bl) {
        short s = C.getColix(this.getArgbFromPalette(f, f2, f3, n));
        if (bl) {
            float f4 = (f3 - f) / (f3 - f2);
            if (f4 > 1.0f) {
                f4 = 1.0f;
            } else if (f4 < 0.125f) {
                f4 = 0.125f;
            }
            s = C.getColixTranslucent3(s, true, f4);
        }
        return s;
    }

    public int getPaletteColorCount(int n) {
        switch (n) {
            case -1: {
                return this.thisScale.length;
            }
            case 10: 
            case 11: {
                return this.getPaletteBW().length;
            }
            case 0: 
            case 1: {
                return this.ce.argbsRoygb.length;
            }
            case 8: 
            case 9: {
                return this.ce.ihalf;
            }
            case 6: 
            case 7: {
                return this.ce.argbsRwb.length;
            }
            case -14: 
            case -13: {
                return this.ce.userScale.length;
            }
            case 2: {
                return this.argbsCpk.length;
            }
            case 3: {
                return ColorEncoder.getRasmolScale().length;
            }
            case 4: {
                return this.ce.argbsShapely.length;
            }
            case 5: {
                return this.ce.argbsAmino.length;
            }
            case 12: {
                return this.getPaletteAC().length;
            }
        }
        return 0;
    }

    public int getArgbFromPalette(float f, float f2, float f3, int n) {
        if (Float.isNaN(f)) {
            return -8355712;
        }
        int n2 = this.getPaletteColorCount(n);
        switch (n) {
            case -1: {
                if (this.isColorIndex) {
                    f2 = 0.0f;
                    f3 = this.thisScale.length;
                }
                return this.thisScale[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 10: {
                return this.getPaletteBW()[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 11: {
                return this.getPaletteWB()[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 0: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 1: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(-f, -f3, -f2, n2)];
            }
            case 8: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 9: {
                return this.ce.argbsRoygb[this.ce.ihalf + ColorEncoder.quantize4(f, f2, f3, n2) * 2];
            }
            case 6: {
                return this.ce.argbsRwb[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case 7: {
                return this.ce.argbsRwb[ColorEncoder.quantize4(-f, -f3, -f2, n2)];
            }
            case -13: {
                return this.ce.userScale.length == 0 ? -8355712 : this.ce.userScale[ColorEncoder.quantize4(f, f2, f3, n2)];
            }
            case -14: {
                return this.ce.userScale.length == 0 ? -8355712 : this.ce.userScale[ColorEncoder.quantize4(-f, -f3, -f2, n2)];
            }
            case 2: {
                return this.ce.argbsCpk[ColorEncoder.colorIndex(f, n2)];
            }
            case 3: {
                return ColorEncoder.getRasmolScale()[ColorEncoder.colorIndex(f, n2)];
            }
            case 4: {
                return this.ce.argbsShapely[ColorEncoder.colorIndex(f, n2)];
            }
            case 5: {
                return this.ce.argbsAmino[ColorEncoder.colorIndex(f, n2)];
            }
            case 12: {
                return this.getPaletteAC()[ColorEncoder.colorIndexRepeat(f, n2)];
            }
        }
        return -8355712;
    }

    private void setThisScheme(String string, int[] nArray) {
        this.thisName = string;
        this.thisScale = nArray;
        if (string.equals("user")) {
            this.userScale = nArray;
        }
        this.isColorIndex = string.indexOf(BYELEMENT_PREFIX) == 0 || string.indexOf(BYRESIDUE_PREFIX) == 0;
    }

    public int getArgb(float f) {
        return this.isReversed ? this.getArgbFromPalette(-f, -this.hi, -this.lo, this.currentPalette) : this.getArgbFromPalette(f, this.lo, this.hi, this.currentPalette);
    }

    public int getArgbMinMax(float f, float f2, float f3) {
        return this.isReversed ? this.getArgbFromPalette(-f, -f3, -f2, this.currentPalette) : this.getArgbFromPalette(f, f2, f3, this.currentPalette);
    }

    public short getColorIndex(float f) {
        return this.isReversed ? this.getColorIndexFromPalette(-f, -this.hi, -this.lo, this.currentPalette, this.isTranslucent) : this.getColorIndexFromPalette(f, this.lo, this.hi, this.currentPalette, this.isTranslucent);
    }

    public Map<String, Object> getColorKey() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = this.getPaletteColorCount(this.currentPalette);
        Lst<P3> lst = new Lst<P3>();
        float[] fArray = new float[n + 1];
        float f = (this.hi - this.lo) / (float)n;
        float f2 = f * (this.isReversed ? -0.5f : 0.5f);
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.isReversed ? this.hi - (float)i * f : this.lo + (float)i * f;
            lst.addLast(CU.colorPtFromInt(this.getArgb(fArray[i] + f2), null));
        }
        fArray[n] = this.isReversed ? this.lo : this.hi;
        hashtable.put("values", fArray);
        hashtable.put("colors", lst);
        hashtable.put("min", Float.valueOf(this.lo));
        hashtable.put("max", Float.valueOf(this.hi));
        hashtable.put("reversed", this.isReversed);
        hashtable.put("name", this.getCurrentColorSchemeName());
        return hashtable;
    }

    public String getColorScheme() {
        return (this.isTranslucent ? "translucent " : "") + (this.currentPalette < 0 ? ColorEncoder.getColorSchemeList(this.getColorSchemeArray(this.currentPalette)) : this.getColorSchemeName(this.currentPalette));
    }

    public void setColorScheme(String string, boolean bl) {
        this.isTranslucent = bl;
        if (string != null) {
            this.currentPalette = this.createColorScheme(string, true, false);
        }
    }

    public void setRange(float f, float f2, boolean bl) {
        if (f2 == Float.MAX_VALUE) {
            f = 1.0f;
            f2 = this.getPaletteColorCount(this.currentPalette) + 1;
        }
        this.lo = Math.min(f, f2);
        this.hi = Math.max(f, f2);
        this.isReversed = bl;
    }

    public String getCurrentColorSchemeName() {
        return this.getColorSchemeName(this.currentPalette);
    }

    public String getColorSchemeName(int n) {
        int n2 = Math.abs(n);
        return n == -1 ? this.thisName : (n2 < colorSchemes.length && n2 >= 0 ? colorSchemes[n2] : null);
    }

    public static final String getColorSchemeList(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + Escape.escapeColor(nArray[i]);
        }
        return string;
    }

    public static final synchronized int[] getRasmolScale() {
        if (rasmolScale != null) {
            return rasmolScale;
        }
        rasmolScale = new int[PAL.argbsCpk.length];
        int n = PAL.argbsCpkRasmol[0] | 0xFF000000;
        int n2 = rasmolScale.length;
        while (--n2 >= 0) {
            ColorEncoder.rasmolScale[n2] = n;
        }
        n2 = PAL.argbsCpkRasmol.length;
        while (--n2 >= 0) {
            n = PAL.argbsCpkRasmol[n2];
            ColorEncoder.rasmolScale[n >> 24] = n | 0xFF000000;
        }
        return rasmolScale;
    }

    private int[] getPaletteAC() {
        return this.ce.paletteFriendly == null ? (this.ce.paletteFriendly = new int[]{0x808080, 1067945, 0xAA00A2, 13235712, 16753152, 2640510, 8331387, 10467374, 12553008, 339310, 7209065, 8626176, 0xA66A00, 4488148, 13907405, 14219839, 16759360, 6984660, 13918415, 14809713, 16764019}) : this.ce.paletteFriendly;
    }

    private int[] getPaletteWB() {
        if (this.ce.paletteWB != null) {
            return this.ce.paletteWB;
        }
        int[] nArray = new int[JC.argbsRoygbScale.length];
        for (int i = 0; i < nArray.length; ++i) {
            float f = 1.0f / (float)nArray.length * (float)(nArray.length - i);
            nArray[i] = CU.colorTriadToFFRGB(f, f, f);
        }
        this.ce.paletteWB = nArray;
        return nArray;
    }

    public static int[] getPaletteAtoB(int n, int n2, int n3) {
        if (n3 < 2) {
            n3 = JC.argbsRoygbScale.length;
        }
        int[] nArray = new int[n3];
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        CU.toRGB3f(n, fArray);
        CU.toRGB3f(n2, fArray2);
        float f = (fArray2[0] - fArray[0]) / (float)(n3 - 1);
        float f2 = (fArray2[1] - fArray[1]) / (float)(n3 - 1);
        float f3 = (fArray2[2] - fArray[2]) / (float)(n3 - 1);
        for (int i = 0; i < n3; ++i) {
            nArray[i] = CU.colorTriadToFFRGB(fArray[0] + f * (float)i, fArray[1] + f2 * (float)i, fArray[2] + f3 * (float)i);
        }
        return nArray;
    }

    private int[] getPaletteBW() {
        if (this.ce.paletteBW != null) {
            return this.ce.paletteBW;
        }
        int[] nArray = new int[JC.argbsRoygbScale.length];
        for (int i = 0; i < nArray.length; ++i) {
            float f = 1.0f / (float)nArray.length * (float)i;
            nArray[i] = CU.colorTriadToFFRGB(f, f, f);
        }
        this.ce.paletteBW = nArray;
        return nArray;
    }

    public float quantize(float f, boolean bl) {
        int n = this.getPaletteColorCount(this.currentPalette);
        return (f = ((float)((int)(f * (float)n)) + (bl ? 0.0f : 1.0f)) / (float)n) <= 0.0f ? this.lo : (f >= 1.0f ? this.hi : this.lo + (this.hi - this.lo) * f);
    }

    public static final int quantize4(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        if (f4 <= 0.0f || Float.isNaN(f)) {
            return n / 2;
        }
        float f5 = f - f2;
        if (f5 <= 0.0f) {
            return 0;
        }
        float f6 = f4 / (float)n;
        int n2 = (int)(f5 / f6 + 1.0E-4f);
        if (n2 >= n) {
            n2 = n - 1;
        }
        return n2;
    }

    private static final int colorIndex(float f, int n) {
        return (int)Math.floor(f <= 0.0f || f >= (float)n ? 0.0 : (double)f);
    }

    private static final int colorIndexRepeat(float f, int n) {
        int n2 = (int)Math.floor(f <= 0.0f ? 0.0 : (double)f);
        return n2 % n;
    }
}

