/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.GData;
import org.jmol.util.Shader;

public class SphereRenderer {
    private final Graphics3D g3d;
    private final Shader shader;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private int x;
    private int y;
    private int z;
    private int diameter;
    private boolean tScreened;
    private int[] shades;
    private static final int maxOddSizeSphere = 49;
    static final int maxSphereDiameter = 1000;
    static final int maxSphereDiameter2 = 2000;
    private double[] zroot = new double[2];
    private M3 mat;
    private double[] coef;
    private M4 mDeriv;
    private int selectedOctant;
    private P3i[] octantPoints;
    private int planeShade;
    private int[] zbuf;
    private int width;
    private int height;
    private int depth;
    private int slab;
    private int offsetPbufBeginLine;
    private boolean addAllPixels;
    private static final int SHADE_SLAB_CLIPPED = 47;
    private final P3 ptTemp = new P3();
    private final int[] planeShades = new int[3];
    private final float[][] dxyz = new float[3][3];
    private int z0;

    SphereRenderer(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.shader = graphics3D.shader;
    }

    void render(int[] nArray, boolean bl, int n, int n2, int n3, int n4, M3 m3, double[] dArray, M4 m4, int n5, P3i[] p3iArray, boolean bl2) {
        if (n4 == 1) {
            return;
        }
        this.width = this.g3d.width;
        this.height = this.g3d.height;
        if (n > 49) {
            n &= 0xFFFFFFFE;
        }
        if (this.g3d.isClippedXY(n, n2, n3)) {
            return;
        }
        int n6 = n + 1 >> 1;
        this.minX = n2 - n6;
        this.maxX = n2 + n6;
        this.minY = n3 - n6;
        this.maxY = n3 + n6;
        this.slab = this.g3d.slab;
        this.depth = this.g3d.depth;
        this.minZ = n4 - n6;
        this.maxZ = n4 + n6;
        if (this.maxZ < this.slab || this.minZ > this.depth) {
            return;
        }
        this.shader.nIn = 0;
        this.shader.nOut = 0;
        this.zbuf = this.g3d.zbuf;
        this.addAllPixels = bl2;
        this.offsetPbufBeginLine = this.width * n3 + n2;
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.diameter = n;
        this.tScreened = bl;
        this.shades = nArray;
        this.mat = m3;
        if (m3 != null) {
            this.coef = dArray;
            this.mDeriv = m4;
            this.selectedOctant = n5;
            this.octantPoints = p3iArray;
        }
        if (m3 != null || n > 128) {
            this.renderLarge();
            if (m3 != null) {
                this.mat = null;
                this.coef = null;
                this.mDeriv = null;
                this.octantPoints = null;
            }
        } else {
            int[] nArray2 = this.shader.sphereShapeCache[n - 1];
            if (nArray2 == null) {
                nArray2 = this.createSphereShape(n);
            }
            if (this.minX < 0 || this.maxX >= this.width || this.minY < 0 || this.maxY >= this.height || this.minZ < this.slab || n4 > this.depth) {
                this.renderShapeClipped(nArray2, n2, n3, n4, n);
            } else {
                this.renderShapeUnclipped(nArray2, n2, n3, n4, n);
            }
        }
        this.shades = null;
        this.zbuf = null;
    }

    private int[] createSphereShape(int n) {
        float f;
        Shader shader = this.shader;
        int n2 = 0;
        boolean bl = (n & 1) != 0;
        float f2 = (float)n / 2.0f;
        float f3 = f2 * f2;
        int n3 = (n + 1) / 2;
        float f4 = bl ? 0.0f : 0.5f;
        int n4 = 0;
        while (n4 < n3) {
            float f5 = f4 * f4;
            float f6 = bl ? 0.0f : 0.5f;
            int n5 = 0;
            while (n5 < n3) {
                f = f6 * f6;
                float f7 = f3 - f5 - f;
                if (f7 >= 0.0f) {
                    ++n2;
                }
                ++n5;
                f6 += 1.0f;
            }
            ++n4;
            f4 += 1.0f;
        }
        int[] nArray = new int[n2];
        int n6 = 0;
        f4 = bl ? 0.0f : 0.5f;
        int n7 = 0;
        while (n7 < n3) {
            float f8 = f4 * f4;
            f = bl ? 0.0f : 0.5f;
            int n8 = 0;
            while (n8 < n3) {
                float f9 = f * f;
                float f10 = f3 - f8 - f9;
                if (f10 >= 0.0f) {
                    float f11 = (float)Math.sqrt(f10);
                    int n9 = (int)f11;
                    byte by = shader.getShadeN(f, f4, f11, f2);
                    byte by2 = shader.getShadeN(-f, f4, f11, f2);
                    byte by3 = shader.getShadeN(f, -f4, f11, f2);
                    byte by4 = shader.getShadeN(-f, -f4, f11, f2);
                    int n10 = n9 | by << 7 | by2 << 13 | by3 << 19 | by4 << 25;
                    nArray[n6++] = n10;
                }
                ++n8;
                f += 1.0f;
            }
            int n11 = n6 - 1;
            nArray[n11] = nArray[n11] | Integer.MIN_VALUE;
            ++n7;
            f4 += 1.0f;
        }
        shader.sphereShapeCache[n - 1] = nArray;
        return nArray;
    }

    private void renderShapeUnclipped(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 1 - (n4 & 1);
        int n7 = this.offsetPbufBeginLine;
        int n8 = n7 - n6 * this.width;
        int n9 = (n4 + 1) / 2;
        int[] nArray2 = this.shades;
        Graphics3D graphics3D = this.g3d;
        int[] nArray3 = this.zbuf;
        int n10 = this.width;
        if (!this.tScreened) {
            do {
                int n11;
                int n12 = n7;
                int n13 = n7 - n6;
                int n14 = n8;
                int n15 = n8 - n6;
                do {
                    int n16;
                    if ((n16 = n3 - ((n11 = nArray[n5++]) & 0x7F)) < nArray3[n12]) {
                        graphics3D.addPixel(n12, n16, nArray2[n11 >> 7 & 0x3F]);
                    }
                    if (n16 < nArray3[n13]) {
                        graphics3D.addPixel(n13, n16, nArray2[n11 >> 13 & 0x3F]);
                    }
                    if (n16 < nArray3[n14]) {
                        graphics3D.addPixel(n14, n16, nArray2[n11 >> 19 & 0x3F]);
                    }
                    if (n16 < nArray3[n15]) {
                        graphics3D.addPixel(n15, n16, nArray2[n11 >> 25 & 0x3F]);
                    }
                    ++n12;
                    --n13;
                    ++n14;
                    --n15;
                } while (n11 >= 0);
                n7 += n10;
                n8 -= n10;
            } while (--n9 > 0);
            return;
        }
        int n17 = (n ^ n2) & 1;
        int n18 = n17 ^ n6;
        int n19 = n17;
        int n20 = n17 ^ n6;
        int n21 = n18;
        int n22 = n18 ^ n6;
        int n23 = n19 | n20 << 1 | n21 << 2 | n22 << 3;
        do {
            int n24;
            int n25 = n7;
            int n26 = n7 - n6;
            int n27 = n8;
            int n28 = n8 - n6;
            int n29 = n23 ^= 0xFFFFFFFF;
            do {
                n24 = nArray[n5++];
                int n30 = n3 - (n24 & 0x7F);
                if ((n29 & 1) != 0 && n30 < nArray3[n25]) {
                    graphics3D.addPixel(n25, n30, nArray2[n24 >> 7 & 0x3F]);
                }
                if ((n29 & 2) != 0 && n30 < nArray3[n26]) {
                    graphics3D.addPixel(n26, n30, nArray2[n24 >> 13 & 0x3F]);
                }
                if ((n29 & 4) != 0 && n30 < nArray3[n27]) {
                    graphics3D.addPixel(n27, n30, nArray2[n24 >> 19 & 0x3F]);
                }
                if ((n29 & 8) != 0 && n30 < nArray3[n28]) {
                    graphics3D.addPixel(n28, n30, nArray2[n24 >> 25 & 0x3F]);
                }
                ++n25;
                --n26;
                ++n27;
                --n28;
                n29 ^= 0xFFFFFFFF;
            } while (n24 >= 0);
            n7 += n10;
            n8 -= n10;
        } while (--n9 > 0);
    }

    private void renderShapeClipped(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 1 - (n4 & 1);
        int n7 = this.offsetPbufBeginLine;
        int n8 = n7 - n6 * this.width;
        int n9 = (n4 + 1) / 2;
        int n10 = n2;
        int n11 = n2 - n6;
        int n12 = (n << 16) + (n2 << 1) ^ 0x33333333;
        int n13 = (n ^ n2) & 1;
        int n14 = n13 ^ n6;
        int n15 = n13;
        int n16 = n13 ^ n6;
        int n17 = n14;
        int n18 = n14 ^ n6;
        int n19 = n15 | n16 << 1 | n17 << 2 | n18 << 3;
        int[] nArray2 = this.shades;
        Graphics3D graphics3D = this.g3d;
        int[] nArray3 = this.zbuf;
        do {
            int n20;
            boolean bl = n10 >= 0 && n10 < this.height;
            boolean bl2 = n11 >= 0 && n11 < this.height;
            int n21 = n7;
            int n22 = n7 - n6;
            int n23 = n8;
            int n24 = n8 - n6;
            int n25 = n19 ^= 0xFFFFFFFF;
            int n26 = n;
            int n27 = n - n6;
            do {
                boolean bl3;
                int n28;
                boolean bl4 = n27 >= 0 && n27 < this.width;
                boolean bl5 = n26 >= 0 && n26 < this.width;
                n20 = nArray[n5++];
                int n29 = n20 & 0x7F;
                if (n3 < this.slab) {
                    n28 = n3 + n29;
                    bl3 = n28 >= this.slab;
                } else {
                    n28 = n3 - n29;
                    boolean bl6 = bl3 = n28 < this.slab;
                }
                if (bl3) {
                    n28 = this.slab;
                }
                if (n28 >= this.slab && n28 <= this.depth) {
                    int n30;
                    if (bl) {
                        if (bl5 && (this.addAllPixels || (n25 & 1) != 0) && n28 < nArray3[n21]) {
                            n30 = bl3 ? 44 + (n12 >> 7 & 7) : n20 >> 7 & 0x3F;
                            graphics3D.addPixel(n21, n28, nArray2[n30]);
                        }
                        if (bl4 && (this.addAllPixels || (n25 & 2) != 0) && n28 < nArray3[n22]) {
                            n30 = bl3 ? 44 + (n12 >> 13 & 7) : n20 >> 13 & 0x3F;
                            graphics3D.addPixel(n22, n28, nArray2[n30]);
                        }
                    }
                    if (bl2) {
                        if (bl5 && (!this.tScreened || (n25 & 4) != 0) && n28 < nArray3[n23]) {
                            n30 = bl3 ? 44 + (n12 >> 19 & 7) : n20 >> 19 & 0x3F;
                            graphics3D.addPixel(n23, n28, nArray2[n30]);
                        }
                        if (bl4 && (!this.tScreened || (n25 & 8) != 0) && n28 < nArray3[n24]) {
                            n30 = bl3 ? 44 + (n12 >> 25 & 7) : n20 >> 25 & 0x3F;
                            graphics3D.addPixel(n24, n28, nArray2[n30]);
                        }
                    }
                }
                ++n21;
                --n22;
                ++n23;
                --n24;
                ++n26;
                --n27;
                n25 ^= 0xFFFFFFFF;
                if (!bl3) continue;
                n12 = (n12 << 16) + (n12 << 1) + n12 & Integer.MAX_VALUE;
            } while (n20 >= 0);
            n7 += this.width;
            n8 -= this.width;
            ++n10;
            --n11;
        } while (--n9 > 0);
    }

    private void renderLarge() {
        if (this.mat != null) {
            if (this.shader.ellipsoidShades == null) {
                this.shader.createEllipsoidShades();
            }
            if (this.octantPoints != null) {
                this.setPlaneDerivatives();
            }
        }
        this.renderQuadrant(-1, -1);
        this.renderQuadrant(-1, 1);
        this.renderQuadrant(1, -1);
        this.renderQuadrant(1, 1);
    }

    private void renderQuadrant(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5 = (this.x < 0 ? -1 : (this.x < this.width ? 0 : 1)) + ((n4 = this.x + (n3 = this.diameter / 2) * n) < 0 ? -2 : (n4 < this.width ? 0 : 2));
        if (n5 == -3 || n5 == 3) {
            return;
        }
        int n6 = (this.y < 0 ? -1 : (this.y < this.height ? 0 : 1)) + ((n4 = this.y + n3 * n2) < 0 ? -2 : (n4 < this.height ? 0 : 2));
        if (n6 == -3 || n6 == 3) {
            return;
        }
        boolean bl2 = bl = this.mat == null && n5 == 0 && n6 == 0 && this.z - n3 >= this.slab && this.z <= this.depth;
        if (bl) {
            this.renderQuadrantUnclipped(n3, n, n2);
        } else {
            this.renderQuadrantClipped(n3, n, n2);
        }
    }

    private void renderQuadrantUnclipped(int n, int n2, int n3) {
        int n4 = n * n;
        int n5 = n * 2 + 1;
        boolean bl = ((this.x ^ this.y) & 1) == 0;
        int n6 = n3 < 0 ? -this.width : this.width;
        int n7 = this.offsetPbufBeginLine;
        int n8 = 0;
        int n9 = 0;
        while (n9 <= n4) {
            int n10 = n7;
            bl = !bl;
            boolean bl2 = bl;
            int n11 = n4 - n9;
            int n12 = this.z - n;
            int n13 = (n8 * n3 + n << 8) / n5;
            int n14 = 0;
            int n15 = 0;
            while (n15 <= n11) {
                int n16;
                if ((this.addAllPixels || (bl2 = !bl2)) && this.zbuf[n10] > n12 && this.zbuf[n10] > (n12 = this.z - (n16 = (int)Math.sqrt(n11 - n15)))) {
                    int n17 = (n14 * n2 + n << 8) / n5;
                    this.g3d.addPixel(n10, n12, this.shades[this.shader.sphereShadeIndexes[(n13 << 8) + n17]]);
                }
                n15 += n14++ + n14;
                n10 += n2;
            }
            n9 += n8++ + n8;
            n7 += n6;
        }
    }

    private void renderQuadrantClipped(int n, int n2, int n3) {
        boolean bl = this.mat != null;
        boolean bl2 = this.selectedOctant >= 0;
        int n4 = n * n;
        int n5 = n * 2 + 1;
        int n6 = n3 < 0 ? -this.width : this.width;
        int n7 = this.offsetPbufBeginLine;
        int n8 = (this.x << 16) + (this.y << 1) ^ 0x33333333;
        int n9 = this.y;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 <= n4) {
            block23: {
                block24: {
                    block22: {
                        if (n9 >= 0) break block22;
                        if (n3 < 0) {
                            return;
                        }
                        break block23;
                    }
                    if (n9 < this.height) break block24;
                    if (n3 > 0) {
                        return;
                    }
                    break block23;
                }
                int n14 = n4 - (bl ? 0 : n13);
                int n15 = this.x;
                if (!bl) {
                    n10 = (n12 * n3 + n << 8) / n5;
                }
                n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE;
                int n16 = -1;
                int n17 = 1;
                int n18 = n7;
                int n19 = 0;
                int n20 = 0;
                while (n20 <= n14) {
                    block26: {
                        int n21;
                        int n22;
                        block30: {
                            boolean bl3;
                            block28: {
                                block29: {
                                    block27: {
                                        block25: {
                                            if (n15 >= 0) break block25;
                                            if (n2 < 0) {
                                                break;
                                            }
                                            break block26;
                                        }
                                        if (n15 < this.width) break block27;
                                        if (n2 > 0) {
                                            break;
                                        }
                                        break block26;
                                    }
                                    if (this.tScreened && ((n15 ^ n9) & 1) != 0) break block26;
                                    if (!bl) break block28;
                                    if (SphereRenderer.getQuardricZ(n15, n9, this.coef, this.zroot)) break block29;
                                    if (n16 >= 0) {
                                        break;
                                    }
                                    break block26;
                                }
                                n16 = this.z < this.slab ? 1 : 0;
                                n22 = (int)this.zroot[n16];
                                if (n22 == 0) {
                                    n22 = this.z;
                                }
                                n17 = 2;
                                this.z0 = n22;
                                if (bl2) {
                                    this.ptTemp.set(n15 - this.x, n9 - this.y, n22 - this.z);
                                    this.mat.rotate(this.ptTemp);
                                    n21 = GData.getScreenOctant(this.ptTemp);
                                    if (n21 == this.selectedOctant) {
                                        n11 = this.getPlaneShade(n15, n9, this.zroot);
                                        n22 = (int)this.zroot[0];
                                        n17 = 3;
                                    }
                                    boolean bl4 = this.z < this.slab ? n22 >= this.slab : (bl3 = n22 < this.slab);
                                    if (bl3) {
                                        this.z0 = n22 = this.slab;
                                        n17 = 0;
                                    }
                                }
                                if (n22 >= this.slab && n22 <= this.depth && this.zbuf[n18] > this.z0) break block30;
                                break block26;
                            }
                            n21 = (int)Math.sqrt(n14 - n20);
                            n22 = this.z + (this.z < this.slab ? n21 : -n21);
                            boolean bl5 = this.z < this.slab ? n22 >= this.slab : (bl3 = n22 < this.slab);
                            if (bl3) {
                                n22 = this.slab;
                                n17 = 0;
                            }
                            if (n22 < this.slab || n22 > this.depth || this.zbuf[n18] <= n22) break block26;
                        }
                        switch (n17) {
                            case 0: {
                                n11 = 44 + (n8 >> 8 & 7);
                                n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE;
                                n17 = 1;
                                break;
                            }
                            case 2: {
                                n11 = this.shader.getEllipsoidShade(n15, n9, (float)this.zroot[n16], n, this.mDeriv);
                                break;
                            }
                            case 3: {
                                this.g3d.clearPixel(n18, this.z0);
                                break;
                            }
                            default: {
                                n21 = (n19 * n2 + n << 8) / n5;
                                n11 = this.shader.sphereShadeIndexes[(n10 << 8) + n21];
                            }
                        }
                        this.g3d.addPixel(n18, n22, this.shades[n11]);
                    }
                    n20 += n19++ + n19;
                    n18 += n2;
                    n15 += n2;
                }
                n8 = (n8 + n15 + n9 | 1) & Integer.MAX_VALUE;
            }
            n13 += n12++ + n12;
            n7 += n6;
            n9 += n3;
        }
    }

    private static boolean getQuardricZ(double d, double d2, double[] dArray, double[] dArray2) {
        double d3 = (dArray[4] * d + dArray[5] * d2 + dArray[8]) / dArray[2] / 2.0;
        double d4 = (dArray[0] * d * d + dArray[1] * d2 * d2 + dArray[3] * d * d2 + dArray[6] * d + dArray[7] * d2 - 1.0) / dArray[2];
        double d5 = d3 * d3 - d4;
        if (d5 < 0.0) {
            return false;
        }
        d5 = Math.sqrt(d5);
        dArray2[0] = -d3 - d5;
        dArray2[1] = -d3 + d5;
        return true;
    }

    private void setPlaneDerivatives() {
        this.planeShade = -1;
        for (int i = 0; i < 3; ++i) {
            float f = this.octantPoints[i].x - this.x;
            this.dxyz[i][0] = f;
            float f2 = f;
            float f3 = this.octantPoints[i].y - this.y;
            this.dxyz[i][1] = f3;
            float f4 = f3;
            float f5 = this.octantPoints[i].z - this.z;
            this.dxyz[i][2] = f5;
            float f6 = f5;
            this.planeShades[i] = this.shader.getShadeIndex(f2, f4, -f6);
            if (f2 != 0.0f || f4 != 0.0f) continue;
            this.planeShade = this.planeShades[i];
            return;
        }
    }

    private int getPlaneShade(int n, int n2, double[] dArray) {
        if (this.planeShade >= 0) {
            return this.planeShade;
        }
        int n3 = 3;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            float f2;
            float f3 = this.dxyz[i][2];
            if (f3 == 0.0f || !((f2 = (float)this.z + (-this.dxyz[i][0] * (float)(n - this.x) - this.dxyz[i][1] * (float)(n2 - this.y)) / f3) < f)) continue;
            f = f2;
            n3 = i;
        }
        if (n3 == 3) {
            n3 = 0;
            f = this.z;
        }
        dArray[0] = f;
        return this.planeShades[n3];
    }
}

