/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.Viewer;

public class AnimationThread
extends JmolThread {
    private AnimationManager am;
    private int framePointer1;
    private int framePointer2;
    private int intThread;
    private boolean isFirst;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        int[] nArray = (int[])object2;
        this.framePointer1 = nArray[0];
        this.framePointer2 = nArray[1];
        this.intThread = nArray[2];
        this.am = (AnimationManager)object;
        this.setViewer(viewer, "AnimationThread");
        viewer.startHoverWatcher(false);
        return 0;
    }

    @Override
    public void interrupt() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (Logger.debugging) {
            Logger.debug("animation thread interrupted!");
        }
        try {
            this.am.setAnimationOn(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interrupt();
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " running");
                    }
                    this.vwr.requestRepaintAndWait("animationThread");
                    this.vwr.startHoverWatcher(false);
                    this.haveReference = true;
                    this.isFirst = true;
                    n = 0;
                    break;
                }
                case 0: {
                    if (!this.am.animationOn || this.checkInterrupted(this.am.animationThread)) {
                        n = -2;
                        break;
                    }
                    if (this.am.currentFrameIs(this.framePointer1)) {
                        this.targetTime += (long)this.am.firstFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 1)) {
                            return;
                        }
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (this.am.currentFrameIs(this.framePointer2)) {
                        this.targetTime += (long)this.am.lastFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 2)) {
                            return;
                        }
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    if (!this.isFirst && this.am.currentIsLast() && !this.am.setAnimationNext()) {
                        n = -2;
                        break;
                    }
                    this.isFirst = false;
                    this.targetTime += (long)((int)(1000.0f / (float)this.am.animationFps + (float)this.vwr.getFrameDelayMs(this.am.cmi)));
                    n = 3;
                    break;
                }
                case 3: {
                    while (this.am.animationOn && !this.checkInterrupted(this.am.animationThread) && !this.vwr.getRefreshing()) {
                        if (this.runSleep(10, 3)) continue;
                        return;
                    }
                    if (!this.vwr.tm.spinOn) {
                        this.vwr.refresh(1, "animationThread");
                    }
                    this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                    }
                    this.am.stopThread(false);
                    return;
                }
            }
        }
    }
}

