/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dots;
import org.jmol.util.C;
import org.jmol.util.Geodesic;

public class DotsRenderer
extends ShapeRenderer {
    public boolean iShowSolid;
    V3[] verticesTransformed;
    public int screenLevel;
    public int screenDotCount;
    public int[] screenCoordinates;
    public int[] faceMap = null;
    private int dotScale;
    protected float testRadiusAdjust;

    @Override
    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount(Dots.MAX_LEVEL);
        this.verticesTransformed = new V3[this.screenDotCount];
        int n = this.screenDotCount;
        while (--n >= 0) {
            this.verticesTransformed[n] = new V3();
        }
        this.screenCoordinates = new int[3 * this.screenDotCount];
    }

    @Override
    protected boolean render() {
        this.render1((Dots)this.shape);
        return false;
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setC((short)4)) {
            return;
        }
        int n = (int)this.vwr.getScalePixelsPerAngstrom(true);
        int n2 = this.iShowSolid || n > 20 ? 3 : (n > 10 ? 2 : (this.screenLevel = n > 5 ? 1 : 0));
        if (!this.iShowSolid) {
            this.screenLevel += this.vwr.getInt(553648143) - 3;
        }
        this.screenLevel = Math.max(Math.min(this.screenLevel, Dots.MAX_LEVEL), 0);
        this.screenDotCount = Geodesic.getVertexCount(this.screenLevel);
        this.dotScale = this.vwr.getInt(0x21000010);
        int n3 = this.screenDotCount;
        while (--n3 >= 0) {
            this.tm.transformVector(Geodesic.getVertexVector(n3), this.verticesTransformed[n3]);
        }
        BS[] bSArray = dots.ec.getDotsConvexMaps();
        int n4 = dots.ec.getDotsConvexMax();
        while (--n4 >= 0) {
            Atom atom = this.ms.at[n4];
            BS bS = bSArray[n4];
            if (bS == null || !this.isVisibleForMe(atom) || !this.g3d.isInDisplayRange(atom.sX, atom.sY)) continue;
            try {
                int n5 = this.calcScreenPoints(bS, dots.ec.getAppropriateRadius(n4) + this.testRadiusAdjust, atom.sX, atom.sY, atom.sZ);
                if (n5 == 0) continue;
                this.renderConvex(C.getColixInherited(dots.colixes[n4], atom.getColix()), bS, n5);
            }
            catch (Exception exception) {
                System.out.println("Dots rendering error");
                System.out.println(exception.toString());
            }
        }
    }

    private int calcScreenPoints(BS bS, float f, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        float f2 = this.vwr.tm.scaleToPerspective(n3, f);
        int n6 = Math.min(bS.size(), this.screenDotCount);
        while (--n6 >= 0) {
            if (!bS.get(n6)) continue;
            V3 v3 = this.verticesTransformed[n6];
            if (this.faceMap != null) {
                this.faceMap[n6] = n5;
            }
            this.screenCoordinates[n5++] = n + Math.round(f2 * v3.x);
            this.screenCoordinates[n5++] = n2 + Math.round(f2 * v3.y);
            this.screenCoordinates[n5++] = n3 + Math.round(f2 * v3.z);
            ++n4;
        }
        return n4;
    }

    protected void renderConvex(short s, BS bS, int n) {
        this.colix = C.getColixTranslucent3(s, false, 0.0f);
        this.renderDots(n);
    }

    protected void renderDots(int n) {
        this.g3d.setC(this.colix);
        this.g3d.drawPoints(n, this.screenCoordinates, this.dotScale);
    }
}

