/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Text;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Labels;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JC;

public class LabelsRenderer
extends FontLineShapeRenderer {
    final int[] minZ = new int[1];
    protected int ascent;
    protected int descent;
    protected float sppm;
    protected float[] xy = new float[3];
    private P3i screen = new P3i();
    byte fidPrevious;
    private int zCutoff;
    private P3 pTemp = new P3();
    protected short bgcolix;
    protected short labelColix;
    private byte fid;
    private Atom atom;
    protected Point3fi atomPt;
    private boolean isExact;
    private int offset;
    protected int textAlign;
    private int pointer;
    protected int zSlab = Integer.MIN_VALUE;
    private int zBox;
    private float[] boxXY;
    private float scalePixelsPerMicron;

    @Override
    protected boolean render() {
        this.fidPrevious = 0;
        this.zCutoff = this.tm.getZShadeStart();
        Labels labels = (Labels)this.shape;
        String[] stringArray = labels.strings;
        short[] sArray = labels.bgcolixes;
        if (this.isExport) {
            sArray = this.g3d.getBgColixes(sArray);
        }
        byte[] byArray = labels.fids;
        int[] nArray = labels.offsets;
        if (stringArray == null) {
            return false;
        }
        Atom[] atomArray = this.ms.at;
        short s = this.vwr.getColixBackgroundContrast();
        int n = this.vwr.getBackgroundArgb();
        this.sppm = this.vwr.getScalePixelsPerAngstrom(true);
        this.scalePixelsPerMicron = this.vwr.getBoolean(603979845) ? this.sppm * 10000.0f : 0.0f;
        this.imageFontScaling = this.vwr.getImageFontScaling();
        int n2 = -1;
        this.minZ[0] = Integer.MAX_VALUE;
        boolean bl = this.g3d.isAntialiased();
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            Object object;
            String string;
            this.atom = atomArray[n3];
            this.atomPt = this.atom;
            if (!this.isVisibleForMe(this.atom) || (string = stringArray[n3]) == null || string.length() == 0 || labels.mads != null && labels.mads[n3] < 0) continue;
            this.labelColix = labels.getColix2(n3, this.atom, false);
            this.bgcolix = labels.getColix2(n3, this.atom, true);
            if (this.bgcolix == 0 && this.g3d.getColorArgbOrGray(this.labelColix) == n) {
                this.labelColix = s;
            }
            this.fid = byArray == null || n3 >= byArray.length || byArray[n3] == 0 ? labels.zeroFontId : byArray[n3];
            int n4 = nArray == null || n3 >= nArray.length ? 0 : nArray[n3];
            boolean bl2 = (n4 & 0x20) != 0;
            boolean bl3 = (n4 & 0x10) != 0;
            this.isExact = (n4 & 0x80) != 0;
            this.offset = n4 >> 8;
            this.textAlign = Labels.getAlignment(n4);
            this.pointer = n4 & 3;
            this.zSlab = this.atom.sZ - this.atom.sD / 2 - 3;
            if (this.zCutoff > 0 && this.zSlab > this.zCutoff) continue;
            if (this.zSlab < 1) {
                this.zSlab = 1;
            }
            this.zBox = this.zSlab;
            if (bl3) {
                object = this.atom.getGroup();
                int n5 = ((Group)object).getGroupIndex();
                if (n5 != n2) {
                    ((Group)object).getMinZ(atomArray, this.minZ);
                    n2 = n5;
                }
                this.zBox = this.minZ[0];
            } else if (bl2) {
                this.zBox = 1;
            }
            if (this.zBox < 1) {
                this.zBox = 1;
            }
            object = labels.getLabel(n3);
            float[] fArray = this.boxXY = !this.isExport || this.vwr.creatingImage ? labels.getBox(n3) : new float[5];
            if (this.boxXY == null) {
                this.boxXY = new float[5];
                labels.putBox(n3, this.boxXY);
            }
            if ((object = this.renderLabelOrMeasure((Text)object, string)) != null) {
                labels.putLabel(n3, (Text)object);
            }
            if (bl) {
                this.boxXY[0] = this.boxXY[0] / 2.0f;
                this.boxXY[1] = this.boxXY[1] / 2.0f;
            }
            this.boxXY[4] = this.zBox;
        }
        return false;
    }

    protected Text renderLabelOrMeasure(Text text, String string) {
        boolean bl = false;
        if (text != null) {
            if (text.font == null) {
                text.setFontFromFid(this.fid);
            }
            text.atomX = this.atomPt.sX;
            text.atomY = this.atomPt.sY;
            text.atomZ = this.zSlab;
            if (text.pymolOffset == null) {
                text.setXYZs(this.atomPt.sX, this.atomPt.sY, this.zBox, this.zSlab);
                text.setColix(this.labelColix);
                text.setBgColix(this.bgcolix);
            } else {
                if (text.pymolOffset[0] == 1.0f) {
                    this.pTemp.setT(this.atomPt);
                } else {
                    this.pTemp.set(0.0f, 0.0f, 0.0f);
                }
                this.pTemp.add3(text.pymolOffset[4], text.pymolOffset[5], text.pymolOffset[6]);
                this.tm.transformPtScr(this.pTemp, this.screen);
                text.setXYZs(this.screen.x, this.screen.y, this.screen.z, this.zSlab);
                text.setScalePixelsPerMicron(this.sppm);
            }
        } else {
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = this.textAlign == 1 || this.textAlign == 0;
            if (this.fid != this.fidPrevious || this.ascent == 0) {
                this.g3d.setFontFid(this.fid);
                this.fidPrevious = this.fid;
                this.font3d = this.g3d.getFont3DCurrent();
                if (bl3) {
                    this.ascent = this.font3d.getAscent();
                    this.descent = this.font3d.getDescent();
                }
            }
            boolean bl5 = bl2 = bl3 && this.imageFontScaling == 1.0f && this.scalePixelsPerMicron == 0.0f && string.indexOf("|") < 0 && string.indexOf("<su") < 0;
            if (bl2) {
                boolean bl6 = (this.pointer & 1) != 0;
                short s = (this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.labelColix;
                this.boxXY[0] = this.atomPt.sX;
                this.boxXY[1] = this.atomPt.sY;
                TextRenderer.renderSimpleLabel(this.g3d, this.font3d, string, this.labelColix, this.bgcolix, this.boxXY, this.zBox, this.zSlab, JC.getXOffset(this.offset), JC.getYOffset(this.offset), this.ascent, this.descent, bl6, s, this.isExact);
                this.atomPt = null;
            } else {
                text = Text.newLabel(this.g3d.getGData(), this.font3d, string, this.labelColix, this.bgcolix, this.textAlign, 0.0f, null);
                text.atomX = this.atomPt.sX;
                text.atomY = this.atomPt.sY;
                text.atomZ = this.zSlab;
                text.setXYZs(this.atomPt.sX, this.atomPt.sY, this.zBox, this.zSlab);
                bl = true;
            }
        }
        if (this.atomPt != null) {
            if (text.pymolOffset == null) {
                text.setOffset(this.offset);
                if (this.textAlign != 0) {
                    text.setAlignment(this.textAlign);
                }
            }
            text.setPointer(this.pointer);
            TextRenderer.render(text, this.vwr, this.g3d, this.scalePixelsPerMicron, this.imageFontScaling, this.isExact, this.boxXY, this.xy);
        }
        return bl ? text : null;
    }
}

