/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class PmeshReader
extends PolygonFileReader {
    private boolean isBinary;
    protected int nPolygons;
    protected String pmeshError;
    protected String type;
    protected boolean isClosedFace;
    protected int fixedCount;
    protected boolean onePerLine;
    protected int vertexBase;
    protected int[] vertexMap;
    protected String[] tokens = new String[0];
    protected int iToken = 0;

    PmeshReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PR(surfaceGenerator, bufferedReader);
    }

    protected void init2PR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (string == null) {
            return;
        }
        this.type = "pmesh";
        this.setHeader();
        this.isBinary = this.checkBinary(string);
        this.isClosedFace = !this.isBinary;
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(this.type + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected boolean checkBinary(String string) {
        try {
            this.br.mark(4);
            char[] cArray = new char[5];
            this.br.read(cArray, 0, 5);
            if (new String(cArray).startsWith("PM\u0001\u0000")) {
                this.br.close();
                this.binarydoc = this.newBinaryDocument();
                this.binarydoc.setStream(this.sg.getAtomDataServer().getBufferedInputStream(string), cArray[4] == '\u0000');
                return true;
            }
            this.br.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info((this.isBinary ? "binary " : "") + this.type + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block4: {
            try {
                if (this.isBinary && !this.readBinaryHeader()) {
                    return false;
                }
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block4;
                this.pmeshError = this.type + " ERROR: " + exception;
            }
        }
        return false;
    }

    boolean readBinaryHeader() {
        this.pmeshError = "could not read binary Pmesh file header";
        try {
            byte[] byArray = new byte[64];
            this.binarydoc.readByteArray(byArray, 0, 8);
            this.nVertices = this.binarydoc.readInt();
            this.nPolygons = this.binarydoc.readInt();
            this.binarydoc.readByteArray(byArray, 0, 64);
        }
        catch (Exception exception) {
            this.pmeshError = this.pmeshError + " " + exception.toString();
            this.binarydoc.close();
            return false;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readVertices() throws Exception {
        return this.readVerticesPM();
    }

    protected boolean readVerticesPM() throws Exception {
        this.pmeshError = this.type + " ERROR: vertex count must be positive";
        if (!this.isBinary) {
            this.nVertices = this.getInt();
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        if (this.nVertices <= 0) {
            this.pmeshError = this.pmeshError + " (" + this.nVertices + ")";
            return false;
        }
        this.pmeshError = this.type + " ERROR: invalid vertex list";
        this.vertexMap = new int[this.nVertices];
        for (int i = 0; i < this.nVertices; ++i) {
            P3 p3 = P3.new3(this.getFloat(), this.getFloat(), this.getFloat());
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(p3);
            }
            if (Logger.debugging) {
                Logger.debug(i + ": " + p3);
            }
            this.vertexMap[i] = this.addVertexCopy(p3, 0.0f, i, false);
            if (!this.onePerLine) continue;
            this.iToken = Integer.MAX_VALUE;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readPolygons() throws Exception {
        return this.readPolygonsPM();
    }

    protected boolean readPolygonsPM() throws Exception {
        this.pmeshError = this.type + " ERROR: polygon count must be zero or positive";
        if (!this.isBinary) {
            this.nPolygons = this.getInt();
        }
        if (this.nPolygons < 0) {
            this.pmeshError = this.pmeshError + " (" + this.nPolygons + ")";
            return false;
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        int[] nArray = new int[5];
        for (int i = 0; i < this.nPolygons; ++i) {
            int n;
            int n2 = this.fixedCount == 0 ? this.getInt() : this.fixedCount;
            int n3 = n2 - (this.isClosedFace ? 1 : 0);
            if (n3 < 1 || n3 > 4) {
                this.pmeshError = this.type + " ERROR: bad polygon (must have 1-4 vertices) at #" + (i + 1);
                return false;
            }
            boolean bl = true;
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.getInt() - this.vertexBase;
                if (nArray[n] < 0 || nArray[n] >= this.nVertices) {
                    this.pmeshError = this.type + " ERROR: invalid vertex index: " + nArray[n];
                    return false;
                }
                nArray[n] = this.vertexMap[nArray[n]];
                if (nArray[n] >= 0) continue;
                bl = false;
            }
            if (this.onePerLine) {
                this.iToken = Integer.MAX_VALUE;
            }
            if (!bl) continue;
            if (n3 < 3) {
                for (n = n3; n < 3; ++n) {
                    nArray[n] = nArray[n - 1];
                }
            }
            if (n3 == 4) {
                this.nTriangles += 2;
                this.addTriangleCheck(nArray[0], nArray[1], nArray[3], 5, 0, false, 0);
                this.addTriangleCheck(nArray[1], nArray[2], nArray[3], 3, 0, false, 0);
                continue;
            }
            ++this.nTriangles;
            this.addTriangleCheck(nArray[0], nArray[1], nArray[2], 7, 0, false, 0);
        }
        if (this.isBinary) {
            this.nBytes = this.binarydoc.getPosition();
        }
        return true;
    }

    private String nextToken() throws Exception {
        while (this.iToken >= this.tokens.length) {
            this.iToken = 0;
            this.readLine();
            this.tokens = this.getTokens();
        }
        return this.tokens[this.iToken++];
    }

    private int getInt() throws Exception {
        return this.isBinary ? this.binarydoc.readInt() : this.parseIntStr(this.nextToken());
    }

    private float getFloat() throws Exception {
        return this.isBinary ? this.binarydoc.readFloat() : this.parseFloatStr(this.nextToken());
    }
}

