/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.__RayTracerExporter;
import org.jmol.java.BS;
import org.jmol.viewer.Viewer;

public class _PovrayExporter
extends __RayTracerExporter {
    private boolean haveMacros;

    public _PovrayExporter() {
        this.commentChar = "// ";
    }

    @Override
    String finalizeOutput() {
        this.finalizeOutput2();
        return this.getAuxiliaryFileData();
    }

    @Override
    protected void outputHeader() {
        this.initVars();
        this.output("// ******************************************************\n");
        this.output("// Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("//\n");
        this.output("// This script was generated on " + this.getExportDate() + "\n");
        this.output("// ******************************************************\n");
        try {
            this.output(this.vwr.getWrappedStateScript());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.output("\n");
        this.output("// ******************************************************\n");
        this.output("// Declare the resolution, camera, and light sources.\n");
        this.output("// ******************************************************\n");
        this.output("\n");
        this.output("// NOTE: if you plan to render at a different resolution,\n");
        this.output("// be sure to update the following two lines to maintain\n");
        this.output("// the correct aspect ratio.\n\n");
        this.output("#declare Width = " + this.screenWidth + ";\n");
        this.output("#declare Height = " + this.screenHeight + ";\n");
        this.output("#declare minScreenDimension = " + this.minScreenDimension + ";\n");
        this.output("#declare showAtoms = true;\n");
        this.output("#declare showBonds = true;\n");
        this.output("#declare noShadows = true;\n");
        this.output("camera{\n");
        this.output("  orthographic\n");
        this.output("  location < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 0>\n" + "\n");
        this.output("  // Negative right for a right hand coordinate system.\n");
        this.output("\n");
        this.output("  sky < 0, -1, 0 >\n");
        this.output("  right < -" + this.screenWidth + ", 0, 0>\n");
        this.output("  up < 0, " + this.screenHeight + ", 0 >\n");
        this.output("  look_at < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 1000 >\n");
        this.output("}\n");
        this.output("\n");
        this.output("background { color rgb <" + this.rgbFractionalFromColix(this.backgroundColix) + "> }\n");
        this.output("\n");
        float f = Math.max(this.screenWidth, this.screenHeight);
        this.output("light_source { <" + this.lightSource.x * f + "," + this.lightSource.y * f + ", " + -1.0f * this.lightSource.z * f + "> " + " rgb <0.6,0.6,0.6> }\n");
        this.output("\n");
        this.output("\n");
        this.output("// ***********************************************\n");
        this.output("// macros for common shapes\n");
        this.output("// ***********************************************\n");
        this.output("\n");
        this.writeMacros();
    }

    private void writeMacros() {
        this.output("#default { finish {\n  ambient " + (float)this.g3d.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)this.g3d.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)this.g3d.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n  metallic\n  phong 0.9\n  phong_size 120\n}}" + "\n\n");
        this.output("#macro check_shadow()\n #if (noShadows)\n  no_shadow \n #end\n#end\n\n");
        this.output("#declare slabZ = " + this.slabZ + ";\n" + "#declare depthZ = " + this.depthZ + ";\n" + "#declare dzSlab = 10;\n" + "#declare dzDepth = dzSlab;\n" + "#declare dzStep = 0.001;\n\n");
        this.output("#macro clip()\n  clipped_by { box {<0,0,slabZ>,<Width,Height,depthZ>} }\n#end\n\n");
        this.output("#macro circleCap(Z,RADIUS,R,G,B,T)\n// cap for lower clip\n #local cutDiff = Z - slabZ;\n #local cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzSlab > 0)\n   #declare dzSlab = dzSlab - dzStep;\n  #end\n  cylinder{<X,Y,slabZ-dzSlab>,<X,Y,(slabZ+1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n// cap for upper clip\n #declare cutDiff = Z - depthZ;\n #declare cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzDepth > 0)\n   #declare dzDepth = dzDepth - dzStep;\n  #end\n  cylinder{<X,Y,depthZ+dzDepth>,<X,Y,(depthZ-1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n#end\n\n");
        this.writeMacrosFinish();
        this.writeMacrosAtom();
        this.writeMacrosBond();
    }

    private void writeMacrosFinish() {
        this.output("#macro translucentFinish(T)\n #local shineFactor = T;\n #if (T <= 0.25)\n  #declare shineFactor = (1.0-4*T);\n #end\n #if (T > 0.25)\n  #declare shineFactor = 0;\n #end\n finish {\n  ambient " + (float)this.g3d.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)this.g3d.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)this.g3d.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n" + "  metallic shineFactor\n" + "  phong 0.9*shineFactor\n" + "  phong_size 120*shineFactor\n}" + "#end\n\n");
    }

    private void writeMacrosAtom() {
        this.output("#macro a(X,Y,Z,RADIUS,R,G,B,T)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n" + (this.isSlabEnabled ? " circleCap(Z,RADIUS,R,G,B,T)\n" : "") + "#end\n\n");
        this.output("#macro q(XX,YY,ZZ,XY,XZ,YZ,X,Y,Z,J,R,G,B,T)\n quadric{<XX,YY,ZZ>,<XY,XZ,YZ>,<X,Y,Z>,J\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosBond() {
        this.output("#macro b(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro c(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2 open\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacros2() {
        this.output("#macro r(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,R,G,B,T)\n triangle{<X1,Y1,Z1>,<X2,Y2,Z2>,<X3,Y3,Z3>\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro p(X,Y,Z,R,G,B,T)\n box{<X,Y,Z>,<X+1,Y+1,Z+1>\n  pigment{rgbt<R,G,B,T>}\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro barb(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T,X3,Y3,Z3,W3)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  clipped_by{plane{<X3,Y3,Z3>,W3}}\n  check_shadow()}\n#end\n\n");
        this.haveMacros = true;
    }

    @Override
    protected String getTriad(T3 t3) {
        if (Float.isNaN(t3.x)) {
            return "0,0,0";
        }
        return t3.x + "," + t3.y + "," + t3.z;
    }

    private String getTriad(int[] nArray) {
        return nArray[0] + "," + nArray[1] + "," + nArray[2];
    }

    private String color4(short s) {
        return this.rgbFractionalFromColix(s) + "," + _PovrayExporter.translucencyFractionalFromColix(s);
    }

    private String getAuxiliaryFileData() {
        String string = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
        string = string.substring(string.lastIndexOf("\\") + 1);
        return "; Created by: Jmol " + Viewer.getJmolVersion() + "\n; Creation date: " + this.getExportDate() + "\n; File created: " + this.fileName + " (" + this.out.getByteCount() + " bytes)\n\n" + (this.commandLineOptions != null ? this.commandLineOptions : "\n; Jmol state: (embedded in input file)\nInput_File_Name=" + string + "\nOutput_to_File=true" + "\nOutput_File_Type=N" + "\nOutput_File_Name=" + string + ".png" + "\nWidth=" + this.screenWidth + "\nHeight=" + this.screenHeight + "\nAntialias=true" + "\nAntialias_Threshold=0.1" + "\nDisplay=true" + "\nPause_When_Done=true" + "\nWarning_Level=5" + "\nVerbose=false" + "\n");
    }

    @Override
    protected void output(T3 t3) {
        this.output(", <" + this.getTriad(t3) + ">");
    }

    @Override
    protected void outputCircle(int n, int n2, int n3, float f, short s, boolean bl) {
        this.output((bl ? "b(" : "c(") + n + "," + n2 + "," + n3 + "," + f + "," + n + "," + n2 + "," + (n3 + 1) + "," + (f + (float)(bl ? 0 : 2)) + "," + this.color4(s) + ")\n");
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            if (!this.haveMacros) {
                this.writeMacros2();
            }
            P4 p4 = new P4();
            this.tempP1.set(p3.x, p32.y, 12345.679f);
            Measure.getPlaneThroughPoints(p3, p32, this.tempP1, this.tempV1, this.tempV2, this.tempV3, p4);
            this.output("barb(" + this.getTriad(p3) + "," + f + "," + this.getTriad(p32) + ",0" + "," + this.color4(s) + "," + p4.x + "," + p4.y + "," + p4.z + "," + -p4.w + ")\n");
        } else {
            this.output("b(" + this.getTriad(p3) + "," + f + "," + this.getTriad(p32) + ",0" + "," + this.color4(s) + ")\n");
        }
    }

    @Override
    protected void outputCylinder(P3 p3, P3 p32, float f, short s, boolean bl) {
        String string = this.color4(s);
        this.output((bl ? "b(" : "c(") + this.getTriad(p3) + "," + f + "," + this.getTriad(p32) + "," + f + "," + string + ")\n");
    }

    @Override
    protected void outputCylinderConical(P3 p3, P3 p32, float f, float f2, short s) {
        this.output("b(" + this.getTriad(p3) + "," + f + "," + this.getTriad(p32) + "," + f2 + "," + this.color4(s) + ")\n");
    }

    @Override
    protected void outputEllipsoid(P3 p3, float f, double[] dArray, short s) {
        String string = dArray[0] + "," + dArray[1] + "," + dArray[2] + "," + dArray[3] + "," + dArray[4] + "," + dArray[5] + "," + dArray[6] + "," + dArray[7] + "," + dArray[8] + "," + dArray[9] + "," + this.color4(s);
        this.output("q(" + string + ")\n");
    }

    @Override
    protected void outputSurface(P3[] p3Array, V3[] v3Array, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (sArray2 != null) {
            int n9;
            boolean bl = bS == null;
            int n10 = n9 = bl ? n2 - 1 : bS.nextSetBit(0);
            while (n10 >= 0) {
                this.output("polygon { 4\n");
                for (int i = 0; i <= 3; ++i) {
                    this.outputVertex(p3Array[nArray[n10][i % 3]], p3);
                }
                this.output("\n");
                s = sArray2[n10];
                this.output("pigment{rgbt<" + this.color4(s) + ">}\n");
                this.output("  translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(s) + ")\n");
                this.output("  check_shadow()\n");
                this.output("  clip()\n");
                this.output("}\n");
                n10 = bl ? n10 - 1 : bS.nextSetBit(n10 + 1);
            }
            return;
        }
        this.output("mesh2 {\n");
        this.output("vertex_vectors { " + n);
        for (n8 = 0; n8 < n; ++n8) {
            this.outputVertex(p3Array[n8], p3);
        }
        this.output("\n}\n");
        int n11 = n8 = v3Array != null ? 1 : 0;
        if (n8 != 0) {
            this.output("normal_vectors { " + n);
            for (n7 = 0; n7 < n; ++n7) {
                _PovrayExporter.setTempVertex(p3Array[n7], p3, this.tempP2);
                this.output(this.getScreenNormal(this.tempP2, v3Array[n7], 1.0f));
                this.output("\n");
            }
            this.output("\n}\n");
        }
        if (sArray != null) {
            n7 = lst.size();
            this.output("texture_list { " + n7);
            String string = ">} translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(sArray[0]) + ")}";
            for (n6 = 0; n6 < n7; ++n6) {
                this.output("\n, texture{pigment{rgbt<" + this.color4((Short)lst.get(n6)) + string);
            }
            this.output("\n}\n");
        }
        this.output("face_indices { " + n3);
        n7 = bS == null ? 1 : 0;
        n6 = n5 = n7 != 0 ? n2 - 1 : bS.nextSetBit(0);
        while (n6 >= 0) {
            this.output(", <" + this.getTriad(nArray[n6]) + ">");
            if (sArray != null) {
                this.output("," + map.get(sArray[nArray[n6][0]]));
                this.output("," + map.get(sArray[nArray[n6][1]]));
                this.output("," + map.get(sArray[nArray[n6][2]]));
            }
            if (n4 == 4 && nArray[n6].length == 4) {
                this.output(", <" + nArray[n6][0] + "," + nArray[n6][2] + "," + nArray[n6][3] + ">");
                if (sArray != null) {
                    this.output("," + map.get(sArray[nArray[n6][0]]));
                    this.output("," + map.get(sArray[nArray[n6][2]]));
                    this.output("," + map.get(sArray[nArray[n6][3]]));
                }
            }
            this.output("\n");
            n6 = n7 != 0 ? n6 - 1 : bS.nextSetBit(n6 + 1);
        }
        this.output("\n}\n");
        if (sArray == null) {
            this.output("pigment{rgbt<" + this.color4(s) + ">}\n");
            this.output("  translucentFinish(" + _PovrayExporter.translucencyFractionalFromColix(s) + ")\n");
        }
        this.output("  check_shadow()\n");
        this.output("  clip()\n");
        this.output("}\n");
    }

    @Override
    protected void outputSphere(float f, float f2, float f3, float f4, short s) {
        this.output("a(" + f + "," + f2 + "," + f3 + "," + f4 + "," + this.color4(s) + ")\n");
    }

    @Override
    protected void outputTextPixel(int n, int n2, int n3, int n4) {
        if (!this.haveMacros) {
            this.writeMacros2();
        }
        float f = n4 >> 24 & 0xFF;
        f = (255.0f - f) / 255.0f;
        this.output("p(" + n + "," + n2 + "," + n3 + "," + this.rgbFractionalFromArgb(n4) + "," + f + ")\n");
    }

    @Override
    protected void outputTriangle(P3 p3, P3 p32, P3 p33, short s) {
        if (!this.haveMacros) {
            this.writeMacros2();
        }
        this.output("r(" + this.getTriad(p3) + "," + this.getTriad(p32) + "," + this.getTriad(p33) + "," + this.color4(s) + ")\n");
    }
}

