/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Node;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String string, boolean bl) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
        smilesSearch.createTopoMap(null);
        smilesSearch.nodes = smilesSearch.jmolAtoms;
        return smilesSearch.getMolecularFormula(!bl);
    }

    public String getSmiles(Node[] nodeArray, int n, BS bS, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws Exception {
        InvalidSmilesException.clear();
        if (bl) {
            return new SmilesGenerator().getBioSmiles((BNode[])nodeArray, n, bS, bl2, bl3, string);
        }
        return new SmilesGenerator().getSmiles(nodeArray, n, bS, bl4);
    }

    public int areEqual(String string, String string2) throws Exception {
        BS[] bSArray = this.find(string, string2, false, false);
        return bSArray == null ? -1 : bSArray.length;
    }

    public boolean areEqual(String string, SmilesSearch smilesSearch) throws Exception {
        BS[] bSArray = this.find(string, smilesSearch, false, true, true);
        return bSArray != null && bSArray.length == 1;
    }

    public BS[] find(String string, String string2, boolean bl, boolean bl2) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
        return this.find(string, smilesSearch, bl, !bl, bl2);
    }

    public String getRelationship(String string, String string2) throws Exception {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = SmilesMatcher.countStereo(string);
        boolean bl2 = bl = n2 == (n = SmilesMatcher.countStereo(string2)) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = string + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0) {
                    boolean bl3 = bl = this.areEqual(string = this.reverseChirality(string), string2) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    public String reverseChirality(String string) {
        string = PT.rep((String)string, (String)"@@", (String)"!@");
        string = PT.rep((String)string, (String)"@", (String)"@@");
        string = PT.rep((String)string, (String)"!@@", (String)"@");
        string = PT.rep((String)string, (String)"@@SP", (String)"@SP");
        string = PT.rep((String)string, (String)"@@OH", (String)"@OH");
        string = PT.rep((String)string, (String)"@@TB", (String)"@TB");
        return string;
    }

    public BS getSubstructureSet(String string, Node[] nodeArray, int n, BS bS, boolean bl, boolean bl2) throws Exception {
        return (BS)this.match(string, nodeArray, n, bS, null, bl, false, bl2, 1);
    }

    public void getSubstructureSets(String[] stringArray, Node[] nodeArray, int n, int n2, BS bS, Lst<BS> lst, Lst<BS>[] lstArray) throws Exception {
        InvalidSmilesException.clear();
        SmilesParser smilesParser = new SmilesParser(true);
        SmilesSearch smilesSearch = null;
        smilesSearch = smilesParser.parse("");
        smilesSearch.firstMatchOnly = false;
        smilesSearch.matchAllAtoms = false;
        smilesSearch.jmolAtoms = nodeArray;
        smilesSearch.jmolAtomCount = Math.abs(n);
        smilesSearch.setSelected(bS);
        smilesSearch.getRingData(true, n2, lstArray);
        smilesSearch.asVector = false;
        smilesSearch.subSearches = new SmilesSearch[1];
        smilesSearch.getSelections();
        BS bS2 = new BS();
        for (int i = 0; i < stringArray.length; ++i) {
            SmilesSearch smilesSearch2;
            if (stringArray[i] == null || stringArray[i].length() == 0 || stringArray[i].startsWith("#")) {
                lst.addLast(null);
                continue;
            }
            smilesSearch.clear();
            smilesSearch.subSearches[0] = smilesSearch2 = smilesParser.getSearch(smilesSearch, SmilesParser.cleanPattern(stringArray[i]), n2);
            BS bS3 = BSUtil.copy((BS)((BS)smilesSearch.search(false)));
            lst.addLast((Object)bS3);
            bS2.or(bS3);
            if (bS2.cardinality() != n) continue;
            return;
        }
    }

    public BS[] getSubstructureSetArray(String string, Node[] nodeArray, int n, BS bS, BS bS2, boolean bl, boolean bl2) throws Exception {
        return (BS[])this.match(string, nodeArray, n, bS, bS2, bl, false, bl2, 2);
    }

    public int[][] getCorrelationMaps(String string, Node[] nodeArray, int n, BS bS, boolean bl, boolean bl2) throws Exception {
        return (int[][])this.match(string, nodeArray, n, bS, null, bl, false, bl2, 3);
    }

    private BS[] find(String string, SmilesSearch smilesSearch, boolean bl, boolean bl2, boolean bl3) throws Exception {
        BS bS = new BS();
        smilesSearch.createTopoMap(bS);
        return (BS[])this.match(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bS, bl, bl2, bl3, 2);
    }

    private Object match(String string, Node[] nodeArray, int n, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, int n2) throws Exception {
        InvalidSmilesException.clear();
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.jmolAtoms = nodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            smilesSearch.setSelected(bS);
            smilesSearch.getSelections();
            smilesSearch.bsRequired = null;
            smilesSearch.setRingData(bS2);
            smilesSearch.firstMatchOnly = bl3;
            smilesSearch.matchAllAtoms = bl2;
            switch (n2) {
                case 1: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search(false);
                }
                case 2: {
                    smilesSearch.asVector = true;
                    Lst lst = (Lst)smilesSearch.search(false);
                    return lst.toArray((Object[])new BS[lst.size()]);
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    Lst lst = (Lst)smilesSearch.search(false);
                    return lst.toArray((Object[])AU.newInt2((int)lst.size()));
                }
            }
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.clear();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    private static int countStereo(String string) {
        string = PT.rep((String)string, (String)"@@", (String)"@");
        int n = string.lastIndexOf(64) + 1;
        int n2 = 0;
        while (--n >= 0) {
            if (string.charAt(n) != '@') continue;
            ++n2;
        }
        return n2;
    }
}

