/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.M4;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3i;
import org.jmol.symmetry.HallInfo;
import org.jmol.symmetry.HallRotation;
import org.jmol.symmetry.HallTranslation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;

class HallRotationTerm {
    String inputCode;
    String primitiveCode;
    String lookupCode;
    String translationString;
    HallRotation rotation;
    HallTranslation translation;
    M4 seitzMatrix12ths = new M4();
    boolean isImproper;
    int order;
    char axisType = '\u0000';
    char diagonalReferenceAxis = '\u0000';
    boolean allPositive = true;

    HallRotationTerm(HallInfo hallInfo, String string, int n, char c) {
        HallTranslation hallTranslation;
        this.inputCode = string;
        string = string + "   ";
        if (string.charAt(0) == '-') {
            this.isImproper = true;
            string = string.substring(1);
        }
        this.primitiveCode = "";
        this.order = string.charAt(0) - 48;
        this.diagonalReferenceAxis = '\u0000';
        this.axisType = '\u0000';
        int n2 = 2;
        char c2 = string.charAt(1);
        block0 : switch (c2) {
            case 'x': 
            case 'y': 
            case 'z': {
                switch (string.charAt(2)) {
                    case '\"': 
                    case '\'': {
                        this.diagonalReferenceAxis = c2;
                        c2 = string.charAt(2);
                        ++n2;
                    }
                }
            }
            case '*': {
                this.axisType = c2;
                break;
            }
            case '\"': 
            case '\'': {
                this.axisType = c2;
                switch (string.charAt(2)) {
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.diagonalReferenceAxis = string.charAt(2);
                        ++n2;
                        break block0;
                    }
                }
                this.diagonalReferenceAxis = c;
                break;
            }
            default: {
                this.axisType = (char)(this.order == 1 ? 95 : (hallInfo.nRotations == 0 ? 122 : (hallInfo.nRotations == 2 ? 42 : (n == 2 || n == 4 ? 120 : 39))));
                string = string.substring(0, 1) + this.axisType + string.substring(1);
            }
        }
        this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : string.substring(0, 2));
        if (this.diagonalReferenceAxis != '\u0000') {
            string = string.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + string.substring(n2);
            this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
            n2 = 3;
        }
        this.lookupCode = string.substring(0, n2);
        this.rotation = HallRotation.lookup(this.lookupCode);
        if (this.rotation == null) {
            Logger.error((String)("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode));
            return;
        }
        this.translation = new HallTranslation('\u0000', null);
        this.translationString = "";
        int n3 = string.length();
        for (int i = n2; i < n3; ++i) {
            char c3 = string.charAt(i);
            hallTranslation = HallTranslation.getHallTranslation(c3, this.order);
            if (hallTranslation == null) continue;
            this.translationString = this.translationString + "" + hallTranslation.translationCode;
            this.translation.rotationShift12ths += hallTranslation.rotationShift12ths;
            this.translation.vectorShift12ths.add((T3i)hallTranslation.vectorShift12ths);
        }
        this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
        if (this.isImproper) {
            this.seitzMatrix12ths.setM4(this.rotation.seitzMatrixInv);
        } else {
            this.seitzMatrix12ths.setM4(this.rotation.seitzMatrix);
        }
        this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
        this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
        this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
        switch (this.axisType) {
            case 'x': {
                this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'y': {
                this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'z': {
                this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
            }
        }
        if (hallInfo.vectorCode.length() > 0) {
            M4 m4 = M4.newM4(null);
            M4 m42 = M4.newM4(null);
            hallTranslation = hallInfo.vector12ths;
            m4.m03 = ((P3i)hallTranslation).x;
            m4.m13 = ((P3i)hallTranslation).y;
            m4.m23 = ((P3i)hallTranslation).z;
            m42.m03 = -((P3i)hallTranslation).x;
            m42.m13 = -((P3i)hallTranslation).y;
            m42.m23 = -((P3i)hallTranslation).z;
            this.seitzMatrix12ths.mul2(m4, this.seitzMatrix12ths);
            this.seitzMatrix12ths.mul(m42);
        }
        if (Logger.debugging) {
            Logger.debug((String)("code = " + string + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths));
        }
    }

    String dumpInfo(String string) {
        SB sB = new SB();
        sB.append("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").appendI(this.order).append(this.isImproper ? " (improper axis)" : "");
        if (this.axisType != '_') {
            sB.append("; axisType: ").appendC(this.axisType);
            if (this.diagonalReferenceAxis != '\u0000') {
                sB.appendC(this.diagonalReferenceAxis);
            }
        }
        if (this.translationString.length() > 0) {
            sB.append("; translation: ").append(this.translationString);
        }
        if (string.length() > 0) {
            sB.append("; vector offset: ").append(string);
        }
        if (this.rotation != null) {
            sB.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths, false));
        }
        return sB.toString();
    }

    String getXYZ(boolean bl) {
        return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, true, bl, true);
    }
}

