/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Vectors;
import org.jmol.util.Vibration;

public class VectorsRenderer
extends ShapeRenderer {
    private static final float arrowHeadOffset = -0.2f;
    private final P3 pointVectorStart = new P3();
    private final P3 pointVectorEnd = new P3();
    private final P3 pointArrowHead = new P3();
    private final P3i screenVectorStart = new P3i();
    private final P3i screenVectorEnd = new P3i();
    private final P3i screenArrowHead = new P3i();
    private final V3 headOffsetVector = new V3();
    private int diameter;
    private int headWidthPixels;
    private float vectorScale;
    private boolean vectorSymmetry;
    private float headScale;
    private boolean doShaft;
    private Vibration vibTemp;
    private boolean vectorsCentered;
    private boolean standardVector = true;
    private boolean vibrationOn;
    private boolean drawCap;

    protected boolean render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return false;
        }
        short[] sArray = vectors.mads;
        if (sArray == null) {
            return false;
        }
        Atom[] atomArray = vectors.atoms;
        short[] sArray2 = vectors.colixes;
        boolean bl = false;
        this.vectorScale = this.vwr.getFloat(1649410049);
        this.vectorSymmetry = this.vwr.getBoolean(603979973);
        this.vectorsCentered = this.vwr.getBoolean(603979972);
        this.vibrationOn = this.vwr.tm.vibrationOn;
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        int n = this.ms.getAtomCount();
        while (--n >= 0) {
            Vibration vibration;
            Atom atom = atomArray[n];
            if (!this.isVisibleForMe(atom) || (vibration = this.ms.getVibration(n, false)) == null || !this.transform(sArray[n], atom, vibration)) continue;
            if (!this.g3d.setC(Shape.getColix((short[])sArray2, (int)n, (Atom)atom))) {
                bl = true;
                continue;
            }
            this.renderVector(atom);
            if (!this.vectorSymmetry) continue;
            if (this.vibTemp == null) {
                this.vibTemp = new Vibration();
            }
            this.vibTemp.setT((T3)vibration);
            this.vibTemp.scale(-1.0f);
            this.transform(sArray[n], atom, this.vibTemp);
            this.renderVector(atom);
        }
        return bl;
    }

    private boolean transform(short s, Atom atom, Vibration vibration) {
        boolean bl = vibration.modDim >= 0;
        boolean bl2 = vibration.modDim == -2;
        this.drawCap = true;
        if (!bl) {
            float f = vibration.length();
            if ((double)Math.abs(f * this.vectorScale) < 0.01) {
                return false;
            }
            this.standardVector = true;
            this.doShaft = 0.1 + (double)Math.abs(this.headScale / f) < (double)Math.abs(this.vectorScale);
            this.headOffsetVector.setT((T3)vibration);
            this.headOffsetVector.scale(this.headScale / f);
        }
        if (bl) {
            this.standardVector = false;
            this.doShaft = true;
            this.pointVectorStart.setT((T3)atom);
            this.pointVectorEnd.setT((T3)atom);
            JmolModulationSet jmolModulationSet = (JmolModulationSet)vibration;
            if (!jmolModulationSet.isEnabled()) {
                jmolModulationSet.addTo((T3)this.pointVectorEnd, 1.0f);
            } else {
                if (this.vibrationOn) {
                    this.vwr.tm.getVibrationPoint(vibration, (T3)this.pointVectorEnd, Float.NaN);
                }
                jmolModulationSet.addTo((T3)this.pointVectorStart, -1.0f);
            }
            this.headOffsetVector.sub2((T3)this.pointVectorEnd, (T3)this.pointVectorStart);
            float f = this.headOffsetVector.length();
            this.drawCap = f + -0.2f > 0.001f;
            this.doShaft = f > 0.01f;
            this.headOffsetVector.scale(this.headScale / this.headOffsetVector.length());
        } else if (this.vectorsCentered || bl2) {
            this.standardVector = false;
            this.pointVectorEnd.scaleAdd2(0.5f * this.vectorScale, (T3)vibration, (T3)atom);
            this.pointVectorStart.scaleAdd2(-0.5f * this.vectorScale, (T3)vibration, (T3)atom);
        } else {
            this.pointVectorEnd.scaleAdd2(this.vectorScale, (T3)vibration, (T3)atom);
            this.screenVectorEnd.setT((T3i)(this.vibrationOn ? this.tm.transformPtVib(this.pointVectorEnd, vibration) : this.tm.transformPt((T3)this.pointVectorEnd)));
            this.pointArrowHead.add2((T3)this.pointVectorEnd, (T3)this.headOffsetVector);
            if (atom.getAtomNumber() == 16) {
                System.out.println("vecrend " + vibration + atom.x + " " + atom.y + " " + atom.z + " ptH=" + this.pointVectorEnd);
            }
            this.screenArrowHead.setT((T3i)(this.vibrationOn ? this.tm.transformPtVib(this.pointArrowHead, vibration) : this.tm.transformPt((T3)this.pointArrowHead)));
        }
        if (!this.standardVector) {
            this.screenVectorEnd.setT((T3i)this.tm.transformPt((T3)this.pointVectorEnd));
            this.screenVectorStart.setT((T3i)this.tm.transformPt((T3)this.pointVectorStart));
            if (this.drawCap) {
                this.pointArrowHead.add2((T3)this.pointVectorEnd, (T3)this.headOffsetVector);
            } else {
                this.pointArrowHead.setT((T3)this.pointVectorEnd);
            }
            this.screenArrowHead.setT((T3i)this.tm.transformPt((T3)this.pointArrowHead));
        }
        this.diameter = (int)(s < 0 ? (float)(-s) : (s < 1 ? 1.0f : this.vwr.tm.scaleToScreen(this.screenVectorEnd.z, (int)s)));
        this.headWidthPixels = this.diameter << 1;
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    private void renderVector(Atom atom) {
        if (this.doShaft) {
            if (this.standardVector) {
                this.g3d.fillCylinderScreen((byte)1, this.diameter, atom.sX, atom.sY, atom.sZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
            } else {
                this.g3d.fillCylinderScreen((byte)2, this.diameter, this.screenVectorStart.x, this.screenVectorStart.y, this.screenVectorStart.z, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
            }
        }
        if (this.drawCap) {
            this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd, false);
        }
    }
}

