/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    V3 centering;
    private P3 atomTest;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    private boolean isBio;
    private Matrix sigma;
    int index;
    String subsystemCode;
    public int timeReversal;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    static final String[] labelsXYZ = new String[]{"x", "y", "z"};
    static final String[] labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
    static final String[] labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
    float magOp = Float.MAX_VALUE;
    boolean isCenteringOp;
    private boolean unCentered;

    void setSigma(String string, Matrix matrix) {
        this.subsystemCode = string;
        this.sigma = matrix;
    }

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.modDim = symmetryOperation.modDim;
        this.myLabels = symmetryOperation.myLabels;
        this.index = symmetryOperation.index;
        this.linearRotTrans = symmetryOperation.linearRotTrans;
        this.sigma = symmetryOperation.sigma;
        this.subsystemCode = symmetryOperation.subsystemCode;
        this.timeReversal = symmetryOperation.timeReversal;
        this.setMatrix(false);
        if (!symmetryOperation.isFinalized) {
            this.doFinalize();
        }
        if (bl && this.sigma == null) {
            this.setOffset(p3Array, n, n2);
        }
    }

    private void setGamma(boolean bl) {
        int n;
        int n2;
        int n3 = 3 + this.modDim;
        this.rsvs = new Matrix((double[][])null, n3 + 1, n3 + 1);
        double[][] dArray = this.rsvs.getArray();
        double[] dArray2 = new double[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = this.linearRotTrans[n4++];
            }
            dArray2[n2] = (float)(bl ? -1 : 1) * this.linearRotTrans[n4++];
        }
        dArray[n3][n3] = 1.0;
        if (bl) {
            this.rsvs = this.rsvs.inverse();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2][n3] = dArray2[n2];
        }
        dArray = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.setElement(n2, n, (float)(n < 3 ? dArray[n2][n] : dArray2[n2]));
            }
        }
        this.setElement(3, 3, 1.0f);
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (this.modDim > 0) {
            double[][] dArray = this.rsvs.getArray();
            int n = dArray.length - 1;
            while (--n >= 0) {
                double[] dArray2 = dArray[n];
                int n2 = 3 + this.modDim;
                dArray2[n2] = dArray2[n2] / 12.0;
            }
        }
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(P3 p3, P3 p32, int n, int n2, int n3) {
        this.rotTrans2((T3)p3, (T3)p32);
        p32.add3((float)n, (float)n2, (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 m4, boolean bl) {
        SB sB = new SB();
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            m4.getRow(i, fArray);
            sB.append("[\t");
            for (int j = 0; j < 3; ++j) {
                sB.appendI((int)fArray[j]).append("\t");
            }
            sB.append(SymmetryOperation.twelfthsOf(bl ? (float)(((int)fArray[3] + 12) % 12) : (float)((int)fArray[3]))).append("\t]\n");
        }
        return sB.toString();
    }

    boolean setMatrixFromXYZ(String string, int n, boolean bl) {
        String string2;
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        int n2 = (n + 4) * (n + 4);
        this.modDim = n;
        if (n > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n2];
        boolean bl2 = string.startsWith("!");
        if (bl2) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.linearRotTrans);
            return this.setFromMatrix(null, bl2);
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.linearRotTrans);
            for (int i = 0; i < n2; ++i) {
                float f = this.linearRotTrans[i];
                if (!Float.isNaN(f)) continue;
                return false;
            }
            this.setMatrix(bl2);
            this.isFinalized = true;
            this.isBio = string.indexOf("bio") >= 0;
            this.xyz = this.isBio ? this.toString() : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (string.indexOf(",m") >= 0) {
            this.timeReversal = string.indexOf(",m-1") >= 0 ? -1 : 1;
            bl = true;
        }
        if ((string2 = SymmetryOperation.getMatrixFromString(this, string, this.linearRotTrans, bl)) == null) {
            return false;
        }
        this.setMatrix(bl2);
        String string3 = this.xyz = bl2 ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : string2;
        if (this.timeReversal != 0) {
            this.xyz = this.xyz + (this.timeReversal == 1 ? ",m+1" : ",m-1");
        }
        if (Logger.debugging) {
            Logger.debug((String)("" + (Object)((Object)this)));
        }
        return true;
    }

    private void setMatrix(boolean bl) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(bl);
        } else {
            this.setA(this.linearRotTrans);
            if (bl) {
                P3 p3 = P3.new3((float)this.m03, (float)this.m13, (float)this.m23);
                this.invertM(this);
                this.rotate((T3)p3);
                p3.scale(-1.0f);
                this.setTranslation((T3)p3);
            }
        }
    }

    boolean setFromMatrix(float[] fArray, boolean bl) {
        float f = 0.0f;
        int n = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int n2 = 0;
        int n3 = 3 + this.modDim;
        int n4 = 0;
        while (n2 < n3) {
            boolean bl2;
            if (Float.isNaN(this.linearRotTrans[n4])) {
                return false;
            }
            f = this.linearRotTrans[n4];
            if (Math.abs(f) < 1.0E-5f) {
                f = 0.0f;
            }
            boolean bl3 = bl2 = (n4 + 1) % (n3 + 1) == 0;
            if (bl2) {
                if (fArray != null) {
                    f /= 12.0f;
                    if (n < fArray.length) {
                        f += fArray[n++];
                    }
                }
                f = SymmetryOperation.normalizeTwelfths((float)((f < 0.0f ? -1 : 1) * Math.round(Math.abs(f * 12.0f))) / 12.0f, this.doNormalize);
                ++n2;
            }
            this.linearRotTrans[n4] = f;
            ++n4;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = 1.0f;
        this.setMatrix(bl);
        this.isFinalized = fArray == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    static String getMatrixFromString(SymmetryOperation symmetryOperation, String string, float[] fArray, boolean bl) {
        int n;
        String[] stringArray;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = symmetryOperation == null ? 0 : symmetryOperation.modDim;
        int n3 = 4 + n2;
        boolean bl5 = symmetryOperation != null && symmetryOperation.doNormalize;
        int n4 = n2 > 0 ? 3 : 0;
        fArray[fArray.length - 1] = 1.0f;
        int n5 = string.indexOf(59) + 1;
        if (n5 != 0) {
            bl = true;
            if (n5 == string.length()) {
                string = string + "0,0,0";
            }
        }
        int n6 = -1;
        String[] stringArray2 = stringArray = symmetryOperation == null || n2 == 0 ? null : symmetryOperation.myLabels;
        if (stringArray == null) {
            stringArray = labelsXYZ;
        }
        string = string.toLowerCase() + ",";
        if (n2 > 0) {
            n = n2 + 3;
            while (--n >= 0) {
                string = PT.rep((String)string, (String)labelsXn[n], (String)labelsXnSub[n]);
            }
        }
        n = 0;
        int n7 = 0;
        int n8 = 0;
        float f = 0.0f;
        float f2 = 1.0f;
        String string2 = "";
        String string3 = "";
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ';': {
                    break;
                }
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block12;
                }
                case '-': {
                    bl4 = true;
                    continue block12;
                }
                case '+': {
                    bl4 = false;
                    continue block12;
                }
                case '/': {
                    bl2 = true;
                    continue block12;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int n9;
                    n7 = n8 * n3;
                    int n10 = c >= 'x' ? c - 120 : c - 97 + n4;
                    n = n7 + n10;
                    int n11 = n9 = bl4 ? -1 : 1;
                    if (bl && f != 0.0f) {
                        fArray[n] = f;
                        n9 = (int)f;
                        f = 0.0f;
                    } else {
                        fArray[n] = n9;
                    }
                    string2 = string2 + SymmetryOperation.plusMinus(string2, n9, stringArray[n10]);
                    break;
                }
                case ',': {
                    if (n5 != 0) {
                        if (n5 > 0) {
                            n6 = i;
                            i = n5 - 1;
                            n5 = -i;
                            f = 0.0f;
                            continue block12;
                        }
                        n5 = i + 1;
                        i = n6;
                    }
                    fArray[n7 + n3 - 1] = f = SymmetryOperation.normalizeTwelfths(f, bl5);
                    string2 = string2 + SymmetryOperation.xyzFraction(f, false, true);
                    string3 = string3 + (string3 == "" ? "" : ",") + string2;
                    if (n8 == n3 - 2) {
                        return string3;
                    }
                    f = 0.0f;
                    string2 = "";
                    if (n8++ <= 2 || n2 != 0) break;
                    Logger.warn((String)("Symmetry Operation? " + string));
                    return null;
                }
                case '.': {
                    bl3 = true;
                    f2 = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!bl3 && (bl2 || !bl)) continue block12;
                }
                default: {
                    int n12 = c - 48;
                    if (bl3 && n12 >= 0 && n12 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl4 = true;
                        }
                        f += f2 * (float)n12 * (float)(bl4 ? -1 : 1);
                        continue block12;
                    }
                    if (n12 >= 0 && n12 <= 9) {
                        if (bl2) {
                            if (f == 0.0f) {
                                int n13 = n;
                                fArray[n13] = fArray[n13] / (float)n12;
                                break;
                            }
                            f /= (float)n12;
                            break;
                        }
                        f = f * 10.0f + (float)((bl4 ? -1 : 1) * n12);
                        bl4 = false;
                        break;
                    }
                    Logger.warn((String)("symmetry character?" + c));
                }
            }
            bl4 = false;
            bl2 = false;
            bl3 = false;
        }
        return null;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        block4: {
            block3: {
                if (!bl) break block3;
                for (f = (float)Math.round(f); f < 0.0f; f += 12.0f) {
                }
                break block4;
            }
            if (!bl2) break block4;
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f < -6.0f) {
                f += 12.0f;
            }
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private static final String twelfthsOf(float f) {
        int n;
        String string = "";
        int n2 = Math.round(f);
        if (n2 == 12) {
            return "1";
        }
        if (n2 == -12) {
            return "-1";
        }
        if (n2 < 0 && (n2 = -n2) % 12 != 0) {
            string = "-";
        }
        if ((n = n2 / 12) < 1) {
            return string + twelfths[n2 % 12];
        }
        int n3 = 0;
        switch (n2 % 12) {
            case 0: {
                return string + n;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                n3 = 12;
                break;
            }
            case 2: 
            case 10: {
                n3 = 6;
                break;
            }
            case 3: 
            case 9: {
                n3 = 4;
                break;
            }
            case 4: 
            case 8: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
            }
        }
        return string + n2 * n3 / 12 + "/" + n3;
    }

    private static String plusMinus(String string, float f, String string2) {
        return f == 0.0f ? "" : (f < 0.0f ? "-" : (string.length() == 0 ? "" : "+")) + (f == 1.0f || f == -1.0f ? "" : "" + (int)Math.abs(f)) + string2;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(M4 m4, boolean bl, boolean bl2, boolean bl3) {
        SymmetryOperation symmetryOperation;
        String string = "";
        SymmetryOperation symmetryOperation2 = symmetryOperation = m4 instanceof SymmetryOperation ? (SymmetryOperation)m4 : null;
        if (symmetryOperation != null && symmetryOperation.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(symmetryOperation.rsvs.getRotation(), symmetryOperation.rsvs.getTranslation(), bl);
        }
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            int n = i < 3 ? 0 : 3;
            m4.getRow(i, fArray);
            String string2 = "";
            for (int j = 0; j < 3; ++j) {
                if (fArray[j] == 0.0f) continue;
                string2 = string2 + SymmetryOperation.plusMinus(string2, fArray[j], labelsXYZ[j + n]);
            }
            string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3);
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private void setOffset(P3[] p3Array, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.atomTest == null) {
            this.atomTest = new P3();
        }
        for (int i = n3; i < n4; ++i) {
            this.newPoint(p3Array[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    V3[] rotateAxes(V3[] v3Array, UnitCell unitCell, P3 p3, M3 m3) {
        V3[] v3Array2 = new V3[3];
        this.getRotationScale(m3);
        int n = v3Array.length;
        while (--n >= 0) {
            p3.setT((T3)v3Array[n]);
            unitCell.toFractional((T3)p3, true);
            m3.rotate((T3)p3);
            unitCell.toCartesian((T3)p3, true);
            v3Array2[n] = V3.newV((T3)p3);
        }
        return v3Array2;
    }

    Object[] getDescription(ModelSet modelSet, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        V3 v3;
        boolean bl;
        if (!this.isFinalized) {
            this.doFinalize();
        }
        V3 v32 = new V3();
        P3 p33 = new P3();
        P3 p34 = new P3();
        P3 p35 = new P3();
        P3 p36 = new P3();
        V3 v33 = new V3();
        V3 v34 = new V3();
        V3 v35 = null;
        if (this.centering != null) {
            v35 = V3.newV((T3)this.centering);
            symmetryInterface.toCartesian((T3)v35, false);
        }
        boolean bl2 = false;
        if (p3 == null || Float.isNaN(p3.x)) {
            p3 = new P3();
        }
        if (p32 != null) {
            SymmetryOperation.setFractional(symmetryInterface, p35, (T3)p3, p33);
            this.rotTrans((T3)p35);
            symmetryInterface.toCartesian((T3)p35, false);
            symmetryInterface.toUnitCell(p35, p33);
            p36.setT((T3)p32);
            symmetryInterface.toUnitCell(p36, p33);
            if (p35.distance((T3)p36) > 0.1f) {
                return null;
            }
            SymmetryOperation.setFractional(symmetryInterface, p35, (T3)p3, null);
            this.rotTrans((T3)p35);
            SymmetryOperation.setFractional(symmetryInterface, p36, (T3)p32, null);
            v34.sub2((T3)p36, (T3)p35);
        }
        p35.set(1.0f, 0.0f, 0.0f);
        p36.set(0.0f, 1.0f, 0.0f);
        P3 p37 = P3.new3((float)0.0f, (float)0.0f, (float)1.0f);
        p35.add((T3)p3);
        p36.add((T3)p3);
        p37.add((T3)p3);
        if (bl2) {
            v34.sub((T3)this.centering);
        }
        P3 p38 = this.rotTransCart(p3, symmetryInterface, v34);
        P3 p39 = this.rotTransCart(p35, symmetryInterface, v34);
        P3 p310 = this.rotTransCart(p36, symmetryInterface, v34);
        P3 p311 = this.rotTransCart(p37, symmetryInterface, v34);
        V3 v36 = V3.newVsub((T3)p39, (T3)p38);
        V3 v37 = V3.newVsub((T3)p310, (T3)p38);
        V3 v38 = V3.newVsub((T3)p311, (T3)p38);
        SymmetryOperation.approx((T3)v34);
        v32.cross((T3)v36, (T3)v37);
        boolean bl3 = bl = v32.dot((T3)v38) < 0.0f;
        if (bl) {
            p39.sub2((T3)p38, (T3)v36);
            p310.sub2((T3)p38, (T3)v37);
            p311.sub2((T3)p38, (T3)v38);
        }
        T3[] t3Array = Measure.computeHelicalAxis((P3)p3, (P3)p38, (Quat)Quat.getQuaternionFrame((P3)p38, (T3)p39, (T3)p310).div(Quat.getQuaternionFrame((P3)p3, (T3)p35, (T3)p36)));
        P3 p312 = (P3)t3Array[0];
        V3 v39 = (V3)t3Array[1];
        int n = (int)Math.abs(PT.approx((float)((P3)t3Array[3]).x, (float)1.0f));
        float f = SymmetryOperation.approxF(((P3)t3Array[3]).y);
        if (bl) {
            p39.add2((T3)p38, (T3)v36);
            p310.add2((T3)p38, (T3)v37);
            p311.add2((T3)p38, (T3)v38);
        }
        if ((v3 = V3.newVsub((T3)p38, (T3)p3)).length() < 0.1f) {
            v3 = null;
        }
        P3 p313 = null;
        P3 p314 = null;
        P3 p315 = null;
        boolean bl4 = n == 0;
        boolean bl5 = !bl4;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl5 || bl) {
            v3 = null;
        }
        if (bl && bl4) {
            p314 = P3.newP((T3)p3);
            p314.add((T3)p38);
            p314.scale(0.5f);
            p313 = p38;
            bl6 = true;
        } else if (bl) {
            V3 v310 = f == 0.0f ? new V3() : v39;
            float f2 = 0.0f;
            switch (n) {
                case 60: {
                    f2 = 0.6666667f;
                    break;
                }
                case 120: {
                    f2 = 2.0f;
                    break;
                }
                case 90: {
                    f2 = 1.0f;
                    break;
                }
                case 180: {
                    p315 = P3.newP((T3)p3);
                    p315.add((T3)v310);
                    p312.scaleAdd2(0.5f, (T3)v310, (T3)p3);
                    if (p315.distance((T3)p38) > 0.1f) {
                        v3 = V3.newVsub((T3)p38, (T3)p315);
                        SymmetryOperation.setFractional(symmetryInterface, p33, (T3)v3, null);
                        v33.setT((T3)p33);
                    } else {
                        v3 = null;
                    }
                    bl5 = false;
                    bl = false;
                    bl7 = true;
                }
            }
            if (f2 != 0.0f) {
                v32.sub2((T3)p3, (T3)p312);
                v32.add((T3)p38);
                v32.sub((T3)p312);
                v32.sub((T3)v310);
                v32.scale(f2);
                p312.add((T3)v32);
                p314 = new P3();
                p314.scaleAdd2(0.5f, (T3)v310, (T3)p312);
                p313 = new P3();
                p313.scaleAdd2(-2.0f, (T3)p314, (T3)p3);
                p313.scale(-1.0f);
            }
        } else if (v3 != null) {
            p33.setT((T3)v3);
            symmetryInterface.toFractional((T3)p33, false);
            if (SymmetryOperation.approxF(p33.x) == 1.0f) {
                p33.x = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.y) == 1.0f) {
                p33.y = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.z) == 1.0f) {
                p33.z = 0.0f;
            }
            v33.setT((T3)p33);
            symmetryInterface.toCartesian((T3)p33, false);
            v3.setT((T3)p33);
        }
        int n2 = n;
        SymmetryOperation.approx0((T3)v39);
        if (bl5) {
            P3 p316 = new P3();
            v32.setT((T3)v39);
            int n3 = n;
            if (bl) {
                p316.add2((T3)p312, (T3)v32);
                n3 = Math.round(Measure.computeTorsion((T3)p313, (T3)p312, (T3)p316, (T3)p38, (boolean)true));
            } else if (f == 0.0f) {
                p316.setT((T3)p312);
                p33.scaleAdd2(1.0f, (T3)p316, (T3)v32);
                n3 = Math.round(Measure.computeTorsion((T3)p3, (T3)p312, (T3)p33, (T3)p38, (boolean)true));
            } else {
                p33.add2((T3)p312, (T3)v32);
                p316.scaleAdd2(0.5f, (T3)v32, (T3)p312);
                n3 = Math.round(Measure.computeTorsion((T3)p3, (T3)p312, (T3)p33, (T3)p38, (boolean)true));
            }
            if (n3 != 0) {
                n = n3;
            }
        }
        if (bl5 && !bl && f == 0.0f && (v39.z < 0.0f || v39.z == 0.0f && (v39.y < 0.0f || v39.y == 0.0f && v39.x < 0.0f))) {
            v39.scale(-1.0f);
            n = -n;
        }
        String string2 = "identity";
        if (bl6) {
            p33.setT((T3)p314);
            symmetryInterface.toFractional((T3)p33, false);
            string2 = "Ci: " + this.strCoord((T3)p33);
        } else if (bl5) {
            if (bl) {
                string2 = "" + 360 / n2 + "-bar axis";
            } else if (f != 0.0f) {
                string2 = "" + 360 / n2 + "-fold screw axis";
                p33.setT((T3)v39);
                symmetryInterface.toFractional((T3)p33, false);
                string2 = string2 + "|translation: " + this.strCoord((T3)p33);
            } else {
                string2 = "C" + 360 / n2 + " axis";
            }
        } else if (v3 != null) {
            String string3 = " " + this.strCoord((T3)v33);
            if (bl4) {
                string2 = "translation:" + string3;
            } else if (bl7) {
                float f3 = SymmetryOperation.approxF(v33.x);
                float f4 = SymmetryOperation.approxF(v33.y);
                float f5 = SymmetryOperation.approxF(v33.z);
                string3 = " " + this.strCoord((T3)v33);
                string2 = f3 != 0.0f && f4 != 0.0f && f5 != 0.0f ? (Math.abs(f3) == Math.abs(f4) && Math.abs(f4) == Math.abs(f5) ? "d-" : "g-") : (f3 != 0.0f && f4 != 0.0f || f4 != 0.0f && f5 != 0.0f || f5 != 0.0f && f3 != 0.0f ? "n-" : (f3 != 0.0f ? "a-" : (f4 != 0.0f ? "b-" : "c-")));
                string2 = string2 + "glide plane|translation:" + string3;
            }
        } else if (bl7) {
            string2 = "mirror plane";
        }
        if (bl && !bl6) {
            p33.setT((T3)p314);
            symmetryInterface.toFractional((T3)p33, false);
            string2 = string2 + "|inversion center at " + this.strCoord((T3)p33);
        }
        if (bl2) {
            string2 = string2 + "|centering " + this.strCoord((T3)this.centering);
        }
        if (this.timeReversal != 0) {
            string2 = string2 + "|spin timeReversal " + (this.timeReversal == 1 ? "+1" : "-1");
        }
        String string4 = null;
        String string5 = this.isBio ? this.xyzOriginal : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
        SB sB = new SB();
        if (string != null) {
            String string6;
            String string7 = null;
            String string8 = "\ndraw ID " + string + "_";
            sB = new SB();
            sB.append(("// " + this.xyzOriginal + "|" + string5 + "|" + string2).replace('\n', ' ')).append("\n").append(string8).append("* delete");
            SymmetryOperation.drawLine(sB, string8 + "frame1X", 0.15f, p3, p35, "red");
            SymmetryOperation.drawLine(sB, string8 + "frame1Y", 0.15f, p3, p36, "green");
            SymmetryOperation.drawLine(sB, string8 + "frame1Z", 0.15f, p3, p37, "blue");
            if (bl5) {
                P3 p317 = new P3();
                string6 = "red";
                n2 = n;
                float f6 = 1.0f;
                v32.setT((T3)v39);
                if (bl) {
                    string7 = string8 + "rotinv";
                    p317.add2((T3)p312, (T3)v32);
                    if (f == 0.0f) {
                        p317.setT((T3)p314);
                        v32.scale(3.0f);
                        p33.scaleAdd2(-1.0f, (T3)v32, (T3)p312);
                        sB.append(string8).append("rotVector2 diameter 0.1 ").append(Escape.eP((T3)p312)).append(Escape.eP((T3)p33)).append(" color red");
                    }
                    f6 = p38.distance((T3)p317);
                    sB.append(string8).append("rotLine1 ").append(Escape.eP((T3)p317)).append(Escape.eP((T3)p313)).append(" color red");
                    sB.append(string8).append("rotLine2 ").append(Escape.eP((T3)p317)).append(Escape.eP((T3)p38)).append(" color red");
                } else if (f == 0.0f) {
                    boolean bl8;
                    string7 = string8 + "rot";
                    boolean bl9 = bl8 = p3.distance((T3)p38) < 0.2f;
                    if (!bl8) {
                        sB.append(string8).append("rotLine1 ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p312)).append(" color red");
                        sB.append(string8).append("rotLine2 ").append(Escape.eP((T3)p38)).append(Escape.eP((T3)p312)).append(" color red");
                    }
                    v32.scale(3.0f);
                    p33.scaleAdd2(-1.0f, (T3)v32, (T3)p312);
                    sB.append(string8).append("rotVector2 diameter 0.1 ").append(Escape.eP((T3)p312)).append(Escape.eP((T3)p33)).append(" color red");
                    p317.setT((T3)p312);
                    if (f == 0.0f && (double)p3.distance((T3)p38) < 0.2) {
                        p317.scaleAdd2(0.5f, (T3)p317, (T3)v32);
                    }
                } else {
                    string7 = string8 + "screw";
                    string6 = "orange";
                    sB.append(string8).append("rotLine1 ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p312)).append(" color red");
                    p33.add2((T3)p312, (T3)v32);
                    sB.append(string8).append("rotLine2 ").append(Escape.eP((T3)p38)).append(Escape.eP((T3)p33)).append(" color red");
                    p317.scaleAdd2(0.5f, (T3)v32, (T3)p312);
                }
                p33.add2((T3)p317, (T3)v32);
                if (bl && f != 0.0f) {
                    sB.append(string8).append("rotRotLine1").append(Escape.eP((T3)p317)).append(Escape.eP((T3)p313)).append(" color red");
                    sB.append(string8).append("rotRotLine2").append(Escape.eP((T3)p317)).append(Escape.eP((T3)p38)).append(" color red");
                }
                sB.append(string8).append("rotRotArrow arrow width 0.10 scale " + f6 + " arc ").append(Escape.eP((T3)p317)).append(Escape.eP((T3)p33));
                p33.setT((T3)(bl ? p313 : p3));
                if (p33.distance((T3)p38) < 0.1f) {
                    p33.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                sB.append(Escape.eP((T3)p33));
                p33.set(0.0f, (float)n2, 0.0f);
                sB.append(Escape.eP((T3)p33)).append(" color red");
                sB.append(string8).append("rotVector1 vector diameter 0.1 ").append(Escape.eP((T3)p312)).append(Escape.eP((T3)v32)).append("color ").append(string6);
            }
            if (bl7) {
                if ((double)p3.distance((T3)p315) > 0.2) {
                    sB.append(string8).append("planeVector arrow ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p315)).append(" color indigo");
                }
                string7 = string8 + "plane";
                if (v3 != null) {
                    this.drawFrameLine("X", p315, v36, 0.15f, p33, sB, string7, "red");
                    this.drawFrameLine("Y", p315, v37, 0.15f, p33, sB, string7, "green");
                    this.drawFrameLine("Z", p315, v38, 0.15f, p33, sB, string7, "blue");
                    string7 = string8 + "glide";
                }
                string6 = v3 == null ? "green" : "blue";
                v32.setT((T3)v39);
                v32.normalize();
                float f7 = -v32.x * p312.x - v32.y * p312.y - v32.z * p312.z;
                P4 p4 = P4.new4((float)v32.x, (float)v32.y, (float)v32.z, (float)f7);
                Lst lst = new Lst();
                float f8 = 1.05f;
                lst.addLast((Object)symmetryInterface.getCanonicalCopy(f8, false));
                modelSet.intersectPlane(p4, lst, 3);
                int n4 = lst.size();
                while (--n4 >= 0) {
                    P3[] p3Array = (P3[])lst.get(n4);
                    sB.append(string8).append("planep").appendI(n4).append(" ").append(Escape.eP((T3)p3Array[0])).append(Escape.eP((T3)p3Array[1]));
                    if (p3Array.length == 3) {
                        sB.append(Escape.eP((T3)p3Array[2]));
                    }
                    sB.append(" color translucent ").append(string6);
                }
                if (lst.size() == 0) {
                    p33.add2((T3)p312, (T3)v39);
                    sB.append(string8).append("planeCircle scale 2.0 circle ").append(Escape.eP((T3)p312)).append(Escape.eP((T3)p33)).append(" color translucent ").append(string6).append(" mesh fill");
                }
            }
            if (bl) {
                string7 = string8 + "inv";
                sB.append(string8).append("invPoint diameter 0.4 ").append(Escape.eP((T3)p314));
                sB.append(string8).append("invArrow arrow ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p313)).append(" color indigo");
                if (!bl6 && !bl2) {
                    this.drawFrameLine("X", p313, v36, 0.15f, p33, sB, string7, "red");
                    this.drawFrameLine("Y", p313, v37, 0.15f, p33, sB, string7, "green");
                    this.drawFrameLine("Z", p313, v38, 0.15f, p33, sB, string7, "blue");
                }
            }
            if (v3 != null) {
                if (p315 == null) {
                    p315 = P3.newP((T3)p3);
                }
                sB.append(string8).append("transVector vector ").append(Escape.eP((T3)p315)).append(Escape.eP((T3)v3));
            }
            if (bl2) {
                if (string7 != null) {
                    this.drawFrameLine("X", p38, v36, 0.15f, p33, sB, string7, "red");
                    this.drawFrameLine("Y", p38, v37, 0.15f, p33, sB, string7, "green");
                    this.drawFrameLine("Z", p38, v38, 0.15f, p33, sB, string7, "blue");
                }
                if (p32 == null) {
                    p32 = p33;
                    p33.add2((T3)p38, (T3)v35);
                }
                sB.append(string8).append("centeringVector arrow ").append(Escape.eP((T3)p38)).append(Escape.eP((T3)p32)).append(" color cyan");
            }
            p34.setT((T3)p38);
            if (bl2) {
                p34.add((T3)v35);
            }
            p33.sub2((T3)p39, (T3)p38);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p34);
            SymmetryOperation.drawLine(sB, string8 + "frame2X", 0.2f, p34, p33, "red");
            p33.sub2((T3)p310, (T3)p38);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p34);
            SymmetryOperation.drawLine(sB, string8 + "frame2Y", 0.2f, p34, p33, "green");
            p33.sub2((T3)p311, (T3)p38);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p34);
            SymmetryOperation.drawLine(sB, string8 + "frame2Z", 0.2f, p34, p33, "purple");
            sB.append("\nvar pt00 = " + Escape.eP((T3)p3));
            sB.append("\nsym_point = pt00");
            sB.append("\nvar p0 = " + Escape.eP((T3)p34));
            sB.append("\nvar set2 = within(0.2,p0);if(!set2){set2 = within(0.2,p0.uxyz.xyz)}");
            sB.append("\nsym_target = set2;if (set2) {");
            sB.append(string8).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v36)).append("*0.9} color red");
            sB.append(string8).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v37)).append("*0.9} color green");
            sB.append(string8).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v38)).append("*0.9} color purple");
            sB.append("\n}}\n");
            string4 = sB.toString();
            sB = null;
            string8 = null;
        }
        if (v3 == null) {
            v33 = null;
        }
        if (bl5 && !bl && f != 0.0f) {
            v3 = V3.newV((T3)v39);
            p33.setT((T3)v3);
            symmetryInterface.toFractional((T3)p33, false);
            v33 = V3.newV((T3)p33);
        }
        if (bl7) {
            n = 0;
        }
        if (bl) {
            if (bl6) {
                p312 = null;
                v39 = null;
                v3 = null;
                v33 = null;
            }
        } else if (bl4) {
            p312 = null;
            v39 = null;
        }
        if (v39 != null) {
            v39.normalize();
        }
        M4 m4 = null;
        m4 = M4.newM4((M4)this);
        if (bl2) {
            v34.add((T3)this.centering);
        }
        if (v34.length() != 0.0f) {
            m4.m03 += v34.x;
            m4.m13 += v34.y;
            m4.m23 += v34.z;
        }
        String string9 = this.isBio ? m4.toString() : (string5 = this.modDim > 0 ? this.xyzOriginal : SymmetryOperation.getXYZFromMatrix(m4, false, false, false));
        if (this.timeReversal != 0) {
            string5 = string5 + (this.timeReversal == 1 ? ",m+1" : ",m-1");
        }
        return new Object[]{string5, this.xyzOriginal, string2, string4, SymmetryOperation.approx0((T3)v33), SymmetryOperation.approx0((T3)v3), SymmetryOperation.approx0((T3)p314), SymmetryOperation.approx0((T3)p312), SymmetryOperation.approx0((T3)v39), n, m4, v34, this.centering};
    }

    private static void setFractional(SymmetryInterface symmetryInterface, P3 p3, T3 t3, P3 p32) {
        p3.setT(t3);
        if (p32 != null) {
            symmetryInterface.toUnitCell(p3, p32);
        }
        symmetryInterface.toFractional((T3)p3, false);
    }

    private void drawFrameLine(String string, P3 p3, V3 v3, float f, P3 p32, SB sB, String string2, String string3) {
        p32.setT((T3)p3);
        p32.add((T3)v3);
        SymmetryOperation.drawLine(sB, string2 + "Frame" + string, f, p3, p32, "translucent " + string3);
    }

    private P3 rotTransCart(P3 p3, SymmetryInterface symmetryInterface, V3 v3) {
        P3 p32 = P3.newP((T3)p3);
        symmetryInterface.toFractional((T3)p32, false);
        this.rotTrans2((T3)p32, (T3)p32);
        p32.add((T3)v3);
        symmetryInterface.toCartesian((T3)p32, false);
        return p32;
    }

    private String strCoord(T3 t3) {
        SymmetryOperation.approx0(t3);
        return this.isBio ? t3.x + " " + t3.y + " " + t3.z : SymmetryOperation.fcoord(t3);
    }

    private static void drawLine(SB sB, String string, float f, P3 p3, P3 p32, String string2) {
        sB.append(string).append(" diameter ").appendF(f).append(Escape.eP((T3)p3)).append(Escape.eP((T3)p32)).append(" color ").append(string2);
    }

    static String fcoord(T3 t3) {
        return SymmetryOperation.fc(t3.x) + " " + SymmetryOperation.fc(t3.y) + " " + SymmetryOperation.fc(t3.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    private static T3 approx0(T3 t3) {
        if (t3 != null) {
            if (Math.abs(t3.x) < 1.0E-4f) {
                t3.x = 0.0f;
            }
            if (Math.abs(t3.y) < 1.0E-4f) {
                t3.y = 0.0f;
            }
            if (Math.abs(t3.z) < 1.0E-4f) {
                t3.z = 0.0f;
            }
        }
        return t3;
    }

    private static T3 approx(T3 t3) {
        if (t3 != null) {
            t3.x = SymmetryOperation.approxF(t3.x);
            t3.y = SymmetryOperation.approxF(t3.y);
            t3.z = SymmetryOperation.approxF(t3.z);
        }
        return t3;
    }

    private static float approxF(float f) {
        return PT.approx((float)f, (float)100.0f);
    }

    public static void normalizeTranslation(M4 m4) {
        m4.m03 = ((int)m4.m03 + 12) % 12;
        m4.m13 = ((int)m4.m13 + 12) % 12;
        m4.m23 = ((int)m4.m23 + 12) % 12;
    }

    public static String getXYZFromRsVs(Matrix matrix, Matrix matrix2, boolean bl) {
        double[][] dArray = matrix.getArray();
        double[][] dArray2 = matrix2.getArray();
        int n = dArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + ",";
            for (int j = 0; j < n; ++j) {
                double d = dArray[i][j];
                if (d == 0.0) continue;
                string = string + (d < 0.0 ? "-" : (string.endsWith(",") ? "" : "+")) + (Math.abs(d) == 1.0 ? "" : "" + (int)Math.abs(d)) + "x" + (j + 1);
            }
            string = string + SymmetryOperation.xyzFraction((int)(dArray2[i][0] * (double)(bl ? 1 : 12)), false, true);
        }
        return PT.rep((String)string.substring(1), (String)",+", (String)",");
    }

    public String toString() {
        return this.rsvs == null ? super.toString() : super.toString() + " " + this.rsvs.toString();
    }

    public float getSpinOp() {
        if (this.magOp == Float.MAX_VALUE) {
            this.magOp = this.determinant3() * (float)this.timeReversal;
        }
        return this.magOp;
    }

    public void setTimeReversal(int n) {
        this.timeReversal = n;
        if (this.xyz.indexOf(",m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf(",m"));
        }
        this.xyz = this.xyz + (n == 1 ? ",m+1" : ",m-1");
    }

    public static String cleanMatrix(M4 m4) {
        SB sB = new SB();
        sB.append("[ ");
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            m4.getRow(i, fArray);
            sB.append("[ ").appendI((int)fArray[0]).append(" ").appendI((int)fArray[1]).append(" ").appendI((int)fArray[2]).append(" ");
            sB.append(SymmetryOperation.twelfthsOf(fArray[3] * 12.0f)).append(" ]");
        }
        return sB.append(" ]").toString();
    }

    public V3 setCentering(V3 v3, boolean bl) {
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.index > 1 && this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f) {
                this.centering = V3.new3((float)this.m03, (float)this.m13, (float)this.m23);
                if (this.centering.lengthSquared() == 0.0f) {
                    this.unCentered = true;
                    this.centering = null;
                } else if (!bl) {
                    this.centering.scale(0.083333336f);
                }
                this.isCenteringOp = true;
            } else {
                this.centering = v3;
            }
        }
        return this.centering;
    }
}

