/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.api.VolumeDataInterface;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class VolumeData
implements VolumeDataInterface {
    public SurfaceReader sr;
    public boolean doIterate = true;
    public final P3 volumetricOrigin = new P3();
    public final float[] origin = new float[3];
    public final V3[] volumetricVectors = new V3[3];
    public final int[] voxelCounts = new int[3];
    public int nPoints;
    private float[][][] voxelData;
    private Map<Integer, Float> voxelMap;
    public final float[] volumetricVectorLengths = new float[3];
    private float maxVectorLength;
    private float minToPlaneDistance;
    private int yzCount;
    public final V3[] unitVolumetricVectors = new V3[3];
    private final M3 volumetricMatrix = new M3();
    private final M3 inverseMatrix = new M3();
    private P4 thePlane;
    private float thePlaneNormalMag;
    private final P3 ptXyzTemp = new P3();
    public String xmlData;
    public P4 mappingPlane;
    float mappingPlaneNormalMag;
    public float minGrid;
    public float maxGrid;
    public float voxelVolume;
    private V3[] spanningVectors;
    public boolean isPeriodic;
    private boolean isSquared;
    private final V3 edgeVector = new V3();
    private P3 ptTemp = new P3();

    @Override
    public float[][][] getVoxelData() {
        return this.voxelData;
    }

    @Override
    public void setVoxelDataAsArray(float[][][] fArray) {
        this.voxelData = fArray;
        if (fArray != null) {
            this.sr = null;
        }
    }

    public boolean hasPlane() {
        return this.thePlane != null;
    }

    public VolumeData() {
        this.volumetricVectors[0] = new V3();
        this.volumetricVectors[1] = new V3();
        this.volumetricVectors[2] = new V3();
        this.unitVolumetricVectors[0] = new V3();
        this.unitVolumetricVectors[1] = new V3();
        this.unitVolumetricVectors[2] = new V3();
    }

    public void setMappingPlane(P4 p4) {
        this.mappingPlane = p4;
        if (p4 == null) {
            return;
        }
        this.mappingPlaneNormalMag = (float)Math.sqrt(p4.x * p4.x + p4.y * p4.y + p4.z * p4.z);
    }

    public float distanceToMappingPlane(T3 t3) {
        return (this.mappingPlane.x * t3.x + this.mappingPlane.y * t3.y + this.mappingPlane.z * t3.z + this.mappingPlane.w) / this.mappingPlaneNormalMag;
    }

    @Override
    public void setVolumetricOrigin(float f, float f2, float f3) {
        this.volumetricOrigin.set(f, f2, f3);
    }

    @Override
    public float[] getOriginFloat() {
        return this.origin;
    }

    public V3[] getSpanningVectors() {
        return this.spanningVectors;
    }

    public int getYzCount() {
        this.minGrid = this.volumetricVectors[0].length();
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[1].length());
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[2].length());
        this.maxGrid = this.volumetricVectors[0].length();
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[1].length());
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[2].length());
        this.nPoints = this.voxelCounts[0] * this.voxelCounts[1] * this.voxelCounts[2];
        this.yzCount = this.voxelCounts[1] * this.voxelCounts[2];
        return this.yzCount;
    }

    @Override
    public float[] getVolumetricVectorLengths() {
        return this.volumetricVectorLengths;
    }

    @Override
    public void setVolumetricVector(int n, float f, float f2, float f3) {
        this.volumetricVectors[n].x = f;
        this.volumetricVectors[n].y = f2;
        this.volumetricVectors[n].z = f3;
        this.setUnitVectors();
    }

    @Override
    public int[] getVoxelCounts() {
        return this.voxelCounts;
    }

    @Override
    public int setVoxelCounts(int n, int n2, int n3) {
        this.voxelCounts[0] = n;
        this.voxelCounts[1] = n2;
        this.voxelCounts[2] = n3;
        return n * n2 * n3;
    }

    public float getVoxelDataAt(int n) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        return this.voxelData[n2][n3][n4];
    }

    public int getPointIndex(int n, int n2, int n3) {
        return n * this.yzCount + n2 * this.voxelCounts[2] + n3;
    }

    public void getPoint(int n, P3 p3) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        this.voxelPtToXYZ(n2, n3, n4, p3);
    }

    public void setVoxelData(int n, float f) {
        int n2 = n / this.yzCount;
        int n3 = (n -= n2 * this.yzCount) / this.voxelCounts[2];
        int n4 = n - n3 * this.voxelCounts[2];
        this.voxelData[n2][n3][n4] = f;
    }

    public void setVoxelMap() {
        this.voxelMap = new Hashtable<Integer, Float>();
        this.getYzCount();
    }

    private boolean setMatrix() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricMatrix.setColumnV(i, this.volumetricVectors[i]);
        }
        try {
            this.inverseMatrix.invertM(this.volumetricMatrix);
        }
        catch (Exception exception) {
            Logger.error("VolumeData error setting matrix -- bad unit vectors? ");
            return false;
        }
        return true;
    }

    @Override
    public void transform(V3 v3, V3 v32) {
        this.volumetricMatrix.rotate2(v3, v32);
    }

    @Override
    public void setPlaneParameters(P4 p4) {
        this.thePlane = p4;
        this.thePlaneNormalMag = (float)Math.sqrt(p4.x * p4.x + p4.y * p4.y + p4.z * p4.z);
    }

    @Override
    public float calcVoxelPlaneDistance(int n, int n2, int n3) {
        this.voxelPtToXYZ(n, n2, n3, this.ptXyzTemp);
        return this.distancePointToPlane(this.ptXyzTemp);
    }

    public float getToPlaneParameter() {
        return (float)(Math.sqrt(this.thePlane.x * this.thePlane.x + this.thePlane.y * this.thePlane.y + this.thePlane.z * this.thePlane.z) * (double)this.minToPlaneDistance);
    }

    public boolean isNearPlane(int n, int n2, int n3, float f) {
        this.voxelPtToXYZ(n, n2, n3, this.ptXyzTemp);
        return this.thePlane.x * this.ptXyzTemp.x + this.thePlane.y * this.ptXyzTemp.y + this.thePlane.z * this.ptXyzTemp.z + this.thePlane.w < f;
    }

    @Override
    public float distancePointToPlane(T3 t3) {
        return (this.thePlane.x * t3.x + this.thePlane.y * t3.y + this.thePlane.z * t3.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    @Override
    public void voxelPtToXYZ(int n, int n2, int n3, T3 t3) {
        t3.scaleAdd2(n, this.volumetricVectors[0], this.volumetricOrigin);
        t3.scaleAdd2(n2, this.volumetricVectors[1], t3);
        t3.scaleAdd2(n3, this.volumetricVectors[2], t3);
    }

    public boolean setUnitVectors() {
        int n;
        this.maxVectorLength = 0.0f;
        this.voxelVolume = 1.0f;
        for (n = 0; n < 3; ++n) {
            this.volumetricVectorLengths[n] = this.volumetricVectors[n].length();
            float f = this.volumetricVectorLengths[n];
            if (f == 0.0f) {
                return false;
            }
            if (f > this.maxVectorLength) {
                this.maxVectorLength = f;
            }
            this.voxelVolume *= f;
            this.unitVolumetricVectors[n].setT(this.volumetricVectors[n]);
            this.unitVolumetricVectors[n].normalize();
        }
        this.minToPlaneDistance = this.maxVectorLength * 2.0f;
        this.origin[0] = this.volumetricOrigin.x;
        this.origin[1] = this.volumetricOrigin.y;
        this.origin[2] = this.volumetricOrigin.z;
        this.spanningVectors = new V3[4];
        this.spanningVectors[0] = V3.newV(this.volumetricOrigin);
        for (n = 0; n < 3; ++n) {
            V3 v3 = new V3();
            this.spanningVectors[n + 1] = v3;
            V3 v32 = v3;
            v32.scaleAdd2(this.voxelCounts[n] - 1, this.volumetricVectors[n], v32);
        }
        return this.setMatrix();
    }

    @Override
    public void xyzToVoxelPt(float f, float f2, float f3, T3i t3i) {
        this.ptXyzTemp.set(f, f2, f3);
        this.ptXyzTemp.sub(this.volumetricOrigin);
        this.inverseMatrix.rotate(this.ptXyzTemp);
        t3i.set(Math.round(this.ptXyzTemp.x), Math.round(this.ptXyzTemp.y), Math.round(this.ptXyzTemp.z));
    }

    @Override
    public float lookupInterpolatedVoxelValue(T3 t3, boolean bl) {
        if (this.mappingPlane != null) {
            return this.distanceToMappingPlane(t3);
        }
        if (this.sr != null) {
            float f = this.sr.getValueAtPoint(t3, bl);
            return this.isSquared ? f * f : f;
        }
        this.ptXyzTemp.sub2(t3, this.volumetricOrigin);
        this.inverseMatrix.rotate(this.ptXyzTemp);
        int n = this.voxelCounts[0] - 1;
        int n2 = this.indexLower(this.ptXyzTemp.x, n);
        int n3 = this.indexUpper(this.ptXyzTemp.x, n2, n);
        n = this.voxelCounts[1] - 1;
        int n4 = this.indexLower(this.ptXyzTemp.y, n);
        int n5 = this.indexUpper(this.ptXyzTemp.y, n4, n);
        n = this.voxelCounts[2] - 1;
        int n6 = this.indexLower(this.ptXyzTemp.z, n);
        int n7 = this.indexUpper(this.ptXyzTemp.z, n6, n);
        float f = VolumeData.getFractional2DValue(this.mantissa(this.ptXyzTemp.x - (float)n2), this.mantissa(this.ptXyzTemp.y - (float)n4), this.getVoxelValue(n2, n4, n6), this.getVoxelValue(n3, n4, n6), this.getVoxelValue(n2, n5, n6), this.getVoxelValue(n3, n5, n6));
        float f2 = VolumeData.getFractional2DValue(this.mantissa(this.ptXyzTemp.x - (float)n2), this.mantissa(this.ptXyzTemp.y - (float)n4), this.getVoxelValue(n2, n4, n7), this.getVoxelValue(n3, n4, n7), this.getVoxelValue(n2, n5, n7), this.getVoxelValue(n3, n5, n7));
        return f + this.mantissa(this.ptXyzTemp.z - (float)n6) * (f2 - f);
    }

    private float mantissa(float f) {
        return this.isPeriodic ? f - (float)Math.floor(f) : f;
    }

    public float getVoxelValue(int n, int n2, int n3) {
        if (this.voxelMap == null) {
            return this.voxelData[n][n2][n3];
        }
        Float f = this.voxelMap.get(this.getPointIndex(n, n2, n3));
        return f == null ? Float.NaN : f.floatValue();
    }

    public static float getFractional2DValue(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f3 + f * (f4 - f3);
        float f8 = f5 + f * (f6 - f5);
        return f7 + f2 * (f8 - f7);
    }

    private int indexLower(float f, int n) {
        if (this.isPeriodic && n > 0) {
            while (f < 0.0f) {
                f += (float)n;
            }
            while (f >= (float)n) {
                f -= (float)n;
            }
            return (int)Math.floor(f);
        }
        if (f < 0.0f) {
            return 0;
        }
        int n2 = (int)Math.floor(f);
        return n2 > n ? n : n2;
    }

    private int indexUpper(float f, int n, int n2) {
        return !this.isPeriodic && f < 0.0f || n == n2 ? n : n + 1;
    }

    void offsetCenter(P3 p3) {
        P3 p32 = new P3();
        p32.scaleAdd2((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], p32);
        p32.scaleAdd2((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], p32);
        p32.scaleAdd2((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], p32);
        this.volumetricOrigin.sub2(p3, p32);
    }

    @Override
    public void setDataDistanceToPlane(P4 p4) {
        this.setPlaneParameters(p4);
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        this.voxelData = new float[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.voxelData[i][j][k] = this.calcVoxelPlaneDistance(i, j, k);
                }
            }
        }
    }

    @Override
    public void filterData(boolean bl, float f) {
        int n;
        int n2;
        int n3;
        boolean bl2;
        boolean bl3 = bl2 = !Float.isNaN(f);
        if (this.sr != null) {
            this.isSquared = bl;
            return;
        }
        int n4 = this.voxelCounts[0];
        int n5 = this.voxelCounts[1];
        int n6 = this.voxelCounts[2];
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        float[] fArray = this.voxelData[n3][n2];
                        int n7 = n;
                        fArray[n7] = fArray[n7] * this.voxelData[n3][n2][n];
                    }
                }
            }
        }
        if (bl2) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        this.voxelData[n3][n2][n] = f - this.voxelData[n3][n2][n];
                    }
                }
            }
        }
    }

    @Override
    public void capData(P4 p4, float f) {
        if (this.voxelData == null) {
            return;
        }
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        V3 v3 = V3.new3(p4.x, p4.y, p4.z);
        v3.normalize();
        float f2 = 1.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float f3 = this.voxelData[i][j][k] - f;
                    this.voxelPtToXYZ(i, j, k, this.ptXyzTemp);
                    float f4 = (this.ptXyzTemp.x * v3.x + this.ptXyzTemp.y * v3.y + this.ptXyzTemp.z * v3.z + p4.w - f) / f2;
                    if (!(f4 >= 0.0f) && !(f4 > f3)) continue;
                    this.voxelData[i][j][k] = f4;
                }
            }
        }
    }

    public String setVolumetricXml() {
        SB sB = new SB();
        if (this.voxelCounts[0] == 0) {
            sB.append("<jvxlVolumeData>\n");
        } else {
            sB.append("<jvxlVolumeData origin=\"" + Escape.eP(this.volumetricOrigin) + "\">\n");
            for (int i = 0; i < 3; ++i) {
                sB.append("<jvxlVolumeVector type=\"" + i + "\" count=\"" + this.voxelCounts[i] + "\" vector=\"" + Escape.eP(this.volumetricVectors[i]) + "\"></jvxlVolumeVector>\n");
            }
        }
        sB.append("</jvxlVolumeData>\n");
        this.xmlData = sB.toString();
        return this.xmlData;
    }

    public void setVoxelMapValue(int n, int n2, int n3, float f) {
        if (this.voxelMap == null) {
            return;
        }
        this.voxelMap.put(this.getPointIndex(n, n2, n3), Float.valueOf(f));
    }

    public float calculateFractionalPoint(float f, P3 p3, P3 p32, float f2, float f3, P3 p33) {
        float f4;
        float f5;
        float f6 = f3 - f2;
        float f7 = (f - f2) / f6;
        this.edgeVector.sub2(p32, p3);
        p33.scaleAdd2(f7, this.edgeVector, p3);
        if (this.sr == null || !this.doIterate || f3 == f2 || f7 < 0.01f || f7 > 0.99f || this.edgeVector.length() < 0.01f) {
            return f;
        }
        int n = 0;
        this.ptTemp.setT(p33);
        float f8 = this.lookupInterpolatedVoxelValue(this.ptTemp, false);
        float f9 = Float.NaN;
        while (!(++n >= 10 || (f5 = (f8 - f2) / f6) < 0.0f || f5 > 1.0f || (f7 += (f4 = (f - f8) / f6 / 2.0f)) < 0.0f || f7 > 1.0f)) {
            p33.setT(this.ptTemp);
            f9 = f8;
            if (Math.abs(f4) < 0.005f) break;
            this.ptTemp.scaleAdd2(f4, this.edgeVector, p33);
            f8 = this.lookupInterpolatedVoxelValue(this.ptTemp, false);
        }
        return f9;
    }
}

