/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.export.___Exporter;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.GData;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class Export3D
implements JmolRendererInterface {
    protected ___Exporter exporter;
    private double privateKey;
    private GData g3d;
    private short colix;
    private HermiteRenderer hermite3d;
    private int width;
    private int height;
    private int slab;
    String exportName;
    private boolean isWebGL;
    private P3 ptA = new P3();
    private P3 ptB = new P3();
    private P3 ptC = new P3();
    private P3 ptD = new P3();
    private P3i ptAi = new P3i();
    private P3i ptBi = new P3i();

    @Override
    public Object initializeExporter(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.exportName = (String)map.get("type");
        this.isWebGL = this.exportName.equals("JS");
        this.exporter = (___Exporter)Interface.getOption("export." + (this.isWebGL ? "" : "_") + this.exportName + "Exporter");
        if (this.exporter == null) {
            return null;
        }
        this.g3d = gData;
        this.exporter.setRenderer(this);
        this.g3d.setNewWindowParametersForExport();
        this.slab = this.g3d.getSlab();
        this.width = this.g3d.getRenderWidth();
        this.height = this.g3d.getRenderHeight();
        this.privateKey = d;
        return this.initializeOutput(viewer, d, this.g3d, map) ? this.exporter : null;
    }

    @Override
    public boolean initializeOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        return this.exporter.initializeOutput(viewer, d, this.g3d, map);
    }

    @Override
    public int getExportType() {
        return this.exporter.exportType;
    }

    @Override
    public String getExportName() {
        return this.exportName;
    }

    @Override
    public String finalizeOutput() {
        return this.exporter.finalizeOutput();
    }

    @Override
    public void setSlab(int n) {
        this.slab = n;
        this.g3d.setSlab(n);
    }

    @Override
    public void setDepth(int n) {
        this.g3d.setDepth(n);
    }

    @Override
    public void renderBackground(JmolRendererInterface jmolRendererInterface) {
        if (this.exporter.exportType == 2) {
            this.g3d.renderBackground(jmolRendererInterface);
        }
    }

    @Override
    public void drawAtom(Atom atom) {
        this.exporter.drawAtom(atom);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isWebGL) {
            return;
        }
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n + i, n2, n3);
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n, n2 + i, n3);
        }
    }

    @Override
    public void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.exporter.drawFilledCircle(s, s2, n, n2, n3, n4);
    }

    public void drawCircle(short s, int n, int n2, int n3, int n4, boolean bl) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.exporter.drawCircle(n2, n3, n4, n, s, bl);
    }

    @Override
    public void fillSphereXYZ(int n, int n2, int n3, int n4) {
        this.ptA.set(n2, n3, n4);
        this.fillSphere(n, this.ptA);
    }

    @Override
    public void fillSphereI(int n, P3i p3i) {
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.fillSphere(n, this.ptA);
    }

    @Override
    public void fillSphere(int n, P3 p3) {
        if (n == 0) {
            return;
        }
        this.exporter.fillSphere(this.colix, n, p3);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.ptA.set(n, n2, n3);
        this.ptB.set(n + n5, n2, n3);
        this.ptC.set(n + n5, n2 + n6, n3);
        this.ptD.set(n, n2 + n6, n3);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD);
    }

    @Override
    public void drawString(String string, Font font, int n, int n2, int n3, int n4, short s) {
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font, n, n2, n3, s);
    }

    @Override
    public void drawStringNoSlab(String string, Font font, int n, int n2, int n3, short s) {
        if (string == null) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        if (font == null) {
            font = this.g3d.getFont3DCurrent();
        } else {
            this.g3d.setFont(font);
        }
        this.exporter.plotText(n, n2, n3, this.colix, string, font);
    }

    @Override
    public void drawImage(Object object, int n, int n2, int n3, int n4, short s, int n5, int n6) {
        if (object == null || n5 == 0 || n6 == 0) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        this.exporter.plotImage(n, n2, n3, object, s, n5, n6);
    }

    @Override
    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.isClipped(n, n2, n3)) {
            return;
        }
        this.exporter.drawPixel(this.colix, n, n2, n3, 1);
    }

    @Override
    public void plotPixelClippedP3i(P3i p3i) {
        if (this.isClipped(p3i.x, p3i.y, p3i.z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, p3i.x, p3i.y, p3i.z, 1);
    }

    @Override
    public void drawPoints(int n, int[] nArray, int n2) {
        int n3 = n * 3;
        while (n3 > 0) {
            int n4;
            int n5;
            int n6 = nArray[--n3];
            --n3;
            if (this.isClipped(n5 = nArray[--n3], n4 = nArray[n3], n6)) continue;
            this.exporter.drawPixel(this.colix, n5, n4, n6, n2);
        }
    }

    @Override
    public void drawDashedLine(int n, int n2, P3i p3i, P3i p3i2) {
        this.drawLineAB(p3i, p3i2);
    }

    @Override
    public void drawDottedLine(P3i p3i, P3i p3i2) {
        this.drawLineAB(p3i, p3i2);
    }

    @Override
    public void drawLineXYZ(int n, int n2, int n3, int n4, int n5, int n6) {
        this.ptAi.set(n, n2, n3);
        this.ptBi.set(n4, n5, n6);
        this.drawLineAB(this.ptAi, this.ptBi);
    }

    @Override
    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillCylinderXYZ(s, s2, (byte)2, this.exporter.lineWidthMad, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawLineAB(P3i p3i, P3i p3i2) {
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, this.ptA, this.ptB);
    }

    @Override
    public void drawBond(P3 p3, P3 p32, short s, short s2, byte by, short s3, int n) {
        if (s3 == 1) {
            s3 = this.exporter.lineWidthMad;
        }
        this.exporter.drawCylinder(p3, p32, s, s2, by, s3, n);
    }

    @Override
    public void fillCylinderXYZ(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ptA.set(n2, n3, n4);
        this.ptB.set(n5, n6, n7);
        this.exporter.drawCylinder(this.ptA, this.ptB, s, s2, by, n, 1);
    }

    @Override
    public void fillCylinderScreen(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ptA.set(n2, n3, n4);
        this.ptB.set(n5, n6, n7);
        this.exporter.fillCylinderScreen(this.colix, by, n, this.ptA, this.ptB, null, null, 0.0f);
    }

    @Override
    public void fillCylinderScreen3I(byte by, int n, P3i p3i, P3i p3i2, P3 p3, P3 p32, float f) {
        if (n <= 0) {
            return;
        }
        if (!this.exporter.isCartesian) {
            this.ptA.set(p3i.x, p3i.y, p3i.z);
            this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        }
        this.exporter.fillCylinderScreen(this.colix, by, n, this.ptA, this.ptB, p3, p32, f);
    }

    @Override
    public void fillCylinder(byte by, int n, P3i p3i, P3i p3i2) {
        if (n <= 0) {
            return;
        }
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.exporter.fillCylinderScreenMad(this.colix, by, n, this.ptA, this.ptB);
    }

    @Override
    public void fillCylinderBits(byte by, int n, P3 p3, P3 p32) {
        if (n <= 0) {
            return;
        }
        this.exporter.fillCylinderScreenMad(this.colix, by, n, p3, p32);
    }

    @Override
    public void fillConeScreen(byte by, int n, P3i p3i, P3i p3i2, boolean bl) {
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.exporter.fillConeScreen(this.colix, by, n, this.ptA, this.ptB, bl);
    }

    @Override
    public void fillConeSceen3f(byte by, int n, P3 p3, P3 p32) {
        this.exporter.fillConeScreen(this.colix, by, n, p3, p32, false);
    }

    @Override
    public void drawHermite4(int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.hermite3d.renderHermiteRope(false, n, 0, 0, 0, p3i, p3i2, p3i3, p3i4);
    }

    @Override
    public void fillHermite(int n, int n2, int n3, int n4, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.hermite3d.renderHermiteRope(true, n, n2, n3, n4, p3i, p3i2, p3i3, p3i4);
    }

    @Override
    public void drawTriangle3C(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(s, s2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    @Override
    public void drawTriangle3I(P3i p3i, P3i p3i2, P3i p3i3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(this.colix, this.colix, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(this.colix, this.colix, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(this.colix, this.colix, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    @Override
    public void fillTriangle3CN(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6) {
        if (s != s3 || s3 != s5) {
            return;
        }
        this.ptA.set(p3i.x, p3i.y, p3i.z);
        this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
        this.ptC.set(p3i3.x, p3i3.y, p3i3.z);
        this.exporter.fillTriangle(s, this.ptA, this.ptB, this.ptC, false, false);
    }

    @Override
    public void fillTriangleTwoSided(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.ptA.set(n, n2, n3);
        this.ptB.set(n4, n5, n6);
        this.ptC.set(n7, n8, n9);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC, true, false);
    }

    @Override
    public void fillTriangle3f(P3 p3, P3 p32, P3 p33, boolean bl) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, false, false);
    }

    @Override
    public void fillTriangle3i(P3i p3i, P3i p3i2, P3i p3i3, P3 p3, P3 p32, P3 p33) {
        if (this.exporter.isCartesian) {
            this.exporter.fillTriangle(this.colix, p3, p32, p33, true, true);
        } else {
            this.ptA.set(p3i.x, p3i.y, p3i.z);
            this.ptB.set(p3i2.x, p3i2.y, p3i2.z);
            this.ptC.set(p3i3.x, p3i3.y, p3i3.z);
            this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC, true, false);
        }
    }

    @Override
    public void fillTriangle(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6, float f) {
        this.fillTriangle3CN(p3i, s, s2, p3i2, s3, s4, p3i3, s5, s6);
    }

    @Override
    public void drawQuadrilateral(short s, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.setC(s);
        this.drawLineAB(p3i, p3i2);
        this.drawLineAB(p3i2, p3i3);
        this.drawLineAB(p3i3, p3i4);
        this.drawLineAB(p3i4, p3i);
    }

    @Override
    public void fillQuadrilateral(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.exporter.fillTriangle(this.colix, p3, p32, p33, false, false);
        this.exporter.fillTriangle(this.colix, p3, p33, p34, false, false);
    }

    @Override
    public void fillQuadrilateral3i(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6, P3i p3i4, short s7, short s8) {
        this.fillTriangle3CN(p3i, s, s2, p3i2, s3, s4, p3i3, s5, s6);
        this.fillTriangle3CN(p3i, s, s2, p3i3, s5, s6, p3i4, s7, s8);
    }

    @Override
    public void drawSurface(MeshSurface meshSurface, short s) {
        this.exporter.drawSurface(meshSurface, s);
    }

    @Override
    public short[] getBgColixes(short[] sArray) {
        return this.exporter.exportType == 1 ? null : sArray;
    }

    @Override
    public void fillEllipsoid(P3 p3, P3[] p3Array, int n, int n2, int n3, int n4, M3 m3, double[] dArray, M4 m4, int n5, P3i[] p3iArray) {
        this.exporter.fillEllipsoid(p3, p3Array, this.colix, n, n2, n3, n4, m3, dArray, m4, p3iArray);
    }

    @Override
    public boolean drawEllipse(P3 p3, P3 p32, P3 p33, boolean bl, boolean bl2) {
        return this.exporter.drawEllipse(p3, p32, p33, this.colix, bl);
    }

    @Override
    public GData getGData() {
        return this.g3d;
    }

    @Override
    public boolean isAntialiased() {
        return false;
    }

    @Override
    public boolean checkTranslucent(boolean bl) {
        return true;
    }

    @Override
    public boolean haveTranslucentObjects() {
        return true;
    }

    @Override
    public void setColor(int n) {
        this.g3d.setColor(n);
    }

    @Override
    public int getRenderWidth() {
        return this.g3d.getRenderWidth();
    }

    @Override
    public int getRenderHeight() {
        return this.g3d.getRenderHeight();
    }

    @Override
    public boolean isPass2() {
        return this.g3d.isPass2();
    }

    @Override
    public int getSlab() {
        return this.g3d.getSlab();
    }

    @Override
    public int getDepth() {
        return this.g3d.getDepth();
    }

    @Override
    public boolean setC(short s) {
        this.colix = s;
        this.g3d.setC(s);
        return true;
    }

    @Override
    public void setFontFid(byte by) {
        this.g3d.setFontFid(by);
    }

    @Override
    public Font getFont3DCurrent() {
        return this.g3d.getFont3DCurrent();
    }

    @Override
    public boolean isInDisplayRange(int n, int n2) {
        if (this.exporter.exportType == 1) {
            return true;
        }
        return this.g3d.isInDisplayRange(n, n2);
    }

    @Override
    public boolean isClippedZ(int n) {
        return this.g3d.isClippedZ(n);
    }

    public int clipCode(int n, int n2, int n3) {
        return this.exporter.exportType == 1 ? this.g3d.clipCode(n3) : this.g3d.clipCode3(n, n2, n3);
    }

    @Override
    public boolean isClippedXY(int n, int n2, int n3) {
        if (this.exporter.exportType == 1) {
            return false;
        }
        return this.g3d.isClippedXY(n, n2, n3);
    }

    public boolean isClipped(int n, int n2, int n3) {
        return this.g3d.isClippedZ(n3) || this.isClipped(n, n2);
    }

    protected boolean isClipped(int n, int n2) {
        if (this.exporter.exportType == 1) {
            return false;
        }
        return this.g3d.isClipped(n, n2);
    }

    @Override
    public int getColorArgbOrGray(short s) {
        return this.g3d.getColorArgbOrGray(s);
    }

    @Override
    public void setNoisySurfaceShade(P3i p3i, P3i p3i2, P3i p3i3) {
        this.g3d.setNoisySurfaceShade(p3i, p3i2, p3i3);
    }

    @Override
    public byte getFontFidFS(String string, float f) {
        return this.g3d.getFontFidFS(string, f);
    }

    @Override
    public boolean isDirectedTowardsCamera(short s) {
        return this.g3d.isDirectedTowardsCamera(s);
    }

    @Override
    public V3[] getTransformedVertexVectors() {
        return this.g3d.getTransformedVertexVectors();
    }

    @Override
    public Font getFont3DScaled(Font font, float f) {
        return this.g3d.getFont3DScaled(font, f);
    }

    @Override
    public byte getFontFid(float f) {
        return this.g3d.getFontFid(f);
    }

    @Override
    public void setTranslucentCoverOnly(boolean bl) {
    }

    public double getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void volumeRender4(int n, int n2, int n3, int n4) {
        this.fillSphereXYZ(n, n2, n3, n4);
    }

    @Override
    public boolean currentlyRendering() {
        return false;
    }

    @Override
    public void renderCrossHairs(int[] nArray, int n, int n2, P3 p3, float f) {
    }

    @Override
    public void volumeRender(boolean bl) {
    }

    @Override
    public boolean getTranslucentCoverOnly() {
        return this.g3d.getTranslucentCoverOnly();
    }

    @Override
    public void addRenderer(int n) {
        if (n == 553648147) {
            this.hermite3d = (HermiteRenderer)new HermiteRenderer().set(this);
        }
    }

    @Override
    public void setAmbientOcclusion(int n) {
    }

    @Override
    public void plotImagePixel(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isWebGL) {
            return;
        }
        n4 = Math.max(this.slab, n4);
        if (n5 != 0) {
            int n7 = n5 == 8 ? 255 : (8 - n5 << 4) + (8 - n5);
            n = n & 0xFFFFFF | n7 << 24;
        }
        this.exporter.drawTextPixel(n, n2, n3, n4);
    }

    @Override
    public void drawHermite7(boolean bl, boolean bl2, int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4, P3i p3i5, P3i p3i6, P3i p3i7, P3i p3i8, int n2, short s) {
        if (s == 0 || this.isWebGL) {
            this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, 0);
            return;
        }
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, 1);
        short s2 = this.colix;
        this.setC(s);
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, -1);
        this.setC(s2);
    }

    @Override
    public void renderAllStrings(Object object) {
        if (this.isWebGL) {
            return;
        }
        this.g3d.renderAllStrings(this);
    }
}

