/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class NWChemReader
extends MOReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;
    private Lst<String> atomTypes;
    private Map<String, Lst<String>> htMOs = new Hashtable<String, Lst<String>>();
    int nBasisFunctions;
    private static String DS_LIST = "d2-   d1-   d0    d1+   d2+";
    private static String FS_LIST = "f3-   f2-   f1-   f0    f1+   f2+   f3+";
    private static String DC_LIST = "DXX   DXY   DXZ   DYY   DYZ   DZZ";
    private static String FC_LIST = "XXX   XXY   XXZ   XYY   XYZ   XZZ   YYY   YYZ   YZZ   ZZZ";
    int moCount;
    private boolean purging;

    @Override
    protected void initializeReader() {
        this.calculationType = "(NWCHEM)";
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.trim().startsWith("NWChem")) {
            boolean bl = this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
            if (this.inInput) {
                this.checkMOs();
            }
        }
        if (this.line.startsWith("          Step")) {
            this.init();
            return true;
        }
        if (this.line.indexOf("  wavefunction    = ") >= 0) {
            this.calculationType = this.line.substring(this.line.indexOf("=") + 1).trim() + "(NWCHEM)";
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("Total") >= 0) {
            this.readTotal();
            return true;
        }
        if (this.line.indexOf("@") >= 0) {
            this.readAtSign();
            return true;
        }
        if (this.line.startsWith(" Task  times")) {
            this.init();
            ++this.taskNumber;
            return true;
        }
        if (this.line.startsWith("      Optimization converged")) {
            this.converged = true;
            return true;
        }
        if (this.line.startsWith("      Symmetry information")) {
            this.readSymmetry();
            return true;
        }
        if (this.line.indexOf("Output coordinates in ") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            this.readAtoms();
            return true;
        }
        if (this.line.indexOf("Vibrational analysis") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("ENERGY GRADIENTS") >= 0) {
            ++this.equivalentAtomSets;
            this.readGradients();
            return true;
        }
        if (this.line.startsWith("  Mulliken analysis of the total density")) {
            if (this.equivalentAtomSets != 0) {
                this.readPartialCharges();
            }
            return true;
        }
        if (this.line.contains("Basis \"ao basis\"") && this.doReadMolecularOrbitals) {
            return this.readBasis();
        }
        if (this.line.contains("Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets != 0) {
                this.readMOs();
            }
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeReader() throws Exception {
        this.checkMOs();
        this.finalizeReaderASCR();
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String string, String string2, int n) {
        this.energyKey = string;
        this.energyValue = string2;
        this.asc.setAtomSetPropertyForSets(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.asc.setAtomSetNames(this.energyKey + " = " + this.energyValue, this.equivalentAtomSets, null);
        this.asc.setAtomSetEnergy(string2, this.parseFloatStr(string2));
        this.haveEnergy = true;
    }

    private void setEnergy(String string, String string2) {
        this.energyKey = string;
        this.energyValue = string2;
        this.asc.setAtomSetModelProperty(this.energyKey, this.energyValue);
        this.asc.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        String[] stringArray = NWChemReader.getTokensStr(this.readLines(3));
        this.asc.setAtomSetPropertyForSets("Symmetry group name", stringArray[stringArray.length - 1], this.equivalentAtomSets);
    }

    private void readTotal() {
        String[] stringArray = this.getTokens();
        try {
            if (stringArray[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + stringArray[1] + ")", stringArray[stringArray.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S' && this.readLines(2) == null) {
            return;
        }
        String[] stringArray = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", stringArray[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.asc.setAtomSetPropertyForSets("Step", stringArray[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void readAtoms() throws Exception {
        String[] stringArray;
        float f = this.line.indexOf("angstroms") < 0 ? 0.5291772f : 1.0f;
        this.readLines(3);
        this.haveEnergy = false;
        this.asc.newAtomSet();
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        this.atomTypes = new Lst();
        while (this.rd() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 6) {
            String string;
            this.setAtomCoordScaled(null, (String[])stringArray, (int)3, (float)f).atomName = string = this.fixTag(stringArray[1]);
            this.atomTypes.addLast(string);
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.asc.setAtomSetModelProperty("Step", "converged");
        } else if (this.inInput) {
            this.asc.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        String[] stringArray;
        this.readLines(3);
        this.asc.newAtomSet();
        if (this.equivalentAtomSets > 1) {
            this.asc.cloneLastAtomSetProperties();
        }
        this.asc.setAtomSetModelProperty("vector", "gradient");
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        while (this.rd() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 8) {
            Atom atom = this.setAtomCoordScaled(null, stringArray, 2, 0.5291772f);
            atom.atomName = this.fixTag(stringArray[1]);
            this.asc.addVibrationVector(atom.index, -this.parseFloatStr(stringArray[5]), -this.parseFloatStr(stringArray[6]), -this.parseFloatStr(stringArray[7]));
        }
    }

    private void readFrequencies() throws Exception {
        int n;
        int n2;
        int n3;
        String[] stringArray;
        int n4 = this.asc.atomSetCount;
        String string = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.readLines(2);
        this.asc.newAtomSet();
        while (this.rd() != null && this.line.indexOf("---") < 0) {
            stringArray = this.getTokens();
            this.setAtomCoordScaled(null, (String[])stringArray, (int)2, (float)0.5291772f).atomName = this.fixTag(stringArray[0]);
        }
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.readLines(3);
        boolean bl = true;
        while (this.rd() != null && this.line.indexOf("P.Frequency") >= 0) {
            stringArray = NWChemReader.getTokensAt(this.line, 12);
            n3 = stringArray.length;
            n2 = this.asc.ac;
            n = this.asc.getLastAtomSetAtomCount();
            if (bl) {
                n2 -= n;
            }
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl2 = blArray[i] = stringArray[i].equals("0.00") || !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                if (!bl) {
                    this.asc.cloneLastAtomSet();
                }
                bl = false;
                this.asc.setAtomSetFrequency(string, null, stringArray[i], null);
            }
            this.readLines(1);
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 0);
            this.readLines(3);
        }
        try {
            this.discardLinesUntilContains("Projected Infra Red Intensities");
            this.readLines(2);
            n3 = this.vibrationNumber;
            n2 = n4;
            while (--n3 >= 0) {
                if (this.rd() == null) {
                    return;
                }
                if (!this.doGetVibration(n3 + 1)) continue;
                stringArray = this.getTokens();
                n = this.asc.iSet;
                this.asc.iSet = n2++;
                this.asc.setAtomSetFrequency(null, null, stringArray[n3], null);
                this.asc.setAtomSetModelProperty("IRIntensity", stringArray[5] + " KM/mol");
                this.asc.iSet = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readPartialCharges() throws Exception {
        this.readLines(4);
        int n = this.asc.ac;
        int n2 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.asc.atoms;
        for (int i = n2; i < n; ++i) {
            String[] stringArray;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            do {
                if (this.rd() != null && this.line.length() >= 3) continue;
                return;
            } while ((stringArray = this.getTokens())[0].indexOf(".") >= 0);
            atomArray[i].partialCharge = (float)this.parseIntStr(stringArray[2]) - this.parseFloatStr(stringArray[3]);
        }
    }

    private String fixTag(String string) {
        if (string.equalsIgnoreCase("bq")) {
            return "X";
        }
        if (string.toLowerCase().startsWith("bq")) {
            string = string.substring(2) + "-Bq";
        }
        return "" + Character.toUpperCase(string.charAt(0)) + (string.length() == 1 ? "" : "" + Character.toLowerCase(string.charAt(1)));
    }

    private boolean readBasis() throws Exception {
        int n;
        Object[] objectArray;
        int n2;
        boolean bl;
        this.gaussianCount = 0;
        this.shellCount = 0;
        this.nBasisFunctions = 0;
        boolean bl2 = bl = this.line.indexOf("cartesian") >= 0;
        if (bl) {
            this.getDFMap(DC_LIST, JmolAdapter.SHELL_D_CARTESIAN, CANONICAL_DC_LIST, 3);
            this.getDFMap(FC_LIST, JmolAdapter.SHELL_F_CARTESIAN, CANONICAL_FC_LIST, 3);
        } else {
            this.getDFMap(DS_LIST, JmolAdapter.SHELL_D_SPHERICAL, CANONICAL_DS_LIST, 2);
            this.getDFMap(FS_LIST, JmolAdapter.SHELL_F_SPHERICAL, CANONICAL_FS_LIST, 2);
        }
        this.shells = new Lst();
        Hashtable hashtable = new Hashtable();
        String string = null;
        Lst<Lst> lst = null;
        Lst lst2 = null;
        while (this.line != null) {
            n2 = 0;
            while (this.line.length() < 3 || this.line.charAt(2) == ' ') {
                lst2 = new Lst();
                this.rd();
                if (this.line.length() >= 3) continue;
                ++n2;
            }
            if (n2 >= 2) break;
            if (this.parseIntStr(this.line) == Integer.MIN_VALUE) {
                string = this.getTokens()[0];
                if (string.length() > 2) {
                    string = JmolAdapter.getElementSymbol(Elements.elementNumberFromName(string));
                }
                lst = new Lst<Lst>();
                hashtable.put(string, lst);
                this.rd();
                this.rd();
                continue;
            }
            while (this.line != null && this.line.length() > 3) {
                String[] stringArray = this.getTokens();
                objectArray = new Object[]{stringArray[1], new float[]{this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3])}};
                lst2.addLast(objectArray);
                this.rd();
            }
            lst.addLast(lst2);
        }
        n2 = bl ? 6 : 5;
        int n3 = bl ? 10 : 7;
        objectArray = new Lst();
        for (n = 0; n < this.atomTypes.size(); ++n) {
            lst = (Lst<Lst>)hashtable.get(this.atomTypes.get(n));
            int n4 = lst.size();
            for (int i = 0; i < n4; ++i) {
                ++this.shellCount;
                lst2 = (Lst)lst.get(i);
                int n5 = lst2.size();
                String string2 = (String)((Object[])lst2.get(0))[0];
                switch (string2.charAt(0)) {
                    case 'S': {
                        ++this.nBasisFunctions;
                        break;
                    }
                    case 'P': {
                        this.nBasisFunctions += 3;
                        break;
                    }
                    case 'D': {
                        this.nBasisFunctions += n2;
                        break;
                    }
                    case 'F': {
                        this.nBasisFunctions += n3;
                    }
                }
                int[] nArray = new int[]{n, bl ? JmolAdapter.getQuantumShellTagID(string2) : JmolAdapter.getQuantumShellTagIDSpherical(string2), this.gaussianCount, n5};
                this.shells.addLast(nArray);
                for (int j = 0; j < n5; ++j) {
                    objectArray.addLast((float[])((Object[])lst2.get(j))[1]);
                }
                this.gaussianCount += n5;
            }
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = (float[])objectArray.get(n);
        }
        Logger.info(this.gaussianCount + " Gaussians read");
        return true;
    }

    private boolean readMOs() throws Exception {
        Lst<String> lst = new Lst<String>();
        this.htMOs.put(this.line, lst);
        lst.addLast(this.line);
        int n = 0;
        while (n != 2 && this.rd() != null) {
            lst.addLast(this.line);
            if (this.line.length() < 2) {
                ++n;
                continue;
            }
            n = 0;
        }
        return true;
    }

    private void checkMOs() throws Exception {
        if (this.shells == null) {
            return;
        }
        block0: for (Map.Entry<String, Lst<String>> entry : this.htMOs.entrySet()) {
            this.line = entry.getKey();
            this.alphaBeta = this.line.substring(0, this.line.indexOf("Final")).trim() + " ";
            int n = 0;
            if (!this.filterMO()) continue;
            Lst<String> lst = entry.getValue();
            int n2 = lst.size();
            Logger.info(this.line);
            for (int i = 3; i < n2; ++i) {
                while (i < n2 && ((this.line = (String)lst.get(i)).length() < 2 || this.line.charAt(1) != 'V')) {
                    ++i;
                }
                if (i == n2) continue block0;
                this.line = this.line.replace('=', ' ');
                String[] stringArray = this.getTokens();
                float f = this.parseFloatStr(stringArray[3]);
                float f2 = this.parseFloatStr(stringArray[5]);
                String string = stringArray.length > 7 ? stringArray[7] : null;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("occupancy", Float.valueOf(f));
                hashtable.put("energy", Float.valueOf(f2));
                if (string != null) {
                    hashtable.put("symmetry", string);
                }
                float[] fArray = null;
                this.setMO(hashtable);
                hashtable.put("type", this.alphaBeta + ++n);
                fArray = new float[this.nBasisFunctions];
                hashtable.put("coefficients", fArray);
                i += 3;
                while ((this.line = (String)lst.get(++i)) != null && this.line.length() > 3) {
                    stringArray = this.getTokens();
                    fArray[this.parseIntStr((String)stringArray[0]) - 1] = this.parseFloatStr(stringArray[1]);
                    int n3 = stringArray.length / 2;
                    if (n3 != 5 && n3 != 6) continue;
                    fArray[this.parseIntStr((String)stringArray[n3]) - 1] = this.parseFloatStr(stringArray[n3 + 1]);
                }
            }
        }
        this.energyUnits = "a.u.";
        this.setMOData(true);
        this.shells = null;
        this.htMOs.clear();
    }

    @Override
    public String rd() throws Exception {
        this.RL();
        if (!this.purging && this.line != null && this.line.startsWith("--")) {
            this.purging = true;
            this.discardLinesUntilStartsWith("*");
            this.rd();
            this.purging = false;
            this.RL();
        }
        return this.line;
    }
}

