/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dipole {
    String thisID = "";
    public short mad;
    public short colix = 0;
    short type;
    public P3 origin;
    public P3 center;
    public V3 vector;
    String dipoleInfo = "";
    public float dipoleValue;
    boolean isUserValue;
    public float offsetSide;
    public float offsetAngstroms;
    public P3 offsetPt;
    int offsetPercent;
    public int visibilityFlags;
    int modelIndex;
    boolean visible;
    public boolean noCross;
    boolean haveAtoms;
    boolean isValid;
    public Atom[] atoms = new Atom[2];
    P3[] coords = new P3[2];
    public Bond bond;
    public BS bsMolecule;
    public Lst<Object> lstDipoles;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole() {
    }

    Dipole(int n, String string, String string2, short s, short s2, boolean bl) {
        this.modelIndex = n;
        this.thisID = string;
        this.dipoleInfo = string2;
        this.colix = s;
        this.mad = s2;
        this.visible = bl;
        this.type = 0;
    }

    void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3((short)this.colix, (boolean)bl, (float)f);
    }

    void set(Dipole dipole) {
        this.thisID = dipole.thisID;
        this.dipoleInfo = dipole.dipoleInfo;
        this.dipoleValue = dipole.dipoleValue;
        this.mad = dipole.mad;
        this.lstDipoles = dipole.lstDipoles;
        if (this.lstDipoles != null) {
            this.isValid = true;
        }
        this.offsetAngstroms = dipole.offsetAngstroms;
        this.offsetPercent = dipole.offsetPercent;
        this.offsetSide = dipole.offsetSide;
        this.vector = V3.newV((T3)dipole.vector);
        this.origin = P3.newP((T3)dipole.origin);
        if (dipole.offsetPt != null) {
            this.origin.add((T3)dipole.offsetPt);
            this.offsetPt = P3.newP((T3)dipole.offsetPt);
        }
        this.bsMolecule = dipole.bsMolecule;
        boolean bl = this.haveAtoms = dipole.atoms[0] != null;
        if (this.haveAtoms) {
            this.atoms[0] = dipole.atoms[0];
            this.atoms[1] = dipole.atoms[1];
            this.centerDipole();
        } else {
            this.center = null;
        }
    }

    private void set2(P3 p3, P3 p32) {
        this.coords[0] = P3.newP((T3)p3);
        this.coords[1] = P3.newP((T3)p32);
        boolean bl = this.isValid = this.coords[0].distance((T3)this.coords[1]) > 0.1f;
        if (this.dipoleValue < 0.0f) {
            this.origin = P3.newP((T3)p32);
            this.vector = V3.newV((T3)p3);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = P3.newP((T3)p3);
            this.vector = V3.newV((T3)p32);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub((T3)this.origin);
        if (this.dipoleValue == 0.0f) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void setValue(float f) {
        float f2 = this.dipoleValue;
        this.dipoleValue = f;
        if (f == 0.0f) {
            this.isValid = false;
        }
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (f2 * this.dipoleValue < 0.0f) {
            this.origin.sub((T3)this.vector);
        }
    }

    void set2Value(P3 p3, P3 p32, float f) {
        this.dipoleValue = f;
        this.atoms[0] = null;
        this.set2(p3, p32);
    }

    void setPtVector(P3 p3, V3 v3) {
        this.setValue(v3.length());
        P3 p32 = P3.newP((T3)p3);
        p32.add((T3)v3);
        this.set2(p3, p32);
        this.type = (short)5;
    }

    void set2AtomValue(Atom atom, Atom atom2, float f) {
        this.setValue(f);
        this.set2((P3)atom, (P3)atom2);
        this.offsetSide = 0.4f;
        this.mad = (short)5;
        this.atoms[0] = atom;
        this.atoms[1] = atom2;
        this.haveAtoms = true;
        this.centerDipole();
    }

    void centerDipole() {
        boolean bl = this.isValid = this.atoms[0] != this.atoms[1] && this.dipoleValue != 0.0f;
        if (!this.isValid) {
            return;
        }
        float f = this.atoms[0].distance((T3)this.atoms[1]) / (2.0f * this.dipoleValue) - 0.5f;
        this.origin.scaleAdd2(f, (T3)this.vector, (T3)this.atoms[0]);
        this.center = new P3();
        this.center.scaleAdd2(0.5f, (T3)this.vector, (T3)this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }

    public String getShapeState() {
        if (!this.isValid) {
            return "";
        }
        SB sB = new SB();
        sB.append("dipole ID ").append(this.thisID);
        if (this.lstDipoles != null) {
            sB.append(" all ").append(Escape.eBS((BS)this.bsMolecule));
        } else if (this.haveAtoms) {
            sB.append(" ({").appendI(this.atoms[0].i).append("}) ({").appendI(this.atoms[1].i).append("})");
        } else {
            if (this.coords[0] == null) {
                return "";
            }
            sB.append(" ").append(Escape.eP((T3)this.coords[0])).append(" ").append(Escape.eP((T3)this.coords[1]));
        }
        if (this.isUserValue) {
            sB.append(" value ").appendF(this.dipoleValue);
        }
        if (this.mad != 5) {
            sB.append(" width ").appendF((float)this.mad / 1000.0f);
        }
        if (this.offsetAngstroms != 0.0f) {
            sB.append(" offset ").appendF(this.offsetAngstroms);
        } else if (this.offsetPercent != 0) {
            sB.append(" offset ").appendI(this.offsetPercent);
        }
        if (this.offsetSide != 0.4f) {
            sB.append(" offsetSide ").appendF(this.offsetSide);
        }
        if (this.offsetPt != null) {
            sB.append(" offset ").append(Escape.eP((T3)this.offsetPt));
        }
        if (this.noCross) {
            sB.append(" nocross");
        }
        if (!this.visible) {
            sB.append(" off");
        }
        sB.append(";\n");
        return sB.toString();
    }

    public void setOffsetPt(P3 p3) {
        if (this.offsetPt != null) {
            this.origin.sub((T3)this.offsetPt);
        }
        this.offsetPt = p3;
        this.origin.add((T3)p3);
    }
}

