/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.exception.JSVException;
import org.jmol.util.Logger;

public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    public static Map<String, String> htCorrelationCache;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static String nciResolver;
    private static String nmrdbServer;
    private static int stringCount;

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string, null);
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2);
                sB.appendC('\n');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return sB.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForData(Object object) {
        return object == null ? null : new BufferedReader(new StringReader(object instanceof String ? (String)object : new String((byte[])object)));
    }

    public static BufferedReader getBufferedReaderFromName(String string, String string2) throws JSVException {
        if (string == null) {
            throw new JSVException("Cannot find " + string);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + string);
        String string3 = JSVFileManager.getFullPathName(string);
        if (!string3.equals(string)) {
            Logger.info("JSVFileManager getBufferedReaderFromName " + string3);
        }
        return JSVFileManager.getUnzippedBufferedReaderFromName(string3, string2);
    }

    public static String getFullPathName(String string) throws JSVException {
        try {
            if (appletDocumentBase == null) {
                if (JSVFileManager.isURL(string)) {
                    URL uRL = new URL((URL)null, string, null);
                    return uRL.toString();
                }
                return JSVFileManager.viewer.apiPlatform.newFile(string).getFullPath();
            }
            if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                string = "file:///" + string;
            } else if (string.startsWith("cache://")) {
                return string;
            }
            URL uRL = new URL(appletDocumentBase, string, null);
            return uRL.toString();
        }
        catch (Exception exception) {
            throw new JSVException("Cannot create path for " + string);
        }
    }

    public static boolean isURL(String string) {
        int n = urlPrefixes.length;
        while (--n >= 0) {
            if (!string.startsWith(urlPrefixes[n])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = JSVFileManager.urlTypeIndex(string);
        return n < 0 || n == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String string, String string2) throws JSVException {
        String[] stringArray = null;
        if (string.indexOf("|") >= 0 && (stringArray = PT.split(string, "|")) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getSimulationReader(string);
        }
        try {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream = JSVFileManager.getInputStream(string, true, null);
            if (inputStream instanceof SB || inputStream instanceof String) {
                return new BufferedReader(new StringReader(inputStream.toString()));
            }
            if (JSVFileManager.isAB(inputStream)) {
                return new BufferedReader(new StringReader(new String((byte[])inputStream)));
            }
            InputStream inputStream2 = bufferedInputStream = new BufferedInputStream(inputStream);
            if (JSVFileManager.isZipFile(bufferedInputStream)) {
                return ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newJSVZipFileSequentialReader(inputStream2, stringArray, string2);
            }
            if (JSVFileManager.isGzip(bufferedInputStream)) {
                inputStream2 = ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newGZIPInputStream(inputStream2);
            }
            return new BufferedReader(new InputStreamReader(inputStream2, "UTF-8"));
        }
        catch (Exception exception) {
            throw new JSVException("Cannot read file " + string + " " + exception);
        }
    }

    public static String getAbbrSimulationFileName(String string) {
        String string2;
        String string3 = JSVFileManager.getAbbreviatedSimulationName(string, true);
        if (string.indexOf("MOL=") >= 0 && (string2 = htCorrelationCache.get(string)) != null) {
            htCorrelationCache.put(string3, string2);
        }
        return string3;
    }

    static String getAbbreviatedSimulationName(String string, boolean bl) {
        return string.indexOf("MOL=") >= 0 ? (bl ? SIMULATION_PROTOCOL : "") + "MOL=" + JSVFileManager.getSimulationHash(string) : string;
    }

    private static String getSimulationHash(String string) {
        return "" + Math.abs(string.substring(string.indexOf("V2000") + 1).hashCode());
    }

    public static String getSimulationFileData(String string) {
        return htCorrelationCache.get(string.startsWith("MOL=") ? string.substring(4) : JSVFileManager.getAbbreviatedSimulationName(string, false));
    }

    private static BufferedReader getSimulationReader(String string) {
        String string2 = htCorrelationCache.get(string);
        if (string2 == null && (string2 = JSVFileManager.getNMRSimulationJCampDX(string.substring(SIMULATION_PROTOCOL.length()))) != null) {
            htCorrelationCache.put(string, string2);
        }
        return JSVFileManager.getBufferedReaderForData(string2);
    }

    public static boolean isAB(Object object) {
        return object instanceof byte[];
    }

    public static boolean isZipFile(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    private static boolean isGzip(InputStream inputStream) throws JSVException {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(5);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            return n == 4 && byArray[0] == 31 && byArray[1] == -117;
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OC oC) throws JSVException {
        try {
            byte[] byArray = new byte[1024];
            byte[] byArray2 = oC == null ? new byte[4096] : null;
            int n = 0;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                n2 += n;
                if (oC == null) {
                    if (n2 >= byArray2.length) {
                        byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
                    }
                    System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                    continue;
                }
                oC.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            if (oC == null) {
                return AU.arrayCopyByte(byArray2, n2);
            }
            return n2 + " bytes";
        }
        catch (Exception exception) {
            throw new JSVException(exception.toString());
        }
    }

    public static String postByteArray(String string, byte[] byArray) {
        Object object = null;
        try {
            object = JSVFileManager.getInputStream(string, false, byArray);
        }
        catch (Exception exception) {
            object = exception.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = JSVFileManager.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (JSVException jSVException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object == null ? "" : JSVFileManager.fixUTF((byte[])object);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = JSVFileManager.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (IOException iOException) {
                Logger.error("fixUTF error " + iOException);
            }
        }
        return new String(byArray);
    }

    public static InputStream getInputStream(String string, boolean bl, byte[] byArray) throws JSVException {
        int n;
        boolean bl2 = JSVFileManager.isURL(string);
        boolean bl3 = appletDocumentBase != null;
        Object object = null;
        String string2 = null;
        if (bl2 && (n = string.indexOf("?POST?")) >= 0) {
            string2 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        if (bl3 || bl2) {
            URL uRL;
            try {
                uRL = new URL(appletDocumentBase, string, null);
            }
            catch (Exception exception) {
                throw new JSVException("Cannot read " + string);
            }
            Logger.info("JSVFileManager opening URL " + uRL + (string2 == null ? "" : " with POST of " + string2.length() + " bytes"));
            object = JSVFileManager.viewer.apiPlatform.getURLContents(uRL, byArray, string2, false);
        } else {
            if (bl) {
                Logger.info("JSVFileManager opening file " + string);
            }
            object = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(string);
        }
        if (object instanceof String) {
            throw new JSVException((String)object);
        }
        return (InputStream)object;
    }

    private static String getNMRSimulationJCampDX(String string) {
        String string2 = "" + JSVFileManager.getSimulationHash(string);
        String string3 = htCorrelationCache.get(string2);
        if (string3 != null) {
            return string3;
        }
        boolean bl = string.startsWith("MOL=");
        String string4 = bl ? null : PT.rep(nciResolver, "%FILE", PT.escapeUrl(string));
        String string5 = bl ? PT.rep(string.substring(4), "\\n", "\n") : JSVFileManager.getFileAsString(string4);
        if (string5 == null) {
            Logger.info("no data returned");
        }
        String string6 = JSVFileManager.getFileAsString(nmrdbServer + string5);
        htCorrelationCache.put("json", string6);
        Logger.debug(string6);
        if (string6.indexOf("\"error\":") >= 0) {
            return null;
        }
        string6 = PT.rep(string6, "\\r\\n", "\n");
        string6 = PT.rep(string6, "\\t", "\t");
        string6 = PT.rep(string6, "\\n", "\n");
        String string7 = JSVFileManager.getQuotedJSONAttribute(string6, "molfile", null);
        htCorrelationCache.put("mol", string7);
        System.out.println("jsonMolFile is " + string7);
        viewer.syncScript("JSVSTR:" + string7);
        String string8 = JSVFileManager.getQuotedJSONAttribute(string6, "xml", null);
        string8 = PT.rep(string8, "<Signals>", "<Signals src=" + PT.esc(PT.rep(nmrdbServer, "?POST?molfile=", "")) + ">");
        string8 = PT.rep(string8, "</", "\n</");
        string8 = PT.rep(string8, "><", ">\n<");
        string8 = PT.rep(string8, "\\\"", "\"");
        htCorrelationCache.put("xml", string8);
        string3 = JSVFileManager.getQuotedJSONAttribute(string6, "jcamp", null);
        string3 = "##TITLE=" + (bl ? "JMOL SIMULATION" : string) + "\n" + string3.substring(string3.indexOf("\n##") + 1);
        int n = string5.indexOf("\n");
        n = string5.indexOf("\n", n + 1);
        if (n > 0 && n == string5.indexOf("\n \n")) {
            string5 = string5.substring(0, n + 1) + "Created " + JSVFileManager.viewer.apiPlatform.getDateFormat("8824") + " by JSpecView " + JSVersion.VERSION + string5.substring(n + 1);
        }
        n = 0;
        n = string3.indexOf("##.");
        String string9 = JSVFileManager.getAbbreviatedSimulationName(string, false);
        int n2 = string9.indexOf("id='");
        if (bl && n2 > 0) {
            string9 = string9.substring(n2 + 4, (string9 + "'").indexOf("'", n2 + 4));
        }
        string3 = string3.substring(0, n) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + PT.esc(string9) + " type=\"MOL\" src=" + PT.esc(string4) + ">\n" + string5 + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + string8 + "\n" + string3.substring(n);
        htCorrelationCache.put("jcamp", string3);
        htCorrelationCache.put(string2, string3);
        return string3;
    }

    private static URL getResource(Object object, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = object.getClass().getResource(string);
            if (uRL == null) {
                stringArray[0] = "Couldn't find file: " + string;
            }
        }
        catch (Exception exception) {
            stringArray[0] = "Exception " + exception + " in getResource " + string;
        }
        return uRL;
    }

    public static String getResourceString(Object object, String string, String[] stringArray) {
        URL uRL = JSVFileManager.getResource(object, string, stringArray);
        if (uRL == null) {
            stringArray[0] = "Error loading resource " + string;
            return null;
        }
        if (uRL instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)uRL));
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent(), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
        }
        return sB.toString();
    }

    public static String getJmolFilePath(String string) {
        try {
            string = JSVFileManager.getFullPathName(string);
        }
        catch (JSVException jSVException) {
            return null;
        }
        return appletDocumentBase == null ? string.replace('\\', '/') : string;
    }

    public static String getTagName(String string) {
        if (string == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(string)) {
            try {
                if (string.startsWith(SIMULATION_PROTOCOL)) {
                    return JSVFileManager.getAbbrSimulationFileName(string);
                }
                String string2 = new URL((URL)null, string, null).getFile();
                return string2.substring(string2.lastIndexOf(47) + 1);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return JSVFileManager.viewer.apiPlatform.newFile(string).getName();
    }

    public static String getQuotedJSONAttribute(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = string2;
        }
        string2 = "\"" + string2 + "\":";
        string3 = "\"" + string3 + "\":";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n);
        return n < 0 || n2 < 0 ? null : PT.getQuotedStringAt(string, n2 + string3.length());
    }

    public static void setDocumentBase(JSViewer jSViewer, URL uRL) {
        viewer = jSViewer;
        appletDocumentBase = uRL;
    }

    static {
        jsDocumentBase = "";
        htCorrelationCache = new Hashtable<String, String>();
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        nciResolver = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServer = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
    }
}

