/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    V3 widthUnitVector;
    V3 heightUnitVector;

    Sheet(AlphaPolymer alphaPolymer, int n, int n2, STR sTR) {
        this.setupPS(alphaPolymer, STR.SHEET, n, n2);
        this.subtype = sTR;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.nRes == 2) {
            this.axisA = this.apolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.apolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes - 1, this.axisB);
        }
        this.axisUnitVector = new V3();
        this.axisUnitVector.sub2((T3)this.axisB, (T3)this.axisA);
        this.axisUnitVector.normalize();
        P3 p3 = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst, p3);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis((P3)p3, (P3)this.axisA, (V3)this.axisUnitVector, (V3)this.vectorProjection);
        }
        P3 p32 = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes, p32);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis((P3)p32, (P3)this.axisA, (V3)this.axisUnitVector, (V3)this.vectorProjection);
        }
        this.axisA = p3;
        this.axisB = p32;
    }

    void calcSheetUnitVectors() {
        if (!(this.apolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            V3 v3 = new V3();
            V3 v32 = new V3();
            AminoMonomer aminoMonomer = (AminoMonomer)this.apolymer.monomers[this.monomerIndexFirst];
            v32.sub2((T3)aminoMonomer.getCarbonylOxygenAtom(), (T3)aminoMonomer.getCarbonylCarbonAtom());
            int n = this.nRes;
            while (--n > this.monomerIndexFirst) {
                aminoMonomer = (AminoMonomer)this.apolymer.monomers[n];
                v3.sub2((T3)aminoMonomer.getCarbonylOxygenAtom(), (T3)aminoMonomer.getCarbonylCarbonAtom());
                if (v32.angle(v3) < 1.5707964f) {
                    v32.add((T3)v3);
                    continue;
                }
                v32.sub((T3)v3);
            }
            this.heightUnitVector = v3;
            this.heightUnitVector.cross((T3)this.axisUnitVector, (T3)v32);
            this.heightUnitVector.normalize();
            this.widthUnitVector = v32;
            this.widthUnitVector.cross((T3)this.axisUnitVector, (T3)this.heightUnitVector);
        }
    }

    public V3 getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    public V3 getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

