/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;

public class AminoMonomer
extends AlphaMonomer {
    private static final byte CA = 0;
    private static final byte O = 1;
    private static final byte N = 2;
    private static final byte C = 3;
    private static final byte OT = 4;
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -5, 1, 3, -65};
    boolean nhChecked = false;
    private static final float beta = 0.29670596f;
    private P3 ptTemp;

    protected AminoMonomer() {
    }

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        byte[] byArray = AminoMonomer.scanForOffsets(n2, nArray, interestingAminoAtomIDs);
        if (byArray == null) {
            return null;
        }
        AminoMonomer.checkOptional(byArray, (byte)1, n2, nArray[5]);
        if (atomArray[n2].isHetero() && !AminoMonomer.isBondedCorrectly(n2, byArray, atomArray)) {
            return null;
        }
        return new AminoMonomer().set2(chain, string, n, n2, n3, byArray);
    }

    private static boolean isBondedCorrectlyRange(int n, int n2, int n3, byte[] byArray, Atom[] atomArray) {
        int n4 = n3 + (byArray[n] & 0xFF);
        int n5 = n3 + (byArray[n2] & 0xFF);
        return n4 != n5 && atomArray[n4].isBonded(atomArray[n5]);
    }

    private static boolean isBondedCorrectly(int n, byte[] byArray, Atom[] atomArray) {
        return AminoMonomer.isBondedCorrectlyRange(2, 0, n, byArray, atomArray) && AminoMonomer.isBondedCorrectlyRange(0, 3, n, byArray, atomArray) && (!AminoMonomer.have(byArray, (byte)1) || AminoMonomer.isBondedCorrectlyRange(3, 1, n, byArray, atomArray));
    }

    boolean isAminoMonomer() {
        return true;
    }

    public Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    public Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    @Override
    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    @Override
    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(AminoMonomer.have(this.offsets, (byte)4) ? 4 : 3);
    }

    boolean hasOAtom() {
        return AminoMonomer.have(this.offsets, (byte)1);
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        AminoMonomer aminoMonomer = (AminoMonomer)monomer;
        return aminoMonomer.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    @Override
    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        Atom atom;
        int n3;
        Atom atom2 = atomArray[0];
        Atom atom3 = this.getNitrogenAtom();
        int n4 = s / 2;
        if (n4 < 1200) {
            n4 = 1200;
        }
        if (atom3.sZ == 0) {
            return;
        }
        int n5 = (int)this.scaleToScreen(atom3.sZ, n4);
        if (n5 < 4) {
            n5 = 4;
        }
        Atom atom4 = this.getCarbonylCarbonAtom();
        int n6 = s2 / 2;
        if (n6 < 1200) {
            n6 = 1200;
        }
        if ((n3 = (int)this.scaleToScreen(atom3.sZ, n6)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom = this.getLeadAtom(), n, n2, (n5 + n3) / 2, atom2) || this.isCursorOnTopOf(atom3, n, n2, n5, atom2) || this.isCursorOnTopOf(atom4, n, n2, n3, atom2)) {
            atomArray[0] = atom;
        }
    }

    public void resetHydrogenPoint() {
        this.nhChecked = false;
        this.nitrogenHydrogenPoint = null;
    }

    P3 getNitrogenHydrogenPoint() {
        if (this.nitrogenHydrogenPoint == null && !this.nhChecked) {
            this.nhChecked = true;
            this.nitrogenHydrogenPoint = this.getExplicitNH();
        }
        return this.nitrogenHydrogenPoint;
    }

    public P3 getExplicitNH() {
        Atom atom = this.getNitrogenAtom();
        Atom atom2 = null;
        Bond[] bondArray = atom.getBonds();
        if (bondArray == null) {
            return null;
        }
        for (int i = 0; i < bondArray.length; ++i) {
            atom2 = bondArray[i].getOtherAtom(atom);
            if (atom2.getElementNumber() != 1) continue;
            return atom2;
        }
        return null;
    }

    public boolean getNHPoint(P3 p3, V3 v3, boolean bl, boolean bl2) {
        if (this.monomerIndex == 0 || this.groupID == 15) {
            return false;
        }
        Atom atom = this.getNitrogenAtom();
        P3 p32 = this.getNitrogenHydrogenPoint();
        if (p32 != null && !bl2) {
            v3.sub2((T3)p32, (T3)atom);
            p3.setT((T3)p32);
            return true;
        }
        AminoMonomer aminoMonomer = (AminoMonomer)this.bioPolymer.monomers[this.monomerIndex - 1];
        if (bl) {
            v3.sub2((T3)atom, (T3)this.getLeadAtom());
            v3.normalize();
            V3 v32 = V3.newVsub((T3)atom, (T3)aminoMonomer.getCarbonylCarbonAtom());
            v32.normalize();
            v3.add((T3)v32);
        } else {
            Atom atom2 = aminoMonomer.getCarbonylOxygenAtom();
            if (atom2 == null) {
                return false;
            }
            v3.sub2((T3)aminoMonomer.getCarbonylCarbonAtom(), (T3)atom2);
        }
        v3.normalize();
        p3.add2((T3)atom, (T3)v3);
        this.nitrogenHydrogenPoint = P3.newP((T3)p3);
        if (Logger.debugging) {
            Logger.debug((String)("draw ID \"pta" + this.monomerIndex + "_" + atom.i + "\" " + Escape.eP((T3)atom) + Escape.eP((T3)p3) + " # " + atom));
        }
        return true;
    }

    @Override
    P3 getQuaternionFrameCenter(char c) {
        switch (c) {
            default: {
                return this.getQuaternionFrameCenterAlpha(c);
            }
            case 'n': {
                return this.getNitrogenAtom();
            }
            case 'P': 
            case 'p': {
                return this.getCarbonylCarbonAtom();
            }
            case 'q': 
        }
        if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
            return null;
        }
        AminoMonomer aminoMonomer = (AminoMonomer)this.bioPolymer.getGroups()[this.monomerIndex + 1];
        P3 p3 = new P3();
        p3.ave((T3)this.getCarbonylCarbonAtom(), (T3)aminoMonomer.getNitrogenAtom());
        return p3;
    }

    @Override
    public Quat getQuaternion(char c) {
        Atom atom = this.getCarbonylCarbonAtom();
        Atom atom2 = this.getLeadAtom();
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = null;
        switch (c) {
            case 'a': 
            case 'n': {
                if (this.monomerIndex == 0 || this.groupID == 15) {
                    return null;
                }
                v33 = new V3();
                if (this.ptTemp == null) {
                    this.ptTemp = new P3();
                }
                this.getNHPoint(this.ptTemp, v33, true, false);
                v32.sub2((T3)atom2, (T3)this.getNitrogenAtom());
                v32.cross((T3)v33, (T3)v32);
                new M3().setAA(A4.newVA((V3)v32, (float)-0.29670596f)).rotate((T3)v33);
                v3.cross((T3)v32, (T3)v33);
                break;
            }
            case 'b': {
                return this.getQuaternionAlpha('b');
            }
            case 'c': {
                v3.sub2((T3)atom, (T3)atom2);
                v32.sub2((T3)this.getNitrogenAtom(), (T3)atom2);
                break;
            }
            case 'p': 
            case 'x': {
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                v3.sub2((T3)atom2, (T3)atom);
                v32.sub2((T3)((AminoMonomer)this.bioPolymer.getGroups()[this.monomerIndex + 1]).getNitrogenAtom(), (T3)atom);
                break;
            }
            case 'q': {
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                AminoMonomer aminoMonomer = (AminoMonomer)this.bioPolymer.getGroups()[this.monomerIndex + 1];
                v32.sub2((T3)aminoMonomer.getLeadAtom(), (T3)aminoMonomer.getNitrogenAtom());
                v3.sub2((T3)atom2, (T3)atom);
                break;
            }
            default: {
                return null;
            }
        }
        return Quat.getQuaternionFrameV((V3)v3, (V3)v32, (V3)v33, (boolean)false);
    }

    @Override
    public String getStructureId() {
        if (this.proteinStructure == null || this.proteinStructure.structureID == null) {
            return "";
        }
        return this.proteinStructure.structureID;
    }

    public String getProteinStructureTag() {
        if (this.proteinStructure == null || this.proteinStructure.structureID == null) {
            return null;
        }
        String string = "%3N %3ID";
        string = Txt.formatStringI((String)string, (String)"N", (int)this.proteinStructure.serialID);
        string = Txt.formatStringS((String)string, (String)"ID", (String)this.proteinStructure.structureID);
        if (this.proteinStructure.type == STR.SHEET) {
            string = string + Txt.formatStringI((String)"%2SC", (String)"SC", (int)this.proteinStructure.strandCount);
        }
        return string;
    }

    public BS getBSSideChain() {
        BS bS = new BS();
        this.selectAtoms(bS);
        this.clear(bS, this.getLeadAtom(), true);
        this.clear(bS, this.getCarbonylCarbonAtom(), false);
        this.clear(bS, this.getCarbonylOxygenAtom(), false);
        this.clear(bS, this.getNitrogenAtom(), true);
        return bS;
    }

    private void clear(BS bS, Atom atom, boolean bl) {
        if (atom == null) {
            return;
        }
        bS.clear(atom.i);
        if (!bl) {
            return;
        }
        Bond[] bondArray = atom.getBonds();
        int n = bondArray.length;
        while (--n >= 0) {
            Atom atom2 = bondArray[n].getOtherAtom(atom);
            if (atom2.getElementNumber() != 1) continue;
            bS.clear(atom2.i);
        }
    }
}

