/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesGenerator {
    private Node[] atoms;
    private int ac;
    private BS bsSelected;
    private BS bsAromatic;
    private boolean explicitH;
    private SB ringSets;
    private VTemp vTemp = new VTemp();
    private int nPairs;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private Node prevAtom;
    private Node[] prevSp2Atoms;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsIncludingH;

    String getSmiles(Node[] nodeArray, int n, BS bS, boolean bl) throws InvalidSmilesException {
        int n2 = bS.nextSetBit(0);
        if (n2 < 0) {
            return "";
        }
        this.atoms = nodeArray;
        this.ac = n;
        this.bsSelected = bS = BSUtil.copy(bS);
        this.explicitH = bl;
        return this.getSmilesComponent(nodeArray[n2], bS, false);
    }

    /*
     * Unable to fully structure code
     */
    String getBioSmiles(BNode[] var1_1, int var2_2, BS var3_3, boolean var4_4, boolean var5_5, String var6_6) throws InvalidSmilesException {
        this.atoms = var1_1;
        this.ac = var2_2;
        var7_7 = new SB();
        var8_8 = BSUtil.copy(var3_3);
        if (var6_6 != null) {
            var7_7.append("//* Jmol bioSMILES ").append(var6_6.replace('*', '_')).append(" *//");
        }
        var9_9 = "\n";
        var10_10 = new BS();
        var11_11 = null;
        var13_12 = new Lst<Integer>();
        try {
            var14_13 = 0;
            var15_15 = var8_8.nextSetBit(0);
            while (var15_15 >= 0) {
                var16_17 = var1_1[var15_15];
                var17_18 = var16_17.getGroup1('?');
                var18_19 = var16_17.getBioStructureTypeName();
                var19_20 = var17_18.equals("?");
                if (var9_9 == null) ** GOTO lbl49
                if (var7_7.length() > 0) {
                    var7_7.append(var9_9);
                }
                var9_9 = null;
                var14_13 = 0;
                if (var18_19.length() <= 0) {
                    var12_16 = this.getSmilesComponent(var16_17, var8_8, true);
                    if (var12_16.equals(var11_11)) {
                        var9_9 = "";
                    } else {
                        var11_11 = var12_16;
                        var20_22 = var16_17.getGroup3(true);
                        if (var20_22 != null) {
                            var7_7.append("//* ").append(var20_22).append(" *//");
                        }
                        var7_7.append(var12_16);
                        var9_9 = ".\n";
                    }
                } else {
                    var20_21 = var16_17.getChainID();
                    if (var20_21 != 0) {
                        var12_16 = "//* chain " + var16_17.getChainIDStr() + " " + var18_19 + " " + var16_17.getResno() + " *// ";
                        var14_13 = var12_16.length();
                        var7_7.append(var12_16);
                    }
                    var7_7.append("~").appendC(var18_19.charAt(0)).append("~");
                    ++var14_13;
lbl49:
                    // 2 sources

                    if (var14_13 >= 75) {
                        var7_7.append("\n  ");
                        var14_13 = 2;
                    }
                    if (var19_20) {
                        this.addBracketedBioName(var7_7, var16_17, var18_19.length() > 0 ? ".0" : null);
                    } else {
                        var7_7.append(var17_18);
                    }
                    ++var14_13;
                    var20_21 = var16_17.getOffsetResidueAtom("0", 0);
                    if (var5_5) {
                        var16_17.getCrossLinkLeadAtomIndexes(var13_12);
                        for (var21_23 = 0; var21_23 < var13_12.size(); ++var21_23) {
                            var7_7.append(":");
                            var12_16 = this.getRingCache(var20_21, (Integer)var13_12.get(var21_23), this.htRingsSequence);
                            var7_7.append(var12_16);
                            var14_13 += 1 + var12_16.length();
                        }
                        var13_12.clear();
                    }
                    var16_17.getGroupBits(var10_10);
                    var8_8.andNot(var10_10);
                    var21_23 = var16_17.getOffsetResidueAtom("0", 1);
                    if (var21_23 < 0 || !var8_8.get(var21_23)) {
                        var7_7.append(" //* ").appendI(var16_17.getResno()).append(" *//");
                        if (var21_23 < 0 && (var21_23 = var8_8.nextSetBit(var15_15 + 1)) < 0) break;
                        if (var14_13 > 0) {
                            var9_9 = ".\n";
                        }
                    }
                    var15_15 = var21_23 - 1;
                }
                var15_15 = var8_8.nextSetBit(var15_15 + 1);
            }
        }
        catch (Exception var14_14) {
            throw new InvalidSmilesException("//* error: " + var14_14.getMessage() + " *//");
        }
        if (!var4_4 && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(var7_7, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        var12_16 = var7_7.toString();
        if (var12_16.endsWith(".\n")) {
            var12_16 = var12_16.substring(0, var12_16.length() - 2);
        }
        return var12_16;
    }

    private void addBracketedBioName(SB sB, Node node, String string) {
        sB.append("[");
        if (string != null && node instanceof BNode) {
            BNode bNode = (BNode)node;
            String string2 = bNode.getChainIDStr();
            sB.append(bNode.getGroup3(false));
            if (!string.equals(".0")) {
                sB.append(string).append("#").appendI(bNode.getElementNumber());
            }
            sB.append("//* ").appendI(bNode.getResno());
            if (string2.length() > 0) {
                sB.append(":").append(string2);
            }
            sB.append(" *//");
        } else {
            sB.append(Elements.elementNameFromNumber(node.getElementNumber()));
        }
        sB.append("]");
    }

    private String getSmilesComponent(Node node, BS bS, boolean bl) throws InvalidSmilesException {
        if (!this.explicitH && node.getElementNumber() == 1 && node.getEdges().length > 0) {
            node = this.atoms[node.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet(this.atoms, node.getIndex(), BSUtil.copy(bS), null, -1, true, false);
        bS.andNot(this.bsSelected);
        this.bsIncludingH = BSUtil.copy(this.bsSelected);
        if (!this.explicitH) {
            int n = this.bsSelected.nextSetBit(0);
            while (n >= 0) {
                Node node2 = this.atoms[n];
                if (node2.getElementNumber() == 1 && node2.getIsotopeNumber() == 0) {
                    this.bsSelected.clear(n);
                }
                n = this.bsSelected.nextSetBit(n + 1);
            }
        }
        if (this.bsSelected.cardinality() > 2) {
            SmilesSearch smilesSearch = null;
            smilesSearch = SmilesParser.getMolecule("A[=&@]A", true);
            smilesSearch.jmolAtoms = this.atoms;
            if (this.atoms instanceof BNode[]) {
                smilesSearch.bioAtoms = (BNode[])this.atoms;
            }
            smilesSearch.setSelected(this.bsSelected);
            smilesSearch.jmolAtomCount = this.ac;
            smilesSearch.ringDataMax = 7;
            smilesSearch.setRingData(null);
            this.bsAromatic = smilesSearch.bsAromatic;
            this.ringSets = smilesSearch.ringSets;
            this.setBondDirections();
        } else {
            this.bsAromatic = new BS();
        }
        this.bsToDo = BSUtil.copy(this.bsSelected);
        SB sB = new SB();
        int n = this.bsToDo.nextSetBit(0);
        while (n >= 0) {
            if (this.atoms[n].getCovalentBondCount() > 4) {
                this.getSmiles(sB, this.atoms[n], bl, false, this.explicitH);
                node = null;
            }
            n = this.bsToDo.nextSetBit(n + 1);
        }
        if (node != null) {
            while ((node = this.getSmiles(sB, node, bl, true, this.explicitH)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> iterator = this.htRings.values().iterator();
            if (iterator.hasNext()) {
                node = this.atoms[(Integer)iterator.next()[1]];
                if (!this.bsToDo.get(node.getIndex())) {
                    break;
                }
            } else {
                node = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sB.append(".");
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((node = this.getSmiles(sB, node, bl, true, this.explicitH)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sB, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sB);
        }
        return sB.toString();
    }

    private char getBondStereochemistry(Edge edge, Node node) {
        boolean bl;
        if (edge == null) {
            return '\u0000';
        }
        int n = edge.index;
        boolean bl2 = bl = node == null || edge.getAtomIndex1() == node.getIndex();
        return (char)(this.bsBondsUp.get(n) ? (bl ? 47 : 92) : (this.bsBondsDn.get(n) ? (bl ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bS = new BS();
        Edge[][] edgeArray = new Edge[2][3];
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            Node node = this.atoms[n];
            Edge[] edgeArray2 = node.getEdges();
            for (int i = 0; i < edgeArray2.length; ++i) {
                char c;
                Edge edge = edgeArray2[i];
                int n2 = edge.index;
                if (bS.get(n2)) continue;
                Node node2 = edge.getOtherAtomNode(node);
                if (edge.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, n, node2.getIndex())) continue;
                bS.set(n2);
                Edge edge2 = null;
                Node node3 = null;
                char c2 = '\u0000';
                Node[] nodeArray = new Node[]{node, node2};
                if (Logger.debugging) {
                    Logger.debug(node + " == " + node2);
                }
                int n3 = 1;
                for (c = '\u0000'; c < '\u0002' && n3 > 0 && n3 < 3; ++c) {
                    n3 = 0;
                    Node node4 = nodeArray[c];
                    Edge[] edgeArray3 = node4.getEdges();
                    for (int j = 0; j < edgeArray3.length; ++j) {
                        if (edgeArray3[j].getCovalentOrder() != 1) continue;
                        edgeArray[c][n3++] = edgeArray3[j];
                        if (this.getBondStereochemistry(edgeArray3[j], node4) == '\u0000') continue;
                        edge2 = edgeArray3[j];
                        c2 = c;
                    }
                }
                if (n3 == 3 || n3 == 0) continue;
                if (edge2 == null) {
                    c2 = '\u0000';
                    edge2 = edgeArray[c2][0];
                    this.bsBondsUp.set(edge2.index);
                }
                c = this.getBondStereochemistry(edge2, nodeArray[c2]);
                node3 = edge2.getOtherAtomNode(nodeArray[c2]);
                if (node3 == null) continue;
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        Edge edge3 = edgeArray[j][k];
                        if (edge3 == null || edge3 == edge2) continue;
                        int n4 = edge3.index;
                        Node node5 = edge3.getOtherAtomNode(nodeArray[j]);
                        if (node5 == null) continue;
                        char c3 = this.getBondStereochemistry(edge3, nodeArray[j]);
                        boolean bl = SmilesSearch.isDiaxial(nodeArray[c2], nodeArray[j], node3, node5, this.vTemp, 0.0f);
                        if (c3 == '\u0000' || c3 != c == bl) {
                            boolean bl2 = c == '\\' && bl || c == '/' && !bl;
                            if (bl2 == (edge3.getAtomIndex1() != node5.getIndex())) {
                                this.bsBondsUp.set(n4);
                            } else {
                                this.bsBondsDn.set(n4);
                            }
                        } else {
                            Logger.error("BOND STEREOCHEMISTRY ERROR");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug(this.getBondStereochemistry(edge2, nodeArray[0]) + " " + node3.getIndex() + " " + node5.getIndex() + " " + this.getBondStereochemistry(edge3, nodeArray[j]));
                    }
                }
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    private Node getSmiles(SB sB, Node node, boolean bl, boolean bl2, boolean bl3) {
        String string;
        String string2;
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3;
        char c;
        int n4;
        Object object4;
        int n5 = node.getIndex();
        if (!this.bsToDo.get(n5)) {
            return null;
        }
        this.bsToDo.clear(n5);
        boolean bl4 = !this.bsSelected.get(n5);
        int n6 = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean bl5 = this.bsAromatic.get(n5);
        boolean bl6 = this.prevSp2Atoms != null;
        Node[] nodeArray = this.prevSp2Atoms;
        int n7 = 0;
        int n8 = node.getElementNumber();
        int n9 = 0;
        Lst<Edge> lst = new Lst<Edge>();
        Object object5 = null;
        Edge edge = null;
        Edge[] edgeArray = node.getEdges();
        Object object6 = null;
        int n10 = bl5 ? 10 : 0;
        Node[] nodeArray2 = new Node[7];
        if (Logger.debugging) {
            Logger.debug(sB.toString());
        }
        if (edgeArray != null) {
            int n11 = edgeArray.length;
            while (--n11 >= 0) {
                boolean bl7;
                Edge edge2 = edgeArray[n11];
                if (!edge2.isCovalent()) continue;
                object4 = edgeArray[n11].getOtherAtomNode(node);
                n4 = object4.getIndex();
                if (n4 == n6) {
                    edge = edgeArray[n11];
                    continue;
                }
                boolean bl8 = bl7 = !bl3 && object4.getElementNumber() == 1 && object4.getIsotopeNumber() == 0;
                if (!this.bsIncludingH.get(n4)) {
                    if (bl7 || !bl || !this.bsSelected.get(n5)) continue;
                    this.bsToDo.set(n4);
                }
                if (bl7) {
                    object6 = object4;
                    if (++n9 <= 1) continue;
                    n10 = 10;
                    continue;
                }
                lst.addLast(edgeArray[n11]);
            }
        }
        String string3 = null;
        if (nodeArray == null) {
            nodeArray = new Node[5];
        }
        if (edge != null) {
            string3 = SmilesBond.getBondOrderString(edge.getCovalentOrder());
            if (this.prevSp2Atoms == null) {
                nodeArray[n7++] = this.prevAtom;
            } else {
                n7 = 2;
            }
        }
        n7 += n9;
        char c2 = '\u0000';
        object4 = new BS();
        if (bl2) {
            for (n4 = 0; n4 < lst.size(); ++n4) {
                Edge edge3 = (Edge)lst.get(n4);
                Node node2 = edge3.getOtherAtomNode(node);
                c = node2.getCovalentBondCount() - (bl3 ? 0 : node2.getCovalentHydrogenCount());
                int n12 = edge3.getCovalentOrder();
                if (n12 == 1 && c == '\u0001' && n4 < lst.size() - (object5 == null ? 1 : 0)) {
                    ((BS)object4).set(edge3.index);
                    continue;
                }
                if (n12 <= 1 && c <= c2 || this.htRings.containsKey(SmilesGenerator.getRingKey(node2.getIndex(), n5))) continue;
                c2 = n12 > 1 ? 1000 + n12 : c;
                object5 = edge3;
            }
        }
        Node node3 = object5 == null ? null : ((Edge)object5).getOtherAtomNode(node);
        int n13 = n3 = object5 == null ? 0 : ((Edge)object5).getCovalentOrder();
        if (n10 < 7 && edge != null) {
            if (edge.getCovalentOrder() == 2 && n3 == 2 && this.prevSp2Atoms != null && this.prevSp2Atoms[1] != null) {
                nodeArray2[n10++] = this.prevSp2Atoms[0];
                nodeArray2[n10++] = this.prevSp2Atoms[1];
            } else {
                nodeArray2[n10++] = this.prevAtom;
            }
        }
        if (n10 < 7 && n9 == 1) {
            nodeArray2[n10++] = object6;
        }
        boolean bl9 = n3 == 1 && this.prevSp2Atoms == null;
        c = this.getBondStereochemistry(edge, this.prevAtom);
        SB sB2 = new SB();
        for (n2 = 0; n2 < lst.size(); ++n2) {
            object3 = (Edge)lst.get(n2);
            if (!((BS)object4).get(((Edge)object3).index)) continue;
            Node node4 = ((Edge)object3).getOtherAtomNode(node);
            object2 = new SB();
            ((SB)object2).append("(");
            this.prevAtom = node;
            this.prevSp2Atoms = null;
            object = object5;
            this.getSmiles((SB)object2, node4, bl, bl2, bl3);
            object5 = object;
            ((SB)object2).append(")");
            if (sB2.indexOf(((SB)object2).toString()) >= 0) {
                n10 = 10;
            }
            sB2.appendSB((SB)object2);
            lst.remove(n2--);
            if (n10 < 7) {
                nodeArray2[n10++] = node4;
            }
            if (n7 >= 5) continue;
            nodeArray[n7++] = node4;
        }
        int n14 = n2 = n3 == 2 ? node3.getIndex() : -1;
        if (n9 > 1 || bl5 || n2 < 0 || SmilesSearch.isRingBond(this.ringSets, n5, n2)) {
            n7 = -1;
        }
        if (n7 < 0) {
            nodeArray = null;
        }
        if (string3 != null || c != '\u0000') {
            if (c != '\u0000') {
                string3 = "" + c;
            }
            sB.append(string3);
        }
        object3 = null;
        if (!(bl2 || lst.size() != 5 && lst.size() != 6)) {
            object3 = this.sortInorganic(node, lst);
        }
        for (n = 0; n < lst.size(); ++n) {
            object2 = (Edge)lst.get(n);
            if (object2 == object5) continue;
            object = ((Edge)object2).getOtherAtomNode(node);
            string2 = this.getRingCache(n5, object.getIndex(), this.htRings);
            string3 = SmilesBond.getBondOrderString(((Edge)object2).order);
            if (!bl9 && (c = this.getBondStereochemistry((Edge)object2, node)) != '\u0000') {
                string3 = "" + c;
            }
            sB2.append(string3);
            sB2.append(string2);
            if (n10 < 7) {
                nodeArray2[n10++] = object;
            }
            if (nodeArray == null || n7 >= 5) continue;
            nodeArray[n7++] = object;
        }
        if (bl6 && n10 == 2 && n3 == 2 && node3.getCovalentBondCount() == 3) {
            edgeArray = node3.getEdges();
            for (n = 0; n < edgeArray.length; ++n) {
                if (!edgeArray[n].isCovalent() || node3.getBondedAtomIndex(n) == n5) continue;
                nodeArray2[n10++] = this.atoms[node3.getBondedAtomIndex(n)];
            }
            n7 = 0;
        } else if (node3 != null && n10 < 7) {
            nodeArray2[n10++] = node3;
        }
        n = node.getFormalCharge();
        int n15 = node.getIsotopeNumber();
        int n16 = node.getValence();
        string2 = node.getAtomName();
        String string4 = string = node instanceof BNode ? ((BNode)node).getBioStructureTypeName() : "";
        if (Logger.debugging) {
            sB.append("\n//* " + node + " *//\t");
        }
        if (bl4 && string.length() != 0 && string2.length() != 0) {
            this.addBracketedBioName(sB, node, "." + string2);
        } else {
            sB.append(SmilesAtom.getAtomLabel(n8, n15, n16, n, n9, bl5, (String)(object3 != null ? object3 : this.checkStereoPairs(node, n5, nodeArray2, n10))));
        }
        sB.appendSB(sB2);
        if (object5 == null) {
            return null;
        }
        if (n3 == 2 && (n7 == 1 || n7 == 2)) {
            if (nodeArray[0] == null) {
                nodeArray[0] = node;
            }
            if (nodeArray[1] == null) {
                nodeArray[1] = node;
            }
        } else {
            nodeArray = null;
            n7 = 0;
        }
        this.prevSp2Atoms = nodeArray;
        this.prevAtom = node;
        return node3;
    }

    private String sortInorganic(Node node, Lst<Edge> lst) {
        int n;
        Edge edge;
        int n2;
        int n3 = node.getIndex();
        int n4 = lst.size();
        Lst<Edge[]> lst2 = new Lst<Edge[]>();
        Lst<Edge> lst3 = new Lst<Edge>();
        BS bS = new BS();
        Edge[] edgeArray = null;
        Node[] nodeArray = new Node[6];
        boolean bl = true;
        String string = "";
        for (n2 = 0; n2 < n4; ++n2) {
            Node node2;
            edge = (Edge)lst.get(n2);
            nodeArray[0] = node2 = edge.getOtherAtomNode(node);
            if (n2 == 0) {
                string = this.addStereoCheck(n3, nodeArray, 0, "");
            } else if (bl && this.addStereoCheck(n3, nodeArray, 0, string) != null) {
                bl = false;
            }
            if (bS.get(n2)) continue;
            bS.set(n2);
            n = 0;
            for (int i = n2 + 1; i < n4; ++i) {
                Edge edge2;
                Node node3;
                if (bS.get(i) || !SmilesSearch.isDiaxial(node, node, node2, node3 = (edge2 = (Edge)lst.get(i)).getOtherAtomNode(node), this.vTemp, -0.95f)) continue;
                lst2.addLast(new Edge[]{edge, edge2});
                n = 1;
                bS.set(i);
                break;
            }
            if (n != 0) continue;
            lst3.addLast(edge);
        }
        n2 = lst2.size();
        if (bl || n4 == 6 && n2 != 3 || n4 == 5 && n2 == 0) {
            return "";
        }
        edgeArray = (Edge[])lst2.get(0);
        edge = edgeArray[0];
        nodeArray[0] = edge.getOtherAtomNode(node);
        lst.clear();
        lst.addLast(edge);
        if (n2 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[0]);
        }
        if (n2 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[0]);
        }
        if (n2 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[1]);
        }
        if (n2 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[1]);
        }
        for (n = 0; n < lst3.size(); ++n) {
            edge = (Edge)lst3.get(n);
            lst.addLast(edge);
            nodeArray[n + 1] = edge.getOtherAtomNode(node);
        }
        lst.addLast(edgeArray[1]);
        return SmilesGenerator.getStereoFlag(node, nodeArray, n4, this.vTemp);
    }

    private String checkStereoPairs(Node node, int n, Node[] nodeArray, int n2) {
        if (n2 < 4) {
            return "";
        }
        if (n2 == 4 && node.getElementNumber() == 6) {
            String string = "";
            for (int i = 0; i < 4; ++i) {
                if ((string = this.addStereoCheck(n, nodeArray, i, string)) != null) continue;
                n2 = 10;
                break;
            }
        }
        return n2 > 6 ? "" : SmilesGenerator.getStereoFlag(node, nodeArray, n2, this.vTemp);
    }

    private static String getStereoFlag(Node node, Node[] nodeArray, int n, VTemp vTemp) {
        Node node2 = nodeArray[0];
        Node node3 = nodeArray[1];
        Node node4 = nodeArray[2];
        Node node5 = nodeArray[3];
        Node node6 = nodeArray[4];
        Node node7 = nodeArray[5];
        int n2 = 4;
        switch (n) {
            default: {
                return SmilesSearch.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (node4 == null || node5 == null) {
            return "";
        }
        float f = SmilesAromatic.getNormalThroughPoints(node2, node3, node4, vTemp.vTemp, vTemp.vA, vTemp.vB);
        if (Math.abs(SmilesSearch.distanceToPlane(vTemp.vTemp, f, (P3)((Object)node5))) < 0.2f) {
            n2 = 8;
            if (SmilesSearch.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP1";
            }
            if (SmilesSearch.checkStereochemistryAll(false, node, n2, 2, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP2";
            }
            if (SmilesSearch.checkStereochemistryAll(false, node, n2, 3, node2, node3, node4, node5, node6, node7, vTemp)) {
                return "@SP3";
            }
        } else {
            return SmilesSearch.checkStereochemistryAll(false, node, n2, 1, node2, node3, node4, node5, node6, node7, vTemp) ? "@" : "@@";
        }
        return "";
    }

    private String addStereoCheck(int n, Node[] nodeArray, int n2, String string) {
        int n3;
        int n4 = nodeArray[n2].getAtomicAndIsotopeNumber();
        int n5 = nodeArray[n2].getCovalentBondCount();
        int n6 = n3 = n4 == 6 && !this.explicitH ? nodeArray[n2].getCovalentHydrogenCount() : 0;
        if (n4 == 6 ? n5 != 4 || n3 != 3 : n5 > 1) {
            return string;
        }
        String string2 = ";" + n4 + "/" + n3 + "/" + n5 + ",";
        if (string.indexOf(string2) >= 0) {
            if (n3 == 3) {
                int n7 = 0;
                for (int i = 0; i < n5 && n7 < 3; ++i) {
                    int n8 = nodeArray[n2].getBondedAtomIndex(i);
                    if (n8 == n) continue;
                    n7 += this.atoms[n8].getAtomicAndIsotopeNumber();
                }
                if (n7 > 3) {
                    return string;
                }
            }
            return null;
        }
        return string + string2;
    }

    private String getRingCache(int n, int n2, Map<String, Object[]> map) {
        String string;
        String string2 = SmilesGenerator.getRingKey(n, n2);
        Object[] objectArray = map.get(string2);
        String string3 = string = objectArray == null ? null : (String)objectArray[0];
        if (string == null) {
            Object[] objectArray2 = new Object[2];
            string = SmilesParser.getRingPointer(++this.nPairs);
            objectArray2[0] = string;
            objectArray2[1] = n2;
            map.put(string2, objectArray2);
            if (Logger.debugging) {
                Logger.debug("adding for " + n + " ring key " + this.nPairs + ": " + string2);
            }
        } else {
            map.remove(string2);
            if (Logger.debugging) {
                Logger.debug("using ring key " + string2);
            }
        }
        return string;
    }

    private void dumpRingKeys(SB sB, Map<String, Object[]> map) {
        Logger.info(sB.toString() + "\n\n");
        for (String string : map.keySet()) {
            Logger.info("unmatched ring key: " + string);
        }
    }

    protected static String getRingKey(int n, int n2) {
        return Math.min(n, n2) + "_" + Math.max(n, n2);
    }
}

