/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.LoopedStreams;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea(InputStream[] inputStreamArray) {
        for (int i = 0; i < inputStreamArray.length; ++i) {
            this.startConsoleReaderThread(inputStreamArray[i]);
        }
    }

    public ConsoleTextArea(boolean bl) throws IOException {
        String string;
        LoopedStreams loopedStreams = new LoopedStreams();
        String string2 = string = bl ? System.getProperty("JmolConsole") : "false";
        if (string == null || string.equals("true")) {
            PrintStream printStream = new PrintStream(loopedStreams.getOutputStream());
            System.setOut(printStream);
            System.setErr(printStream);
        }
        this.startConsoleReaderThread(loopedStreams.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inputStream) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("ConsoleReaderThread");
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    Document document = ConsoleTextArea.this.getDocument();
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        boolean bl = false;
                        bl = ConsoleTextArea.this.getCaretPosition() == document.getLength();
                        stringBuilder.setLength(0);
                        ConsoleTextArea.this.append(stringBuilder.append(string).append('\n').toString());
                        if (bl) {
                            ConsoleTextArea.this.setCaretPosition(document.getLength());
                        }
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, GT.o(GT._("Error reading from BufferedReader: {0}"), iOException.getMessage()));
                    System.exit(1);
                }
            }
        }).start();
    }
}

