/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import javajs.util.XmlUtil;
import org.jmol.api.Interface;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.Shape;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Txt;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

@J2SIgnoreImport(value={XmlUtil.class})
public class PropertyManager
implements JmolPropertyManager {
    Viewer vwr;
    private Map<String, Integer> map = new Hashtable<String, Integer>();
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "{*}", "ligandInfo", "<atom selection>", "{*}", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "{*}", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "<width=www,height=hhh>", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", "", "isosurfaceInfo", "", "", "isosurfaceData", "", "", "consoleText", "", "", "JSpecView", "<key>", "", "scriptQueueInfo", "", "", "nmrInfo", "<elementSymbol> or 'all' or 'shifts'", "all", "variableInfo", "<name>", "all", "domainInfo", "<atom selection>", "{visible}", "validationInfo", "<atom selection>", "{visible}"};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    private static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_LIGAND_INFO = 7;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_LIST = 13;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_ISOSURFACE_INFO = 35;
    private static final int PROP_ISOSURFACE_DATA = 36;
    private static final int PROP_CONSOLE_TEXT = 37;
    private static final int PROP_JSPECVIEW = 38;
    private static final int PROP_SCRIPT_QUEUE_INFO = 39;
    private static final int PROP_NMR_INFO = 40;
    private static final int PROP_VAR_INFO = 41;
    private static final int PROP_DOM_INFO = 42;
    private static final int PROP_VAL_INFO = 43;
    private static final int PROP_COUNT = 44;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu", "minimizationInfo"};

    @Override
    public void setViewer(Viewer viewer) {
        this.vwr = viewer;
        int n = 0;
        for (int i = 0; i < propertyTypes.length; i += 3) {
            this.map.put(propertyTypes[i].toLowerCase(), n++);
        }
    }

    @Override
    public int getPropertyNumber(String string) {
        Integer n = this.map.get(string == null ? "" : string.toLowerCase());
        return n == null ? -1 : n;
    }

    @Override
    public String getDefaultPropertyParam(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 2];
    }

    @Override
    public boolean checkPropertyParameter(String string) {
        int n = this.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != atomExpression;
    }

    @Override
    public Object getProperty(String string, String string2, Object object) {
        Object object2;
        if (propertyTypes.length != 132) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 132);
        }
        if (string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0) {
            SV[] sVArray = this.getArguments(string2);
            object2 = this.extractProperty(this.getPropertyAsObject(sVArray[0].asString(), object, null), sVArray, 1, null, false);
        } else {
            object2 = this.getPropertyAsObject(string2, object, string);
        }
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + PT.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    private SV[] getArguments(String string) {
        String string2 = string.toLowerCase();
        int n = -1;
        while (true) {
            ++n;
            if ((n = string2.indexOf("[select ", n)) < 0) break;
            int n2 = string2.indexOf(" where ", n);
            int n3 = string2.indexOf("]", n);
            if (n2 < 0 || n2 > n3) continue;
            string = string.substring(0, n2) + string.substring(n2, n3).replace('.', '\u0001') + string.substring(n3);
        }
        string = string.replace(']', '\u0000').replace('[', '\u0000').replace('.', '\u0000').replace('\u0001', '.');
        string = PT.rep(string, "\u0000\u0000", "\u0000");
        String[] stringArray = PT.split(PT.trim(string, "\u0000"), "\u0000");
        SV[] sVArray = new SV[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n4;
            sVArray[i] = stringArray[i].startsWith("'") || stringArray[i].startsWith("\"") ? SV.newS(PT.trim(stringArray[i], "'\"")) : ((n4 = PT.parseInt(stringArray[i])) == Integer.MIN_VALUE ? SV.newS(stringArray[i]) : SV.newI(n4));
        }
        return sVArray;
    }

    @Override
    public Object extractProperty(Object object, Object object2, int n, Lst<Object> lst, boolean bl) {
        if (n < 0) {
            object2 = this.getArguments((String)object2);
            n = 0;
        }
        if (n >= ((SV[])object2).length) {
            return object;
        }
        if (!bl) {
            object2 = this.compileSelect((SV[])object2);
        }
        SV sV = object2[n++];
        Object object3 = this.getObj(object);
        switch (sV.tok) {
            case 2: {
                int n2 = sV.intValue - 1;
                if (object3 instanceof Lst) {
                    Lst lst2 = (Lst)object3;
                    if (n2 < 0) {
                        n2 += lst2.size();
                    }
                    return n2 >= 0 && n2 < lst2.size() ? this.extractProperty(lst2.get(n2), object2, n, null, true) : "";
                }
                if (object3 instanceof M3) {
                    M3 m3 = (M3)object3;
                    float[][] fArrayArray = new float[][]{{m3.m00, m3.m01, m3.m02}, {m3.m10, m3.m11, m3.m12}, {m3.m20, m3.m21, m3.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return this.extractProperty(fArrayArray, object2, --n, null, true);
                    }
                    return "";
                }
                if (object3 instanceof M4) {
                    M4 m4 = (M4)object3;
                    float[][] fArrayArray = new float[][]{{m4.m00, m4.m01, m4.m02, m4.m03}, {m4.m10, m4.m11, m4.m12, m4.m13}, {m4.m20, m4.m21, m4.m22, m4.m23}, {m4.m30, m4.m31, m4.m32, m4.m33}};
                    if (n2 < 0) {
                        n2 += 4;
                    }
                    if (n2 >= 0 && n2 < 4) {
                        return this.extractProperty(fArrayArray, object2, --n, null, true);
                    }
                    return "";
                }
                if (PT.isAI(object3)) {
                    int[] nArray = (int[])object3;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return nArray[n2];
                    }
                    return "";
                }
                if (PT.isAD(object3)) {
                    double[] dArray = (double[])object3;
                    if (n2 < 0) {
                        n2 += dArray.length;
                    }
                    if (n2 >= 0 && n2 < dArray.length) {
                        return dArray[n2];
                    }
                    return "";
                }
                if (PT.isAF(object3)) {
                    float[] fArray = (float[])object3;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return Float.valueOf(fArray[n2]);
                    }
                    return "";
                }
                if (PT.isAII(object3)) {
                    int[][] nArray = (int[][])object3;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return this.extractProperty(nArray[n2], object2, n, null, true);
                    }
                    return "";
                }
                if (PT.isAFF(object3)) {
                    float[][] fArray = (float[][])object3;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return this.extractProperty(fArray[n2], object2, n, null, true);
                    }
                    return "";
                }
                if (PT.isAS(object3)) {
                    String[] stringArray = (String[])object3;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (!(object3 instanceof Object[])) break;
                Object[] objectArray = (Object[])object3;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: 
            case 135280132: {
                if (object3 instanceof Map) {
                    boolean bl2;
                    String string;
                    Map map = (Map)object3;
                    if (sV.tok == 135280132) {
                        string = sV.myName;
                        if (!this.vwr.checkSelect((Map)object3, (T[])sV.value)) {
                            return "";
                        }
                    } else {
                        string = sV.asString();
                        if (string.equalsIgnoreCase("keys")) {
                            Lst<String> lst3 = new Lst<String>();
                            for (String string2 : map.keySet()) {
                                lst3.addLast(string2);
                            }
                            return this.extractProperty(lst3, object2, n, null, true);
                        }
                    }
                    boolean bl3 = bl2 = string.startsWith("*") || string.endsWith("*") || string.indexOf(",") >= 0;
                    if (bl2 && lst == null) {
                        lst = new Lst();
                    }
                    if (bl2 && string.length() == 1) {
                        if (n == ((SV[])object2).length) {
                            lst.addLast(object3);
                            return lst;
                        }
                        return this.extractProperty(object3, object2, n, lst, true);
                    }
                    if (string.contains(",")) {
                        Hashtable<String, Object> hashtable = null;
                        hashtable = new Hashtable<String, Object>();
                        String[] stringArray = PT.split(string, ",");
                        int n3 = stringArray.length;
                        while (--n3 >= 0) {
                            PT.getMapSubset(map, stringArray[n3], hashtable);
                        }
                        if (n == ((SV[])object2).length) {
                            lst.addLast(hashtable);
                            return lst;
                        }
                        return this.extractProperty(hashtable, object2, n, lst, true);
                    }
                    return (string = this.checkMap(map, string, bl2, lst, object2, n)) != null && !bl2 ? this.extractProperty(map.get(string), object2, n, null, true) : (bl2 ? lst : "");
                }
                if (!(object3 instanceof Lst)) break;
                Lst lst4 = (Lst)object3;
                if (lst == null) {
                    lst = new Lst();
                }
                --n;
                for (int i = 0; i < lst4.size(); ++i) {
                    Object e = lst4.get(i);
                    if (!(e instanceof Map) && !(e instanceof Lst) && (!(e instanceof SV) || ((SV)e).getMap() == null && ((SV)e).getList() == null)) continue;
                    this.extractProperty(e, object2, n, lst, true);
                }
                return lst;
            }
        }
        return object;
    }

    private Object compileSelect(SV[] sVArray) {
        SV[] sVArray2 = null;
        int n = sVArray.length;
        while (--n >= 0) {
            int n2;
            String string;
            if (sVArray[n].tok != 4 || !(string = (String)sVArray[n].value).toUpperCase().startsWith("SELECT ")) continue;
            if (sVArray2 == null) {
                sVArray2 = (SV[])AU.arrayCopyObject(sVArray, sVArray.length);
            }
            if ((string = string.substring(6).trim()).toUpperCase().startsWith("WHERE ")) {
                string = "* " + string;
            }
            if ((n2 = string.toUpperCase().indexOf(" WHERE ")) < 0) {
                sVArray2[n].value = string;
                continue;
            }
            sVArray2[n] = SV.newV(135280132, this.vwr.compileExpr(string.substring(n2 + 6).trim()));
            sVArray2[n].myName = string.substring(0, n2).trim();
        }
        return sVArray2 == null ? sVArray : sVArray2;
    }

    private String checkMap(Map<String, ?> map, String string, boolean bl, Lst<Object> lst, Object object, int n) {
        boolean bl2;
        boolean bl3 = bl2 = lst == null && map.containsKey(string);
        if (!bl2) {
            String string2 = bl ? string.toLowerCase() : null;
            for (String string3 : map.keySet()) {
                if (!string3.equalsIgnoreCase(string) && (string2 == null || !PT.isLike(string3.toLowerCase(), string2))) continue;
                if (lst == null) {
                    return string3;
                }
                lst.addLast(this.extractProperty(map.get(string3), object, n, null, true));
                if (bl) continue;
                return null;
            }
        }
        return bl2 ? string : null;
    }

    private Object getObj(Object object) {
        return object instanceof SV ? SV.oValue((SV)object) : object;
    }

    private static String getPropertyName(int n) {
        return n < 0 ? "" : propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyAsObject(String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return T.getTokensLike((String)object);
        }
        int n = this.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : this.getDefaultPropertyParam(n);
        switch (n) {
            case 0: {
                return this.getAppletInfo();
            }
            case 5: {
                return this.getAnimationInfo();
            }
            case 13: {
                return this.vwr.getAtomBitSetVector(object2);
            }
            case 14: {
                return this.getAllAtomInfo(this.vwr.getAtomBitSet(object2));
            }
            case 24: {
                return this.getAuxiliaryInfo(object2);
            }
            case 15: {
                return this.getAllBondInfo(object2);
            }
            case 25: {
                return this.getBoundBoxInfo();
            }
            case 10: {
                return this.vwr.tm.getRotationCenter();
            }
            case 16: {
                return this.getAllChainInfo(this.vwr.getAtomBitSet(object2));
            }
            case 37: {
                return this.vwr.getProperty("DATA_API", "consoleText", null);
            }
            case 26: {
                return this.vwr.getData(object2.toString());
            }
            case 33: {
                return this.vwr.getErrorMessageUn();
            }
            case 28: {
                return this.vwr.evaluateExpression(object2.toString());
            }
            case 20: {
                return this.vwr.getModelExtract(object2, true, false, "MOL");
            }
            case 32: {
                return PropertyManager.getFileInfo(this.vwr.getFileData(), object2.toString());
            }
            case 1: {
                return this.vwr.getFullPathName(false);
            }
            case 2: {
                return this.vwr.getFileHeader();
            }
            case 3: 
            case 4: {
                return bl ? this.vwr.getFileAsString(object2.toString(), true) : this.vwr.getCurrentFileAsString();
            }
            case 27: {
                String string3 = object2.toString().toLowerCase();
                return this.getImage(string3, string3.indexOf("g64") < 0 && string3.indexOf("base64") < 0 && (string2 == null || string2.equalsIgnoreCase("java")));
            }
            case 35: {
                return this.vwr.getShapeProperty(24, "getInfo");
            }
            case 36: {
                return this.vwr.getShapeProperty(24, "getData");
            }
            case 40: {
                return this.vwr.getNMRCalculation().getInfo(object2.toString());
            }
            case 41: {
                return this.getVariables(object2.toString());
            }
            case 21: {
                return this.vwr.getStatusChanged(object2.toString());
            }
            case 22: {
                return this.vwr;
            }
            case 38: {
                return this.vwr.getJspecViewProperties(object2);
            }
            case 7: {
                return this.getLigandInfo(this.vwr.getAtomBitSet(object2));
            }
            case 9: {
                return this.getMeasurementInfo();
            }
            case 29: {
                return this.vwr.getMenu(object2.toString());
            }
            case 23: {
                return this.vwr.sm.getMessageQueue();
            }
            case 30: {
                return this.vwr.getMinimizationInfo();
            }
            case 6: {
                return this.getModelInfo(this.vwr.getAtomBitSet(object2));
            }
            case 18: {
                return this.getMoleculeInfo(this.vwr.getAtomBitSet(object2));
            }
            case 34: {
                return this.getMouseInfo();
            }
            case 11: {
                return this.vwr.tm.getOrientationInfo();
            }
            case 31: {
                return this.vwr.getPointGroupInfo(object2);
            }
            case 17: {
                return this.getAllPolymerInfo(this.vwr.getAtomBitSet(object2));
            }
            case 39: {
                return this.vwr.getScriptQueueInfo();
            }
            case 8: {
                return this.getShapeInfo();
            }
            case 19: {
                return this.vwr.getStateInfo3(object2.toString(), 0, 0);
            }
            case 12: {
                return this.vwr.tm.getMatrixRotate();
            }
            case 42: {
                return this.getAnnotationInfo(object2, 1073741925);
            }
            case 43: {
                return this.getAnnotationInfo(object2, 1073742189);
            }
        }
        Object[] objectArray = new String[44];
        for (int i = 0; i < 44; ++i) {
            String string4 = PropertyManager.getParamType(i);
            String string5 = this.getDefaultPropertyParam(i);
            String string6 = PropertyManager.getPropertyName(i);
            objectArray[i] = string6.charAt(0) == 'X' ? "" : string6 + (string4 != "" ? " " + PropertyManager.getParamType(i) + (string5 != "" ? " #default: " + this.getDefaultPropertyParam(i) : "") : "");
        }
        Arrays.sort(objectArray);
        SB sB = new SB();
        sB.append("getProperty ERROR\n").append(string).append("?\nOptions include:\n");
        for (int i = 0; i < 44; ++i) {
            if (((String)objectArray[i]).length() <= 0) continue;
            sB.append("\n getProperty ").append((String)objectArray[i]);
        }
        return sB.toString();
    }

    private Object getImage(String string, boolean bl) {
        int n = -1;
        int n2 = -1;
        int n3 = string.indexOf("height=");
        if (n3 >= 0) {
            n = PT.parseInt(string.substring(n3 + 7));
        }
        if ((n3 = string.indexOf("width=")) >= 0) {
            n2 = PT.parseInt(string.substring(n3 + 6));
        }
        if (n2 < 0 && n < 0) {
            n2 = -1;
            n = -1;
        } else if (n2 < 0) {
            n2 = n;
        } else {
            n = n2;
        }
        String string2 = "JPG";
        if (string.indexOf("type=") >= 0) {
            string2 = PT.getTokens(PT.replaceWithCharacter(string.substring(string.indexOf("type=") + 5), ";,", ' '))[0];
        }
        String[] stringArray = new String[1];
        byte[] byArray = this.vwr.getImageAsBytes(string2.toUpperCase(), n2, n, -1, stringArray);
        return stringArray[0] != null ? stringArray[0] : (bl ? new BArray(byArray) : Base64.getBase64(byArray).toString());
    }

    private Object getVariables(String string) {
        return string.toLowerCase().equals("all") ? this.vwr.g.getAllVariables() : this.vwr.evaluateExpressionAsVariable(string);
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Map) {
            return bl ? ((Map)object).get(string) : object;
        }
        String[] stringArray = PT.split((String)object, "\n");
        if (stringArray.length == 0 || stringArray[0].length() < 6 || stringArray[0].charAt(6) != ' ' || !stringArray[0].substring(0, 6).equals(stringArray[0].substring(0, 6).toUpperCase())) {
            hashtable.put("fileHeader", (String)object);
            return hashtable;
        }
        String string2 = "";
        SB sB = new SB();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() < 12) continue;
            string3 = string4.substring(0, 6).trim();
            String string5 = string4.substring(7, 10).trim();
            if (string3.equals("REMARK")) {
                string3 = string3 + string5;
            }
            if (!string3.equals(string2)) {
                if (bl && string2.equals(string)) {
                    return sB.toString();
                }
                if (!bl) {
                    hashtable.put(string2, sB.toString());
                    sB = new SB();
                }
                string2 = string3;
            }
            if (bl && !string3.equals(string)) continue;
            sB.append(string4).appendC('\n');
        }
        if (!bl) {
            hashtable.put(string2, sB.toString());
        }
        if (bl) {
            return string3.equals(string) ? sB.toString() : "";
        }
        return hashtable;
    }

    public Lst<Map<String, Object>> getMoleculeInfo(Object object) {
        BS bS = this.vwr.getAtomBitSet(object);
        JmolMolecule[] jmolMoleculeArray = this.vwr.ms.getMolecules();
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        BS bS2 = new BS();
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            bS2 = BSUtil.copy(bS);
            JmolMolecule jmolMolecule = jmolMoleculeArray[i];
            bS2.and(jmolMolecule.atomList);
            if (bS2.length() <= 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mf", jmolMolecule.getMolecularFormula(false));
            hashtable.put("number", jmolMolecule.moleculeIndex + 1);
            hashtable.put("modelNumber", this.vwr.ms.getModelNumberDotted(jmolMolecule.modelIndex));
            hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
            hashtable.put("nAtoms", jmolMolecule.ac);
            hashtable.put("nElements", jmolMolecule.nElements);
            lst.addLast((Map<String, Object>)hashtable);
        }
        return lst;
    }

    @Override
    public Map<String, Object> getModelInfo(Object object) {
        BS bS = this.vwr.ms.getModelBS(this.vwr.getAtomBitSet(object), false);
        ModelSet modelSet = this.vwr.ms;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", modelSet.modelSetName);
        hashtable.put("modelCount", modelSet.mc);
        hashtable.put("isTainted", modelSet.tainted != null);
        hashtable.put("canSkipLoad", modelSet.canSkipLoad);
        hashtable.put("modelSetHasVibrationVectors", modelSet.modelSetHasVibrationVectors());
        if (modelSet.modelSetProperties != null) {
            hashtable.put("modelSetProperties", modelSet.modelSetProperties);
        }
        hashtable.put("modelCountSelected", BSUtil.cardinalityOf(bS));
        hashtable.put("modelsSelected", bS);
        Lst lst = new Lst();
        modelSet.getMolecules();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", modelSet.getModelNumber(n));
            hashtable2.put("file_model", modelSet.getModelNumberDotted(n));
            hashtable2.put("name", modelSet.getModelName(n));
            String string = modelSet.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = modelSet.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            if ((string = (String)modelSet.getInfo(n, "modelID")) != null) {
                hashtable2.put("id", string);
            }
            hashtable2.put("vibrationVectors", this.vwr.modelHasVibrationVectors(n));
            Model model = modelSet.am[n];
            hashtable2.put("atomCount", model.ac);
            hashtable2.put("bondCount", model.getBondCount());
            hashtable2.put("groupCount", model.getGroupCount());
            hashtable2.put("moleculeCount", model.moleculeCount);
            hashtable2.put("polymerCount", model.getBioPolymerCount());
            hashtable2.put("chainCount", modelSet.getChainCountInModelWater(n, true));
            if (model.properties != null) {
                hashtable2.put("modelProperties", model.properties);
            }
            if ((f = (Float)modelSet.getInfo(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", model.ac);
            lst.addLast(hashtable2);
            n = bS.nextSetBit(n + 1);
        }
        hashtable.put("models", lst);
        return hashtable;
    }

    @Override
    public Map<String, Object> getLigandInfo(Object object) {
        BS bS = this.vwr.getAtomBitSet(object);
        BS bS2 = this.vwr.getAtomBitSet("solvent");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst lst = new Lst();
        hashtable.put("ligands", lst);
        ModelSet modelSet = this.vwr.ms;
        BS bS3 = BSUtil.copyInvert(bS, modelSet.ac);
        bS3.or(bS2);
        BNode[] bNodeArray = modelSet.at;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bNodeArray[n].isProtein() || bNodeArray[n].isNucleic()) {
                bS3.set(n);
            }
            n = bS.nextSetBit(n + 1);
        }
        BS[] bSArray = new BS[modelSet.mc];
        int n2 = modelSet.mc;
        while (--n2 >= 0) {
            bSArray[n2] = this.vwr.getModelUndeletedAtomsBitSet(n2);
            bSArray[n2].andNot(bS3);
        }
        JmolMolecule[] jmolMoleculeArray = JmolMolecule.getMolecules(bNodeArray, bSArray, null, bS3);
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            BS bS4 = jmolMoleculeArray[i].atomList;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            lst.addLast(hashtable2);
            hashtable2.put("atoms", Escape.eBS(bS4));
            String string = "";
            String string2 = "";
            Group group = null;
            int n3 = 0;
            String string3 = null;
            String string4 = "";
            String string5 = "";
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = bS4.nextSetBit(0);
            while (n6 >= 0) {
                BNode bNode = bNodeArray[n6];
                if (group != ((Atom)bNode).group) {
                    group = ((Atom)bNode).group;
                    int n7 = ((Atom)bNode).getResno();
                    int n8 = ((Atom)bNode).getChainID();
                    if (n4 != n7 - 1) {
                        if (string4.length() != 0 && n4 != n5) {
                            string4 = string4 + "-" + n4;
                        }
                        n8 = -1;
                        n5 = n7;
                    }
                    string5 = "/" + modelSet.getModelNumberDotted(((Atom)bNode).mi);
                    if (n3 != 0 && n8 != n3) {
                        string4 = string4 + ":" + string3 + string5;
                    }
                    if (n8 == -1) {
                        string4 = string4 + " " + n7;
                    }
                    n4 = n7;
                    n3 = ((Atom)bNode).getChainID();
                    string3 = ((Atom)bNode).getChainIDStr();
                    string = string + string2 + ((Atom)bNode).getGroup3(false);
                    string2 = "-";
                }
                n6 = bS4.nextSetBit(n6 + 1);
            }
            string4 = string4 + (n5 == n4 ? "" : "-" + n4) + (n3 == 0 ? "" : ":" + string3) + string5;
            hashtable2.put("groupNames", string);
            hashtable2.put("residueList", string4.substring(1));
        }
        return hashtable;
    }

    @Override
    public Object getSymmetryInfo(BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bS == null) {
            n4 = this.vwr.am.cmi;
            if (n4 < 0) {
                return "";
            }
            bS = this.vwr.getModelUndeletedAtomsBitSet(n4);
        }
        if ((n3 = bS.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.vwr.ms.at[n3].mi;
        SymmetryInterface symmetryInterface = this.vwr.ms.am[n4].biosymmetry;
        if (symmetryInterface == null) {
            symmetryInterface = this.vwr.ms.getUnitCell(n4);
        }
        if (symmetryInterface == null) {
            return "";
        }
        return symmetryInterface.getSymmetryInfo(this.vwr.ms, n4, n3, symmetryInterface, string, n, p3, p32, string2, n2);
    }

    @Override
    public String getModelExtract(BS bS, boolean bl, boolean bl2, String string) {
        Quat quat;
        int n;
        int n2;
        LabelToken[] labelTokenArray;
        Object object;
        boolean bl3 = string.equalsIgnoreCase("V3000");
        boolean bl4 = string.equalsIgnoreCase("SDF");
        boolean bl5 = string.equalsIgnoreCase("XYZVIB");
        boolean bl6 = string.equalsIgnoreCase("JSON") || string.equalsIgnoreCase("CD");
        SB sB = new SB();
        ModelSet modelSet = this.vwr.ms;
        if (!bl5 && !bl6) {
            sB.append(bl2 ? "Jmol Model Kit" : this.vwr.getFullPathName(false).replace('\\', '/'));
            object = Viewer.getJmolVersion();
            sB.append("\n__Jmol-").append(((String)object).substring(0, 2));
            labelTokenArray = Calendar.getInstance();
            int n3 = labelTokenArray.get(2);
            n2 = labelTokenArray.get(5);
            n = labelTokenArray.get(1);
            int n4 = labelTokenArray.get(11);
            int n5 = labelTokenArray.get(12);
            Txt.rightJustify(sB, "_00", "" + (1 + n3));
            Txt.rightJustify(sB, "00", "" + n2);
            sB.append(("" + n).substring(2, 4));
            Txt.rightJustify(sB, "00", "" + n4);
            Txt.rightJustify(sB, "00", "" + n5);
            sB.append("3D 1   1.00000     0.00000     0");
            sB.append("\nJmol version ").append(Viewer.getJmolVersion()).append(" EXTRACT: ").append(Escape.eBS(bS)).append("\n");
        }
        object = BSUtil.copy(bS);
        Atom[] atomArray = modelSet.at;
        n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (bl && atomArray[n2].isDeleted()) {
                ((BS)object).clear(n2);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        BS bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bo, modelSet.bondCount, (BS)object);
        if (!bl5 && ((BS)object).cardinality() == 0) {
            return "";
        }
        n = 1;
        Quat quat2 = quat = bl ? this.vwr.tm.getRotationQuaternion() : null;
        if (bl4) {
            String string2 = sB.toString();
            sB = new SB();
            labelTokenArray = this.vwr.ms.getModelBS((BS)object, true);
            int n6 = labelTokenArray.nextSetBit(0);
            while (n6 >= 0) {
                sB.append(string2);
                BS bS3 = BSUtil.copy((BS)object);
                bS3.and(modelSet.getModelAtomBitSetIncludingDeleted(n6, false));
                bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bo, modelSet.bondCount, bS3);
                boolean bl7 = this.addMolFile(sB, bS3, bS2, false, false, quat);
                n = bl7 ? 1 : 0;
                if (bl7) {
                    sB.append("$$$$\n");
                    n6 = labelTokenArray.nextSetBit(n6 + 1);
                    continue;
                }
                break;
            }
        } else if (bl5) {
            LabelToken[] labelTokenArray2 = LabelToken.compile(this.vwr, "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz\n", '\u0000', null);
            labelTokenArray = LabelToken.compile(this.vwr, "%-2e %10.5x %10.5y %10.5z\n", '\u0000', null);
            BS bS4 = this.vwr.ms.getModelBS((BS)object, true);
            P3 p3 = new P3();
            int n7 = bS4.nextSetBit(0);
            while (n7 >= 0) {
                BS bS5 = BSUtil.copy((BS)object);
                bS5.and(modelSet.getModelAtomBitSetIncludingDeleted(n7, false));
                if (bS5.cardinality() != 0) {
                    sB.appendI(bS5.cardinality()).appendC('\n');
                    Properties properties = modelSet.am[n7].properties;
                    sB.append("Model[" + (n7 + 1) + "]: ");
                    if (modelSet.frameTitles[n7] != null && modelSet.frameTitles[n7].length() > 0) {
                        sB.append(modelSet.frameTitles[n7].replace('\n', ' '));
                    } else if (properties == null) {
                        sB.append("Jmol " + Viewer.getJmolVersion());
                    } else {
                        SB sB2 = new SB();
                        Enumeration<?> enumeration = properties.propertyNames();
                        String string3 = null;
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            if (string4.equals(".PATH")) {
                                string3 = properties.getProperty(string4);
                                continue;
                            }
                            sB2.append(";").append(string4).append("=").append(properties.getProperty(string4));
                        }
                        if (string3 != null) {
                            sB2.append(";PATH=").append(string3);
                        }
                        string3 = sB2.substring(sB2.length() > 0 ? 1 : 0);
                        sB.append(string3.replace('\n', ' '));
                    }
                    sB.appendC('\n');
                    int n8 = bS5.nextSetBit(0);
                    while (n8 >= 0) {
                        sB.append(LabelToken.formatLabelAtomArray(this.vwr, atomArray[n8], modelSet.getVibration(n8, false) == null ? labelTokenArray : labelTokenArray2, '\u0000', null, p3));
                        n8 = bS5.nextSetBit(n8 + 1);
                    }
                }
                n7 = bS4.nextSetBit(n7 + 1);
            }
        } else {
            n = this.addMolFile(sB, (BS)object, bS2, bl3, bl6, quat) ? 1 : 0;
        }
        return n != 0 ? sB.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private boolean addMolFile(SB sB, BS bS, BS bS2, boolean bl, boolean bl2, Quat quat) {
        float[] fArray;
        int n = bS.cardinality();
        int n2 = bS2.cardinality();
        if (!(bl || bl2 || n <= 999 && n2 <= 999)) {
            return false;
        }
        ModelSet modelSet = this.vwr.ms;
        int[] nArray = new int[modelSet.ac];
        P3 p3 = new P3();
        if (bl) {
            sB.append("  0  0  0  0  0  0            999 V3000");
        } else if (bl2) {
            sB.append("{\"mol\":{\"createdBy\":\"Jmol " + Viewer.getJmolVersion() + "\",\"a\":[");
        } else {
            Txt.rightJustify(sB, "   ", "" + n);
            Txt.rightJustify(sB, "   ", "" + n2);
            sB.append("  0  0  0  0              1 V2000");
        }
        if (!bl2) {
            sB.append("\n");
        }
        if (bl) {
            sB.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").appendI(n).append(" ").appendI(n2).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        P3 p32 = new P3();
        int n3 = bS.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            nArray[n3] = ++n4;
            this.getAtomRecordMOL(modelSet, sB, nArray[n3], modelSet.at[n3], quat, p3, p32, bl, bl2);
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (bl2) {
            sB.append("],\"b\":[");
        }
        n3 = bS2.nextSetBit(0);
        n4 = 0;
        while (n3 >= 0) {
            this.getBondRecordMOL(sB, ++n4, modelSet.bo[n3], nArray, bl, bl2);
            n3 = bS2.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (bl2) {
            sB.append("]}}");
        } else {
            sB.append("M  END\n");
        }
        if (!bl2 && !bl && (fArray = modelSet.getPartialCharges()) != null) {
            sB.append("> <JMOL_PARTIAL_CHARGES>\n").appendI(n).appendC('\n');
            n4 = bS.nextSetBit(0);
            int n5 = 0;
            while (n4 >= 0) {
                sB.appendI(++n5).append(" ").appendF(fArray[n4]).appendC('\n');
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        return true;
    }

    private static BS getCovalentBondsForAtoms(Bond[] bondArray, int n, BS bS) {
        BS bS2 = new BS();
        for (int i = 0; i < n; ++i) {
            Bond bond = bondArray[i];
            if (!bS.get(bond.atom1.i) || !bS.get(bond.atom2.i) || !bond.isCovalent()) continue;
            bS2.set(i);
        }
        return bS2;
    }

    private void getAtomRecordMOL(ModelSet modelSet, SB sB, int n, Atom atom, Quat quat, P3 p3, P3 p32, boolean bl, boolean bl2) {
        if (modelSet.am[atom.mi].isTrajectory) {
            atom.setFractionalCoordPt(p32, ((P3[])modelSet.trajectorySteps.get(atom.mi))[atom.i - modelSet.am[atom.mi].firstAtomIndex], true);
        } else {
            p3.setT(atom);
        }
        if (quat != null) {
            quat.transformP2(p3, p3);
        }
        int n2 = atom.getElementNumber();
        String string = atom.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(n2);
        int n3 = atom.getIsotopeNumber();
        int n4 = atom.getFormalCharge();
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").append(string).append(" ").appendF(p3.x).append(" ").appendF(p3.y).append(" ").appendF(p3.z).append(" 0");
            if (n4 != 0) {
                sB.append(" CHG=").appendI(n4);
            }
            if (n3 != 0) {
                sB.append(" MASS=").appendI(n3);
            }
            sB.append("\n");
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{");
            if (atom.getElementNumber() != 6) {
                sB.append("\"l\":\"").append(atom.getElementSymbol()).append("\",");
            }
            if (n4 != 0) {
                sB.append("\"c\":").appendI(n4).append(",");
            }
            if (n3 != 0 && n3 != Elements.getNaturalIsotope(n2)) {
                sB.append("\"m\":").appendI(n3).append(",");
            }
            sB.append("\"x\":").appendF(atom.x).append(",\"y\":").appendF(atom.y).append(",\"z\":").appendF(atom.z).append("}");
        } else {
            sB.append(Txt.sprintf("%10.5p%10.5p%10.5p", "p", new Object[]{p3}));
            sB.append(" ").append(string);
            if (string.length() == 1) {
                sB.append(" ");
            }
            if (n3 > 0) {
                n3 -= Elements.getNaturalIsotope(atom.getElementNumber());
            }
            sB.append(" ");
            Txt.rightJustify(sB, "  ", "" + n3);
            Txt.rightJustify(sB, "   ", "" + (n4 == 0 ? 0 : 4 - n4));
            sB.append("  0  0  0  0\n");
        }
    }

    private void getBondRecordMOL(SB sB, int n, Bond bond, int[] nArray, boolean bl, boolean bl2) {
        int n2 = nArray[bond.atom1.i];
        int n3 = nArray[bond.atom2.i];
        int n4 = bond.getValence();
        if (n4 > 3) {
            n4 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n4 = bl2 ? -3 : 4;
                break;
            }
            case 66: {
                n4 = bl2 ? -3 : 5;
                break;
            }
            case 513: {
                n4 = bl2 ? 1 : 6;
                break;
            }
            case 514: {
                n4 = bl2 ? 2 : 7;
                break;
            }
            case 33: {
                int n5 = n4 = bl2 ? -1 : 8;
            }
        }
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").appendI(n4).append(" ").appendI(n2).append(" ").appendI(n3).appendC('\n');
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{\"b\":").appendI(n2 - 1).append(",\"e\":").appendI(n3 - 1);
            if (n4 != 1) {
                sB.append(",\"o\":");
                if (n4 < 0) {
                    sB.appendF((float)(-n4) / 2.0f);
                } else {
                    sB.appendI(n4);
                }
            }
            sB.append("}");
        } else {
            Txt.rightJustify(sB, "   ", "" + n2);
            Txt.rightJustify(sB, "   ", "" + n3);
            sB.append("  ").appendI(n4).append("  0  0  0\n");
        }
    }

    @Override
    public String getChimeInfo(int n, BS bS) {
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741864: {
                return this.getBasePairInfo(bS);
            }
            default: {
                return this.getChimeInfoA(this.vwr.ms.at, n, bS);
            }
        }
        SB sB = new SB();
        this.vwr.ms.am[0].getChimeInfo(sB, 0);
        return sB.appendC('\n').toString().substring(1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String getChimeInfoA(Atom[] var1_1, int var2_2, BS var3_3) {
        var4_4 = new SB();
        var4_4.append("\n");
        var5_5 = "";
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        if (var3_3 != null) {
            var10_10 = var3_3.nextSetBit(0);
            block10: while (var10_10 >= 0) {
                var11_11 = var1_1[var10_10];
                switch (var2_2) {
                    case 1114638363: {
                        var5_5 = var11_11.getInfo();
                        ** break;
                    }
                    case 0x44100001: {
                        var5_5 = "" + var11_11.getAtomNumber();
                        ** break;
                    }
                    case 1087373318: {
                        var5_5 = var11_11.getGroup3(false);
                        ** break;
                    }
                    case 1073742120: 
                    case 0x40D00004: 
                    case 1087373319: 
                    case 1087373320: {
                        var12_12 = var11_11.getChainID();
                        v0 = var5_5 = var12_12 == 0 ? " " : var11_11.getChainIDStr();
                        if (var12_12 > 255) {
                            var5_5 = PT.esc(var5_5);
                        }
                        switch (var2_2) {
                            case 1073742120: {
                                var5_5 = "[" + var11_11.getGroup3(false) + "]" + var11_11.getSeqcodeString() + ":" + var5_5;
                                ** break;
                            }
                            case 1087373319: 
                            case 1087373320: {
                                if (var11_11.getModelIndex() != var8_8) {
                                    var4_4.appendC('\n');
                                    var9_9 = 0;
                                    var8_8 = var11_11.getModelIndex();
                                    var4_4.append("Model " + var11_11.getModelNumber());
                                    var7_7 = null;
                                    var6_6 = null;
                                }
                                if (var11_11.getChain() != var6_6) {
                                    var4_4.appendC('\n');
                                    var9_9 = 0;
                                    var6_6 = var11_11.getChain();
                                    var4_4.append("Chain " + var5_5 + ":\n");
                                    var7_7 = null;
                                }
                                if ((var13_13 = var11_11.getGroup()) == var7_7) break;
                                var7_7 = var13_13;
                                if (var2_2 == 1087373319) {
                                    var4_4.append(var11_11.getGroup1('?'));
                                    break;
                                }
                                if (var9_9++ % 5 == 0 && var9_9 > 1) {
                                    var4_4.appendC('\n');
                                }
                                Txt.leftJustify(var4_4, "          ", "[" + var11_11.getGroup3(false) + "]" + var11_11.getResno() + " ");
                                break;
                            }
lbl61:
                            // 2 sources

                            default: lbl-1000:
                            // 4 sources

                            {
                                if (var4_4.indexOf("\n" + var5_5 + "\n") >= 0) break;
                                var4_4.append(var5_5).appendC('\n');
                            }
                        }
                        var10_10 = var3_3.nextSetBit(var10_10 + 1);
                        continue block10;
                    }
                    default: {
                        return "";
                    }
                }
            }
        }
        if (var2_2 == 1087373320) {
            var4_4.appendC('\n');
        }
        return var4_4.toString().substring(1);
    }

    @Override
    public String getModelFileInfo(BS bS) {
        ModelSet modelSet = this.vwr.ms;
        SB sB = new SB();
        for (int i = 0; i < modelSet.mc; ++i) {
            if (bS != null && !bS.get(i)) continue;
            String string = "[\"" + modelSet.getModelNumberDotted(i) + "\"] = ";
            sB.append("\n\nfile").append(string).append(PT.esc(modelSet.getModelFileName(i)));
            String string2 = (String)modelSet.getInfo(i, "modelID");
            if (string2 != null) {
                sB.append("\nid").append(string).append(PT.esc(string2));
            }
            sB.append("\ntitle").append(string).append(PT.esc(modelSet.getModelTitle(i)));
            sB.append("\nname").append(string).append(PT.esc(modelSet.getModelName(i)));
            sB.append("\ntype").append(string).append(PT.esc(modelSet.getModelFileType(i)));
        }
        return sB.toString();
    }

    public Lst<Map<String, Object>> getAllAtomInfo(BS bS) {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        P3 p3 = new P3();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            lst.addLast(this.getAtomInfoLong(n, p3));
            n = bS.nextSetBit(n + 1);
        }
        return lst;
    }

    private Map<String, Object> getAtomInfoLong(int n, P3 p3) {
        ModelSet modelSet = this.vwr.ms;
        Atom atom = modelSet.at[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        modelSet.getAtomIdentityInfo(n, hashtable, p3);
        hashtable.put("element", modelSet.getElementName(n));
        hashtable.put("elemno", modelSet.getElementNumber(n));
        hashtable.put("x", Float.valueOf(atom.x));
        hashtable.put("y", Float.valueOf(atom.y));
        hashtable.put("z", Float.valueOf(atom.z));
        hashtable.put("coord", P3.newP(atom));
        if (modelSet.vibrations != null && modelSet.vibrations[n] != null) {
            modelSet.vibrations[n].getInfo(hashtable);
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        String string = Atom.atomPropertyString(this.vwr, atom, 1087373323);
        if (string != null) {
            hashtable.put("shape", string);
        }
        hashtable.put("visible", atom.checkVisible());
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", Float.valueOf(atom.getRadius()));
        String string2 = Escape.escapeColor(this.vwr.getColorArgbOrGray(atom.colixAtom));
        if (string2 != null) {
            hashtable.put("color", string2);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", Float.valueOf(f));
        }
        if (modelSet.am[atom.mi].isBioModel) {
            hashtable.put("resname", atom.getGroup3(false));
            char c = atom.getInsertionCode();
            int n2 = atom.getResno();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            hashtable.put("name", modelSet.getAtomName(n));
            hashtable.put("chain", atom.getChainIDStr());
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.getGroupID());
            if (atom.altloc != '\u0000') {
                hashtable.put("altLocation", "" + atom.altloc);
            }
            hashtable.put("structure", atom.getProteinStructureType().getId());
            hashtable.put("polymerLength", atom.getPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    public Lst<Map<String, Object>> getAllBondInfo(Object object) {
        Lst<Map<String, Object>> lst;
        block5: {
            P3 p3;
            Bond[] bondArray;
            int n;
            block6: {
                block4: {
                    lst = new Lst<Map<String, Object>>();
                    ModelSet modelSet = this.vwr.ms;
                    n = modelSet.bondCount;
                    bondArray = modelSet.bo;
                    if (object instanceof String) {
                        object = this.vwr.getAtomBitSet(object);
                    }
                    p3 = new P3();
                    if (!(object instanceof BS[])) break block4;
                    BS bS = ((BS[])object)[0];
                    BS bS2 = ((BS[])object)[1];
                    for (int i = 0; i < n; ++i) {
                        int n2 = bondArray[i].atom1.i;
                        int n3 = bondArray[i].atom2.i;
                        if ((!bS.get(n2) || !bS2.get(n3)) && (!bS2.get(n2) || !bS.get(n3))) continue;
                        lst.addLast(this.getBondInfo(i, p3));
                    }
                    break block5;
                }
                if (!(object instanceof BondSet)) break block6;
                BS bS = (BS)object;
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0 && n4 < n) {
                    lst.addLast(this.getBondInfo(n4, p3));
                    n4 = bS.nextSetBit(n4 + 1);
                }
                break block5;
            }
            if (!(object instanceof BS)) break block5;
            BS bS = (BS)object;
            int n5 = bS.cardinality() == 1 ? bS.nextSetBit(0) : -1;
            for (int i = 0; i < n; ++i) {
                if (!(n5 >= 0 ? bondArray[i].atom1.i == n5 || bondArray[i].atom2.i == n5 : bS.get(bondArray[i].atom1.i) && bS.get(bondArray[i].atom2.i))) continue;
                lst.addLast(this.getBondInfo(i, p3));
            }
        }
        return lst;
    }

    private Map<String, Object> getBondInfo(int n, P3 p3) {
        Bond bond = this.vwr.ms.bo[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom.i, hashtable2, p3);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom2.i, hashtable3, p3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", Float.valueOf(PT.fVal(Edge.getBondOrderNumberFromOrder(bond.order))));
        hashtable.put("type", Edge.getBondOrderNameFromOrder(bond.order));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.vwr.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        if (C.isColixTranslucent(bond.colix)) {
            hashtable.put("translucent", Boolean.TRUE);
        }
        return hashtable;
    }

    public Map<String, Lst<Map<String, Object>>> getAllChainInfo(BS bS) {
        Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
        Lst lst = new Lst();
        int n = this.vwr.ms.mc;
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Lst<Map<String, Lst<Map<String, Object>>>> lst2 = this.getChainInfo(i, bS);
            if (lst2.size() <= 0) continue;
            hashtable2.put("modelIndex", Integer.valueOf(i));
            hashtable2.put("chains", lst2);
            lst.addLast(hashtable2);
        }
        hashtable.put("models", lst);
        return hashtable;
    }

    private Lst<Map<String, Lst<Map<String, Object>>>> getChainInfo(int n, BS bS) {
        Model model = this.vwr.ms.am[n];
        int n2 = model.getChainCount(true);
        Lst<Map<String, Lst<Map<String, Object>>>> lst = new Lst<Map<String, Lst<Map<String, Object>>>>();
        P3 p3 = new P3();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChainAt(i);
            Lst<Map<String, Object>> lst2 = new Lst<Map<String, Object>>();
            int n3 = chain.getGroupCount();
            Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bS.get(group.firstAtomIndex)) continue;
                lst2.addLast(group.getGroupInfo(j, p3));
            }
            if (lst2.isEmpty()) continue;
            hashtable.put("residues", lst2);
            lst.addLast((Map<String, Lst<Map<String, Object>>>)hashtable);
        }
        return lst;
    }

    private Map<String, Lst<Map<String, Object>>> getAllPolymerInfo(BS bS) {
        Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        int n = this.vwr.ms.mc;
        Model[] modelArray = this.vwr.ms.am;
        for (int i = 0; i < n; ++i) {
            if (!modelArray[i].isBioModel) continue;
            modelArray[i].getAllPolymerInfo(bS, hashtable, lst);
        }
        hashtable.put("models", lst);
        return hashtable;
    }

    private String getBasePairInfo(BS bS) {
        SB sB = new SB();
        Lst<Bond> lst = new Lst<Bond>();
        this.vwr.ms.calcRasmolHydrogenBonds(bS, bS, lst, true, 1, false, null);
        int n = lst.size();
        while (--n >= 0) {
            Bond bond = (Bond)lst.get(n);
            PropertyManager.getAtomResidueInfo(sB, bond.atom1);
            sB.append(" - ");
            PropertyManager.getAtomResidueInfo(sB, bond.atom2);
            sB.append("\n");
        }
        return sB.toString();
    }

    private static void getAtomResidueInfo(SB sB, Atom atom) {
        sB.append("[").append(atom.getGroup3(false)).append("]").append(atom.getSeqcodeString()).append(":");
        int n = atom.getChainID();
        sB.append(n == 0 ? " " : atom.getChainIDStr());
    }

    private Map<String, Object> getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.vwr.htmlName);
        hashtable.put("syncId", this.vwr.syncId);
        hashtable.put("fullName", this.vwr.fullName);
        hashtable.put("codeBase", "" + Viewer.appletCodeBase);
        if (this.vwr.isApplet()) {
            hashtable.put("documentBase", Viewer.appletDocumentBase);
            hashtable.put("registry", this.vwr.sm.getRegistryInfo());
        }
        hashtable.put("version", JC.version);
        hashtable.put("date", JC.date);
        hashtable.put("javaVendor", Viewer.strJavaVendor);
        hashtable.put("javaVersion", Viewer.strJavaVersion + (!this.vwr.isJS ? "" : (this.vwr.isWebGL ? "(WebGL)" : "(HTML5)")));
        hashtable.put("operatingSystem", Viewer.strOSName);
        return hashtable;
    }

    private Map<String, Object> getAnimationInfo() {
        AnimationManager animationManager = this.vwr.am;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("firstModelIndex", animationManager.firstFrameIndex);
        hashtable.put("lastModelIndex", animationManager.lastFrameIndex);
        hashtable.put("animationDirection", animationManager.animationDirection);
        hashtable.put("currentDirection", animationManager.currentDirection);
        hashtable.put("displayModelIndex", animationManager.cmi);
        if (animationManager.animationFrames != null) {
            hashtable.put("isMovie", Boolean.TRUE);
            hashtable.put("frames", Escape.eAI(animationManager.animationFrames));
            hashtable.put("currentAnimationFrame", animationManager.caf);
        }
        hashtable.put("displayModelNumber", this.vwr.getModelNumberDotted(animationManager.cmi));
        hashtable.put("displayModelName", animationManager.cmi >= 0 ? this.vwr.getModelName(animationManager.cmi) : "");
        hashtable.put("animationFps", animationManager.animationFps);
        hashtable.put("animationReplayMode", animationManager.animationReplayMode.name());
        hashtable.put("firstFrameDelay", Float.valueOf(animationManager.firstFrameDelay));
        hashtable.put("lastFrameDelay", Float.valueOf(animationManager.lastFrameDelay));
        hashtable.put("animationOn", animationManager.animationOn);
        hashtable.put("animationPaused", animationManager.animationPaused);
        return hashtable;
    }

    private Map<String, Object> getBoundBoxInfo() {
        P3[] p3Array = this.vwr.ms.getBoxInfo(null, 1.0f).getBoundBoxPoints(true);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("center", P3.newP(p3Array[0]));
        hashtable.put("vector", V3.newV(p3Array[1]));
        hashtable.put("corner0", P3.newP(p3Array[2]));
        hashtable.put("corner1", P3.newP(p3Array[3]));
        return hashtable;
    }

    private Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        SB sB = new SB();
        Shape[] shapeArray = this.vwr.shm.shapes;
        if (shapeArray != null) {
            for (int i = 0; i < 36; ++i) {
                Shape shape = shapeArray[i];
                if (shape == null) continue;
                String string = JC.shapeClassBases[i];
                Lst<Map<String, Object>> lst = shape.getShapeDetail();
                if (lst == null) continue;
                hashtable.put(string, lst);
            }
        }
        if (sB.length() > 0) {
            hashtable.put("shapeCommands", sB.toString());
        }
        return hashtable;
    }

    private Map<String, Object> getAuxiliaryInfo(Object object) {
        return this.vwr.ms.getAuxiliaryInfo(this.vwr.ms.getModelBS(this.vwr.getAtomBitSet(object), false));
    }

    private SV getAnnotationInfo(Object object, int n) {
        BS bS = this.vwr.getAtomBitSet(object);
        int n2 = this.vwr.ms.getModelBS(bS, false).nextSetBit(0);
        if (n2 < 0) {
            return null;
        }
        Map<String, Object> map = this.vwr.ms.getModelAuxiliaryInfo(n2);
        SV sV = (SV)map.get(n == 1073741925 ? "domains" : "validation");
        if (sV == null || sV.tok != 6) {
            return null;
        }
        this.vwr.getAnnotationParser().initializeAnnotation(sV, n, n2);
        return sV.getMap().get("_list");
    }

    private Lst<Map<String, Object>> getMeasurementInfo() {
        return (Lst)this.vwr.getShapeProperty(6, "info");
    }

    /*
     * WARNING - void declaration
     */
    private Object getMouseInfo() {
        if (!this.vwr.haveDisplay) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst<void> lst = new Lst<void>();
        ActionManager actionManager = this.vwr.actionManager;
        for (Object object : actionManager.b.getBindings().values()) {
            void stringArray;
            if (object instanceof Boolean) continue;
            if (PT.isAI(object)) {
                int[] nArray = (int[])object;
                String[] stringArray2 = new String[]{Binding.getMouseActionName(nArray[0], false), ActionManager.getActionName(nArray[1])};
            }
            lst.addLast(stringArray);
        }
        hashtable.put("bindings", lst);
        hashtable.put("bindingName", actionManager.b.name);
        hashtable.put("actionNames", ActionManager.actionNames);
        hashtable.put("actionInfo", ActionManager.actionInfo);
        hashtable.put("bindingInfo", PT.split(actionManager.getBindingInfo(null), "\n"));
        return hashtable;
    }

    @Override
    public String getPdbAtomData(BS bS, OC oC) {
        int n;
        if (this.vwr.ms.ac == 0 || bS.nextSetBit(0) < 0) {
            return "";
        }
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        }
        Atom[] atomArray = this.vwr.ms.at;
        Model[] modelArray = this.vwr.ms.am;
        short s = atomArray[bS.nextSetBit((int)0)].mi;
        short s2 = -1;
        boolean bl = "PQR".equals(oC.getType());
        String string = "%6.2Q%6.2b          ";
        if (bl) {
            string = "%8.4P%7.4V       ";
            float f = 0.0f;
            n = bS.nextSetBit(0);
            while (n >= 0) {
                f += atomArray[n].getPartialCharge();
                n = bS.nextSetBit(n + 1);
            }
            oC.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + f + " e\nREMARK   6\n");
        }
        int n2 = bS.length() - 1;
        n = s != atomArray[n2].mi ? 1 : 0;
        SB sB = n != 0 ? null : new SB();
        boolean bl2 = modelArray[s].isPdbWithMultipleBonds;
        P3 p3 = new P3();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Bond[] bondArray;
            Atom atom = atomArray[n3];
            if (n != 0 && atom.mi != s2) {
                if (s2 != -1) {
                    oC.append("ENDMDL\n");
                }
                s2 = atom.mi;
                oC.append("MODEL     " + (s2 + 1) + "\n");
            }
            String string2 = atom.getAtomName();
            boolean bl3 = atom.getElementSymbol().length() == 2 || string2.length() >= 4 || Character.isDigit(string2.charAt(0));
            boolean bl4 = modelArray[atom.mi].isBioModel;
            boolean bl5 = atom.isHetero();
            LabelToken[] labelTokenArray = !bl4 ? (bl3 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl5 ? (bl3 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl3 ? LabelToken.compile(this.vwr, "ATOM  %5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "ATOM  %5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)));
            String string3 = atom.getElementSymbolIso(false).toUpperCase();
            oC.append(LabelToken.formatLabelAtomArray(this.vwr, atom, labelTokenArray, '\u0000', null, p3)).append(string3.length() == 1 ? " " + string3 : string3.substring(0, 2)).append("  \n");
            if (n == 0 && (!bl4 || bl5 || bl2) && (bondArray = atom.getBonds()) != null) {
                block6: for (int i = 0; i < bondArray.length; ++i) {
                    int n4;
                    int n5 = atom.getAtomNumber();
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (!bS.get(atom2.i) || (n4 = bondArray[i].getCovalentOrder()) == 1 && bl2 && !bl5) continue;
                    int n6 = atom2.getAtomNumber();
                    switch (n4) {
                        case 2: 
                        case 3: {
                            if (n6 < n5) continue block6;
                        }
                        case 1: {
                            sB.append("CONECT").append(Txt.formatStringI("%5i", "i", n5));
                            for (int j = 0; j < n4; ++j) {
                                sB.append(Txt.formatStringI("%5i", "i", n6));
                            }
                            sB.appendC('\n');
                        }
                    }
                }
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (n != 0) {
            oC.append("ENDMDL\n");
        } else {
            oC.append(sB.toString());
        }
        return oC.toString();
    }

    @Override
    public String getPdbData(int n, String string, BS bS, Object[] objectArray, OC oC, boolean bl) {
        if (this.vwr.ms.isJmolDataFrameForModel(n)) {
            n = this.vwr.ms.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        Model model = this.vwr.ms.am[n];
        boolean bl2 = model.isBioModel;
        if (objectArray == null && !bl2) {
            return null;
        }
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        }
        SB sB = new SB();
        boolean bl3 = string.indexOf("draw") >= 0;
        BS bS2 = null;
        BS bS3 = new BS();
        char c = '\u0000';
        this.vwr.ms.getLabeler();
        LabelToken[] labelTokenArray = LabelToken.compile(this.vwr, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   ", '\u0000', null);
        if (objectArray == null) {
            c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            model.getPdbData(this.vwr, string, c, bl3, bS, oC, labelTokenArray, sB, bS3);
            bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        } else {
            bS2 = (BS)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl4 = fArray3 != null;
            P3 p3 = (P3)objectArray[4];
            P3 p32 = (P3)objectArray[5];
            P3 p33 = (P3)objectArray[6];
            P3 p34 = (P3)objectArray[7];
            oC.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append(";\n");
            oC.append("REMARK   6 Jmol data").append(" min = ").append(Escape.eP(p3)).append(" max = ").append(Escape.eP(p32)).append(" unScaledXyz = xyz * ").append(Escape.eP(p33)).append(" + ").append(Escape.eP(p34)).append(";\n");
            String string2 = "";
            Atom atom = null;
            Atom[] atomArray = this.vwr.ms.at;
            P3 p35 = new P3();
            int n2 = bS2.nextSetBit(0);
            int n3 = 0;
            while (n2 >= 0) {
                float f;
                float f2 = fArray[n3];
                float f3 = fArray2[n3];
                float f4 = f = bl4 ? fArray3[n3] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom2 = atomArray[n2];
                    oC.append(LabelToken.formatLabelAtomArray(this.vwr, atom2, labelTokenArray, '\u0000', null, p35));
                    if (bl2) {
                        bS3.set(n2);
                    }
                    oC.append(Txt.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", "ssF", new Object[]{atom2.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                    if (atom != null && atom.getPolymerIndexInModel() == atom2.getPolymerIndexInModel()) {
                        sB.append("CONECT").append(Txt.formatStringI("%5i", "i", atom.getAtomNumber())).append(Txt.formatStringI("%5i", "i", atom2.getAtomNumber())).appendC('\n');
                    }
                    atom = atom2;
                }
                n2 = bS2.nextSetBit(n2 + 1);
                ++n3;
            }
        }
        oC.append(sB.toString());
        if (bl3) {
            return oC.toString();
        }
        bS.and(bS2);
        if (bl2 && bl) {
            oC.append("\n\n" + this.vwr.ms.getProteinStructureState(bS3, false, c == 'R', 1));
        }
        return oC.toString();
    }

    @Override
    public String getModelCml(BS bS, int n, boolean bl) {
        Bond[] bondArray;
        SB sB = new SB();
        int n2 = BSUtil.cardinalityOf(bS);
        if (n2 == 0) {
            return "";
        }
        Interface.getInterface("javajs.util.XmlUtil");
        XmlUtil.openTag(sB, "molecule");
        XmlUtil.openTag(sB, "atomArray");
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            bondArray = atomArray[n3];
            String string = bondArray.getAtomName();
            PT.rep(string, "\"", "''");
            bS2.set(bondArray.i);
            XmlUtil.appendTag(sB, "atom/", new String[]{"id", "a" + (bondArray.i + 1), "title", bondArray.getAtomName(), "elementType", bondArray.getElementSymbol(), "x3", "" + bondArray.x, "y3", "" + bondArray.y, "z3", "" + bondArray.z});
            n3 = bS.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(sB, "atomArray");
        if (bl) {
            XmlUtil.openTag(sB, "bondArray");
            n3 = this.vwr.getBondCount();
            bondArray = this.vwr.ms.bo;
            for (int i = 0; i < n3; ++i) {
                String string;
                Bond bond = bondArray[i];
                Atom atom = bond.atom1;
                Atom atom2 = bond.atom2;
                if (!bS2.get(atom.i) || !bS2.get(atom2.i) || (string = Edge.getCmlBondOrder(bond.order)) == null) continue;
                XmlUtil.appendTag(sB, "bond/", new String[]{"atomRefs2", "a" + (bond.atom1.i + 1) + " a" + (bond.atom2.i + 1), "order", string});
            }
            XmlUtil.closeTag(sB, "bondArray");
        }
        XmlUtil.closeTag(sB, "molecule");
        return sB.toString();
    }
}

