/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.PAL;
import org.jmol.util.Escape;
import org.jmol.util.Int2IntHash;
import org.jmol.util.Logger;

public final class C {
    public static final short INHERIT_ALL = 0;
    public static final short INHERIT_COLOR = 1;
    public static final short USE_PALETTE = 2;
    public static final short RAW_RGB = 3;
    public static final short SPECIAL_COLIX_MAX = 4;
    static int colixMax = 4;
    static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static final Int2IntHash colixHash;
    private static final int RAW_RGB_INT = 3;
    public static final short UNMASK_CHANGEABLE_TRANSLUCENT = 2047;
    public static final short CHANGEABLE_MASK = Short.MIN_VALUE;
    public static final int LAST_AVAILABLE_COLIX = 2047;
    public static final int TRANSLUCENT_SHIFT = 11;
    public static final int ALPHA_SHIFT = 13;
    public static final int TRANSLUCENT_MASK = 30720;
    public static final int TRANSLUCENT_SCREENED = 30720;
    public static final int TRANSPARENT = 16384;
    public static final short OPAQUE_MASK = -30721;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;

    public static short getColix(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        int n3 = 0;
        if ((n & 0xFF000000) != -16777216) {
            n3 = C.getTranslucentFlag(n >> 24 & 0xFF);
            n |= 0xFF000000;
        }
        if (((n2 = colixHash.get(n)) & 3) == 3) {
            n3 = 0;
        }
        return (short)((n2 > 0 ? n2 : C.allocateColix(n)) | n3);
    }

    public static synchronized int allocateColix(int n) {
        int n2;
        int n3 = colixMax;
        while (--n3 >= 4) {
            if ((n & 0xFFFFFF) != (argbs[n3] & 0xFFFFFF)) continue;
            return n3;
        }
        if (colixMax == argbs.length) {
            n3 = colixMax;
            int n4 = n3 * 2;
            if (n4 > 2048) {
                n4 = 2048;
            }
            argbs = AU.arrayCopyI(argbs, n4);
            if (argbsGreyscale != null) {
                argbsGreyscale = AU.arrayCopyI(argbsGreyscale, n4);
            }
        }
        C.argbs[C.colixMax] = n;
        if (argbsGreyscale != null) {
            C.argbsGreyscale[C.colixMax] = CU.toFFGGGfromRGB(n);
        }
        colixHash.put(n, colixMax);
        if (colixMax < 2047) {
            int n5 = colixMax;
            n2 = n5;
            colixMax = n5 + 1;
        } else {
            n2 = colixMax;
        }
        return n2;
    }

    static void setLastGrey(int n) {
        C.calcArgbsGreyscale();
        C.argbsGreyscale[2047] = CU.toFFGGGfromRGB(n);
    }

    static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale != null) {
            return;
        }
        int[] nArray = new int[argbs.length];
        int n = argbs.length;
        while (--n >= 4) {
            nArray[n] = CU.toFFGGGfromRGB(argbs[n]);
        }
        argbsGreyscale = nArray;
    }

    public static final int getArgbGreyscale(short s) {
        if (argbsGreyscale == null) {
            C.calcArgbsGreyscale();
        }
        return argbsGreyscale[s & 0xFFFF87FF];
    }

    public static short getColixO(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof PAL) {
            return (PAL)((Object)object) == PAL.NONE ? (short)0 : 2;
        }
        if (object instanceof Integer) {
            return C.getColix((Integer)object);
        }
        if (object instanceof String) {
            return C.getColixS((String)object);
        }
        if (object instanceof Byte) {
            return (Byte)object == 0 ? (short)0 : 2;
        }
        if (Logger.debugging) {
            Logger.debug("?? getColix(" + object + ")");
        }
        return 22;
    }

    private static int getTranslucentFlag(float f) {
        if (f == 0.0f) {
            return 0;
        }
        if (f < 0.0f) {
            return 30720;
        }
        if (Float.isNaN(f) || f >= 255.0f || (double)f == 1.0) {
            return 16384;
        }
        int n = (int)Math.floor(f < 1.0f ? (double)(f * 256.0f) : (f <= 9.0f ? (double)((int)Math.floor(f - 1.0f) << 5) : (f < 15.0f ? 256.0 : (double)f)));
        return (n >> 5 & 0xF) << 11;
    }

    public static boolean isColixLastAvailable(short s) {
        return s > 0 && (s & 0x7FF) == 2047;
    }

    public static int getArgb(short s) {
        return argbs[s & 0xFFFF87FF];
    }

    public static final boolean isColixColorInherited(short s) {
        switch (s) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return (s & 0xFFFF87FF) == 1;
    }

    public static final short getColixInherited(short s, short s2) {
        switch (s) {
            case 0: {
                return s2;
            }
            case 1: {
                return (short)(s2 & 0xFFFF87FF);
            }
        }
        return (s & 0xFFFF87FF) == 1 ? (short)(s2 & 0xFFFF87FF | s & 0x7800) : s;
    }

    public static final boolean isColixTranslucent(short s) {
        return (s & 0x7800) != 0;
    }

    public static final short getChangeableColixIndex(short s) {
        return s >= 0 ? (short)-1 : (short)(s & 0x7FF);
    }

    public static final short getColixTranslucent3(short s, boolean bl, float f) {
        if ((s = (short)(s & 0xFFFF87FF)) == 0) {
            s = 1;
        }
        return bl ? (short)(s | C.getTranslucentFlag(f)) : s;
    }

    public static final short copyColixTranslucency(short s, short s2) {
        return C.getColixTranslucent3(s2, C.isColixTranslucent(s), C.getColixTranslucencyLevel(s));
    }

    public static float getColixTranslucencyFractional(short s) {
        int n = C.getColixTranslucencyLevel(s);
        return n == -1 ? 0.5f : (n == 0 ? 0.0f : (n == 255 ? 1.0f : (float)n / 256.0f));
    }

    public static final int getColixTranslucencyLevel(short s) {
        int n = s >> 11 & 0xF;
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return n << 5;
            }
            case 15: {
                return -1;
            }
        }
        return 255;
    }

    public static short getColixS(String string) {
        int n = CU.getArgbFromString(string);
        if (n != 0) {
            return C.getColix(n);
        }
        if ("none".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("opaque".equalsIgnoreCase(string)) {
            return 1;
        }
        return 2;
    }

    public static short[] getColixArray(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = PT.getTokens(string);
        short[] sArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sArray[i] = C.getColix(CU.getArgbFromString(stringArray[i]));
            if (sArray[i] != 0) continue;
            return null;
        }
        return sArray;
    }

    public static String getHexCode(short s) {
        return Escape.escapeColor(C.getArgb(s));
    }

    public static String getHexCodes(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        SB sB = new SB();
        for (int i = 0; i < sArray.length; ++i) {
            sB.append(i == 0 ? "" : " ").append(C.getHexCode(sArray[i]));
        }
        return sB.toString();
    }

    public static short getColixTranslucent(int n) {
        int n2 = n >> 24 & 0xFF;
        return n2 == 255 ? C.getColix(n) : C.getColixTranslucent3(C.getColix(n), true, (float)n2 / 255.0f);
    }

    public static short getBgContrast(int n) {
        return (CU.toFFGGGfromRGB(n) & 0xFF) < 128 ? (short)8 : 4;
    }

    static {
        colixHash = new Int2IntHash(256);
        int[] nArray = new int[]{-16777216, -23296, -16181, -16776961, -1, -16711681, -65536, -16744448, -8355712, -4144960, -16711936, -8388608, -16777088, -8355840, -8388480, -16744320, -65281, -256, -38476, -10496};
        for (int i = 0; i < nArray.length; ++i) {
            C.getColix(nArray[i]);
        }
    }
}

