/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Uccage;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.SimpleUnitCell;

public class UccageRenderer
extends CageRenderer {
    byte fid;
    private final P3[] verticesT = new P3[8];
    private P3 fset0 = P3.new3(555.0f, 555.0f, 1.0f);
    private P3 cell0 = new P3();
    private P3 cell1 = new P3();
    private P3 offset = new P3();
    private P3 offsetT = new P3();

    @Override
    protected void initRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n] = new P3();
        }
        this.tickEdges = BoxInfo.uccageTickEdges;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        this.imageFontScaling = this.vwr.getImageFontScaling();
        this.font3d = this.g3d.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int n = this.vwr.getObjectMad(5);
        if (n == 0 || this.vwr.isJmolDataFrame() || this.tm.isNavigating() && this.vwr.getBoolean(603979888)) {
            return false;
        }
        this.colix = this.vwr.getObjectColix(5);
        boolean bl = C.isColixTranslucent(this.colix);
        if (!this.isExport && bl != this.g3d.isPass2()) {
            return bl;
        }
        this.render1(n);
        return false;
    }

    private void render1(int n) {
        boolean bl;
        this.g3d.setC(this.colix);
        SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        this.isPolymer = symmetryInterface.isPolymer();
        this.isSlab = symmetryInterface.isSlab();
        P3[] p3Array = symmetryInterface.getUnitCellVertices();
        this.offset.setT(symmetryInterface.getCartesianOffset());
        this.offsetT.set(0.0f, 0.0f, 0.0f);
        symmetryInterface.toCartesian(this.offsetT, true);
        this.offset.sub(this.offsetT);
        P3 p3 = symmetryInterface.getUnitCellMultiplier();
        boolean bl2 = bl = p3 != null;
        if (!bl) {
            p3 = this.fset0;
        }
        SimpleUnitCell.ijkToPoint3f((int)p3.x, this.cell0, 0);
        SimpleUnitCell.ijkToPoint3f((int)p3.y, this.cell1, 1);
        if (p3.z < 0.0f) {
            this.cell0.scale(-1.0f / p3.z);
            this.cell1.scale(-1.0f / p3.z);
        }
        float f = Math.abs(p3.z);
        P3[] p3Array2 = this.vwr.getAxisPoints();
        boolean bl3 = this.vwr.getObjectMad(1) == 0 || this.vwr.getFloat(0x22000002) < 2.0f || p3Array2 == null;
        P3[] p3Array3 = p3Array2;
        if (p3.z == 0.0f) {
            this.offsetT.setT(this.cell0);
            symmetryInterface.toCartesian(this.offsetT, true);
            this.offsetT.add(this.offset);
            p3Array3 = this.cell0.x == 0.0f && this.cell0.y == 0.0f && this.cell0.z == 0.0f ? p3Array2 : null;
            int n2 = 0;
            int n3 = 255;
            int n4 = 255;
            P3[] p3Array4 = BoxInfo.unitCubePoints;
            int n5 = 8;
            while (--n5 >= 0) {
                P3 p32 = P3.new3(p3Array4[n5].x * (this.cell1.x - this.cell0.x), p3Array4[n5].y * (this.cell1.y - this.cell0.y), p3Array4[n5].z * (this.cell1.z - this.cell0.z));
                symmetryInterface.toCartesian(p32, true);
                this.verticesT[n5].add2(p32, this.offsetT);
            }
            this.renderCage(n, this.verticesT, p3Array3, n2, n3, n4, 1.0f);
        } else {
            int n6 = (int)this.cell0.x;
            while ((float)n6 < this.cell1.x) {
                int n7 = (int)this.cell0.y;
                while ((float)n7 < this.cell1.y) {
                    int n8 = (int)this.cell0.z;
                    while ((float)n8 < this.cell1.z) {
                        int n9;
                        if (bl) {
                            this.offsetT.set(n6, n7, n8);
                            this.offsetT.scale(f);
                            symmetryInterface.toCartesian(this.offsetT, true);
                            this.offsetT.add(this.offset);
                            p3Array3 = n6 == 0 && n7 == 0 && n8 == 0 ? p3Array2 : null;
                            n9 = bl3 || p3Array3 == null ? 0 : 3;
                        } else {
                            this.offsetT.setT(this.offset);
                            n9 = bl3 ? 0 : 3;
                        }
                        int n10 = 255;
                        int n11 = 255;
                        int n12 = 8;
                        while (--n12 >= 0) {
                            this.verticesT[n12].add2(p3Array[n12], this.offsetT);
                        }
                        this.renderCage(n, this.verticesT, p3Array3, n9, n10, n11, f);
                        ++n8;
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        if (this.vwr.getBoolean(603979828) && !this.vwr.isPreviewOnly() && !symmetryInterface.isPeriodic()) {
            this.renderInfo(symmetryInterface);
        }
    }

    private String nfformat(float f) {
        return DF.formatDecimal(f, 3);
    }

    private void renderInfo(SymmetryInterface symmetryInterface) {
        Lst<String> lst;
        if (this.isExport || !this.g3d.setC(this.vwr.getColixBackgroundContrast()) || !this.vwr.getBoolean(603979938)) {
            return;
        }
        this.fid = this.g3d.getFontFidFS("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFontFid(this.fid);
        int n = (int)Math.floor(15.0f * this.imageFontScaling);
        int n2 = (int)Math.floor(5.0f * this.imageFontScaling);
        int n3 = n;
        String string = symmetryInterface.getSpaceGroupName();
        if (this.isPolymer) {
            string = "polymer";
        } else if (this.isSlab) {
            string = "slab";
        } else if (string != null && string.startsWith("cell=!")) {
            string = "cell=inverse[" + string.substring(6) + "]";
        }
        string = PT.rep(string, ";0,0,0", "");
        if (string != null & !string.equals("-- [--]")) {
            this.g3d.drawStringNoSlab(string, null, n2, n3 += n, 0, (short)0);
        }
        if ((lst = symmetryInterface.getMoreInfo()) != null) {
            for (int i = 0; i < lst.size(); ++i) {
                this.g3d.drawStringNoSlab((String)lst.get(i), null, n2, n3 += n, 0, (short)0);
            }
        }
        if (!this.vwr.getBoolean(603979937)) {
            return;
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(symmetryInterface.getUnitCellInfoType(0)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        if (!this.isPolymer) {
            this.g3d.drawStringNoSlab("b=" + this.nfformat(symmetryInterface.getUnitCellInfoType(1)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        }
        if (!this.isPolymer && !this.isSlab) {
            this.g3d.drawStringNoSlab("c=" + this.nfformat(symmetryInterface.getUnitCellInfoType(2)) + "\u00c5", null, n2, n3 += n, 0, (short)0);
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(symmetryInterface.getUnitCellInfoType(3)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
                this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(symmetryInterface.getUnitCellInfoType(4)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
            }
            this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(symmetryInterface.getUnitCellInfoType(5)) + "\u00b0", null, n2, n3 += n, 0, (short)0);
        }
    }
}

