/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.QuantumPlaneCalculationInterface;
import org.jmol.java.BS;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class SurfaceReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    protected VolumeData volumeData;
    private String edgeData;
    protected boolean haveSurfaceAtoms = false;
    protected boolean allowSigma = false;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private float assocCutoff = 0.3f;
    protected boolean isQuiet;
    boolean vertexDataOnly;
    boolean hasColorData;
    protected float dataMin = Float.MAX_VALUE;
    protected float dataMax = -3.4028235E38f;
    protected float dataMean;
    protected P3 xyzMin;
    protected P3 xyzMax;
    protected P3 center;
    protected float[] anisotropy;
    protected boolean isAnisotropic;
    protected M3 eccentricityMatrix;
    protected M3 eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected float eccentricityScale;
    protected float eccentricityRatio;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    private int edgeCount;
    protected P3 volumetricOrigin;
    protected V3[] volumetricVectors;
    protected int[] voxelCounts;
    protected float[][][] voxelData;
    protected long nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected SB jvxlFileHeaderBuffer;
    protected SB fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected BS jvxlVoxelBitSet;
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected boolean jvxlDataIsColorDensity;
    protected float jvxlCutoff;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN = '\u0000';
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    protected MarchingCubes marchingCubes;
    protected float[][] yzPlanes;
    protected int yzCount;
    protected QuantumPlaneCalculationInterface qpc;
    protected final P3 ptTemp = new P3();
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};
    protected float[] minMax;
    private boolean haveSetAnisotropy = false;

    SurfaceReader() {
    }

    abstract void init(SurfaceGenerator var1);

    void initSR(SurfaceGenerator surfaceGenerator) {
        this.sg = surfaceGenerator;
        this.params = surfaceGenerator.getParams();
        this.marchingSquares = surfaceGenerator.getMarchingSquares();
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
        this.meshData = surfaceGenerator.getMeshData();
        this.jvxlData = surfaceGenerator.getJvxlData();
        this.setVolumeDataV(surfaceGenerator.getVolumeData());
        this.meshDataServer = surfaceGenerator.getMeshDataServer();
        this.cJvxlEdgeNaN = (char)125;
    }

    protected abstract void closeReader();

    protected void setOutputChannel(OC oC) {
    }

    protected void newVoxelDataCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    protected void setVolumeDataV(VolumeData volumeData) {
        this.nBytes = 0L;
        this.volumetricOrigin = volumeData.volumetricOrigin;
        this.volumetricVectors = volumeData.volumetricVectors;
        this.voxelCounts = volumeData.voxelCounts;
        this.voxelData = volumeData.getVoxelData();
        this.volumeData = volumeData;
    }

    protected abstract boolean readVolumeParameters(boolean var1);

    protected abstract boolean readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        this.jvxlData.jvxlUpdateInfo(this.params.title, this.nBytes);
    }

    boolean readAndSetVolumeParameters(boolean bl) {
        if (!this.readVolumeParameters(bl)) {
            return false;
        }
        if (this.vertexDataOnly) {
            return true;
        }
        return this.volumeData.setUnitVectors();
    }

    boolean createIsosurface(boolean bl) {
        this.resetIsosurface();
        if (this.params.showTiming) {
            Logger.startTimer("isosurface creation");
        }
        this.jvxlData.cutoff = Float.NaN;
        if (!this.readAndSetVolumeParameters(bl)) {
            return false;
        }
        if (!(bl || Float.isNaN(this.params.sigma) || this.allowSigma)) {
            if (this.params.sigma > 0.0f) {
                Logger.error("Reader does not support SIGMA option -- using cutoff 1.6");
            }
            this.params.cutoff = 1.6f;
        }
        if (this.params.sigma < 0.0f) {
            this.params.sigma = -this.params.sigma;
        }
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.jvxlData.isSlabbable = (this.params.dataType & 0x400) != 0;
        this.jvxlData.insideOut = this.params.insideOut;
        this.jvxlData.dataXYReversed = this.params.dataXYReversed;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        this.jvxlData.jvxlVolumeDataXml = this.volumeData.xmlData;
        this.jvxlData.voxelVolume = this.volumeData.voxelVolume;
        if (bl) {
            this.volumeData.setMappingPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.params.setMapRanges(this, false);
            this.generateSurfaceData();
            this.volumeData.setMappingPlane(null);
        } else {
            if (!this.readVolumeData(false)) {
                return false;
            }
            this.generateSurfaceData();
        }
        if (this.jvxlFileHeaderBuffer != null) {
            String string = this.jvxlFileHeaderBuffer.toString();
            int n = string.indexOf(10, string.indexOf(10, string.indexOf(10) + 1) + 1) + 1;
            this.jvxlData.jvxlFileTitle = string.substring(0, n);
        }
        if (this.params.contactPair == null) {
            this.setBBoxAll();
        }
        if (!this.params.isSilent) {
            Logger.info("boundbox corners " + Escape.eP(this.xyzMin) + " " + Escape.eP(this.xyzMax));
        }
        this.jvxlData.boundingBox = new P3[]{this.xyzMin, this.xyzMax};
        this.jvxlData.dataMin = this.dataMin;
        this.jvxlData.dataMax = this.dataMax;
        this.jvxlData.cutoff = this.isJvxl ? this.jvxlCutoff : this.params.cutoff;
        this.jvxlData.isCutoffAbsolute = this.params.isCutoffAbsolute;
        this.jvxlData.pointsPerAngstrom = 1.0f / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.edgeData;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.colorDensity = this.params.colorDensity;
        this.jvxlData.pointSize = this.params.pointSize;
        if (this.jvxlData.vContours != null) {
            this.params.nContours = this.jvxlData.vContours.length;
        }
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.jvxlDataIsColorDensity = this.jvxlDataIsColorDensity;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.vertexDataOnly = this.vertexDataOnly;
        this.jvxlData.saveVertexCount = 0;
        if (this.jvxlDataIsColorMapped || this.jvxlData.nVertexColors > 0) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceMappingCompleted();
            }
        }
        if (this.params.showTiming) {
            Logger.checkTimer("isosurface creation", false);
        }
        return true;
    }

    void resetIsosurface() {
        this.meshData = new MeshData();
        this.xyzMax = null;
        this.xyzMin = null;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0, null);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Float.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    void discardTempData(boolean bl) {
        this.discardTempDataSR(bl);
    }

    protected void discardTempDataSR(boolean bl) {
        if (!bl) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.setMarchingSquares(null);
        this.marchingCubes = null;
    }

    void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.setVolumeDataV(this.volumeData);
    }

    protected abstract void readSurfaceData(boolean var1) throws Exception;

    protected boolean gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX > 0 && this.nPointsY > 0 && this.nPointsZ > 0) {
            try {
                this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
                this.readSurfaceData(bl);
            }
            catch (Exception exception) {
                Logger.error(exception.toString());
                return false;
            }
        }
        return true;
    }

    protected void gotoData(int n, int n2) throws Exception {
    }

    protected String readColorData() {
        if (this.jvxlData.vertexColors == null) {
            return "";
        }
        int n = this.jvxlData.vertexCount;
        short[] sArray = this.meshData.vcs;
        float[] fArray = this.meshData.vvs;
        if (sArray == null || sArray.length < n) {
            this.meshData.vcs = sArray = new short[n];
        }
        if (fArray == null || fArray.length < n) {
            this.meshData.vvs = fArray = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            sArray[i] = C.getColix(this.jvxlData.vertexColors[i]);
        }
        return "-";
    }

    @Override
    public float[] getPlane(int n) {
        return this.getPlane2(n);
    }

    protected float[] getPlane2(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        if (this.qpc != null) {
            this.qpc.getPlane(n, this.yzPlanes[n % 2]);
        }
        return this.yzPlanes[n % 2];
    }

    void initPlanes() {
        this.yzCount = this.nPointsY * this.nPointsZ;
        if (!this.isQuiet) {
            Logger.info("reading data progressively -- yzCount = " + this.yzCount);
        }
        this.yzPlanes = AU.newFloat2(2);
        this.yzPlanes[0] = new float[this.yzCount];
        this.yzPlanes[1] = new float[this.yzCount];
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        return this.getValue2(n, n2, n3, n4);
    }

    protected float getValue2(int n, int n2, int n3, int n4) {
        return this.yzPlanes == null ? this.voxelData[n][n2][n3] : this.yzPlanes[n % 2][n4];
    }

    private void generateSurfaceData() {
        this.edgeData = "";
        if (this.vertexDataOnly) {
            try {
                this.readSurfaceData(false);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                Logger.error("Exception in SurfaceReader::readSurfaceData: " + exception.toString());
            }
            return;
        }
        this.contourVertexCount = 0;
        int n = -1;
        this.marchingSquares = null;
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.contoursDiscrete, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            n = this.marchingSquares.getContourType();
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.params.contourType = n;
        this.params.isXLowToHigh = this.isXLowToHigh;
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.params, this.jvxlVoxelBitSet);
        String string = this.marchingCubes.getEdgeData();
        if (this.params.thePlane == null) {
            this.edgeData = string;
        }
        this.jvxlData.setSurfaceInfoFromBitSetPts(this.marchingCubes.getBsVoxels(), this.params.thePlane, this.params.mapLattice);
        this.jvxlData.jvxlExcluded = this.params.bsExcluded;
        if (this.isJvxl) {
            this.edgeData = this.jvxlEdgeDataRead;
        }
        this.postProcessVertices();
    }

    protected void postProcessVertices() {
    }

    @Override
    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, P3i p3i, int n4, int n5, float f2, float f3, T3 t3, V3 v3, boolean bl2, float[] fArray) {
        int n6;
        int n7;
        float f4 = this.getSurfacePointAndFraction(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, this.ptTemp);
        if (this.marchingSquares != null && this.params.isContoured) {
            return this.marchingSquares.addContourVertex(this.ptTemp, f);
        }
        int n8 = this.assocCutoff > 0.0f ? (fArray[0] < this.assocCutoff ? n4 : (fArray[0] > 1.0f - this.assocCutoff ? n5 : -1)) : (n7 = -1);
        if (n7 >= 0) {
            n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n7);
        }
        if ((n6 = this.addVertexCopy(this.ptTemp, f4, n7, true)) >= 0 && this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(n, n2, n3, n5, this.ptTemp);
            this.addVertexCopy(f2 < f3 ? t3 : this.ptTemp, Math.min(f2, f3), -3, true);
            this.addVertexCopy(f2 < f3 ? this.ptTemp : t3, Math.max(f2, f3), -3, true);
        }
        return n6;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        return this.getSPF(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, t32);
    }

    protected float getSPF(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        float f4 = f3 - f2;
        float f5 = (f - f2) / f4;
        if (bl && (f5 < 0.0f || f5 > 1.0f)) {
            f5 = (-f - f2) / f4;
        }
        if (f5 < 0.0f || f5 > 1.0f) {
            f5 = Float.NaN;
        }
        fArray[0] = f5;
        t32.scaleAdd2(f5, v3, t3);
        return f2 + f5 * f4;
    }

    @Override
    public int addVertexCopy(T3 t3, float f, int n, boolean bl) {
        return this.addVC(t3, f, n, bl);
    }

    protected int addVC(T3 t3, float f, int n, boolean bl) {
        return Float.isNaN(f) && n != -3 ? -1 : (this.meshDataServer == null ? this.meshData.addVertexCopy(t3, f, n, bl) : this.meshDataServer.addVertexCopy(t3, f, n, bl));
    }

    @Override
    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        if (this.marchingSquares != null && this.params.isContoured) {
            if (n6 == 0) {
                return this.marchingSquares.addTriangle(n, n2, n3, n4, n5);
            }
            n6 = 0;
        }
        return this.meshDataServer != null ? this.meshDataServer.addTriangleCheck(n, n2, n3, n4, n5, bl, n6) : (bl && !MeshData.checkCutoff(n, n2, n3, this.meshData.vvs) ? -1 : this.meshData.addTriangleCheck(n, n2, n3, n4, n5, n6));
    }

    void colorIsosurface() {
        if (this.params.isSquared && this.volumeData != null) {
            this.volumeData.filterData(true, Float.NaN);
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.jvxlData.saveVertexCount = 0;
        if (this.params.isContoured && this.marchingSquares != null) {
            this.initializeMapping();
            this.params.setMapRanges(this, false);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.jvxlData.saveVertexCount = this.marchingSquares.contourVertexCount;
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour, this.params.isSquared ? 1.0E-8f : 1.0E-4f);
            this.jvxlData.contourValuesUsed = this.marchingSquares.getContourValues();
            this.minMax = this.marchingSquares.getMinMax();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            this.finalizeMapping();
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        boolean bl;
        boolean bl2;
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vcs = new short[this.meshData.vc];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            if (this.params.contactPair == null) {
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
        }
        boolean bl3 = bl2 = this.params.colorDensity || this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        if (this.params.contactPair != null) {
            bl2 = false;
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.contourValues = this.params.contoursDiscrete;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (!this.params.colorDensity && (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign)) {
            this.jvxlData.minColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg), this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
            this.jvxlData.maxColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos), this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        boolean bl4 = bl = this.jvxlDataIs2dContour || this.hasColorData || this.vertexDataOnly || this.params.colorDensity || this.params.isBicolorMap && !this.params.isContoured;
        if (!bl) {
            if (this.haveSurfaceAtoms && this.meshData.vertexSource == null) {
                this.meshData.vertexSource = new int[this.meshData.vc];
            }
            float f = Float.MAX_VALUE;
            float f2 = -3.4028235E38f;
            this.initializeMapping();
            int n = this.meshData.vc;
            while (--n >= this.meshData.mergeVertexCount0) {
                float f3;
                if (this.params.colorBySets) {
                    f3 = this.meshData.vertexSets[n];
                } else if (this.params.colorByPhase) {
                    f3 = this.getPhase(this.meshData.vs[n]);
                } else {
                    boolean bl5 = this.haveSurfaceAtoms;
                    f3 = this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vs[n], bl5);
                    if (bl5) {
                        this.meshData.vertexSource[n] = this.getSurfaceAtomIndex();
                    }
                }
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2 && f3 != Float.MAX_VALUE) {
                    f2 = f3;
                }
                this.meshData.vvs[n] = f3;
            }
            if (this.params.rangeSelected && this.minMax == null) {
                this.minMax = new float[]{f, f2};
            }
            this.finalizeMapping();
        }
        this.params.setMapRanges(this, true);
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        if (this.params.contactPair == null && this.jvxlData.vertexColors == null) {
            this.colorData();
        }
        JvxlCoder.jvxlCreateColorData(this.jvxlData, bl2 ? this.meshData.vvs : null);
        if (this.haveSurfaceAtoms && this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void colorData() {
        float[] fArray = this.meshData.vvs;
        short[] sArray = this.meshData.vcs;
        this.meshData.pcs = null;
        float f = this.jvxlData.valueMappedToBlue;
        float f2 = this.jvxlData.valueMappedToRed;
        short s = this.jvxlData.minColorIndex;
        short s2 = this.jvxlData.maxColorIndex;
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null);
        }
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        int n = this.meshData.vc;
        while (--n >= 0) {
            float f3 = fArray[n];
            if (s >= 0) {
                if (f3 <= 0.0f) {
                    sArray[n] = s;
                    continue;
                }
                if (!(f3 > 0.0f)) continue;
                sArray[n] = s2;
                continue;
            }
            if (f3 <= f2) {
                f3 = f2;
            }
            if (f3 >= f) {
                f3 = f;
            }
            sArray[n] = this.params.colorEncoder.getColorIndex(f3);
        }
        if ((this.params.nContours > 0 || this.jvxlData.contourValues != null) && this.jvxlData.contourColixes == null) {
            n = this.jvxlData.contourValues == null ? this.params.nContours : this.jvxlData.contourValues.length;
            this.jvxlData.contourColixes = new short[n];
            short[] sArray2 = this.jvxlData.contourColixes;
            float[] fArray2 = this.jvxlData.contourValues;
            if (fArray2 == null) {
                fArray2 = this.jvxlData.contourValuesUsed;
            }
            if (this.jvxlData.contourValuesUsed == null) {
                this.jvxlData.contourValuesUsed = fArray2 == null ? new float[n] : fArray2;
            }
            float f4 = (f - f2) / (float)(n + 1);
            this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
            for (int i = 0; i < n; ++i) {
                float f5;
                this.jvxlData.contourValuesUsed[i] = f5 = fArray2 == null ? f2 + (float)(i + 1) * f4 : fArray2[i];
                sArray2[i] = C.getColixTranslucent(this.params.colorEncoder.getArgb(f5));
            }
            this.jvxlData.contourColors = C.getHexCodes(sArray2);
        }
    }

    static int getColorPhaseIndex(String string) {
        int n = -1;
        for (int i = 0; i < colorPhases.length; ++i) {
            if (!string.equalsIgnoreCase(colorPhases[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    private float getPhase(T3 t3) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return t3.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return t3.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return t3.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return t3.x * t3.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return t3.y * t3.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return t3.x * t3.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return t3.x * t3.x - t3.y * t3.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return t3.z * t3.z * 2.0f - t3.x * t3.x - t3.y * t3.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    public float[] getMinMaxMappedValues(boolean bl) {
        if (this.minMax != null && this.minMax[0] != Float.MAX_VALUE) {
            return this.minMax;
        }
        if (this.params.colorBySets) {
            this.minMax = new float[]{0.0f, Math.max(this.meshData.nSets - 1, 0)};
            return this.minMax;
        }
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        if (this.params.usePropertyForColorRange && this.params.theProperty != null) {
            for (int i = 0; i < this.params.theProperty.length; ++i) {
                float f3;
                if (this.params.rangeSelected && !this.params.bsSelected.get(i) || Float.isNaN(f3 = this.params.theProperty[i])) continue;
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            this.minMax = new float[]{f, f2};
            return this.minMax;
        }
        int n = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        T3[] t3Array = this.meshData.vs;
        boolean bl2 = bl || this.jvxlDataIs2dContour || this.vertexDataOnly || this.params.colorDensity;
        for (int i = this.meshData.mergeVertexCount0; i < n; ++i) {
            float f4 = bl2 ? this.meshData.vvs[i] : this.volumeData.lookupInterpolatedVoxelValue(t3Array[i], false);
            if (f4 < f) {
                f = f4;
            }
            if (!(f4 > f2) || f4 == Float.MAX_VALUE) continue;
            f2 = f4;
        }
        this.minMax = new float[]{f, f2};
        return this.minMax;
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidatePolygons();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.meshData.setVertexSets(true);
        this.updateTriangles();
        if (this.params.bsExcluded[1] == null) {
            this.params.bsExcluded[1] = new BS();
        }
        this.meshData.updateInvalidatedVertices(this.params.bsExcluded[1]);
    }

    public void selectPocket(boolean bl) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int n = this.meshData.nSets;
        while (--n >= 0) {
            BS bS = this.meshData.surfaceSet[n];
            if (bS == null || bS.cardinality() >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    void excludeMaximumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int n = this.meshData.nSets;
        while (--n >= 0) {
            BS bS = this.meshData.surfaceSet[n];
            if (bS == null || bS.cardinality() <= this.params.maxSet) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    public void slabIsosurface(Lst<Object[]> lst) {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.slabPolygonsList(lst, true);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
    }

    protected void setVertexAnisotropy(T3 t3) {
        t3.x *= this.anisotropy[0];
        t3.y *= this.anisotropy[1];
        t3.z *= this.anisotropy[2];
        t3.add(this.center);
    }

    protected void setVectorAnisotropy(T3 t3) {
        this.haveSetAnisotropy = true;
        t3.x *= this.anisotropy[0];
        t3.y *= this.anisotropy[1];
        t3.z *= this.anisotropy[2];
    }

    protected void setVolumetricAnisotropy() {
        if (this.haveSetAnisotropy) {
            return;
        }
        this.setVolumetricOriginAnisotropy();
        this.setVectorAnisotropy(this.volumetricVectors[0]);
        this.setVectorAnisotropy(this.volumetricVectors[1]);
        this.setVectorAnisotropy(this.volumetricVectors[2]);
    }

    protected void setVolumetricOriginAnisotropy() {
        this.volumetricOrigin.setT(this.center);
    }

    private void setBBoxAll() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.xyzMin = null;
        for (int i = 0; i < this.meshData.vc; ++i) {
            T3 t3 = this.meshData.vs[i];
            if (Float.isNaN(t3.x)) continue;
            this.setBBox(t3, 0.0f);
        }
    }

    protected void setBBox(T3 t3, float f) {
        if (this.xyzMin == null) {
            this.xyzMin = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.xyzMax = P3.new3(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        }
        BoxInfo.addPoint(t3, this.xyzMin, this.xyzMax, f);
    }

    public float getValueAtPoint(T3 t3, boolean bl) {
        return 0.0f;
    }

    void initializeMapping() {
    }

    protected void finalizeMapping() {
    }

    public int getSurfaceAtomIndex() {
        return -1;
    }

    public V3[] getSpanningVectors() {
        return this.volumeData == null ? null : this.volumeData.getSpanningVectors();
    }
}

