/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javajs.util.AU;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.MeshSurface;

class MeshData {
    MeshData() {
    }

    static MeshSurface getCircleData() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[][] nArray = AU.newInt2(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        T3[] t3Array = new P3[n3];
        T3[] t3Array2 = new P3[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            t3Array[i] = P3.new3(f, f2, 0.0f);
            t3Array2[i] = P3.new3(0.0f, 0.0f, 1.0f);
        }
        t3Array[n2] = P3.new3(0.0f, 0.0f, 0.0f);
        t3Array2[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, t3Array, 0, nArray, t3Array2, 0);
    }

    static MeshSurface getTriangleData(P3 p3, P3 p32, P3 p33) {
        T3[] t3Array = new P3[]{p3, p32, p33};
        V3 v3 = V3.newVsub(p33, p3);
        V3 v32 = V3.newVsub(p32, p3);
        v32.cross(v32, v3);
        v32.normalize();
        T3[] t3Array2 = new V3[]{v32, v32, v32};
        int[][] nArrayArray = new int[][]{{0, 1, 2}};
        return MeshSurface.newMesh(false, t3Array, 0, nArrayArray, t3Array2, 0);
    }

    static MeshSurface getConeData() {
        int n = 10;
        int n2 = 360 / n;
        T3[] t3Array = new P3[n2 + 1];
        int[][] nArray = AU.newInt2(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        double d = (double)n / 180.0 * Math.PI;
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)i * d);
            float f2 = (float)Math.sin((double)i * d);
            t3Array[i] = P3.new3(f, f2, 0.0f);
        }
        t3Array[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, t3Array, 0, nArray, t3Array, 0);
    }

    static MeshSurface getCylinderData(boolean bl) {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[][] nArray = AU.newInt2(n3);
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4, i};
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4 + n4, (i + 1) % n4};
                continue;
            }
            nArray[++n5] = new int[]{i, (i + 1) % n4, i + n4};
            nArray[++n5] = new int[]{(i + 1) % n4, (i + 1) % n4 + n4, i + n4};
        }
        T3[] t3Array = new P3[n3];
        T3[] t3Array2 = new P3[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            t3Array[n] = P3.new3(f2, f, 0.0f);
            t3Array2[n] = P3.new3(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            t3Array[n + n4] = P3.new3(f2, f, 1.0f);
            t3Array2[n + n4] = t3Array2[n];
        }
        if (bl) {
            for (n = 0; n < n4; ++n) {
                t3Array2[n].scale(-1.0f);
            }
        }
        return MeshSurface.newMesh(false, t3Array, 0, nArray, t3Array2, 0);
    }
}

