/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.DF;
import javajs.util.Lst;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class VaspOutcarReader
extends AtomSetCollectionReader {
    private String[] atomNames;
    private int ac = 0;
    private boolean inputOnly;
    private boolean mDsimulation = false;
    private boolean isVersion5 = false;
    private Lst<String> elementNames = new Lst();
    private float[] unitCellData = new float[18];
    private Double gibbsEnergy;
    private Double gibbsEntropy;
    private Double electronEne;
    private Double kinEne;
    private Double totEne;
    private float temp;

    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        this.inputOnly = this.checkFilterKey("INPUT");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains(" vasp.5")) {
            this.isVersion5 = true;
        } else if (this.line.toUpperCase().contains("TITEL")) {
            this.readElementNames();
        } else if (this.line.contains("ions per type")) {
            this.readAtomCountAndSetNames();
        } else if (this.line.contains("molecular dynamics for ions")) {
            this.mDsimulation = true;
        } else if (this.line.contains("direct lattice vectors")) {
            this.readUnitCellVectors();
        } else if (this.line.contains("position of ions in fractional coordinates")) {
            this.readInitialCoordinates();
            if (this.inputOnly) {
                this.continuing = false;
            }
        } else {
            if (this.line.contains("POSITION")) {
                this.readPOSITION();
                return true;
            }
            if (this.line.startsWith("  FREE ENERGIE") && !this.mDsimulation) {
                this.readEnergy();
            } else if (this.line.contains("ENERGIE OF THE ELECTRON-ION-THERMOSTAT") && this.mDsimulation) {
                this.readMdyn();
            } else if (this.line.startsWith(" Eigenvectors and eigenvalues of the dynamical matrix")) {
                this.readFrequency();
            }
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        this.setSymmetry();
    }

    private void readElementNames() throws Exception {
        this.elementNames.addLast((Object)this.getTokens()[3]);
    }

    private void readAtomCountAndSetNames() throws Exception {
        int n;
        int[] nArray = new int[100];
        String[] stringArray = VaspOutcarReader.getTokensStr((String)this.line.substring(this.line.indexOf("=") + 1));
        this.ac = 0;
        for (n = 0; n < stringArray.length; ++n) {
            nArray[n] = this.parseIntStr(stringArray[n].trim());
            this.ac += nArray[n];
        }
        this.atomNames = new String[this.ac];
        n = this.elementNames.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                this.atomNames[n2++] = (String)this.elementNames.get(i);
            }
        }
    }

    private void readUnitCellVectors() throws Exception {
        if (this.asc.ac > 0) {
            this.setSymmetry();
            this.asc.newAtomSet();
            this.setAtomSetInfo();
        }
        this.fillFloatArray(null, 0, this.unitCellData);
        this.setUnitCell();
    }

    private void setUnitCell() {
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 6);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 12);
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readInitialCoordinates() throws Exception {
        int n = 0;
        while (this.rd() != null && this.line.length() > 10) {
            this.addAtomXYZSymName(this.getTokens(), 0, null, this.atomNames[n++]);
        }
        this.asc.setAtomSetName("Initial Coordinates");
    }

    private void readPOSITION() throws Exception {
        int n = 0;
        this.readLines(1);
        while (this.rd() != null && this.line.indexOf("----------") < 0) {
            this.addAtomXYZSymName(this.getTokens(), 0, null, this.atomNames[n++]);
        }
    }

    private void readEnergy() throws Exception {
        this.rd();
        String[] stringArray = VaspOutcarReader.getTokensStr((String)this.rd());
        this.gibbsEnergy = Double.parseDouble(stringArray[4]);
        this.rd();
        stringArray = VaspOutcarReader.getTokensStr((String)this.rd());
        double d = Double.parseDouble(stringArray[3]);
        this.gibbsEntropy = d - this.gibbsEnergy;
    }

    private void setAtomSetInfo() {
        if (this.gibbsEnergy == null) {
            return;
        }
        this.asc.setAtomSetEnergy("" + this.gibbsEnergy, this.gibbsEnergy.floatValue());
        this.asc.setAtomSetAuxiliaryInfo("Energy", (Object)this.gibbsEnergy);
        this.asc.setAtomSetAuxiliaryInfo("Entropy", (Object)this.gibbsEntropy);
        this.asc.setInfo("Energy", (Object)this.gibbsEnergy);
        this.asc.setInfo("Entropy", (Object)this.gibbsEntropy);
        this.asc.setAtomSetName("G = " + this.gibbsEnergy + " eV, T*S = " + this.gibbsEntropy + " eV");
    }

    private void readMdyn() throws Exception {
        String[] stringArray = this.getTokens();
        this.rd();
        stringArray = VaspOutcarReader.getTokensStr((String)this.rd());
        this.electronEne = Double.parseDouble(stringArray[4]);
        stringArray = VaspOutcarReader.getTokensStr((String)this.rd());
        this.kinEne = Double.parseDouble(stringArray[4]);
        this.temp = this.parseFloatStr(stringArray[6]);
        this.readLines(3);
        stringArray = VaspOutcarReader.getTokensStr((String)this.rd());
        this.totEne = Double.parseDouble(stringArray[4]);
        this.setAtomSetInfoMd();
    }

    private void setAtomSetInfoMd() {
        this.asc.setAtomSetName("Temp. = " + DF.formatDecimal((float)this.temp, (int)2) + " K, Energy = " + this.totEne + " eV");
        this.asc.setAtomSetAuxiliaryInfo("Energy", (Object)this.totEne);
        this.asc.setInfo("Energy", (Object)this.totEne);
        this.asc.setAtomSetAuxiliaryInfo("EleEnergy", (Object)this.kinEne);
        this.asc.setInfo("EleEnergy", (Object)this.electronEne);
        this.asc.setAtomSetAuxiliaryInfo("Kinetic", (Object)this.electronEne);
        this.asc.setInfo("Kinetic", (Object)this.kinEne);
        this.asc.setAtomSetAuxiliaryInfo("Temperature", (Object)DF.formatDecimal((float)this.temp, (int)2));
        this.asc.setInfo("Temperature", (Object)DF.formatDecimal((float)this.temp, (int)2));
    }

    private void readFrequency() throws Exception {
        int n = this.asc.iSet;
        this.asc.baseSymmetryAtomCount = this.ac;
        if (this.isVersion5) {
            this.readLines(3);
        } else {
            this.discardLinesUntilContains("Eigenvectors after division by SQRT(mass)");
            this.readLines(5);
        }
        boolean[] blArray = new boolean[1];
        while (this.rd() != null && (this.line.contains("f  = ") || this.line.contains("f/i= "))) {
            this.applySymmetryAndSetTrajectory();
            int n2 = this.asc.ac;
            this.cloneLastAtomSet(this.ac, null);
            if (!blArray[0]) {
                this.asc.iSet = ++n;
                this.asc.setAtomSetFrequency(null, null, this.line.substring(this.line.indexOf("2PiTHz") + 6, this.line.indexOf("c") - 1).trim(), null);
            }
            this.rd();
            this.fillFrequencyData(n2, this.ac, this.ac, blArray, true, 35, 12, null, 0);
            this.rd();
        }
    }
}

