/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.Lst;
import javajs.util.T3;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.util.C;

public class BackboneRenderer
extends BioShapeRenderer {
    private boolean isDataFrame;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        boolean bl = this.vwr.getBoolean(603979811) && bioShape.bioPolymer.isNucleic();
        this.isDataFrame = this.vwr.ms.isJmolDataFrameForModel(bioShape.modelIndex);
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            NucleicMonomer nucleicMonomer;
            Lst<BasePair> lst;
            Atom atom = this.ms.at[this.leadAtomIndices[n]];
            short s = this.colixes[n];
            this.mad = this.mads[n];
            this.drawSegment(atom, this.ms.at[this.leadAtomIndices[n + 1]], s, this.colixes[n + 1], 100.0f);
            if (bl && (lst = (nucleicMonomer = (NucleicMonomer)this.monomers[n]).getBasePairs()) != null) {
                int n2 = lst.size();
                while (--n2 >= 0) {
                    int n3 = ((BasePair)lst.get(n2)).getPartnerAtom(nucleicMonomer);
                    if (n3 <= n) continue;
                    this.drawSegment(atom, this.ms.at[n3], s, s, 1000.0f);
                }
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }

    private void drawSegment(Atom atom, Atom atom2, short s, short s2, float f) {
        if (atom.nBackbonesDisplayed == 0 || atom2.nBackbonesDisplayed == 0 || this.ms.isAtomHidden(atom2.i) || !this.isDataFrame && atom.distanceSquared((T3)atom2) > f) {
            return;
        }
        s = C.getColixInherited((short)s, (short)atom.colixAtom);
        s2 = C.getColixInherited((short)s2, (short)atom2.colixAtom);
        if (!(this.isExport || this.isPass2 || this.setBioColix(s) || this.setBioColix(s2))) {
            return;
        }
        int n = atom.sX;
        int n2 = atom.sY;
        int n3 = atom.sZ;
        int n4 = atom2.sX;
        int n5 = atom2.sY;
        int n6 = atom2.sZ;
        int n7 = this.mad;
        if (f == 1000.0f) {
            n7 >>= 1;
        }
        if (n7 < 0) {
            this.g3d.drawLine(s, s2, n, n2, n3, n4, n5, n6);
        } else {
            int n8 = (int)(this.exportType == 1 ? (float)n7 : this.vwr.tm.scaleToScreen((n3 + n6) / 2, n7));
            this.g3d.fillCylinderXYZ(s, s2, (byte)3, n8, n, n2, n3, n4, n5, n6);
        }
    }
}

