/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.SimpleUnitCell;

class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String sgName;
    SymmetryOperation[] symmetryOperations;
    String infoStr;
    int[] cellRange;
    private P3 periodicOriginXyz;
    Lst<V3> centerings;

    boolean isPeriodic() {
        return this.periodicOriginXyz != null;
    }

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(Map<String, Object> map, float[] fArray) {
        this.cellRange = (int[])map.get("unitCellRange");
        this.periodicOriginXyz = (P3)map.get("periodicOriginXyz");
        this.sgName = (String)map.get("spaceGroup");
        if (this.sgName == null || this.sgName == "") {
            this.sgName = "spacegroup unspecified";
        }
        int n = map.containsKey("symmetryCount") ? (Integer)map.get("symmetryCount") : 0;
        this.symmetryOperations = (SymmetryOperation[])map.remove("symmetryOps");
        this.infoStr = "Spacegroup: " + this.sgName;
        if (this.symmetryOperations == null) {
            this.infoStr = this.infoStr + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
        } else {
            this.centerings = new Lst();
            String string = "";
            String string2 = "\nNumber of symmetry operations: " + (n == 0 ? 1 : n) + "\nSymmetry Operations:";
            for (int i = 0; i < n; ++i) {
                SymmetryOperation symmetryOperation = this.symmetryOperations[i];
                string2 = string2 + "\n" + symmetryOperation.xyz;
                if (!symmetryOperation.isCenteringOp) continue;
                this.centerings.addLast(symmetryOperation.centering);
                String string3 = PT.replaceAllCharacters(symmetryOperation.xyz, "xyz", "0");
                string = string + " (" + PT.rep(string3, "0+", "") + ")";
            }
            if (string.length() > 0) {
                this.infoStr = this.infoStr + "\nCentering: " + string;
            }
            this.infoStr = this.infoStr + string2;
        }
        this.infoStr = this.infoStr + "\n";
        if (fArray == null) {
            fArray = (float[])map.get("notionalUnitcell");
        }
        if (!SimpleUnitCell.isValid(fArray)) {
            return null;
        }
        this.coordinatesAreFractional = map.containsKey("coordinatesAreFractional") ? (Boolean)map.get("coordinatesAreFractional") : false;
        this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        return fArray;
    }
}

