/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class MopacReader
extends AtomSetCollectionReader {
    private boolean chargesFound = false;
    private boolean haveHeader;
    private int mopacVersion;

    @Override
    protected void initializeReader() throws Exception {
        while (this.mopacVersion == 0) {
            this.discardLinesUntilContains("MOPAC");
            if (this.line.indexOf("2009") >= 0) {
                this.mopacVersion = 2009;
                continue;
            }
            if (this.line.indexOf("6.") >= 0) {
                this.mopacVersion = 6;
                continue;
            }
            if (this.line.indexOf("7.") >= 0) {
                this.mopacVersion = 7;
                continue;
            }
            if (this.line.indexOf("93") >= 0) {
                this.mopacVersion = 93;
                continue;
            }
            if (this.line.indexOf("2002") >= 0) {
                this.mopacVersion = 2002;
                continue;
            }
            if (this.line.indexOf("MOPAC2") < 0) continue;
            this.mopacVersion = PT.parseInt(this.line.substring(this.line.indexOf("MOPAC2") + 5));
        }
        Logger.info("MOPAC version " + this.mopacVersion);
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (!this.haveHeader) {
            if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                this.processCoordinates();
                this.asc.setAtomSetName("Input Structure");
                return true;
            }
            this.haveHeader = this.line.startsWith(" ---");
            return true;
        }
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            this.processTotalEnergy();
            return true;
        }
        if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
            this.processAtomicCharges();
            return true;
        }
        if (this.line.trim().equals("CARTESIAN COORDINATES")) {
            this.processCoordinates();
            return true;
        }
        if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
            this.processCoordinates();
            this.asc.setAtomSetName("Orientation in Force Field");
            return true;
        }
        if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    void processTotalEnergy() {
    }

    void processAtomicCharges() throws Exception {
        int n;
        this.readLines(2);
        this.asc.newAtomSet();
        this.baseAtomIndex = this.asc.ac;
        int n2 = 0;
        while (this.rd() != null && (n = this.parseIntStr(this.line)) != Integer.MIN_VALUE) {
            if (n != ++n2) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = this.parseToken();
            atom.partialCharge = this.parseFloat();
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int n;
        String[] stringArray;
        this.readLines(3);
        if (!this.chargesFound) {
            this.asc.newAtomSet();
            this.baseAtomIndex = this.asc.ac;
        } else {
            this.chargesFound = false;
        }
        Atom[] atomArray = this.asc.atoms;
        while (this.rd() != null && (stringArray = this.getTokens()).length != 0 && (n = this.parseIntStr(stringArray[0])) != Integer.MIN_VALUE) {
            Atom atom = atomArray[this.baseAtomIndex + n - 1];
            if (atom == null) {
                atom = this.asc.addNewAtom();
            }
            atom.atomSerial = n;
            this.setAtomCoordTokens(atom, stringArray, 2);
            String string = stringArray[1];
            int n2 = this.parseIntStr(string);
            if (n2 != Integer.MIN_VALUE) {
                string = MopacReader.getElementSymbol(n2);
            }
            atom.elementSymbol = string;
        }
    }

    private void readFrequencies() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        BS bS = new BS();
        int n3 = this.asc.iSet + 1;
        boolean bl = false;
        while (!bl && this.rd() != null && this.line.indexOf("DESCRIPTION") < 0 && this.line.indexOf("MASS-WEIGHTED") < 0) {
            if (this.line.toUpperCase().indexOf("ROOT") < 0) continue;
            this.discardLinesUntilNonBlank();
            stringArray = this.getTokens();
            if (Float.isNaN(PT.parseFloatStrict(stringArray[stringArray.length - 1]))) {
                this.discardLinesUntilNonBlank();
                stringArray = this.getTokens();
            }
            int n4 = stringArray.length;
            this.rd();
            n2 = this.asc.ac;
            n = this.asc.getLastAtomSetAtomCount();
            boolean[] blArray = new boolean[n4];
            float f = PT.parseFloatStrict(stringArray[0]);
            boolean bl2 = f < 0.0f;
            for (int i = 0; i < n4; ++i) {
                boolean bl3 = bl || (bl = !bl2 && PT.parseFloatStrict(stringArray[i]) < 1.0f) || !this.doGetVibration(++this.vibrationNumber) ? true : (blArray[i] = false);
                if (blArray[i]) continue;
                bS.set(this.vibrationNumber - 1);
                this.asc.cloneLastAtomSet();
            }
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 2);
        }
        String[][] stringArrayArray = new String[this.vibrationNumber][];
        if (this.line.indexOf("DESCRIPTION") < 0) {
            this.discardLinesUntilContains("DESCRIPTION");
        }
        while (this.discardLinesUntilContains("VIBRATION") != null) {
            stringArray = this.getTokens();
            n2 = this.parseIntStr(stringArray[1]);
            stringArray[0] = PT.getTokens(this.rd())[1];
            if (stringArray[2].equals("ATOM")) {
                stringArray[2] = null;
            }
            stringArrayArray[n2 - 1] = stringArray;
            if (n2 != this.vibrationNumber) continue;
            break;
        }
        n2 = this.vibrationNumber - 1;
        while (--n2 >= 0) {
            if (stringArrayArray[n2] != null) continue;
            stringArrayArray[n2] = stringArrayArray[n2 + 1];
        }
        n = n3;
        for (n2 = 0; n2 < this.vibrationNumber; ++n2) {
            if (!bS.get(n2)) continue;
            this.asc.iSet = n++;
            this.asc.setAtomSetFrequency(null, stringArrayArray[n2][2], stringArrayArray[n2][0], null);
        }
    }
}

