/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

class VaspChgcarReader
extends PeriodicVolumeFileReader {
    private float volume;
    private int pt;

    VaspChgcarReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.isPeriodic = true;
        this.isProgressive = false;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("Vasp CHGCAR format\n\n\n");
        this.rd();
        float f = this.parseFloatStr(this.rd());
        float[] fArray = new float[15];
        fArray[0] = -1.0f;
        int n = 6;
        for (int i = 0; i < 3; ++i) {
            int n2 = n++;
            float f2 = this.parseFloatStr(this.rd()) * f;
            fArray[n2] = f2;
            int n3 = n++;
            float f3 = this.parseFloat() * f;
            fArray[n3] = f3;
            int n4 = n++;
            float f4 = this.parseFloat() * f;
            fArray[n4] = f4;
            this.volumetricVectors[i].set(f2, f3, f4);
        }
        this.volume = (float)SimpleUnitCell.newA((float[])fArray).volume;
        while (this.rd().length() > 2) {
        }
        this.rd();
        String[] stringArray = this.getTokens();
        for (n = 0; n < 3; ++n) {
            this.voxelCounts[n] = this.parseIntStr(stringArray[n]) + 1;
            this.volumetricVectors[n].scale(1.0f / (float)(this.voxelCounts[n] - 1));
            if (!this.isAnisotropic) continue;
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
        this.swapXZ();
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            this.params.cutoff = 0.5f;
            Logger.info("Cutoff set to " + this.params.cutoff);
        }
    }

    @Override
    protected float nextVoxel() throws Exception {
        if (this.pt++ % 5 == 0) {
            this.rd();
            this.next[0] = 0;
        }
        return this.parseFloat() / this.volume;
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int n = this.voxelCounts[0] - 1;
        int n2 = this.voxelCounts[1] - 1;
        int n3 = this.voxelCounts[2] - 1;
        boolean bl = this.nSkipX > 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                int n5;
                for (n5 = 0; n5 < n3; ++n5) {
                    this.voxelData[i][n4][n5] = this.recordData(this.nextVoxel());
                    if (!bl) continue;
                    int n6 = this.nSkipX;
                    while (--n6 >= 0) {
                        this.nextVoxel();
                    }
                }
                if (!bl) continue;
                n5 = this.nSkipY;
                while (--n5 >= 0) {
                    this.nextVoxel();
                }
            }
            if (!bl) continue;
            n4 = this.nSkipZ;
            while (--n4 >= 0) {
                this.nextVoxel();
            }
        }
    }
}

